/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextPane;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.ui.EventStatusModel;
import oracle.dbtools.migration.workbench.core.ui.FullMigrationPreRequisiteChecker;
import oracle.dbtools.migration.workbench.core.ui.PreReqListener;
import oracle.dbtools.migration.workbench.core.ui.SimpleTablePanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;

public class MigrationCheck
extends DefaultTraversablePanel {
    private PreReqResultsPanel m_testResultsPanel = new PreReqResultsPanel();
    private JButton m_btnTest = new JButton();
    private JTextPane m_txtTestDesc = new JTextPane();
    private FullMigrationPreRequisiteChecker m_checker = null;
    private String m_sourceConnectionName;
    private String m_targetConnectionName;
    private String m_repoName;
    private int m_result = 1;
    private TraversableContext m_dataContext;
    private static final String HTMLCONTENT = "text/html";

    public MigrationCheck() {
        Font f = this.m_txtTestDesc.getFont();
        String fontStyle = MigrationUtils.fontToCSSString(f);
        Dimension jewtButtonSize = new Dimension(72, 22);
        this.m_btnTest.setMinimumSize(jewtButtonSize);
        this.m_btnTest.setMaximumSize(jewtButtonSize);
        this.m_btnTest.setPreferredSize(jewtButtonSize);
        this.m_btnTest.setMnemonic(MigrationAddinArb.getMnemonic(386));
        this.m_btnTest.setText(MigrationAddinArb.getString(385));
        this.m_btnTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MigrationCheck.this.performTest();
            }
        });
        this.m_txtTestDesc.setContentType(HTMLCONTENT);
        this.m_txtTestDesc.setText(MigrationAddinArb.format(404, fontStyle));
        this.m_txtTestDesc.setEditable(false);
        this.m_txtTestDesc.setOpaque(false);
        this.m_txtTestDesc.setRequestFocusEnabled(false);
        this.m_txtTestDesc.setFocusable(false);
        this.setLayout(new GridBagLayout());
        this.add(this.m_txtTestDesc, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.m_btnTest, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.m_testResultsPanel.getPanel(), new GridBagConstraints(0, 2, 3, 1, 1.0, 2.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void performTest() {
        if (this.m_checker != null) {
            this.m_checker.allDone();
        }
        this.m_checker = new FullMigrationPreRequisiteChecker(this.m_sourceConnectionName, this.m_targetConnectionName, this.m_repoName);
        this.m_testResultsPanel.reset();
        this.m_checker.addListener(this.m_testResultsPanel);
        this.m_result = this.m_checker.runTests();
        if (this.m_result == 2) {
            StringBuffer multiPrivMsg = new StringBuffer(MigrationAddinArb.getString(448));
            multiPrivMsg.append("\n");
            multiPrivMsg.append(this.m_checker.getPrivWarning());
            MessageDialog.information((Component)((Object)this), (Object)multiPrivMsg.toString(), (String)MigrationAddinArb.getString(449), (String)"help_migrate_privileges");
        }
        this.setWizardButtons();
    }

    private void setWizardButtons() {
        if (this.m_result == 2 || this.m_result == 0) {
            this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        } else {
            this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        }
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_dataContext = dataContext;
        this.m_sourceConnectionName = (String)dataContext.get("SOURCE_CONNECTION");
        this.m_targetConnectionName = (String)dataContext.get("TARGET_CONNECTION");
        this.m_repoName = (String)dataContext.get("REPO_CONNECTION");
        this.m_btnTest.setEnabled(true);
        this.setWizardButtons();
    }

    private MigrationPlugin getPlugin() {
        if (this.m_checker == null) {
            return null;
        }
        return this.m_checker.getPlugin();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        dataContext.put("TEST_RESULT", (Object)this.m_result);
        dataContext.put("PLUGIN", (Object)this.getPlugin());
    }

    private static class PreReqResultsPanel
    implements PreReqListener {
        private EventStatusModel m_model = new EventStatusModel(new String[]{MigrationAddinArb.getString(391), MigrationAddinArb.getString(392), MigrationAddinArb.getString(393)});
        private SimpleTablePanel m_eventPanel = new SimpleTablePanel(600, null, this.m_model);

        public SimpleTablePanel getPanel() {
            return this.m_eventPanel;
        }

        public void testCompleted(String testName, boolean result, String optionalMessage) {
            String[] info = new String[]{testName, result ? MigrationAddinArb.getString(395) : MigrationAddinArb.getString(396), optionalMessage};
            this.m_eventPanel.updateProgress(info);
        }

        public void testStarted(String testName, String optionalMessage) {
            String[] info = new String[]{testName, MigrationAddinArb.getString(394), optionalMessage};
            this.m_eventPanel.updateProgress(info);
        }

        public void reset() {
            this.m_model.clear();
        }
    }
}

