/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.QMLauncher;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.ui.FullMigrateProgressRunnable;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;

public class QMSummary
extends DefaultTraversablePanel {
    TraversableContext m_dataContext = null;
    private static final String HTMLCONTENT = "text/html";
    private JTextPane m_txtSourceDescription = new JTextPane();
    private JLabel m_typeLabel = new JLabel();

    public QMSummary() {
        this.setLayout(new GridBagLayout());
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_dataContext = dataContext;
        Font f = this.m_typeLabel.getFont();
        String fontStyle = MigrationUtils.fontToCSSString(f);
        Object[] summaryArgs = new String[]{fontStyle, Connections.getDisplayName((String)((String)this.m_dataContext.get("SOURCE_CONNECTION"))), Connections.getDisplayName((String)((String)this.m_dataContext.get("TARGET_CONNECTION"))), Connections.getDisplayName((String)((String)this.m_dataContext.get("REPOSITORY_CONNECTION"))), Connections.getDisplayName((String)((String)this.m_dataContext.get("MIGRATION_TYPE"))), Connections.getDisplayName((String)((String)this.m_dataContext.get("REPOSITORY_KEEP")))};
        this.m_txtSourceDescription.setContentType(HTMLCONTENT);
        this.m_txtSourceDescription.setText(MigrationAddinArb.format(409, summaryArgs));
        this.m_txtSourceDescription.setEditable(false);
        this.m_txtSourceDescription.setOpaque(false);
        this.m_txtSourceDescription.setRequestFocusEnabled(false);
        this.m_txtSourceDescription.setFocusable(false);
        this.add(this.m_txtSourceDescription, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setWizardButtons();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (dataContext.getDirection() == 1) {
            this.doMigration();
        }
    }

    private void doMigration() {
        try {
            Connection sourceConnection = (Connection)this.m_dataContext.get("SOURCE_CONNECTION_OBJ");
            FullMigrateProgressRunnable runner = new FullMigrateProgressRunnable((MigrationPlugin)this.m_dataContext.get("PLUGIN"), sourceConnection, (String)this.m_dataContext.get("SOURCE_CONNECTION"), (String)this.m_dataContext.get("TARGET_CONNECTION"), !((String)this.m_dataContext.get("REPOSITORY_KEEP")).equalsIgnoreCase("TRUE"), (String)this.m_dataContext.get("MIGRATION_TYPE"));
            runner.setContext(QMLauncher.getStaticContext());
            try {
                runner.start(true);
            }
            catch (Exception e) {
                MigrationLogUtil.logThrowable(e.getLocalizedMessage(), "Migrate", (Throwable)e);
            }
        }
        catch (MigrationPluginException mpe) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(416), (String)MigrationAddinArb.getString(415), (String)"help_migration_plugin_exception");
            MigrationLogUtil.logThrowable(mpe.getLocalizedMessage(), "Migrate", (Throwable)mpe);
            return;
        }
    }

    private void setWizardButtons() {
        this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MIGRATIONTYPE {
        TABLE,
        TABLEANDDATA,
        EVERYTHING;

    }
}

