/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.Frame;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.migration.workbench.core.QMLauncher;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.MigrationCheck;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.MigrationType;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMSummary;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizardArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.RepositorySelector;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SourceSelector;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.TargetSelector;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class QMWizard {
    public static final String QM_NAME = "raptor.qmwizard";
    public static final int QM_ACTION = Ide.findOrCreateCmdID((String)"raptor.qmwizard");
    private static QMWizard INSTANCE;

    private static FSM getFSM() {
        FSMBuilder fsmb = new FSMBuilder();
        Step step1 = new Step(QMWizardArb.getString(2), SourceSelector.class, "f1_qmhelp_id_for_step1");
        fsmb.newStartState(step1, (Object)"step2");
        Step step2 = new Step(QMWizardArb.getString(3), TargetSelector.class, "f1_qmhelp_id_for_step2");
        fsmb.newState((Object)"step2", step2, (Object)"step3");
        Step step3 = new Step(QMWizardArb.getString(4), RepositorySelector.class, "f1_qmhelp_id_for_step3");
        fsmb.newState((Object)"step3", step3, (Object)"step4");
        Step step4 = new Step(QMWizardArb.getString(5), MigrationCheck.class, "f1_qmhelp_id_for_step4");
        fsmb.newState((Object)"step4", step4, (Object)"step5");
        Step step5 = new Step(QMWizardArb.getString(6), MigrationType.class, "f1_qmhelp_id_for_step5");
        fsmb.newState((Object)"step5", step5, (Object)"step6");
        Step step6 = new Step(QMWizardArb.getString(7), QMSummary.class, "f1_qmhelp_id_for_step6");
        fsmb.newFinalState((Object)"step6", step6);
        try {
            return fsmb.getFSM();
        }
        catch (FSMInvalidException e) {
            return null;
        }
    }

    public WizardDialog getWizard() {
        FSM fsm = QMWizard.getFSM();
        Namespace initialData = new Namespace();
        Context c = QMLauncher.getStaticContext();
        if (c != null) {
            String connName = (String)c.getProperty("ObjectAction.CONN_NAME");
            initialData.put("SOURCE_CONNECTION", (Object)connName);
        }
        FSMWizard wiz = new FSMWizard(fsm, initialData);
        wiz.setWizardTitle(QMWizardArb.getString(0));
        wiz.setShowStepNumber(true);
        wiz.updateImage(QMWizardArb.getImage(1));
        wiz.setRoadmapVisible(true);
        wiz.setSize(800, 800);
        return wiz.getDialog((Frame)Ide.getMainWindow());
    }

    public static QMWizard getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new QMWizard();
        }
        return INSTANCE;
    }

    public void launch() {
        WizardDialog wiz = this.getWizard();
        WizardLauncher.runDialog((JDialog)wiz);
    }

    private static class QuickMigrationController
    implements Controller {
        private QuickMigrationController() {
        }

        public boolean handleEvent(IdeAction action, Context context) {
            if (action.getCommandId() == QM_ACTION) {
                QMWizard.getInstance().launch();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            if (action.getCommandId() == QM_ACTION) {
                action.setEnabled(true);
                return true;
            }
            return false;
        }
    }
}

