/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;

public class RepositorySelector
extends DefaultTraversablePanel {
    private String m_repoConnectionName;
    private JComboBox m_cmbRepo = new JComboBox();
    private static final String HTMLCONTENT = "text/html";
    private JTextPane m_txtRepoDesc = new JTextPane();
    private String m_repositoryName;
    private JCheckBox m_checkKeepRepo = new JCheckBox();
    private JTextArea m_lblRepo = new JTextArea();
    private boolean m_repoExists = true;
    private TraversableContext m_dataContext;

    public RepositorySelector() {
        this.setLayout(new GridBagLayout());
        this.m_cmbRepo.setRenderer(new comboRenderer());
        Font f = this.m_cmbRepo.getFont();
        String fontStyle = MigrationUtils.fontToCSSString(f);
        this.add(this.m_txtRepoDesc, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.m_cmbRepo, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.m_lblRepo, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.m_checkKeepRepo, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        JLabel dummy = new JLabel();
        dummy.setVisible(true);
        this.add(dummy, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.populateRepositoryField(fontStyle);
    }

    private String getRepoName() {
        if (this.m_repositoryName == null) {
            return (String)this.m_cmbRepo.getSelectedItem();
        }
        return this.m_repositoryName;
    }

    private void populateRepositoryField(String fontStyle) {
        String status;
        String[] allRepos = this.getConfiguredRepositories();
        if (allRepos == null || allRepos.length == 0) {
            this.m_repoExists = false;
            status = MigrationAddinArb.getString(405);
            this.m_cmbRepo.setVisible(false);
            this.m_checkKeepRepo.setText(MigrationAddinArb.getString(390));
            this.m_checkKeepRepo.setHorizontalAlignment(2);
            this.m_checkKeepRepo.setVerticalAlignment(1);
            this.m_checkKeepRepo.setVerticalTextPosition(1);
            this.m_checkKeepRepo.setVisible(true);
        } else if (allRepos.length == 1) {
            String repoName = Connections.getDisplayName((String)allRepos[0]);
            status = MigrationAddinArb.format(406, repoName);
            this.m_cmbRepo.setVisible(false);
            this.m_checkKeepRepo.setVisible(false);
            this.m_repositoryName = allRepos[0];
        } else {
            this.m_cmbRepo.removeAllItems();
            for (String s : allRepos) {
                this.m_cmbRepo.addItem(s);
            }
            status = MigrationAddinArb.getString(407);
            this.m_checkKeepRepo.setVisible(false);
        }
        this.m_lblRepo.setText(status);
        this.m_lblRepo.setVisible(true);
        this.m_lblRepo.setEditable(false);
        this.m_txtRepoDesc.setContentType(HTMLCONTENT);
        this.m_txtRepoDesc.setText(MigrationAddinArb.format(403, fontStyle));
        this.m_txtRepoDesc.setOpaque(false);
        this.m_txtRepoDesc.setEditable(false);
        this.m_txtRepoDesc.setRequestFocusEnabled(false);
        this.m_txtRepoDesc.setFocusable(false);
        this.m_txtRepoDesc.setSize(10, 10);
    }

    private String[] getConfiguredRepositories() {
        ArrayList<String> ret = new ArrayList<String>();
        MigrationConfig config = MigrationAddin.getMigrationConfig();
        String[] allRepos = config.getRepositories();
        if (allRepos == null || allRepos.length == 0) {
            return null;
        }
        String[] allConns = Connections.getInstance().getConnNames();
        block0: for (String s : allRepos) {
            for (String toCheck : allConns) {
                if (!toCheck.equalsIgnoreCase(s) || !Connections.getInstance().isOracle(toCheck)) continue;
                ret.add(toCheck);
                continue block0;
            }
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret.toArray(new String[ret.size()]);
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_dataContext = dataContext;
        this.m_repoConnectionName = (String)dataContext.get("REPOSITORY_CONNECTION");
        if (this.m_repositoryName != null) {
            this.m_cmbRepo.setSelectedItem(this.m_repositoryName);
        } else if (this.m_cmbRepo.getSelectedObjects().length > 0) {
            this.m_cmbRepo.setSelectedIndex(0);
            this.m_repositoryName = (String)this.m_cmbRepo.getSelectedItem();
        }
        this.setWizardButtons();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (!this.m_repoExists) {
            this.m_repositoryName = (String)dataContext.get("TARGET_CONNECTION");
        }
        dataContext.put("REPOSITORY_CONNECTION", (Object)this.m_repositoryName);
        try {
            dataContext.put("REPOSITORY_CONNECTION_OBJ", (Object)Connections.getInstance().getConnection(this.m_repositoryName));
            dataContext.put("REPOSITORY_KEEP", (Object)(this.m_checkKeepRepo.isVisible() ? (this.m_checkKeepRepo.isSelected() ? "True" : "False") : "True"));
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    private void setWizardButtons() {
        this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    private class comboRenderer
    extends DefaultListCellRenderer {
        private comboRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent((JList<?>)list, Connections.getDisplayName((String)((String)value)), index, isSelected, cellHasFocus);
        }
    }
}

