/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextPane;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.raptor.connections.ConnectionComboRenderer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.jdeveloper.db.DatabaseConnectionEditor;

public class SourceSelector
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 329069071724645146L;
    private JComboBox m_cmbSourceConnection = new JComboBox();
    private JTextPane m_txtSourceDescription = new JTextPane();
    private JButton m_btnAddSource = new JButton();
    private boolean m_sourceIsPreSelected = false;
    private String m_sourceConnection;
    private static final String HTMLCONTENT = "text/html";
    private TraversableContext m_dataContext;

    public SourceSelector() {
        this.populatecConnectionCombos(true);
        this.setLayout(new GridBagLayout());
        this.m_btnAddSource.setText(MigrationAddinArb.getString(381));
        this.m_btnAddSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SourceSelector.this.newSourceOrTarget();
            }
        });
        this.m_cmbSourceConnection.setRenderer(new ConnectionComboRenderer());
        this.add(this.m_cmbSourceConnection, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        Dimension jewtButtonSize = new Dimension(72, 22);
        this.m_btnAddSource.setMinimumSize(jewtButtonSize);
        this.m_btnAddSource.setMaximumSize(jewtButtonSize);
        this.m_btnAddSource.setPreferredSize(jewtButtonSize);
        this.m_btnAddSource.setMnemonic(MigrationAddinArb.getMnemonic(382));
        this.add(this.m_btnAddSource, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        Font f = this.m_btnAddSource.getFont();
        String fontStyle = MigrationUtils.fontToCSSString(f);
        this.m_txtSourceDescription.setContentType(HTMLCONTENT);
        this.m_txtSourceDescription.setText(MigrationAddinArb.format(401, fontStyle));
        this.m_txtSourceDescription.setEditable(false);
        this.m_txtSourceDescription.setOpaque(false);
        this.m_txtSourceDescription.setRequestFocusEnabled(false);
        this.m_txtSourceDescription.setFocusable(false);
        this.add(this.m_txtSourceDescription, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void newSourceOrTarget() {
        DatabaseConnectionEditor.editConnection((String)"IdeConnections", null);
        this.populatecConnectionCombos(true);
    }

    private void populatecConnectionCombos(boolean setAsBefore) {
        String[] allConns;
        String grabSourceConnection = null;
        if (setAsBefore && !this.m_sourceIsPreSelected) {
            grabSourceConnection = (String)this.m_cmbSourceConnection.getSelectedItem();
        }
        this.m_cmbSourceConnection.removeAllItems();
        Connections conns = Connections.getInstance();
        for (String s : allConns = conns.getConnNames()) {
            if (conns.isOracle(s)) continue;
            this.m_cmbSourceConnection.addItem(s);
        }
        if (setAsBefore && grabSourceConnection != null && !this.m_sourceIsPreSelected) {
            this.m_cmbSourceConnection.setSelectedItem(grabSourceConnection);
        }
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_dataContext = dataContext;
        this.m_sourceConnection = (String)dataContext.get("SOURCE_CONNECTION");
        if (this.m_sourceConnection != null) {
            this.m_cmbSourceConnection.setSelectedItem(this.m_sourceConnection);
        } else if (this.m_cmbSourceConnection.getSelectedObjects().length > 0) {
            this.m_cmbSourceConnection.setSelectedIndex(0);
            this.m_sourceConnection = (String)this.m_cmbSourceConnection.getItemAt(0);
        }
        this.setWizardButtons();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        dataContext.put("SOURCE_CONNECTION", (Object)((String)this.m_cmbSourceConnection.getSelectedItem()));
        Connections conns = Connections.getInstance();
        try {
            dataContext.put("SOURCE_CONNECTION_OBJ", (Object)conns.getConnection((String)this.m_cmbSourceConnection.getSelectedItem()));
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    private void setWizardButtons() {
        if (this.m_sourceConnection != null) {
            this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        } else {
            this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        }
    }
}

