/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextPane;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.raptor.connections.ConnectionComboRenderer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.jdeveloper.db.DatabaseConnectionEditor;

public class TargetSelector
extends DefaultTraversablePanel {
    private static final long serialVersionUID = -6259962152810412057L;
    private JTextPane m_txtTargetDesc = new JTextPane();
    private JComboBox m_cmbTargetConnection = new JComboBox();
    private JButton m_btnAddTarget = new JButton();
    private String m_targetConnectionName = "";
    private boolean runTest = true;
    private static final String HTMLCONTENT = "text/html";
    TraversableContext m_dataContext;

    public TargetSelector() {
        this.setLayout(new GridBagLayout());
        Font f = this.m_btnAddTarget.getFont();
        String fontStyle = MigrationUtils.fontToCSSString(f);
        this.m_txtTargetDesc.setContentType(HTMLCONTENT);
        this.m_txtTargetDesc.setText(MigrationAddinArb.format(402, fontStyle));
        this.m_txtTargetDesc.setEditable(false);
        this.m_txtTargetDesc.setOpaque(false);
        this.m_txtTargetDesc.setRequestFocusEnabled(false);
        this.m_txtTargetDesc.setFocusable(false);
        this.add(this.m_txtTargetDesc, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        Dimension jewtButtonSize = new Dimension(72, 22);
        this.m_btnAddTarget.setMinimumSize(jewtButtonSize);
        this.m_btnAddTarget.setMaximumSize(jewtButtonSize);
        this.m_btnAddTarget.setPreferredSize(jewtButtonSize);
        this.m_btnAddTarget.setText(MigrationAddinArb.getString(383));
        this.m_btnAddTarget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TargetSelector.this.newSourceOrTarget();
            }
        });
        this.m_btnAddTarget.setMnemonic(MigrationAddinArb.getMnemonic(384));
        this.m_cmbTargetConnection.setRenderer(new ConnectionComboRenderer());
        this.add(this.m_cmbTargetConnection, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.m_btnAddTarget, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void newSourceOrTarget() {
        DatabaseConnectionEditor.editConnection((String)"IdeConnections", null);
        this.populatecConnectionCombos(true);
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_dataContext = dataContext;
        if (dataContext.get("SHOULD_RUN_TEST") != null) {
            this.runTest = (Boolean)dataContext.get("SHOULD_RUN_TEST");
        }
        this.populatecConnectionCombos(false);
        this.m_targetConnectionName = (String)dataContext.get("TARGET_CONNECTION");
        if (this.m_targetConnectionName != null) {
            this.m_cmbTargetConnection.setSelectedItem(this.m_targetConnectionName);
        } else if (this.m_cmbTargetConnection.getSelectedObjects().length > 0) {
            this.m_cmbTargetConnection.setSelectedIndex(0);
            this.m_targetConnectionName = (String)this.m_cmbTargetConnection.getItemAt(0);
        }
        this.setWizardButtons();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        dataContext.put("SHOULD_RUN_TEST", (Object)this.runTest);
        String targetName = (String)this.m_cmbTargetConnection.getSelectedItem();
        dataContext.put("TARGET_CONNECTION", (Object)targetName);
        try {
            dataContext.put("TARGET_CONNECTION_OBJ", (Object)Connections.getInstance().getConnection(targetName));
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    private void populatecConnectionCombos(boolean setAsBefore) {
        String[] allConns;
        Object grabSourceConnectionName = null;
        String grabTargetConnectionName = null;
        if (setAsBefore) {
            grabTargetConnectionName = (String)this.m_cmbTargetConnection.getSelectedItem();
        }
        this.m_cmbTargetConnection.removeAllItems();
        Connections conns = Connections.getInstance();
        for (String s : allConns = conns.getConnNames()) {
            if (!conns.isOracle(s)) continue;
            this.m_cmbTargetConnection.addItem(s);
        }
        if (setAsBefore && grabTargetConnectionName != null) {
            this.m_cmbTargetConnection.setSelectedItem(grabTargetConnectionName);
        }
        this.targetConnectionSelectionChange();
    }

    private void targetConnectionSelectionChange() {
        String currentSelection = (String)this.m_cmbTargetConnection.getSelectedItem();
        if (TargetSelector.stringsDiffer(currentSelection, this.m_targetConnectionName)) {
            this.runTest = false;
            this.m_targetConnectionName = currentSelection;
        }
    }

    private static boolean stringsDiffer(String s1, String s2) {
        if (s1 == null) {
            return s2 != null;
        }
        if (s2 == null) {
            return true;
        }
        return !s1.equals(s2);
    }

    private void setWizardButtons() {
        if (this.m_targetConnectionName != null) {
            this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        } else {
            this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        }
    }
}

