/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.treeTable;

import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import oracle.dbtools.migration.workbench.core.ui.treeTable.MigrationLogModel;
import oracle.dbtools.migration.workbench.core.ui.treeTable.MigrationTreeNode;
import oracle.dbtools.migration.workbench.core.ui.treeTable.TreeTableFilter;
import oracle.ide.controls.AbstractTreeTableModel;

public class FilteredMigrationLogModel
extends AbstractTreeTableModel
implements TreeModelListener {
    private MigrationLogModel _delegateModel;
    private TreeTableFilter _treeFilter;

    public FilteredMigrationLogModel(MigrationLogModel delegateModel, TreeTableFilter treeFilter) {
        super((Object)delegateModel.getRoot());
        this._delegateModel = delegateModel;
        this._treeFilter = treeFilter;
        delegateModel.addTreeModelListener(this);
    }

    public MigrationLogModel getDelegateModel() {
        return this._delegateModel;
    }

    public MigrationTreeNode getRoot() {
        return (MigrationTreeNode)super.getRoot();
    }

    public Class getColumnClass(int column) {
        return this._delegateModel.getColumnClass(column);
    }

    public int getColumnCount() {
        return this._delegateModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this._delegateModel.getColumnName(column);
    }

    public Object getValueAt(Object node, int column) {
        return this._delegateModel.getValueAt(node, column);
    }

    public Object getChild(Object parent, int index) {
        int cnt = -1;
        for (int i = 0; i < this._delegateModel.getChildCount(parent); ++i) {
            Object child = this._delegateModel.getChild(parent, i);
            if (this._treeFilter.pass((MigrationTreeNode)child)) {
                ++cnt;
            }
            if (cnt != index) continue;
            return child;
        }
        return null;
    }

    public int getChildCount(Object parent) {
        int realCount = this._delegateModel.getChildCount(parent);
        int filterCount = 0;
        for (int i = 0; i < realCount; ++i) {
            MigrationTreeNode dmtn = (MigrationTreeNode)this._delegateModel.getChild(parent, i);
            if (!this._treeFilter.pass(dmtn)) continue;
            ++filterCount;
        }
        return filterCount;
    }

    public boolean isLeaf(Object node) {
        return this._delegateModel.isLeaf(node);
    }

    public void setFiltered(Object object) {
        if (this._treeFilter.getFilterObject() == object) {
            return;
        }
        this._treeFilter.setFiltered(object);
        MigrationTreeNode rootNode = (MigrationTreeNode)this.root;
        Object[] path = new Object[]{this.root};
        int[] childIndices = new int[rootNode.getChildCount()];
        Object[] children = new Object[rootNode.getChildCount()];
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            childIndices[i] = i;
            children[i] = rootNode.getChildAt(i);
        }
        this.fireTreeStructureChanged(this, path, null, null);
    }

    public void treeNodesChanged(TreeModelEvent e) {
        Object[] path = new Object[]{this.root};
        this.fireTreeNodesChanged(this, path, null, null);
    }

    public void treeNodesInserted(TreeModelEvent e) {
        Object[] path = new Object[]{this.root};
        this.fireTreeNodesInserted(this, path, null, null);
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        Object[] path = new Object[]{this.root};
        this.fireTreeNodesRemoved(this, path, null, null);
    }

    public void treeStructureChanged(TreeModelEvent e) {
        Object[] path = new Object[]{this.root};
        this.fireTreeStructureChanged(this, path, null, null);
    }
}

