/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.treeTable;

import java.sql.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.ui.treeTable.MigrationTreeNode;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.TreeTableModel;

public class MigrationLogModel
extends AbstractTreeTableModel {
    private static final String ROOT_MESSAGE = MigrationAddinArb.getString(100);
    public static final String MESSAGE = MigrationAddinArb.getString(97);
    public static final String DATE = MigrationAddinArb.getString(96);
    public static final String SOURCE = MigrationAddinArb.getString(98);
    private final String[] _cNames = new String[]{MESSAGE, DATE, SOURCE};
    private final Class[] _cTypes = new Class[]{TreeTableModel.class, Object.class, Object.class};

    public MigrationLogModel() {
        super((Object)new MigrationTreeNode(new LogRecord(Level.CONFIG, ROOT_MESSAGE)));
    }

    public MigrationTreeNode getRoot() {
        return (MigrationTreeNode)super.getRoot();
    }

    public Class getColumnClass(int column) {
        return this._cTypes[column];
    }

    public int getChildCount(Object node) {
        return ((MigrationTreeNode)node).getChildCount();
    }

    public Object getChild(Object node, int i) {
        return ((MigrationTreeNode)node).getChildren().get(i);
    }

    public boolean isLeaf(Object node) {
        if (node == this.getRoot()) {
            return false;
        }
        return this.getChildCount(node) == 0;
    }

    public int getColumnCount() {
        return this._cNames.length;
    }

    public String getColumnName(int column) {
        return this._cNames[column];
    }

    public Object getValueAt(Object node, int column) {
        if (!(node instanceof MigrationTreeNode)) {
            return node;
        }
        MigrationTreeNode migrNode = (MigrationTreeNode)node;
        try {
            switch (column) {
                case 0: {
                    return migrNode.toString();
                }
                case 1: {
                    LogRecord logRecord = migrNode.getUserObject();
                    Date date = new Date(logRecord.getMillis());
                    String formatNLSDate = MigrationUtils.formatNLSDate(date);
                    return formatNLSDate;
                }
                case 2: {
                    LogRecord logRecord = migrNode.getUserObject();
                    List<LogInfo> logInfoParaList = MigrationLogUtil.searchParameterByType(logRecord.getParameters(), LogInfo.class);
                    String sourceDisplayString = "";
                    if (logInfoParaList.size() == 1) {
                        sourceDisplayString = logInfoParaList.get(0).getSourceDisplayString();
                        return sourceDisplayString;
                    }
                    return sourceDisplayString;
                }
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        return "";
    }
}

