/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.treeTable;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationTreeNode {
    private LogRecord _userObject;
    private List<MigrationTreeNode> _children;
    private String _displayString;

    public MigrationTreeNode(LogRecord userObject) {
        this(userObject.getMessage(), userObject);
    }

    public MigrationTreeNode(String displayString, LogRecord userObject) {
        this._userObject = userObject;
        this._displayString = displayString;
        this._children = new ArrayList<MigrationTreeNode>();
    }

    public String toString() {
        return this._displayString;
    }

    public LogRecord getUserObject() {
        return this._userObject;
    }

    public List<MigrationTreeNode> getChildren() {
        return this._children;
    }

    public MigrationTreeNode addChild(String displayStr, LogRecord record) {
        MigrationTreeNode newChild = new MigrationTreeNode(displayStr, record);
        this._children.add(newChild);
        return newChild;
    }

    public MigrationTreeNode getChildAt(int index) {
        return this._children.get(index);
    }

    public int getChildCount() {
        return this._children.size();
    }

    public MigrationTreeNode insertChildAt(int insertIndex, String displayStr, LogRecord recToInsert) {
        MigrationTreeNode newChild = new MigrationTreeNode(displayStr, recToInsert);
        this._children.add(insertIndex, newChild);
        return newChild;
    }

    public void removeChildAt(int rowIndex) {
        this._children.remove(rowIndex);
    }

    public void removeAllChildren() {
        this._children.clear();
    }
}

