/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MgvAllCatalogsRec;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.BasicMigrationStorer;

public class IncrementalMigrationStorer
extends BasicMigrationStorer {
    private MdConnection m_connection;

    public IncrementalMigrationStorer(PersistenceManager persistenceManager, MdConnection mdconnection) {
        super(persistenceManager);
        this.setTargetMDConnection(mdconnection);
    }

    public PersistableObject storeObject(PersistableObject persistableObject) throws PersistenceException {
        MdCatalog catalog;
        if (persistableObject instanceof MdConnection) {
            return this.getTargetMDConnection();
        }
        if (persistableObject instanceof MdCatalog && MigrationUtils.catalogIsDummy(catalog = (MdCatalog)persistableObject)) {
            CloseableIterator<MgvAllCatalogsRec> allCatalogs = this.getPersistenceUtility().getCatalogsForConnectionId(this.m_connection.getKey());
            MgvAllCatalogsRec catRec = (MgvAllCatalogsRec)allCatalogs.next();
            try {
                catalog = MdCatalog.retrieveExistingInstance(this.getPersistenceManager(), catRec.getCatalogId());
            }
            catch (NoSuchObjectException nsme) {
                throw new PersistenceException(nsme);
            }
            allCatalogs.close();
            return catalog;
        }
        try {
            DBObjectId existingId = this.checkExisting(persistableObject);
            if (existingId != null) {
                try {
                    PersistableObject ret = this.getPersistenceUtility().loadPersistableObject(existingId, persistableObject.getObjectType());
                    return ret;
                }
                catch (NoSuchObjectException nsoe) {
                    throw new PersistenceException(nsoe);
                }
            }
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        return super.storeObject(persistableObject);
    }

    protected MdConnection getTargetMDConnection() {
        return this.m_connection;
    }

    protected void setTargetMDConnection(MdConnection connection) {
        this.m_connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBObjectId checkExisting(PersistableObject po) throws SQLException {
        ResultSet rs;
        block5: {
            DBObjectId dBObjectId;
            String parentField = po.getContainerFieldName();
            if (parentField == null) {
                return null;
            }
            String poName = po.getObjectName();
            if (poName == null || poName.trim().length() == 0) {
                return null;
            }
            String sql = "SELECT ID FROM " + po.getObjectType() + " WHERE " + po.getContainerFieldName() + " = ? AND " + po.getObjectNameFieldName() + " = ?";
            PreparedStatement stmt = null;
            rs = null;
            try {
                stmt = this.getPersistenceManager().getPreparedStatement(sql);
                stmt.setLong(1, po.getContainerId().getId());
                stmt.setString(2, po.getObjectName());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                long l = rs.getLong(1);
                dBObjectId = new DBObjectId(l);
                Object var11_9 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                CloseableResultSet.close(null, rs);
                throw throwable;
            }
            CloseableResultSet.close(null, rs);
            return dBObjectId;
        }
        Object var11_10 = null;
        CloseableResultSet.close(null, rs);
        return null;
    }
}

