/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;

public final class MigrationResourceManager {
    private static HashMap<String, Image> s_classImageMap = new HashMap();

    private MigrationResourceManager() {
    }

    private static Image getImage(InputStream is) {
        try {
            int n;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((n = is.read(buf)) != -1) {
                baos.write(buf, 0, n);
            }
            baos.close();
            return Toolkit.getDefaultToolkit().createImage(baos.toByteArray());
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Image getImage(Class clazz, String path) {
        String key = clazz.getName() + '|' + path;
        Image image = s_classImageMap.get(key);
        if (image == null) {
            if (path.length() > 0 && path.charAt(0) == '/') {
                String newPath = path.substring(1, path.length());
                image = MigrationResourceManager.getImage(new BufferedInputStream(clazz.getClassLoader().getResourceAsStream(newPath)));
            } else {
                image = MigrationResourceManager.getImage(clazz.getResourceAsStream(path));
            }
            s_classImageMap.put(key, image);
        }
        return image;
    }

    public static Image getImage(String path) {
        return MigrationResourceManager.getImage("default", path);
    }

    public static Image getImage(String section, String path) {
        String key = section + '|' + MigrationResourceManager.class.getName() + '|' + path;
        Image image = s_classImageMap.get(key);
        if (image == null) {
            try {
                FileInputStream fis = new FileInputStream(path);
                image = MigrationResourceManager.getImage(fis);
                s_classImageMap.put(key, image);
                fis.close();
            }
            catch (IOException e) {
                return null;
            }
        }
        return image;
    }

    public static void clearImages(String section) {
        Iterator<String> it = s_classImageMap.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            if (!key.startsWith(section + '|')) continue;
            Image image = s_classImageMap.get(key);
            image.flush();
            it.remove();
        }
    }

    public static ImageIcon getIcon(Class clazz, String path) {
        return MigrationResourceManager.getIcon(MigrationResourceManager.getImage(clazz, path));
    }

    public static ImageIcon getIcon(String path) {
        return MigrationResourceManager.getIcon("default", path);
    }

    public static ImageIcon getIcon(String section, String path) {
        return MigrationResourceManager.getIcon(MigrationResourceManager.getImage(section, path));
    }

    public static ImageIcon getIcon(Image image) {
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }
}

