/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.util;

import java.lang.reflect.Method;

public class ObjectRunner {
    public Object runObject(Object o, String[] args) throws Exception {
        Object result = null;
        Class<?> myClass = o.getClass();
        Method meth = ObjectRunner.getMethodCalled(myClass, args[0], args.length - 1);
        Object target = (meth.getModifiers() & 8) != 0 ? null : o;
        String[] newArgs = new String[args.length - 1];
        for (int i = 0; i < newArgs.length; ++i) {
            newArgs[i] = args[i + 1];
        }
        result = meth.invoke(target, ObjectRunner.convertArgs(newArgs, meth.getParameterTypes()));
        return result;
    }

    private static Object[] convertArgs(String[] args, Class[] types) throws Exception {
        Object[] returnArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            returnArgs[i] = ObjectRunner.convertFromString(args[i], types[i]);
        }
        return returnArgs;
    }

    private static Object convertFromString(String value, Class type) throws Exception {
        if (type == Character.TYPE) {
            return new Character(value.charAt(0));
        }
        if (type == Integer.TYPE) {
            return new Integer(value);
        }
        if (type == Long.TYPE) {
            return new Long(value);
        }
        if (type == Double.TYPE) {
            return new Double(value);
        }
        if (type == Float.TYPE) {
            return new Float(value);
        }
        if (type == Boolean.TYPE) {
            return new Boolean(value);
        }
        if (type == String.class) {
            return value;
        }
        Class[] params = new Class[]{String.class};
        Object[] args = new Object[]{value};
        return type.getConstructor(params).newInstance(args);
    }

    private static Method getMethodCalled(Class myClass, String name, int length) throws Exception {
        Method[] meths = myClass.getMethods();
        for (int i = 0; i < meths.length; ++i) {
            if (meths[i].getParameterTypes().length != length || !meths[i].getName().equals(name)) continue;
            return meths[i];
        }
        throw new NoSuchMethodException("cannot find " + name + " with " + length + " parameters");
    }
}

