/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.migration.workbench.core.util.Pollable;
import oracle.dbtools.migration.workbench.core.util.SchedulerKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scheduler
implements Runnable {
    private long m_shortestInterval = 0L;
    private static Scheduler s_migrationTimer;
    private int m_key = 0;
    private Hashtable<Integer, InternalScheduledObject> m_listeners;
    private Thread m_thread = null;
    private Object m_syncObj = new Object();
    private boolean m_quit = false;

    private Scheduler() {
        this.m_thread = new Thread(this);
        this.m_thread.start();
    }

    public static Scheduler getInstance() {
        if (s_migrationTimer == null) {
            s_migrationTimer = new Scheduler();
        }
        return s_migrationTimer;
    }

    @Override
    public void run() {
        long lSleepTime = 0L;
        while (!this.m_quit) {
            try {
                lSleepTime = this.checkFireListeners(lSleepTime);
                Thread.sleep(lSleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void fireListeners() {
        long nextInterval = this.m_shortestInterval;
        Set<Integer> keys = this.getListeners().keySet();
        Iterator<Integer> it = keys.iterator();
        while (it.hasNext()) {
            InternalScheduledObject workObject = this.getListeners().get(it.next());
            if (workObject.getTimeLeft() - this.m_shortestInterval <= 0L) {
                workObject.getListener().poll();
                workObject.setTimeLeft(workObject.getInterval());
                continue;
            }
            if (workObject.getTimeLeft() >= nextInterval) continue;
            nextInterval = workObject.getTimeLeft();
            System.out.println(nextInterval);
        }
        System.out.println(nextInterval);
        this.m_shortestInterval = nextInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long checkFireListeners(long lDecrementVal) {
        long lNextInterval = Long.MAX_VALUE;
        Object object = this.m_syncObj;
        synchronized (object) {
            for (InternalScheduledObject so : this.getListeners().values()) {
                so.decrementTime(lDecrementVal);
                if (so.getTimeLeft() <= 0L) {
                    so.fireEvent();
                }
                if (so.getTimeLeft() >= lNextInterval) continue;
                lNextInterval = so.getTimeLeft();
            }
        }
        return lNextInterval;
    }

    protected Hashtable<Integer, InternalScheduledObject> getListeners() {
        if (this.m_listeners == null) {
            this.m_listeners = new Hashtable();
        }
        return this.m_listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchedulerKey addListener(Pollable listener, long interval) {
        ++this.m_key;
        Object object = this.m_syncObj;
        synchronized (object) {
            this.getListeners().put(this.m_key, new InternalScheduledObject(listener, interval));
        }
        this.m_thread.interrupt();
        return new SchedulerKey(this.m_key);
    }

    public void removeListener(SchedulerKey key) {
        this.getListeners().remove(key.getKey());
    }

    private class InternalScheduledObject {
        private Pollable m_listener = null;
        private long m_interval = 0L;
        private long m_timeLeft = 0L;

        protected InternalScheduledObject(Pollable theListener, long theInterval) {
            this.m_listener = theListener;
            this.setInterval(theInterval);
            this.setTimeLeft(theInterval);
        }

        protected Pollable getListener() {
            return this.m_listener;
        }

        protected long getInterval() {
            return this.m_interval;
        }

        protected void setInterval(long theInterval) {
            this.m_interval = theInterval;
        }

        protected long getTimeLeft() {
            return this.m_timeLeft;
        }

        protected void setTimeLeft(long timeLeft) {
            this.m_timeLeft = timeLeft;
        }

        protected void decrementTime(long lTime) {
            this.m_timeLeft -= lTime;
        }

        protected void fireEvent() {
            this.getListener().poll();
            this.setTimeLeft(this.getInterval());
        }
    }
}

