/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.importexport;

import java.awt.Component;
import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ideri.importexport.ExportInvoker;
import oracle.ideri.importexport.ImportExportInvoker;
import oracle.ideri.importexport.ImportExportWizard;
import oracle.ideri.importexport.ImportInvoker;
import oracle.javatools.dialogs.ExceptionDialog;

public class ImportExportManager {
    private static final ImportExportManager _instance = new ImportExportManager();
    private ArrayList _importWizards;
    private ArrayList _exportWizards;

    private void $init$() {
        this._importWizards = new ArrayList();
        this._exportWizards = new ArrayList();
    }

    private ImportExportManager() {
        this.$init$();
    }

    public static ImportExportManager getManager() {
        return _instance;
    }

    public void registerImportWizard(Class clazz, String[] params) {
        this.registerWizard(new ImportInvoker(), clazz, params, this._importWizards);
    }

    public void registerImportWizard(ClassLoader classLoader, String className, String[] params) {
        this.registerWizard(new ImportInvoker(), classLoader, className, params, this._importWizards);
    }

    public void invokeImportWizard(Component parent, Context context) {
        this.invokeWizard(parent, context, this._importWizards, 7, 8, "f1_idedimport_html");
    }

    public void registerExportWizard(Class clazz, String[] params) {
        this.registerWizard(new ExportInvoker(), clazz, params, this._importWizards);
    }

    public void registerExportWizard(ClassLoader classLoader, String className, String[] params) {
        this.registerWizard(new ExportInvoker(), classLoader, className, params, this._exportWizards);
    }

    public void invokeExportWizard(Component parent, Context context) {
        this.invokeWizard(parent, context, this._exportWizards, 3, 2, "f1_idedexport_html");
    }

    private void registerWizard(ImportExportInvoker invoker, Class clazz, String[] params, ArrayList invokers) {
        if (clazz == null) {
            throw new IllegalArgumentException("No wizard class to register");
        }
        invoker.setClass(clazz);
        invoker.setParams(params);
        invokers.add(invoker);
    }

    private void registerWizard(ImportExportInvoker invoker, ClassLoader classLoader, String className, String[] params, ArrayList invokers) {
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (className == null) {
            throw new IllegalArgumentException("No classname to register");
        }
        invoker.setClassLoader(classLoader);
        invoker.setClassName(className);
        invoker.setParams(params);
        invokers.add(invoker);
    }

    private void invokeWizard(Component parent, Context context, ArrayList invokers, int titleIndex, int labelIndex, String helpTag) {
        try {
            ImportExportWizard wizard = new ImportExportWizard(parent, context, invokers, titleIndex, labelIndex, helpTag);
            if (wizard.runDialog()) {
                wizard.getSelectedWizard().invokeWizard(context);
            }
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Component)parent, (Throwable)e);
        }
    }

    public boolean hasExportWizardsEnabled(Context context) {
        boolean enabled = false;
        for (ImportExportInvoker invoker : this._exportWizards) {
            try {
                if (!invoker.isAvailable(context)) continue;
                enabled = true;
                break;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return enabled;
    }
}

