/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.FileAssociations;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.icons.IdeIcons;
import oracle.ide.model.ContentType;
import oracle.ide.model.DeployableTextNode;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Recognizer;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.MenuSpec;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.resource.FileBundle;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.javatools.dialogs.MessageDialog;

public class DocumentExtensionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private Map _docRecordCache;
    private Map _extInfoCache;
    private Map _editorAddinCache;
    private Map _extensionToContentTypeMap;
    private Map _defaultEditorMap;
    private Map _associationMap;
    private static final boolean IS_WINDOWS = File.separatorChar == '\\' && System.getProperty("ide.shell.enableFileTypeAssociation") != null;
    private final JTabbedPane _tabbedPane;
    private final JPanel _fileTypesPanel;
    private final FileTypesTable _fileTypesTable;
    private final JPanel _fileTypesDetailPanel;
    private final JButton _addButton;
    private final JButton _removeButton;
    private final JLabel _fileTypeLabel;
    private final JComboBox _fileTypeCombo;
    private final JLabel _contentLabel;
    private final JRadioButton _contentTextRadioButton;
    private final JRadioButton _contentBinaryRadioButton;
    private JCheckBox _openWithCheckBox;
    private ImageIcon _openWithIcon;
    private TitledBorder _fileTypesDetailBorder;
    private final JPanel _defaultEditorsPanel;
    private final DefaultEditorsTable _defaultEditorsTable;
    private final JPanel _defaultEditorsDetailPanel;
    private final JLabel _defaultEditorLabel;
    private final JComboBox _defaultEditorCombo;
    private final JLabel _defaultEditorCustomizedLabel;
    private final JPanel _spacerPanel;
    private TitledBorder _defaultEditorsDetailBorder;

    private void $init$() {
        this._tabbedPane = new JTabbedPane();
        this._fileTypesPanel = new JPanel();
        this._fileTypesTable = new FileTypesTable(null);
        this._fileTypesDetailPanel = new JPanel();
        this._addButton = new JButton();
        this._removeButton = new JButton();
        this._fileTypeLabel = new JLabel();
        this._fileTypeCombo = new JComboBox();
        this._contentLabel = new JLabel();
        this._contentTextRadioButton = new JRadioButton();
        this._contentBinaryRadioButton = new JRadioButton();
        this._defaultEditorsPanel = new JPanel();
        this._defaultEditorsTable = new DefaultEditorsTable(null);
        this._defaultEditorsDetailPanel = new JPanel();
        this._defaultEditorLabel = new JLabel();
        this._defaultEditorCombo = new JComboBox();
        this._defaultEditorCustomizedLabel = new JLabel();
        this._spacerPanel = new JPanel();
    }

    public DocumentExtensionsPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setHelpID("f1_idedidesetfiletypes_html");
    }

    public void onEntry(TraversableContext tc) {
        DocumentExtensions dext = (DocumentExtensions)tc.find("document-extensions-options");
        this.loadFrom(dext);
    }

    public void onExit(TraversableContext tc) {
        DocumentExtensions dext = (DocumentExtensions)tc.find("document-extensions-options");
        this.commitTo(dext);
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        DocumentExtensions dext = (DocumentExtensions)tc.find("document-extensions-options");
        Collection docs = dext.getDocuments();
        DocumentExtensions.DocRecord[] recs = new DocumentExtensions.DocRecord[docs.size()];
        recs = docs.toArray(recs);
        dext.setUserExtensionList(recs);
        dext.setExtensionToContentTypeMap(this._extensionToContentTypeMap);
        dext.setDefaultEditorMap(this._defaultEditorMap);
        if (IS_WINDOWS) {
            this.applyAssociations(dext);
        }
    }

    public void cancel(ApplyEvent e) {
    }

    private void jbInit() throws Exception {
        this.buildLayouts();
        this.initializeFromResources();
        ButtonGroup contentButtonGroup = new ButtonGroup();
        contentButtonGroup.add(this._contentTextRadioButton);
        contentButtonGroup.add(this._contentBinaryRadioButton);
        contentButtonGroup = null;
        this._fileTypesDetailBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder());
        this._fileTypesDetailPanel.setBorder(this._fileTypesDetailBorder);
        CustomComboBoxRenderer renderer = new FileTypeComboBoxRenderer(this._fileTypeCombo);
        this._fileTypeCombo.setRenderer(renderer);
        this._defaultEditorsDetailBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder());
        this._defaultEditorsDetailPanel.setBorder(this._defaultEditorsDetailBorder);
        renderer = new DefaultEditorComboBoxRenderer(this._defaultEditorCombo);
        renderer.setRendererFlags(1);
        this._defaultEditorCombo.setRenderer(renderer);
        this.attachListeners();
    }

    private void buildLayouts() {
        Insets i = new Insets(2, 2, 2, 2);
        LayoutBuilder builder = new LayoutBuilder();
        builder.add((Component)new JScrollPane((Component)((Object)this._fileTypesTable)), i, 3, true, true);
        builder.nl();
        builder.addHFiller();
        builder.add((Component)this._addButton, i, 1, false, false);
        builder.add((Component)this._removeButton, i, 1, false, false);
        builder.nl();
        builder.add((Component)this._fileTypesDetailPanel, i, 3, false, true);
        builder.nl();
        builder.addToPanel((Container)this._fileTypesPanel);
        builder = new LayoutBuilder();
        builder.add((Component)this._fileTypeLabel, i, 2, false, false);
        builder.add((Component)this._fileTypeCombo, i, 2, false, true);
        builder.nl();
        builder.add((Component)this._contentLabel, i, 1, false, false);
        builder.addHGap();
        builder.add((Component)this._contentTextRadioButton, i, 1, false, false);
        builder.add((Component)this._contentBinaryRadioButton, i, 1, false, true);
        builder.nl();
        if (IS_WINDOWS) {
            this._openWithCheckBox = new JCheckBox();
            builder.add((Component)this._openWithCheckBox, i, 4, false, true);
            builder.nl();
        }
        builder.addToPanel((Container)this._fileTypesDetailPanel);
        builder = new LayoutBuilder();
        builder.add((Component)new JScrollPane((Component)((Object)this._defaultEditorsTable)), i, 1, true, true);
        builder.nl();
        builder.add((Component)this._spacerPanel, i, 1, false, true);
        builder.nl();
        builder.add((Component)this._defaultEditorsDetailPanel, i, 1, false, true);
        builder.nl();
        builder.addToPanel((Container)this._defaultEditorsPanel);
        builder = new LayoutBuilder();
        builder.add((Component)this._defaultEditorLabel, i, 1, false, false);
        builder.addHGap();
        builder.add((Component)this._defaultEditorCombo, i, 1, false, true);
        builder.nl();
        builder.addHGap();
        builder.addHGap();
        builder.add((Component)this._defaultEditorCustomizedLabel, i, 1, false, true);
        builder.nl();
        builder.addToPanel((Container)this._defaultEditorsDetailPanel);
        this.setLayout(new BorderLayout());
        this._tabbedPane.add(this._fileTypesPanel);
        this._tabbedPane.add(this._defaultEditorsPanel);
        this.add(this._tabbedPane, "Center");
    }

    private void initializeFromResources() {
        this._tabbedPane.setTitleAt(0, FileBundle.getBundle().getString("FILE_TYPES_LABEL"));
        this._tabbedPane.setTitleAt(1, FileBundle.getBundle().getString("DEFAULT_EDITORS_LABEL"));
        ResourceUtils.resButton((AbstractButton)this._addButton, (String)FileBundle.getBundle().getString("ADD_BUTTON_LABEL"));
        ResourceUtils.resButton((AbstractButton)this._removeButton, (String)FileBundle.getBundle().getString("REMOVE_BUTTON_LABEL"));
        ResourceUtils.resLabel((JLabel)this._fileTypeLabel, (Component)this._fileTypeCombo, (String)FileBundle.getBundle().getString("FILE_TYPE_LABEL"));
        ResourceUtils.resLabel((JLabel)this._contentLabel, (Component)this._contentTextRadioButton, (String)FileBundle.getBundle().getString("CONTENT_LABEL"));
        ResourceUtils.resButton((AbstractButton)this._contentTextRadioButton, (String)FileBundle.getBundle().getString("CONTENT_TEXT"));
        ResourceUtils.resButton((AbstractButton)this._contentBinaryRadioButton, (String)FileBundle.getBundle().getString("CONTENT_BINARY"));
        if (IS_WINDOWS) {
            ResourceUtils.resButton((AbstractButton)this._openWithCheckBox, (String)MessageFormat.format(FileBundle.getBundle().getString("OPEN_WITH_LABEL"), Ide.getProgramShortName()));
            this._openWithIcon = new ImageIcon(IdeIcons.getImage((int)1));
        }
        ResourceUtils.resLabel((JLabel)this._defaultEditorLabel, (Component)this._defaultEditorCombo, (String)FileBundle.getBundle().getString("DEFAULT_EDITOR_LABEL"));
    }

    private void attachListeners() {
        this._fileTypesTable.getSelectionModel().addListSelectionListener(new 1());
        this._addButton.addActionListener(new 2());
        this._removeButton.addActionListener(new 3());
        this._fileTypeCombo.addItemListener(new 4());
        this._contentTextRadioButton.addActionListener(new 5());
        this._contentBinaryRadioButton.addActionListener(new 6());
        if (IS_WINDOWS) {
            this._openWithCheckBox.addActionListener(new 7());
        }
        this._defaultEditorsTable.getSelectionModel().addListSelectionListener(new 8());
        this._defaultEditorCombo.addItemListener(new 9());
    }

    private void loadFrom(DocumentExtensions dext) {
        this._docRecordCache = this.createDocRecordCache(dext);
        this._extInfoCache = this.createExtInfoCache(dext);
        this._editorAddinCache = this.createEditorAddinCache(dext);
        this._extensionToContentTypeMap = dext.getExtensionToContentTypeMap();
        this._extensionToContentTypeMap = this.copyMap(this._extensionToContentTypeMap);
        this._defaultEditorMap = dext.getDefaultEditorMap();
        this._defaultEditorMap = this.copyMap(this._defaultEditorMap);
        if (IS_WINDOWS) {
            this._associationMap = dext.getAssociationMap();
            this._associationMap = this.copyMap(this._associationMap);
        }
        if (this._fileTypesTable.getBaseModel() instanceof FileTypesTableModel) {
            return;
        }
        this._fileTypesTable.installModel(this.createFileTypesTableModel());
        this._defaultEditorsTable.installModel(this.createDefaultEditorsTableModel());
        this._fileTypeCombo.setModel(this.createFileTypeComboModel());
        this._fileTypesTable_valueChanged(null);
        this._defaultEditorsTable_valueChanged(null);
        Dimension detailSize = new Dimension(Math.max(this._fileTypesDetailPanel.getPreferredSize().width, this._defaultEditorsDetailPanel.getPreferredSize().width), Math.max(this._fileTypesDetailPanel.getPreferredSize().height, this._defaultEditorsDetailPanel.getPreferredSize().height));
        this._fileTypesDetailPanel.setPreferredSize(detailSize);
        this._defaultEditorsDetailPanel.setPreferredSize(detailSize);
        this._spacerPanel.setPreferredSize(this._addButton.getPreferredSize());
    }

    private void commitTo(DocumentExtensions dext) {
        if (IS_WINDOWS) {
            dext.setAssociationMap(this._associationMap);
        }
    }

    private Map copyMap(Map map) {
        return map != null ? new HashMap(map) : new HashMap();
    }

    private Map createDocRecordCache(DocumentExtensions dext) {
        HashMap<Class, DocumentExtensions.DocRecord> docRecordCache = new HashMap<Class, DocumentExtensions.DocRecord>();
        for (DocumentExtensions.DocRecord rec : dext.getDocuments()) {
            docRecordCache.put(rec.getDocClass(), rec);
        }
        return docRecordCache;
    }

    private Map createExtInfoCache(DocumentExtensions dext) {
        HashMap<String, DocumentExtensions.ExtInfo> extInfoCache = new HashMap<String, DocumentExtensions.ExtInfo>();
        for (DocumentExtensions.DocRecord rec : dext.getDocuments()) {
            for (DocumentExtensions.ExtInfo extInfo : rec.getExtensions()) {
                extInfoCache.put(extInfo.getExtension(), extInfo);
            }
        }
        return extInfoCache;
    }

    private Map createEditorAddinCache(DocumentExtensions dext) {
        HashMap<Class, EditorAddin[]> editorAddinCache = new HashMap<Class, EditorAddin[]>();
        Class[] elementTypes = EditorManager.getEditorManager().getStaticElementTypes();
        int i = 0;
        while (i < elementTypes.length) {
            EditorAddin[] editorAddins;
            if (elementTypes[i] != null && (editorAddins = EditorManager.getEditorManager().getStaticAddins(elementTypes[i])) != null && editorAddins.length > 0 && (Recognizer.getDocumentInfo((Class)elementTypes[i]) != null || editorAddins.length >= 2)) {
                editorAddinCache.put(elementTypes[i], editorAddins);
            }
            ++i;
        }
        return editorAddinCache;
    }

    private TableModel createFileTypesTableModel() {
        FileTypesTableModel model = new FileTypesTableModel(null);
        ArrayList<String> extList = new ArrayList<String>();
        model.addColumn(FileBundle.getBundle().getString("COLUMN_EXTENSION"));
        model.addColumn(FileBundle.getBundle().getString("COLUMN_FILE_TYPE"));
        if (IS_WINDOWS) {
            model.addColumn(MessageFormat.format(FileBundle.getBundle().getString("COLUMN_OPEN_WITH"), Ide.getProgramShortName()));
        }
        for (DocumentExtensions.DocRecord rec : this._docRecordCache.values()) {
            for (DocumentExtensions.ExtInfo extInfo : rec.getExtensions()) {
                boolean duplicate = extList.contains(extInfo.getExtension());
                if (!duplicate) {
                    extList.add(extInfo.getExtension());
                }
                if (IS_WINDOWS) {
                    extInfo.setAssociated(FileAssociations.isAssociated((String)extInfo.getExtension()));
                    if (duplicate) continue;
                    model.addRow(new Object[]{extInfo.getExtension(), rec.getDocClass(), extInfo.isAssociated() ? this._openWithIcon : null});
                    continue;
                }
                if (duplicate) continue;
                model.addRow(new Object[]{extInfo.getExtension(), rec.getDocClass()});
            }
        }
        return model;
    }

    private TableModel createDefaultEditorsTableModel() {
        DefaultEditorsTableModel model = new DefaultEditorsTableModel(null);
        model.addColumn(FileBundle.getBundle().getString("COLUMN_FILE_TYPE"));
        model.addColumn(FileBundle.getBundle().getString("COLUMN_DEFAULT_EDITOR"));
        for (Map.Entry entry : this._editorAddinCache.entrySet()) {
            Class docClass = (Class)entry.getKey();
            EditorAddin[] editorAddins = (EditorAddin[])entry.getValue();
            EditorAddin editorAddin = null;
            if (this._defaultEditorMap.containsKey(docClass.getName())) {
                String editorAddinClassName = (String)this._defaultEditorMap.get(docClass.getName());
                int i = 0;
                while (i < editorAddins.length) {
                    if (editorAddins[i].getClass().getName().equals(editorAddinClassName)) {
                        editorAddin = editorAddins[i];
                        break;
                    }
                    ++i;
                }
                if (editorAddin == null) {
                    this._defaultEditorMap.remove(docClass.getName());
                }
            }
            if (editorAddin == null && editorAddins.length > 0) {
                editorAddin = editorAddins[0];
            }
            if (editorAddin == null) continue;
            model.addRow(new Object[]{docClass, editorAddin});
        }
        return model;
    }

    private ComboBoxModel createFileTypeComboModel() {
        SortedComboBoxModel model = new SortedComboBoxModel();
        model.setComparator((Comparator)new FileTypeComparator(null));
        Iterator itr = this._docRecordCache.keySet().iterator();
        while (itr.hasNext()) {
            model.addElement(itr.next());
        }
        return model;
    }

    private ComboBoxModel createDefaultEditorComboModel(Class docClass) {
        SortedComboBoxModel model = new SortedComboBoxModel();
        model.setComparator((Comparator)new DefaultEditorComparator(null));
        if (docClass == null) {
            return model;
        }
        EditorAddin[] editorAddins = (EditorAddin[])this._editorAddinCache.get(docClass);
        int i = 0;
        while (editorAddins != null && i < editorAddins.length) {
            model.addElement((Object)editorAddins[i]);
            ++i;
        }
        return model;
    }

    private void setFileTypesDetailEnabled(boolean enabled) {
        this._removeButton.setEnabled(enabled);
        this._fileTypeLabel.setEnabled(enabled);
        this._fileTypeCombo.setEnabled(enabled);
    }

    private void setFileTypesDetailContentEnabled(boolean enabled) {
        this._contentLabel.setEnabled(enabled);
        this._contentTextRadioButton.setEnabled(enabled);
        this._contentBinaryRadioButton.setEnabled(enabled);
    }

    private void setDefaultEditorsDetailEnabled(boolean enabled) {
        this._defaultEditorLabel.setEnabled(enabled);
        this._defaultEditorCombo.setEnabled(enabled);
        this._defaultEditorCustomizedLabel.setEnabled(enabled);
    }

    private void repaintFileTypesDetailPanel() {
        this.repaintPanel(this._fileTypesDetailPanel);
    }

    private void repaintDefaultEditorsDetailPanel() {
        this.repaintPanel(this._defaultEditorsDetailPanel);
    }

    private void repaintPanel(JPanel panel) {
        panel.invalidate();
        panel.validate();
        panel.repaint();
    }

    private ContentType findContentTypeFromExtension(String ext) {
        ContentType contentType = null;
        if (contentType == null) {
            String name = (String)this._extensionToContentTypeMap.get(ext);
            ContentType contentType2 = contentType = name != null ? ContentType.valueOf((String)name) : null;
        }
        if (contentType == null) {
            contentType = DocumentExtensions.findContentTypeFromExtension((String)ext);
        }
        return contentType;
    }

    private void changeSelectionContentType(ContentType contentType) {
        this._extensionToContentTypeMap.put(this._fileTypesTable.getSelectedExtension(), contentType.name());
    }

    private void setFileTypesContentTypeDefault(Class docClass) {
        String defaultExtension = this.findFirstRecognizerExtension(docClass);
        if (defaultExtension != null) {
            this.changeSelectionContentType(DocumentExtensions.findContentTypeFromExtension((String)defaultExtension));
            this._fileTypesTable_valueChanged(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findFirstRecognizerExtension(Class cls) {
        Map extensionToClassMap;
        Map map = extensionToClassMap = Recognizer.getExtensionToClassMap();
        synchronized (map) {
            for (Map.Entry entry : extensionToClassMap.entrySet()) {
                if (!cls.equals(entry.getValue())) continue;
                File ext = (File)entry.getKey();
                String string = ext.getPath();
                return string;
            }
        }
        return null;
    }

    private void changeDefaultEditor(Class docClass, EditorAddin editorAddin) {
        if (docClass == null || editorAddin == null) {
            return;
        }
        EditorAddin unchangedEditorAddin = ((EditorAddin[])this._editorAddinCache.get(docClass))[0];
        if (editorAddin != unchangedEditorAddin) {
            this._defaultEditorMap.put(docClass.getName(), editorAddin.getClass().getName());
        } else {
            this._defaultEditorMap.remove(docClass.getName());
        }
    }

    private void updateDefaultEditorCustomizedLabel(Class docClass, EditorAddin editorAddin) {
        if (docClass == null || editorAddin == null) {
            this._defaultEditorCustomizedLabel.setText(" ");
            return;
        }
        EditorAddin normalEditorAddin = ((EditorAddin[])this._editorAddinCache.get(docClass))[0];
        if (editorAddin != normalEditorAddin) {
            String normalEditorLabel = normalEditorAddin.getMenuSpecification().label;
            this._defaultEditorCustomizedLabel.setText(MessageFormat.format(FileBundle.getBundle().getString("DEFAULT_EDITOR_CHANGED"), normalEditorLabel));
        } else {
            this._defaultEditorCustomizedLabel.setText(FileBundle.getBundle().getString("DEFAULT_EDITOR_UNCHANGED"));
        }
    }

    private void _fileTypesTable_valueChanged(ListSelectionEvent e) {
        ContentType contentType;
        String extension = this._fileTypesTable.getSelectedExtension();
        Class docClass = this._fileTypesTable.getSelectedDocClass();
        DocumentExtensions.ExtInfo extInfo = extension != null ? (DocumentExtensions.ExtInfo)this._extInfoCache.get(extension) : null;
        this.setFileTypesDetailEnabled(extInfo != null && !extInfo.isLocked());
        this.setFileTypesDetailContentEnabled(extInfo != null);
        this._fileTypesDetailBorder.setTitle(MessageFormat.format(FileBundle.getBundle().getString("FILE_TYPES_DETAIL"), extInfo != null ? extInfo.toString() : ""));
        if (extension == null) {
            this.repaintFileTypesDetailPanel();
            return;
        }
        if (docClass != null) {
            this._fileTypeCombo.setSelectedItem(docClass);
        }
        this._contentTextRadioButton.setSelected((contentType = this.findContentTypeFromExtension(extension)) == ContentType.TEXT);
        this._contentBinaryRadioButton.setSelected(contentType == ContentType.BINARY);
        if (IS_WINDOWS) {
            this._openWithCheckBox.setSelected(extInfo != null && extInfo.isAssociated());
        }
        this.repaintFileTypesDetailPanel();
    }

    private void _addButton_actionPerformed(ActionEvent e) {
        String label;
        AddExtensionDialog dlg = new AddExtensionDialog((Component)((Object)this));
        String title = FileBundle.getBundle().getString("ADD_EXT_TITLE");
        if (!dlg.show(title, label = FileBundle.getBundle().getString("EXT_LABEL"), "f1_idedaddextension_html")) {
            return;
        }
        String extension = DocumentExtensions.DocRecord.sanitizeExtensionAsString((String)dlg.getInputValue());
        if (IS_WINDOWS) {
            ((FileTypesTableModel)this._fileTypesTable.getBaseModel()).addRow(new Object[]{extension, DeployableTextNode.class, this._openWithIcon});
        } else {
            ((FileTypesTableModel)this._fileTypesTable.getBaseModel()).addRow(new Object[]{extension, DeployableTextNode.class});
        }
        this._fileTypesTable.reSort();
        DocumentExtensions.ExtInfo extInfo = ((DocumentExtensions.DocRecord)this._docRecordCache.get(DeployableTextNode.class)).addUserExtension(extension);
        if (IS_WINDOWS) {
            this._associationMap.put(extension, new Boolean(true));
            extInfo.setAssociated(true);
        }
        this._extInfoCache.put(extension, extInfo);
        this._fileTypesTable.setSelectedExtension(extension);
        this._fileTypesTable_valueChanged(null);
    }

    private void _removeButton_actionPerformed(ActionEvent e) {
        int row = this._fileTypesTable.getSelectedRow();
        String extension = this._fileTypesTable.getSelectedExtension();
        Class docClass = this._fileTypesTable.getSelectedDocClass();
        if (!MessageDialog.optionalConfirm((String)"Ide.FileTypes.RemoveConfirm", null, (String)MessageFormat.format(FileBundle.getBundle().getString("CONFIRM_REMOVE"), extension), (String)FileBundle.getBundle().getString("CONFIRM_REMOVE_TITLE"), null)) {
            return;
        }
        this._extInfoCache.remove(extension);
        if (IS_WINDOWS) {
            this._associationMap.put(extension, new Boolean(false));
        }
        this._extensionToContentTypeMap.remove(extension);
        FileTypesTableModel model = (FileTypesTableModel)this._fileTypesTable.getBaseModel();
        model.removeRow(this._fileTypesTable.rowIndexOfExtension(extension, model));
        this._fileTypesTable.reSort();
        ((DocumentExtensions.DocRecord)this._docRecordCache.get(docClass)).removeUserExtension(extension);
        if (this._fileTypesTable.getRowCount() <= 0) {
            return;
        }
        this._fileTypesTable.setSelectedRow(Math.min(row, this._fileTypesTable.getRowCount() - 1));
        this._fileTypesTable_valueChanged(null);
    }

    private void _fileTypeCombo_itemStateChanged(ItemEvent e) {
        Class userDocClass;
        String extension = this._fileTypesTable.getSelectedExtension();
        Class docClass = this._fileTypesTable.getSelectedDocClass();
        if (docClass.equals(userDocClass = (Class)this._fileTypeCombo.getSelectedItem())) {
            return;
        }
        ((DocumentExtensions.DocRecord)this._docRecordCache.get(docClass)).removeUserExtension(extension);
        DocumentExtensions.ExtInfo extInfo = ((DocumentExtensions.DocRecord)this._docRecordCache.get(userDocClass)).addUserExtension(extension);
        this._extInfoCache.put(extension, extInfo);
        FileTypesTableModel model = (FileTypesTableModel)this._fileTypesTable.getBaseModel();
        int row = this._fileTypesTable.rowIndexOfExtension(extension, model);
        this._fileTypesTable.setBaseModelDocClassValue(userDocClass, row);
        this.setFileTypesContentTypeDefault(userDocClass);
    }

    private void _contentTextRadioButton_actionPerformed(ActionEvent e) {
        this.changeSelectionContentType(ContentType.TEXT);
    }

    private void _contentBinaryRadioButton_actionPerformed(ActionEvent e) {
        this.changeSelectionContentType(ContentType.BINARY);
    }

    private void _openWithCheckBox_actionPerformed(ActionEvent e) {
        DocumentExtensions.ExtInfo extInfo;
        String extension = this._fileTypesTable.getSelectedExtension();
        boolean selected = this._openWithCheckBox.isSelected();
        DocumentExtensions.ExtInfo extInfo2 = extInfo = extension != null ? (DocumentExtensions.ExtInfo)this._extInfoCache.get(extension) : null;
        if (extInfo == null) {
            return;
        }
        this._associationMap.put(extension, new Boolean(selected));
        extInfo.setAssociated(selected);
        this._extInfoCache.put(extension, extInfo);
        FileTypesTableModel model = (FileTypesTableModel)this._fileTypesTable.getBaseModel();
        int row = this._fileTypesTable.rowIndexOfExtension(extension, model);
        this._fileTypesTable.setBaseModelOpenWithValue(this._openWithCheckBox.isSelected() ? this._openWithIcon : null, row);
        this._fileTypesTable_valueChanged(null);
    }

    private void _defaultEditorsTable_valueChanged(ListSelectionEvent e) {
        DocumentExtensions.DocRecord rec;
        Class docClass = this._defaultEditorsTable.getSelectedDocClass();
        EditorAddin editorAddin = this._defaultEditorsTable.getSelectedEditorAddin();
        DocumentExtensions.DocRecord docRecord = rec = docClass != null ? (DocumentExtensions.DocRecord)this._docRecordCache.get(docClass) : null;
        if (docClass != null) {
            this._defaultEditorCombo.setModel(this.createDefaultEditorComboModel(docClass));
        }
        this.setDefaultEditorsDetailEnabled(docClass != null && this._defaultEditorCombo.getModel().getSize() > 1);
        this._defaultEditorsDetailBorder.setTitle(MessageFormat.format(FileBundle.getBundle().getString("DEFAULT_EDITORS_DETAIL"), docClass != null ? RendererUtil.getDocumentLabel(docClass) : ""));
        if (docClass == null) {
            this.repaintDefaultEditorsDetailPanel();
            return;
        }
        if (editorAddin != null) {
            this._defaultEditorCombo.setSelectedItem(editorAddin);
        }
        this.updateDefaultEditorCustomizedLabel(docClass, editorAddin);
        this.repaintDefaultEditorsDetailPanel();
    }

    private void _defaultEditorCombo_itemStateChanged(ItemEvent e) {
        EditorAddin userEditorAddin;
        Class docClass = this._defaultEditorsTable.getSelectedDocClass();
        EditorAddin editorAddin = this._defaultEditorsTable.getSelectedEditorAddin();
        if (editorAddin.equals((Object)(userEditorAddin = (EditorAddin)this._defaultEditorCombo.getSelectedItem()))) {
            return;
        }
        DefaultEditorsTableModel model = (DefaultEditorsTableModel)this._defaultEditorsTable.getBaseModel();
        int row = this._defaultEditorsTable.rowIndexOfDocClass(docClass, model);
        this._defaultEditorsTable.setBaseModelEditorAddinValue(userEditorAddin, row);
        this.changeDefaultEditor(docClass, userEditorAddin);
        this.updateDefaultEditorCustomizedLabel(docClass, userEditorAddin);
    }

    private void applyAssociations(DocumentExtensions dext) {
        FileAssociations.setAssociations((Map)this._associationMap);
        this._associationMap.clear();
        dext.setAssociationMap(this._associationMap);
    }

    static boolean ra$IS_WINDOWS() {
        return IS_WINDOWS;
    }

    static ImageIcon ra$_openWithIcon(DocumentExtensionsPanel documentExtensionsPanel) {
        return documentExtensionsPanel._openWithIcon;
    }

    static Map ra$_extInfoCache(DocumentExtensionsPanel documentExtensionsPanel) {
        return documentExtensionsPanel._extInfoCache;
    }

    static void mav$_fileTypesTable_valueChanged(DocumentExtensionsPanel documentExtensionsPanel, ListSelectionEvent listSelectionEvent) {
        documentExtensionsPanel._fileTypesTable_valueChanged(listSelectionEvent);
    }

    static void mav$_addButton_actionPerformed(DocumentExtensionsPanel documentExtensionsPanel, ActionEvent actionEvent) {
        documentExtensionsPanel._addButton_actionPerformed(actionEvent);
    }

    static void mav$_removeButton_actionPerformed(DocumentExtensionsPanel documentExtensionsPanel, ActionEvent actionEvent) {
        documentExtensionsPanel._removeButton_actionPerformed(actionEvent);
    }

    static void mav$_fileTypeCombo_itemStateChanged(DocumentExtensionsPanel documentExtensionsPanel, ItemEvent itemEvent) {
        documentExtensionsPanel._fileTypeCombo_itemStateChanged(itemEvent);
    }

    static void mav$_contentTextRadioButton_actionPerformed(DocumentExtensionsPanel documentExtensionsPanel, ActionEvent actionEvent) {
        documentExtensionsPanel._contentTextRadioButton_actionPerformed(actionEvent);
    }

    static void mav$_contentBinaryRadioButton_actionPerformed(DocumentExtensionsPanel documentExtensionsPanel, ActionEvent actionEvent) {
        documentExtensionsPanel._contentBinaryRadioButton_actionPerformed(actionEvent);
    }

    static void mav$_openWithCheckBox_actionPerformed(DocumentExtensionsPanel documentExtensionsPanel, ActionEvent actionEvent) {
        documentExtensionsPanel._openWithCheckBox_actionPerformed(actionEvent);
    }

    static void mav$_defaultEditorsTable_valueChanged(DocumentExtensionsPanel documentExtensionsPanel, ListSelectionEvent listSelectionEvent) {
        documentExtensionsPanel._defaultEditorsTable_valueChanged(listSelectionEvent);
    }

    static void mav$_defaultEditorCombo_itemStateChanged(DocumentExtensionsPanel documentExtensionsPanel, ItemEvent itemEvent) {
        documentExtensionsPanel._defaultEditorCombo_itemStateChanged(itemEvent);
    }

    final class 1
    implements ListSelectionListener {
        public final void valueChanged(ListSelectionEvent e) {
            DocumentExtensionsPanel.mav$_fileTypesTable_valueChanged(DocumentExtensionsPanel.this, e);
        }
    }

    final class 2
    implements ActionListener {
        public final void actionPerformed(ActionEvent e) {
            DocumentExtensionsPanel.mav$_addButton_actionPerformed(DocumentExtensionsPanel.this, e);
        }
    }

    final class 3
    implements ActionListener {
        public final void actionPerformed(ActionEvent e) {
            DocumentExtensionsPanel.mav$_removeButton_actionPerformed(DocumentExtensionsPanel.this, e);
        }
    }

    final class 4
    implements ItemListener {
        public final void itemStateChanged(ItemEvent e) {
            DocumentExtensionsPanel.mav$_fileTypeCombo_itemStateChanged(DocumentExtensionsPanel.this, e);
        }
    }

    final class 5
    implements ActionListener {
        public final void actionPerformed(ActionEvent e) {
            DocumentExtensionsPanel.mav$_contentTextRadioButton_actionPerformed(DocumentExtensionsPanel.this, e);
        }
    }

    final class 6
    implements ActionListener {
        public final void actionPerformed(ActionEvent e) {
            DocumentExtensionsPanel.mav$_contentBinaryRadioButton_actionPerformed(DocumentExtensionsPanel.this, e);
        }
    }

    final class 7
    implements ActionListener {
        public final void actionPerformed(ActionEvent e) {
            DocumentExtensionsPanel.mav$_openWithCheckBox_actionPerformed(DocumentExtensionsPanel.this, e);
        }
    }

    final class 8
    implements ListSelectionListener {
        public final void valueChanged(ListSelectionEvent e) {
            DocumentExtensionsPanel.mav$_defaultEditorsTable_valueChanged(DocumentExtensionsPanel.this, e);
        }
    }

    final class 9
    implements ItemListener {
        public final void itemStateChanged(ItemEvent e) {
            DocumentExtensionsPanel.mav$_defaultEditorCombo_itemStateChanged(DocumentExtensionsPanel.this, e);
        }
    }

    private abstract class MasterTable
    extends NiceTable {
        private void $init$() {
            this.setSelectionMode(0);
            this.setUseTransferHandler(false);
        }

        public void installModel(TableModel model) {
            this.setModel(model);
            this.setSorted(true);
            this.getTableHeader().setReorderingAllowed(false);
            this.initializeCellRenderers();
            int i = 0;
            while (i < this.getColumnCount()) {
                this.getColumnModel().getColumn(i).setHeaderRenderer(this.getTableHeader().getDefaultRenderer());
                ++i;
            }
            this.setAutoResizeMode(0);
            this.autoSizeColumnsToFit();
            ((DefaultTableModel)this.getBaseModel()).fireTableDataChanged();
            this.setSortColumn(0, true);
            if (model.getRowCount() > 0) {
                this.setSelectedRow(0);
            }
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void reSort() {
            this.setSortColumn(this.getSortColumn(), this.isSortAscending());
        }

        public void setSortColumn(int modelColumn, boolean isSortAscending) {
            int row = this.getSelectedRow();
            Object keyValue = row >= 0 ? this.getModel().getValueAt(row, 0) : null;
            super.setSortColumn(modelColumn, isSortAscending);
            this.selectRowFromKeyValue(keyValue);
        }

        public void setSelectedRow(int row) {
            if (row < 0 && row >= this.getRowCount()) {
                return;
            }
            this.setRowSelectionInterval(row, row);
            this.scrollToSelection();
        }

        public void setBaseModelCellValue(Object aValue, int row, int column) {
            Object keyValue = this.getBaseModel().getValueAt(row, 0);
            int selectedRow = this.getSelectedRow();
            boolean reSelect = selectedRow >= 0 ? this.getModel().getValueAt(selectedRow, 0).equals(keyValue) : false;
            this.getBaseModel().setValueAt(aValue, row, column);
            ((AbstractTableModel)this.getBaseModel()).fireTableCellUpdated(row, column);
            super.setSortColumn(this.getSortColumn(), this.isSortAscending());
            if (reSelect) {
                this.selectRowFromKeyValue(keyValue);
            }
        }

        public int rowIndexOfValue(Object aValue, int column) {
            return this.rowIndexOfValue(aValue, column, this.getModel());
        }

        public int rowIndexOfValue(Object aValue, int column, TableModel model) {
            int i = 0;
            while (i < model.getRowCount()) {
                if (model.getValueAt(i, column).equals(aValue)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        protected abstract void initializeCellRenderers();

        private void selectRowFromKeyValue(Object keyValue) {
            int row = this.getSelectedRow();
            int row2 = -1;
            if (keyValue != null) {
                row2 = this.rowIndexOfValue(keyValue, 0);
            }
            if (row < 0 || row2 < 0 || row == row2) {
                return;
            }
            this.setSelectedRow(row2);
        }

        private MasterTable() {
            this.$init$();
        }

        MasterTable(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class FileTypesTable
    extends MasterTable {
        public void setSelectedExtension(String extension) {
            this.setSelectedRow(this.rowIndexOfExtension(extension));
        }

        public String getSelectedExtension() {
            int row = this.getSelectedRow();
            return row >= 0 ? (String)this.getModel().getValueAt(row, 0) : null;
        }

        public Class getSelectedDocClass() {
            int row = this.getSelectedRow();
            return row >= 0 ? (Class)this.getModel().getValueAt(row, 1) : null;
        }

        public int rowIndexOfExtension(String extension) {
            return this.rowIndexOfValue(extension, 0);
        }

        public int rowIndexOfExtension(String extension, TableModel model) {
            return this.rowIndexOfValue(extension, 0, model);
        }

        public void setBaseModelDocClassValue(Class docClass, int row) {
            this.setBaseModelCellValue(docClass, row, 1);
        }

        public void setBaseModelOpenWithValue(Object obj, int row) {
            this.setBaseModelCellValue(obj, row, 2);
        }

        protected void initializeCellRenderers() {
            this.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)((Object)new FileTypeTableCellRenderer(null)));
            if (DocumentExtensionsPanel.ra$IS_WINDOWS()) {
                this.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)((Object)new FileTypeTableOpenWithRenderer(null)));
            }
        }

        private FileTypesTable() {
            super(null);
        }

        FileTypesTable(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DefaultEditorsTable
    extends MasterTable {
        public void setSelectedDocClass(Class docClass) {
            this.setSelectedRow(this.rowIndexOfDocClass(docClass));
        }

        public Class getSelectedDocClass() {
            int row = this.getSelectedRow();
            return row >= 0 ? (Class)this.getModel().getValueAt(row, 0) : null;
        }

        public EditorAddin getSelectedEditorAddin() {
            int row = this.getSelectedRow();
            return row >= 0 ? (EditorAddin)this.getModel().getValueAt(row, 1) : null;
        }

        public int rowIndexOfDocClass(Class docClass) {
            return this.rowIndexOfValue(docClass, 0);
        }

        public int rowIndexOfDocClass(Class docClass, TableModel model) {
            return this.rowIndexOfValue(docClass, 0, model);
        }

        public void setBaseModelEditorAddinValue(EditorAddin editorAddin, int row) {
            this.setBaseModelCellValue(editorAddin, row, 1);
        }

        protected void initializeCellRenderers() {
            this.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)((Object)new FileTypeTableCellRenderer(null)));
            DefaultEditorTableCellRenderer renderer = new DefaultEditorTableCellRenderer(null);
            renderer.setRendererFlags(1);
            this.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)((Object)renderer));
        }

        private DefaultEditorsTable() {
            super(null);
        }

        DefaultEditorsTable(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class FileTypesTableModel
    extends DefaultTableModel
    implements NiceTableModel {
        public int getColumnAlignment(int column) {
            return 2;
        }

        public Comparator getColumnSortComparator(int column) {
            if (column == 0) {
                return new CustomStringComparator(null);
            }
            if (column == 1) {
                return new FileTypeComparator(null);
            }
            return null;
        }

        private FileTypesTableModel() {
        }

        FileTypesTableModel(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DefaultEditorsTableModel
    extends DefaultTableModel
    implements NiceTableModel {
        public int getColumnAlignment(int column) {
            return 2;
        }

        public Comparator getColumnSortComparator(int column) {
            if (column == 0) {
                return new FileTypeComparator(null);
            }
            if (column == 1) {
                return new DefaultEditorComparator(null);
            }
            return null;
        }

        private DefaultEditorsTableModel() {
        }

        DefaultEditorsTableModel(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomStringComparator
    implements Comparator {
        private final Collator _stringCollator;

        private void $init$() {
            this._stringCollator = (Collator)Collator.getInstance().clone();
            this._stringCollator.setStrength(0);
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return 1;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            return this.compareImpl(o1, o2);
        }

        protected int compareImpl(Object o1, Object o2) {
            return this.getStringCollator().compare(o1.toString(), o2.toString());
        }

        protected Collator getStringCollator() {
            return this._stringCollator;
        }

        private CustomStringComparator() {
            this.$init$();
        }

        CustomStringComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class FileTypeComparator
    extends CustomStringComparator {
        protected int compareImpl(Object o1, Object o2) {
            String s1 = RendererUtil.getDocumentLabel((Class)o1);
            String s2 = RendererUtil.getDocumentLabel((Class)o2);
            return this.getStringCollator().compare(s1, s2);
        }

        private FileTypeComparator() {
            super(null);
        }

        FileTypeComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DefaultEditorComparator
    extends CustomStringComparator {
        protected int compareImpl(Object o1, Object o2) {
            MenuSpec menuSpec1 = ((EditorAddin)o1).getMenuSpecification();
            MenuSpec menuSpec2 = ((EditorAddin)o2).getMenuSpecification();
            String s1 = menuSpec1 != null ? menuSpec1.label : o1.toString();
            String s2 = menuSpec2 != null ? menuSpec2.label : o2.toString();
            return this.getStringCollator().compare(s1, s2);
        }

        private DefaultEditorComparator() {
            super(null);
        }

        DefaultEditorComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static interface RendererFlags {
        public static final int HIDE_ICONS = 1;
    }

    private static class RendererUtil {
        public static final Icon createDisabledIcon(Icon icon) {
            if (!(icon instanceof ImageIcon)) {
                return icon;
            }
            return new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
        }

        public static final String getDocumentLabel(Class docClass) {
            String label;
            DocumentInfo docInfo = Recognizer.getDocumentInfo((Class)docClass);
            String string = label = docInfo != null ? docInfo.getLabel() : null;
            if (label != null) {
                return label;
            }
            label = docClass.getName();
            int i = label.lastIndexOf(46);
            if (i < 0 || i >= label.length() - 1) {
                return label;
            }
            label = label.substring(i + 1);
            return label;
        }

        public static final Icon getDocumentIcon(Class docClass) {
            DocumentInfo docInfo = Recognizer.getDocumentInfo((Class)docClass);
            return docInfo != null ? docInfo.getIcon() : null;
        }

        private RendererUtil() {
        }
    }

    private class EmptyIcon
    implements Icon {
        private final int _iconWidth;
        private final int _iconHeight;

        EmptyIcon(int iconWidth, int iconHeight) {
            this._iconWidth = iconWidth;
            this._iconHeight = iconHeight;
        }

        public int getIconWidth() {
            return this._iconWidth;
        }

        public int getIconHeight() {
            return this._iconHeight;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }

    private abstract class CustomComboBoxRenderer
    extends DefaultListCellRenderer {
        private final JComboBox _comboBox;
        private int _rendererFlags;

        CustomComboBoxRenderer(JComboBox comboBox) {
            this._comboBox = comboBox;
        }

        public JComboBox getComboBox() {
            return this._comboBox;
        }

        public void setRendererFlags(int rendererFlags) {
            this._rendererFlags = rendererFlags;
        }

        public int getRendererFlags() {
            return this._rendererFlags;
        }
    }

    private class FileTypeComboBoxRenderer
    extends CustomComboBoxRenderer {
        FileTypeComboBoxRenderer(JComboBox comboBox) {
            super(comboBox);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setEnabled(list.isEnabled());
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setIcon(null);
            this.setText("");
            if (value == null) {
                return this;
            }
            this.setText(RendererUtil.getDocumentLabel((Class)value));
            Icon icon = null;
            if ((this.getRendererFlags() & 1) <= 0) {
                icon = RendererUtil.getDocumentIcon((Class)value);
            }
            if (icon != null && !this.getComboBox().isEnabled()) {
                icon = RendererUtil.createDisabledIcon(icon);
            }
            this.setIcon(icon);
            return this;
        }
    }

    private class DefaultEditorComboBoxRenderer
    extends CustomComboBoxRenderer {
        DefaultEditorComboBoxRenderer(JComboBox comboBox) {
            super(comboBox);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setEnabled(list.isEnabled());
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setIcon(null);
            this.setText("");
            if (value == null) {
                return this;
            }
            MenuSpec menuSpec = ((EditorAddin)value).getMenuSpecification();
            if (menuSpec == null || menuSpec.label == null) {
                this.setText(value.getClass().getName());
                return this;
            }
            Icon icon = null;
            if ((this.getRendererFlags() & 1) <= 0 && (icon = menuSpec.getIcon()) == null) {
                icon = new EmptyIcon(16, 16);
            }
            if (icon != null && !this.getComboBox().isEnabled()) {
                icon = RendererUtil.createDisabledIcon(icon);
            }
            this.setIcon(icon);
            this.setText(menuSpec.label);
            return this;
        }
    }

    private abstract class CustomTableCellRenderer
    extends NiceTableCellRenderer {
        private int _rendererFlags;

        public void setRendererFlags(int rendererFlags) {
            this._rendererFlags = rendererFlags;
        }

        public int getRendererFlags() {
            return this._rendererFlags;
        }

        private CustomTableCellRenderer() {
        }

        CustomTableCellRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class FileTypeTableCellRenderer
    extends CustomTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setEnabled(table.isEnabled());
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setToolTipText(null);
            this.setIcon(null);
            this.setText("");
            if (value == null) {
                return this;
            }
            this.setText(RendererUtil.getDocumentLabel((Class)value));
            Icon icon = null;
            if ((this.getRendererFlags() & 1) <= 0 && (icon = RendererUtil.getDocumentIcon((Class)value)) == null) {
                icon = new EmptyIcon(16, 16);
            }
            if (icon != null && !table.isEnabled()) {
                icon = RendererUtil.createDisabledIcon(icon);
            }
            this.setIcon(icon);
            return this;
        }

        private FileTypeTableCellRenderer() {
            super(null);
        }

        FileTypeTableCellRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class FileTypeTableOpenWithRenderer
    extends CustomTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setEnabled(table.isEnabled());
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setToolTipText(null);
            this.setIcon(null);
            this.setText("");
            if (value == null) {
                return this;
            }
            Icon icon = null;
            if ((this.getRendererFlags() & 1) <= 0) {
                icon = DocumentExtensionsPanel.ra$_openWithIcon(DocumentExtensionsPanel.this);
            }
            if (icon != null && !table.isEnabled()) {
                icon = RendererUtil.createDisabledIcon(icon);
            }
            this.setIcon(icon);
            return this;
        }

        private FileTypeTableOpenWithRenderer() {
            super(null);
        }

        FileTypeTableOpenWithRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DefaultEditorTableCellRenderer
    extends CustomTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setEnabled(table.isEnabled());
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setToolTipText(null);
            this.setIcon(null);
            this.setText("");
            if (value == null) {
                return this;
            }
            MenuSpec menuSpec = ((EditorAddin)value).getMenuSpecification();
            if (menuSpec == null || menuSpec.label == null) {
                this.setText(value.getClass().getName());
                return this;
            }
            Icon icon = null;
            if ((this.getRendererFlags() & 1) <= 0 && (icon = menuSpec.getIcon()) == null) {
                icon = new EmptyIcon(16, 16);
            }
            if (icon != null && !table.isEnabled()) {
                icon = RendererUtil.createDisabledIcon(icon);
            }
            this.setIcon(icon);
            this.setText(menuSpec.label);
            return this;
        }

        private DefaultEditorTableCellRenderer() {
            super(null);
        }

        DefaultEditorTableCellRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class AddExtensionDialog
    extends SimpleInputDialog {
        AddExtensionDialog(Component parent) {
            super(parent);
        }

        public boolean validate(String extension) {
            int index = extension.lastIndexOf(".");
            if (index > 0) {
                String msg = MessageFormat.format(FileBundle.getBundle().getString("INVALID_EXT"), extension);
                JOptionPane.showMessageDialog((Component)this.getDialog(), msg, FileBundle.getBundle().getString("ADD_EXT_TITLE"), 0);
                return false;
            }
            extension = DocumentExtensions.DocRecord.sanitizeExtensionAsString((String)extension);
            if (DocumentExtensionsPanel.ra$_extInfoCache(DocumentExtensionsPanel.this).containsKey(extension)) {
                String msg = MessageFormat.format(FileBundle.getBundle().getString("DUPLICATE_EXT"), extension);
                JOptionPane.showMessageDialog((Component)this.getDialog(), msg, FileBundle.getBundle().getString("ADD_EXT_TITLE"), 0);
                return false;
            }
            return true;
        }
    }
}

