/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.search;

import oracle.help.common.search.SearchException;
import oracle.help.common.search.SearchExpression;
import oracle.help.common.search.StringExpression;

public class BooleanExpression
implements SearchExpression {
    private boolean _caseSensitive;
    private int _operator;
    private SearchExpression _expr1;
    private SearchExpression _expr2;

    public BooleanExpression(SearchExpression searchExpression, SearchExpression searchExpression2, int n, boolean bl) {
        this._expr1 = searchExpression;
        this._expr2 = searchExpression2;
        this._operator = n;
        this._caseSensitive = bl;
    }

    public SearchExpression getExpression1() {
        return this._expr1;
    }

    public SearchExpression getExpression2() {
        return this._expr2;
    }

    public String[] getData() {
        return null;
    }

    public int getOperator() {
        return this._operator;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this._caseSensitive = bl;
    }

    public void print() {
        if (this._expr1 == null) {
            return;
        }
        this._expr1.print();
        switch (this._operator) {
            case 2: {
                System.out.println("OR");
                break;
            }
            case 1: {
                System.out.println("AND");
                break;
            }
            case 3: {
                System.out.println("NOT");
                break;
            }
            case 4: {
                System.out.println("NAND");
                break;
            }
            default: {
                if (this._expr2 == null) break;
                System.out.println("Unknown operator");
            }
        }
        if (this._expr2 != null) {
            this._expr2.print();
        }
    }

    public static SearchExpression buildExpressionTree(String string, boolean bl) throws SearchException {
        SearchExpression searchExpression = null;
        try {
            int n;
            int n2 = 0;
            int n3 = 0;
            boolean bl2 = true;
            for (n3 = 0; n3 < string.length(); ++n3) {
                n = string.charAt(n3);
                if (Character.isSpaceChar((char)n)) {
                    if (!bl2) {
                        ++n2;
                    }
                    bl2 = true;
                    continue;
                }
                if (n == 40 || n == 41 || n == 43 || n == 45) {
                    if (!bl2) {
                        ++n2;
                    }
                    ++n2;
                    bl2 = true;
                    continue;
                }
                bl2 = false;
            }
            if (!bl2) {
                ++n2;
            }
            bl2 = true;
            n = -1;
            String[] stringArray = new String[n2];
            n2 = 0;
            for (n3 = 0; n3 < string.length(); ++n3) {
                char c = string.charAt(n3);
                if (Character.isSpaceChar(c)) {
                    if (!bl2) {
                        stringArray[n2++] = string.substring(n, n3);
                        n = -1;
                    }
                    bl2 = true;
                    continue;
                }
                if (c == '(' || c == ')' || c == '+' || c == '-') {
                    if (!bl2) {
                        stringArray[n2++] = string.substring(n, n3);
                    }
                    stringArray[n2++] = new Character(c).toString();
                    n = -1;
                    bl2 = true;
                    continue;
                }
                if (n == -1) {
                    n = n3;
                }
                bl2 = false;
            }
            if (!bl2) {
                stringArray[n2++] = string.substring(n, n3);
            }
            if (stringArray.length == 1) {
                searchExpression = new StringExpression(stringArray, bl);
            } else {
                int[] nArray = new int[]{0};
                searchExpression = BooleanExpression._buildExpressionTree(stringArray, nArray, bl);
            }
        }
        catch (Exception exception) {
            throw new SearchException("Unable to parse boolean expression: " + string, exception);
        }
        return searchExpression;
    }

    private static SearchExpression _buildExpressionTree(String[] stringArray, int[] nArray, boolean bl) throws IllegalArgumentException {
        int n = nArray[0];
        SearchExpression searchExpression = null;
        SearchExpression searchExpression2 = null;
        boolean bl2 = false;
        int n2 = 0;
        if (stringArray[n].equals("+")) {
            ++n;
        }
        if (stringArray[n].equals("(")) {
            nArray[0] = n + 1;
            searchExpression = BooleanExpression._buildExpressionTree(stringArray, nArray, bl);
            bl2 = true;
        } else {
            int n3;
            if (BooleanExpression._isBooleanOperator(stringArray[n]) == 1 || BooleanExpression._isBooleanOperator(stringArray[n]) == 2 || stringArray[n].equals(")")) {
                throw new IllegalArgumentException("invalid boolean expression");
            }
            if (BooleanExpression._isBooleanOperator(stringArray[n]) == 3 || stringArray[n].equals("-")) {
                nArray[0] = n + 1;
                searchExpression = BooleanExpression._buildExpressionTree(stringArray, nArray, bl);
                return new BooleanExpression(searchExpression, null, 3, bl);
            }
            if (n == stringArray.length) {
                throw new IllegalArgumentException("invalid boolean expression " + n);
            }
            for (n3 = n + 1; n3 < stringArray.length && BooleanExpression._isBooleanOperator(stringArray[n3]) == 0 && !stringArray[n3].equals(")"); ++n3) {
            }
            String[] stringArray2 = new String[n3 - n];
            for (int i = n; i < n3; ++i) {
                stringArray2[i - n] = stringArray[i];
            }
            searchExpression = new StringExpression(stringArray2, bl);
            nArray[0] = n3;
            if (n3 == stringArray.length) {
                return searchExpression;
            }
        }
        n = nArray[0];
        if (bl2 && stringArray[n].equals(")")) {
            bl2 = false;
            if (++n == stringArray.length) {
                nArray[0] = stringArray.length;
                return searchExpression;
            }
        }
        if (!bl2 && stringArray[n].equals(")")) {
            nArray[0] = n;
            return searchExpression;
        }
        n2 = BooleanExpression._isBooleanOperator(stringArray[n]);
        if (n2 == 0) {
            throw new IllegalArgumentException("invalid boolean expression");
        }
        if (n2 == 3) {
            n2 = 4;
        }
        nArray[0] = n + 1;
        searchExpression2 = BooleanExpression._buildExpressionTree(stringArray, nArray, bl);
        return new BooleanExpression(searchExpression, searchExpression2, n2, bl);
    }

    private static int _isBooleanOperator(String string) {
        if (string.equalsIgnoreCase("AND") || string.equals("+")) {
            return 1;
        }
        if (string.equalsIgnoreCase("OR")) {
            return 2;
        }
        if (string.equalsIgnoreCase("NOT") || string.equals("-")) {
            return 3;
        }
        return 0;
    }
}

