/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.search;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.common.search.QueryHandler;
import oracle.help.common.search.QueryResult;
import oracle.help.common.search.SearchException;
import oracle.help.common.search.SearchExpression;
import oracle.help.common.search.StringExpression;

public class IndexFileQueryHandler
extends QueryHandler {
    private URL _url;
    private View _view;
    private char[] _alphabet;
    private long[] _alphaOffsets;
    private long _eowOffset;
    private long _fsOffset;
    private String _productTitle;
    private int _version;
    private String _encoding;
    private boolean _fileCase;
    private boolean _scoreAvailable;
    private boolean _titlesAvailable;
    private String _rootPath;
    private String _sourceIdentifier;
    private boolean _stopSearch = false;
    private boolean _needToParseHeader = true;
    private static final int VERSION_10 = 10;
    private static final int VERSION_11 = 11;
    private static final int VERSION_20 = 20;
    static final String INDEX_VERSION = "OIN-INDEX-VERSION";
    static final String CHARACTER_SET = "CHARACTER-SET";
    static final String PRODUCT_TITLE = "PRODUCT-TITLE";
    static final String CASESENSITIVE = "CASESENSITIVE";
    static final String TITLES = "TITLES";
    static final String BLOCK_SIZE = "BLOCK-SIZE";
    static final String SCORES = "SCORES";
    static final String ROOT_PATH = "ROOTPATH";
    static final String TRUE = "TRUE";

    public static IndexFileQueryHandler getInstance(View view, String string, URL uRL) {
        IndexFileQueryHandler indexFileQueryHandler = null;
        try {
            indexFileQueryHandler = new IndexFileQueryHandler(view, string, uRL);
            return indexFileQueryHandler;
        }
        catch (Exception exception) {
            System.out.println("Invalid IDX file URL.  IOException when accessing " + uRL.toString());
            exception.printStackTrace();
            return null;
        }
    }

    public URL getIndexFileUrl() {
        return this._url;
    }

    public void stopSearch() {
        this._stopSearch = true;
    }

    public boolean supportsCaseSensitiveSearches() {
        return true;
    }

    public Set getSupportedSources() {
        if (this._sourceIdentifier == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.singleton(this._sourceIdentifier);
    }

    public String productTitle() {
        return this._productTitle;
    }

    public synchronized List executeQuery(String[] stringArray, boolean bl, boolean bl2, Set set) throws SearchException {
        this._stopSearch = false;
        this._checkSources(set);
        if (this._needToParseHeader) {
            this._parseHeader();
        }
        List list = null;
        try {
            list = this._executeStringQuery(stringArray, bl, bl2);
        }
        catch (SearchInterruptedError searchInterruptedError) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    public synchronized List executeQuery(SearchExpression searchExpression, Set set) throws SearchException {
        this._stopSearch = false;
        this._checkSources(set);
        if (this._needToParseHeader) {
            this._parseHeader();
        }
        List list = null;
        try {
            list = this._executeBooleanQuery(searchExpression);
        }
        catch (SearchInterruptedError searchInterruptedError) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    private void _checkSources(Set set) throws SearchException {
        if (set != null && !set.isEmpty()) {
            for (String string : set) {
                if (string.equals(this._sourceIdentifier)) continue;
                throw new SearchException("IndexFileQueryHandler: " + this._url + "\n" + "Called with unsupported source: " + string);
            }
        }
    }

    private void _checkStopSearch() {
        if (this._stopSearch) {
            throw new SearchInterruptedError("Search Interrupted");
        }
    }

    private List _executeStringQuery(String[] stringArray, boolean bl, boolean bl2) throws SearchException {
        String[] stringArray2;
        if (stringArray != null && stringArray.length > 0 && (stringArray2 = this._filter(stringArray)).length > 0) {
            if (this._fileCase && !bl2) {
                return this._executeComplexStringQuery(stringArray2, bl);
            }
            return this._executeSimpleStringQuery(stringArray, bl);
        }
        return Collections.EMPTY_LIST;
    }

    private List _executeSimpleStringQuery(String[] stringArray, boolean bl) throws SearchException {
        ArrayList arrayList = new ArrayList();
        InputStream inputStream = null;
        try {
            int n;
            String[] stringArray2 = new String[stringArray.length];
            if (this._fileCase) {
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray2[n] = stringArray[n];
                }
            } else {
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray2[n] = stringArray[n].toLowerCase();
                }
            }
            this._bubbleSort(stringArray2);
            int n2 = 0;
            byte[] byArray = new byte[1000];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            byte[] byArray2 = new byte[512];
            int n6 = 0;
            boolean bl2 = false;
            long[] lArray = new long[stringArray2.length];
            inputStream = this._openInputStream(this._url);
            InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(inputStream);
            boolean bl3 = !bl;
            while (!bl2) {
                int n7;
                int n8 = n7 = n2;
                for (n = n2; n < stringArray2.length && stringArray2[n2].charAt(0) == stringArray2[n].charAt(0); ++n) {
                    ++n7;
                }
                int n9 = this._getAlphabetIndex(stringArray2[n8].charAt(0));
                if (n9 == -1) {
                    if (bl) {
                        bl3 = true;
                        break;
                    }
                    for (n = n8; n < n7; ++n) {
                        lArray[n] = 0L;
                    }
                    n2 = n7;
                    if (n7 != stringArray2.length) continue;
                    bl2 = true;
                    continue;
                }
                long l = this._alphaOffsets[n9];
                long l2 = n9 == this._alphabet.length - 1 ? this._eowOffset : this._alphaOffsets[n9 + 1];
                inputStreamWrapper.skipToOffset(l);
                boolean bl4 = false;
                while (!bl2 && !bl4) {
                    int n10 = 0;
                    if ((long)n4 + (l2 - inputStreamWrapper.getPosition()) > (long)byArray.length) {
                        n3 = byArray.length - n4;
                    } else {
                        n3 = (int)(l2 - inputStreamWrapper.getPosition());
                        bl4 = true;
                    }
                    inputStreamWrapper.read(byArray, n4, n3);
                    n5 = n3 + n4;
                    n4 = 0;
                    try {
                        n6 = n8;
                        int n11 = 0;
                        int n12 = 0;
                        String string = null;
                        do {
                            int n13 = 0;
                            n10 = n11;
                            if (this._version < 20) {
                                while ((byArray2[n13++] = byArray[n11++]) != 32) {
                                }
                                string = new String(byArray2, 0, n13 - 1);
                            } else {
                                for (n12 = byArray[n11++]; n12 != 0; --n12) {
                                    byArray2[n13++] = byArray[n11++];
                                }
                                string = this._bytesToString(byArray2, 0, n13);
                            }
                            if (stringArray2[n6].equals(string)) {
                                for (int i = 0; i < 4; ++i) {
                                    int n14 = byArray[n11 + i];
                                    if (n14 < 0) {
                                        n14 = 256 + n14;
                                    }
                                    int n15 = n6;
                                    lArray[n15] = lArray[n15] | (long)(n14 << 8 * (3 - i));
                                }
                                ++n6;
                                if (!bl) {
                                    bl3 = false;
                                }
                            } else if (stringArray2[n6].compareTo(string) < 0) {
                                lArray[n6] = 0L;
                                ++n6;
                                if (bl) {
                                    bl3 = true;
                                    bl2 = true;
                                    break;
                                }
                            }
                            if ((n11 += 4) <= n5) continue;
                            throw new IndexOutOfBoundsException();
                        } while (n6 != n7);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        n4 = n5 - n10;
                        for (n = 0; n < n4; ++n) {
                            byArray[n] = byArray[n10 + n];
                        }
                    }
                    if (n6 == stringArray2.length) {
                        bl2 = true;
                    }
                    if (n6 != n7) continue;
                    break;
                }
                n2 = n7;
                this._checkStopSearch();
            }
            if (!bl3) {
                for (n = 0; n < stringArray2.length; ++n) {
                    if (lArray[n] == 0L) continue;
                    inputStreamWrapper.skipToOffset(lArray[n]);
                    if (n == 0) {
                        this._readFileIndices(inputStreamWrapper, arrayList, true);
                    } else if (bl) {
                        this._readFileIndices(inputStreamWrapper, arrayList, false);
                        if (arrayList.size() == 0) {
                            break;
                        }
                    } else {
                        this._readFileIndices(inputStreamWrapper, arrayList, true);
                    }
                    this._checkStopSearch();
                }
                if (arrayList.size() > 0) {
                    inputStreamWrapper.skipToOffset(this._fsOffset);
                    this._readFileNames(inputStreamWrapper, arrayList, byArray);
                    arrayList.trimToSize();
                    if (this._scoreAvailable) {
                        IndexFileQueryHandler._quickSort(arrayList, 0, arrayList.size() - 1);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new SearchException("IndexFileQueryHandler: " + this._url + "\n" + "Error encountered executing search: " + exception.getMessage(), exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                    inputStream = null;
                }
                catch (Exception exception) {}
            }
        }
        return arrayList;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List _executeComplexStringQuery(String[] var1_1, boolean var2_2) throws SearchException {
        block68: {
            block67: {
                block66: {
                    var3_3 = new ArrayList<ResultObject>();
                    var4_4 = null;
                    var6_5 = new ArrayList<String>();
                    var7_6 = new ArrayList<Long>();
                    try {
                        var5_7 = new String[var1_1.length];
                        for (var9_8 = 0; var9_8 < var1_1.length; ++var9_8) {
                            var5_7[var9_8] = var1_1[var9_8].toLowerCase();
                        }
                        this._bubbleSort(var5_7);
                        var14_9 = 0;
                        var15_12 = new byte[1000];
                        var16_13 = 0;
                        var17_14 = 0;
                        var18_15 = 0;
                        var19_16 = new byte[512];
                        var22_17 = 0;
                        var24_18 = false;
                        var4_4 = this._openInputStream(this._url);
                        var27_19 = new InputStreamWrapper(var4_4);
                        var25_20 = var2_2 == false;
                        var28_21 = 0;
lbl23:
                        // 2 sources

                        while (true) {
                            if (var28_21 < 2) {
                                var14_9 = 0;
                                var24_18 = false;
                                break;
                            }
                            if (var6_5.size() == 0 || var2_2 && var6_5.size() < var5_7.length) {
                                var28_22 = Collections.EMPTY_LIST;
                                return var28_22;
                            }
                            var28_23 = new ArrayList[var5_7.length];
                            var9_8 = 0;
lbl33:
                            // 2 sources

                            while (true) {
                                if (var9_8 < var6_5.size()) {
                                    break block66;
                                }
                                if (var2_2) {
                                    for (var9_8 = 0; var9_8 < var5_7.length; ++var9_8) {
                                        if (var28_23[var9_8] != null) continue;
                                        var29_33 = Collections.EMPTY_LIST;
                                        return var29_33;
                                    }
                                }
                                if ((var3_3 = var28_23[0]) == null) {
                                    var3_3 = new ArrayList<ResultObject>();
                                }
                                if (var1_1.length > 1) {
                                    if (var2_2) {
                                        var9_8 = 0;
                                        break block67;
                                    }
                                    for (var9_8 = 1; var9_8 < var1_1.length; ++var9_8) {
                                        if (var28_23[var9_8] != null) {
                                            for (var10_25 = 0; var10_25 < var28_23[var9_8].size(); ++var10_25) {
                                                var29_36 = (ResultObject)var28_23[var9_8].get(var10_25);
                                                var30_41 = this._findFileIndex(var3_3, var29_36.fileno);
                                                if (var30_41 == null) {
                                                    var3_3.add(var29_36);
                                                    continue;
                                                }
                                                var30_41.setHitNumber(var30_41.getHitNumber() + var29_36.getHitNumber());
                                                var29_36.useful = false;
                                            }
                                            this._filterResults(var28_23[var9_8]);
                                        }
                                        this._checkStopSearch();
                                    }
                                }
                                ** GOTO lbl182
                                break;
                            }
                            break;
                        }
                    }
                    catch (Exception var14_11) {
                        throw new SearchException("IndexFileQueryHandler: " + this._url + "\n" + "Error encountered executing search: " + var14_11.getMessage(), var14_11);
                    }
                    while (true) {
                        if (!var24_18) {
                            var20_27 = var21_28 = var14_9;
                            if (var28_21 == 0) {
                                var30_37 = Character.toUpperCase(var5_7[var14_9].charAt(0));
                                for (var9_8 = var14_9; var9_8 < var5_7.length && var30_37 == Character.toUpperCase(var5_7[var9_8].charAt(0)); ++var21_28, ++var9_8) {
                                }
                                var8_24 = new Character(var30_37).toString();
                                var8_24 = var8_24.concat(var5_7[var21_28 - 1].substring(1));
                                var29_31 = this._getAlphabetIndex(var30_37);
                            } else {
                                var30_37 = var5_7[var14_9].charAt(0);
                                for (var9_8 = var14_9; var9_8 < var5_7.length && var30_37 == var5_7[var9_8].charAt(0); ++var21_28, ++var9_8) {
                                }
                                var8_24 = var5_7[var21_28 - 1];
                                var29_31 = this._getAlphabetIndex(var30_37);
                            }
                            if (var29_31 == -1) {
                                var14_9 = var21_28;
                                if (var21_28 != var5_7.length) continue;
                                var24_18 = true;
                                continue;
                            }
                            var12_26 = this._alphaOffsets[var29_31];
                            if (var27_19.getPosition() > var12_26) {
                                var14_9 = var21_28;
                                if (var21_28 != var5_7.length) continue;
                                var24_18 = true;
                                continue;
                            }
                            var30_38 = var29_31 == this._alphabet.length - 1 ? this._eowOffset : this._alphaOffsets[var29_31 + 1];
                            var27_19.skipToOffset(var12_26);
                            var23_29 = false;
                        } else {
                            ++var28_21;
                            ** continue;
                        }
                        block28: while (!var24_18 && !var23_29) {
                            var32_42 = 0;
                            if ((long)var17_14 + (var30_38 - var27_19.getPosition()) > (long)var15_12.length) {
                                var16_13 = var15_12.length - var17_14;
                            } else {
                                var16_13 = (int)(var30_38 - var27_19.getPosition());
                                var23_29 = true;
                            }
                            var27_19.read(var15_12, var17_14, var16_13);
                            var18_15 = var16_13 + var17_14;
                            var17_14 = 0;
                            try {
                                var22_17 = var20_27;
                                var33_43 = 0;
                                var34_45 = null;
                                do {
                                    var26_30 = 0;
                                    var32_42 = var33_43;
                                    if (this._version < 20) {
                                        while ((var19_16[var26_30++] = var15_12[var33_43++]) != 32) {
                                        }
                                        var34_45 = new String(var19_16, 0, var26_30 - 1);
                                    } else {
                                        for (var36_47 = var15_12[var33_43++]; var36_47 != 0; --var36_47) {
                                            var19_16[var26_30++] = var15_12[var33_43++];
                                        }
                                        try {
                                            var34_45 = new String(var19_16, 0, var26_30, this._encoding);
                                        }
                                        catch (UnsupportedEncodingException var37_48) {
                                            var34_45 = new String(var19_16, 0, var26_30);
                                        }
                                    }
                                    var35_46 = true;
                                    for (var9_8 = var20_27; var9_8 < var21_28; ++var9_8) {
                                        if (!var34_45.equalsIgnoreCase(var5_7[var9_8])) continue;
                                        var35_46 = false;
                                        break;
                                    }
                                    if (!var35_46) {
                                        var37_49 = 0L;
                                        for (var10_25 = 0; var10_25 < 4; var37_49 |= (long)(var39_50 << 8 * (3 - var10_25)), ++var10_25) {
                                            var39_50 = var15_12[var33_43 + var10_25];
                                            if (var39_50 >= 0) continue;
                                            var39_50 = 256 + var39_50;
                                        }
                                        var6_5.add(var34_45);
                                        var7_6.add(new Long(var37_49));
                                        continue;
                                    }
                                    if (var8_24.compareTo(var34_45) >= 0) continue;
                                    var23_29 = true;
                                    continue block28;
                                } while ((var33_43 += 4) <= var18_15);
                                throw new IndexOutOfBoundsException();
                            }
                            catch (IndexOutOfBoundsException var33_44) {
                                var17_14 = var18_15 - var32_42;
                                for (var9_8 = 0; var9_8 < var17_14; ++var9_8) {
                                    var15_12[var9_8] = var15_12[var32_42 + var9_8];
                                }
                            }
                        }
                        if (var21_28 == var5_7.length) {
                            var24_18 = true;
                        }
                        var14_9 = var21_28;
                        this._checkStopSearch();
                    }
                }
                for (var10_25 = 0; var10_25 < var5_7.length && !var5_7[var10_25].equalsIgnoreCase((String)var6_5.get(var9_8)); ++var10_25) {
                }
                var12_26 = (Long)var7_6.get(var9_8);
                if (var12_26 != 0L) {
                    if (var28_23[var10_25] == null) {
                        var28_23[var10_25] = new ArrayList<E>();
                    }
                    var27_19.skipToOffset(var12_26);
                    this._readFileIndices(var27_19, var28_23[var10_25], true);
                    this._checkStopSearch();
                }
                ++var9_8;
                ** while (true)
            }
lbl176:
            // 2 sources

            while (true) {
                if (var9_8 < var3_3.size()) {
                    var29_35 = (ResultObject)var3_3.get(var9_8);
                    var29_35.useful = true;
                    break block68;
                }
                this._filterResults(var3_3);
lbl182:
                // 2 sources

                if (var3_3.size() <= 0) return var3_3;
                var27_19.skipToOffset(this._fsOffset);
                this._readFileNames(var27_19, var3_3, var15_12);
                var3_3.trimToSize();
                if (this._scoreAvailable == false) return var3_3;
                IndexFileQueryHandler._quickSort(var3_3, 0, var3_3.size() - 1);
                return var3_3;
            }
            finally {
                if (var4_4 != null) {
                    try {
                        var4_4.close();
                        var4_4 = null;
                    }
                    catch (Exception var41_52) {}
                }
            }
        }
        for (var10_25 = 1; var10_25 < var1_1.length; ++var10_25) {
            var30_40 = this._findFileIndex(var28_23[var10_25], var29_35.fileno);
            if (var30_40 == null) {
                var29_35.useful = false;
            } else {
                var29_35.setHitNumber(var29_35.getHitNumber() + var30_40.getHitNumber());
            }
            this._checkStopSearch();
        }
        ++var9_8;
        ** while (true)
    }

    private List _executeBooleanQuery(SearchExpression searchExpression) throws SearchException {
        if (searchExpression.getOperator() == 0) {
            return this._executeStringQuery(searchExpression.getData(), true, searchExpression.isCaseSensitive());
        }
        List list = Collections.EMPTY_LIST;
        SearchExpression searchExpression2 = searchExpression.getExpression1();
        if (searchExpression2 != null) {
            list = this._executeBooleanQuery(searchExpression2);
        }
        if (list.isEmpty() && searchExpression.getOperator() == 4) {
            return Collections.EMPTY_LIST;
        }
        if (searchExpression.getOperator() == 3) {
            return this._evaluateNOT(list);
        }
        List list2 = Collections.EMPTY_LIST;
        SearchExpression searchExpression3 = searchExpression.getExpression2();
        if (searchExpression3 != null) {
            list2 = this._executeBooleanQuery(searchExpression3);
        }
        if (list2.isEmpty() && searchExpression.getOperator() == 1 && searchExpression3 instanceof StringExpression) {
            StringExpression stringExpression = (StringExpression)searchExpression3;
            String[] stringArray = stringExpression.getData();
            if (stringArray != null && (stringArray = this._filter(stringArray)).length == 0) {
                return list;
            }
            return Collections.EMPTY_LIST;
        }
        if (list.isEmpty() && searchExpression.getOperator() == 1 && searchExpression2 instanceof StringExpression) {
            StringExpression stringExpression = (StringExpression)searchExpression2;
            String[] stringArray = stringExpression.getData();
            if (stringArray != null && (stringArray = this._filter(stringArray)).length == 0) {
                return list2;
            }
            return Collections.EMPTY_LIST;
        }
        if (searchExpression.getOperator() == 1) {
            ArrayList<ResultObject> arrayList = new ArrayList<ResultObject>();
            block0: for (ResultObject resultObject : list) {
                for (ResultObject resultObject2 : list2) {
                    if (resultObject.fileno != resultObject2.fileno) continue;
                    arrayList.add(resultObject);
                    continue block0;
                }
            }
            return arrayList;
        }
        if (searchExpression.getOperator() == 2) {
            if (list.isEmpty()) {
                return list2;
            }
            if (list2.isEmpty()) {
                return list;
            }
            ArrayList<ResultObject> arrayList = new ArrayList<ResultObject>(list.size() + list2.size());
            arrayList.addAll(list);
            for (ResultObject resultObject : list2) {
                boolean bl = false;
                for (ResultObject resultObject3 : list) {
                    if (resultObject.fileno != resultObject3.fileno) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(resultObject);
            }
            return arrayList;
        }
        if (searchExpression.getOperator() == 4) {
            if (list2.isEmpty()) {
                return list;
            }
            ArrayList<ResultObject> arrayList = new ArrayList<ResultObject>(list.size());
            for (ResultObject resultObject : list) {
                boolean bl = false;
                for (ResultObject resultObject4 : list2) {
                    if (resultObject.fileno != resultObject4.fileno) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(resultObject);
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    private String _bytesToString(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, this._encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, n, n2);
        }
    }

    private IndexFileQueryHandler(View view, String string, URL uRL) {
        this._url = uRL;
        this._view = view;
        String string2 = this._view.getTitle();
        this._sourceIdentifier = string2 != null && string2.length() > 0 ? string2 : null;
    }

    private InputStream _openInputStream(URL uRL) throws IOException {
        InputStream inputStream = null;
        if (uRL.getProtocol().equals("file")) {
            try {
                inputStream = new FileInputStream(uRL.getFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            inputStream = uRL.openStream();
        }
        return inputStream;
    }

    private void _handleCorruptIndexFile(String string) throws SearchException {
        throw new SearchException("IndexFileQueryHandler:  " + this._url + "\n" + "Corrupt IDX File Encountered:  " + string);
    }

    private void _parseHeader() throws SearchException {
        this._needToParseHeader = false;
        InputStream inputStream = null;
        try {
            inputStream = this._openInputStream(this._url);
            InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(inputStream);
            String string = inputStreamWrapper.readLine();
            if (!string.startsWith(INDEX_VERSION)) {
                this._handleCorruptIndexFile("Missing Index Version");
            }
            if (string.equals("OIN-INDEX-VERSION 1.0")) {
                this._version = 10;
            } else if (string.equals("OIN-INDEX-VERSION 1.1")) {
                this._version = 11;
            } else if (string.equals("OIN-INDEX-VERSION 2.0")) {
                this._version = 20;
            } else {
                this._handleCorruptIndexFile("Unsupported Index Version");
            }
            string = inputStreamWrapper.readLine();
            if (this._version >= 20) {
                this._encoding = string.substring(CHARACTER_SET.length() + 1);
            }
            if (!(string = inputStreamWrapper.readLine()).startsWith(PRODUCT_TITLE)) {
                this._handleCorruptIndexFile("Missing Product Title");
            }
            this._productTitle = string.substring(PRODUCT_TITLE.length() + 1);
            string = inputStreamWrapper.readLine();
            if (!string.startsWith(TITLES)) {
                this._handleCorruptIndexFile("Missing Titles Marker");
            }
            this._titlesAvailable = string.endsWith(TRUE);
            string = inputStreamWrapper.readLine();
            if (!string.startsWith(CASESENSITIVE)) {
                this._handleCorruptIndexFile("Missing Case Sensitive Marker");
            }
            this._fileCase = string.endsWith(TRUE);
            inputStreamWrapper.readLine();
            if (this._version > 10) {
                string = inputStreamWrapper.readLine();
                if (!string.startsWith(SCORES)) {
                    this._handleCorruptIndexFile("Missing Scores Marker");
                }
                this._scoreAvailable = string.endsWith(TRUE);
            }
            if (!(string = inputStreamWrapper.readLine()).startsWith(ROOT_PATH)) {
                this._handleCorruptIndexFile("Missing Root Path");
            }
            this._rootPath = string.substring(ROOT_PATH.length() + 1);
            int n = inputStreamWrapper.readUb2();
            this._alphabet = new char[n];
            this._alphaOffsets = new long[n];
            byte[] byArray = new byte[16];
            for (int i = 0; i < n; ++i) {
                if (this._version < 20) {
                    this._alphabet[i] = (char)inputStreamWrapper.readUb1();
                } else {
                    int n2 = inputStreamWrapper.readUb1();
                    if (n2 > 16) {
                        throw new SearchException("IndexFileQueryHandler:  " + this._url + "\n" + "Oracle Help Indexer does not support " + "encodings requiring more than 16 bytes " + "to specify a character.  This IDX file" + "may be corrupt.");
                    }
                    for (int j = 0; j < n2; ++j) {
                        byArray[j] = (byte)inputStreamWrapper.readUb1();
                    }
                    String string2 = new String(byArray, 0, n2, this._encoding);
                    this._alphabet[i] = string2.charAt(0);
                }
                this._alphaOffsets[i] = inputStreamWrapper.readUb4();
            }
            this._eowOffset = inputStreamWrapper.readUb4();
            this._fsOffset = inputStreamWrapper.readUb4();
        }
        catch (IOException iOException) {
            throw new SearchException("Error encountered parsing IDX file header:  " + this._url + iOException.getMessage(), iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                    inputStream = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    private int _getAlphabetIndex(char c) {
        for (int i = 0; i < this._alphabet.length; ++i) {
            if (this._alphabet[i] != c) continue;
            return i;
        }
        return -1;
    }

    private void _readFileIndices(InputStreamWrapper inputStreamWrapper, ArrayList arrayList, boolean bl) throws IOException {
        int n;
        int n2 = 0;
        for (ResultObject resultObject : arrayList) {
            if (bl) {
                resultObject.useful = true;
                continue;
            }
            resultObject.useful = false;
        }
        while ((n = inputStreamWrapper.readUb2()) != 65535) {
            ResultObject resultObject;
            if (this._scoreAvailable) {
                n2 = inputStreamWrapper.readUb1();
            }
            if ((resultObject = this._findFileIndex(arrayList, n)) == null) {
                if (!bl) continue;
                resultObject = new ResultObject();
                resultObject.view = this._view;
                resultObject.fileno = n;
                resultObject.useful = true;
                resultObject.label = null;
                resultObject.urlName = null;
                resultObject.setHitNumber(n2);
                arrayList.add(resultObject);
                continue;
            }
            resultObject.useful = true;
            resultObject.setHitNumber(resultObject.getHitNumber() + n2);
        }
        this._filterResults(arrayList);
    }

    private void _readFileNames(InputStreamWrapper inputStreamWrapper, ArrayList arrayList, byte[] byArray) throws IOException {
        int n = inputStreamWrapper.readUb2();
        for (int i = 0; i < n; ++i) {
            int n2 = inputStreamWrapper.readUb1();
            inputStreamWrapper.read(byArray, 0, n2);
            ResultObject resultObject = this._findFileIndex(arrayList, i);
            if (resultObject != null) {
                resultObject.view = this._view;
                resultObject.urlName = this._version < 20 ? new String(byArray, 0, n2) : this._bytesToString(byArray, 0, n2);
            }
            if (this._titlesAvailable) {
                n2 = inputStreamWrapper.readUb1();
                inputStreamWrapper.read(byArray, 0, n2);
                if (resultObject != null) {
                    resultObject.label = this._version < 20 ? new String(byArray, 0, n2) : this._bytesToString(byArray, 0, n2);
                }
            }
            if (i % 20 != 0) continue;
            this._checkStopSearch();
        }
    }

    private List _evaluateNOT(List list) throws SearchException {
        ArrayList<ResultObject> arrayList = Collections.EMPTY_LIST;
        byte[] byArray = new byte[256];
        InputStream inputStream = null;
        try {
            inputStream = this._openInputStream(this._url);
            InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(inputStream);
            inputStreamWrapper.skipToOffset(this._fsOffset);
            int n = inputStreamWrapper.readUb2();
            int n2 = list.size();
            if (n2 >= n) {
                List list2 = Collections.EMPTY_LIST;
                return list2;
            }
            arrayList = new ArrayList<ResultObject>(n - n2);
            for (int i = 0; i < n; ++i) {
                ResultObject resultObject;
                int n3;
                boolean bl = false;
                for (n3 = 0; n3 < n2; ++n3) {
                    resultObject = (ResultObject)list.get(n3);
                    if (resultObject.fileno != i) continue;
                    bl = true;
                    break;
                }
                n3 = inputStreamWrapper.readUb1();
                inputStreamWrapper.read(byArray, 0, n3);
                resultObject = null;
                if (!bl) {
                    resultObject = new ResultObject();
                    resultObject.fileno = i;
                    resultObject.setHitNumber(0);
                    resultObject.view = this._view;
                    resultObject.urlName = this._version < 20 ? new String(byArray, 0, n3) : this._bytesToString(byArray, 0, n3);
                }
                if (this._titlesAvailable) {
                    n3 = inputStreamWrapper.readUb1();
                    inputStreamWrapper.read(byArray, 0, n3);
                    if (resultObject != null) {
                        resultObject.label = this._version < 20 ? new String(byArray, 0, n3) : this._bytesToString(byArray, 0, n3);
                    }
                }
                if (resultObject == null) continue;
                arrayList.add(resultObject);
            }
        }
        catch (Exception exception) {
            throw new SearchException("Error encountered executing NOT boolean search: " + exception.getMessage(), exception);
        }
        finally {
            try {
                inputStream.close();
                inputStream = null;
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    private void _filterResults(List list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            ResultObject resultObject = (ResultObject)list.get(i);
            if (resultObject.useful) continue;
            list.remove(i);
        }
    }

    private ResultObject _findFileIndex(List list, int n) {
        for (ResultObject resultObject : list) {
            if (resultObject.fileno != n) continue;
            return resultObject;
        }
        return null;
    }

    private void _bubbleSort(String[] stringArray) {
        if (stringArray.length == 1) {
            return;
        }
        if (stringArray.length == 2) {
            if (stringArray[0].compareTo(stringArray[1]) > 0) {
                String string = stringArray[1];
                stringArray[1] = stringArray[0];
                stringArray[0] = string;
            }
            return;
        }
        for (int i = stringArray.length - 1; i >= 1; --i) {
            for (int j = 1; j <= i; ++j) {
                if (stringArray[j - 1].compareTo(stringArray[j]) <= 0) continue;
                String string = stringArray[j - 1];
                stringArray[j - 1] = stringArray[j];
                stringArray[j] = string;
            }
        }
    }

    private String[] _filter(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= 1) continue;
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    private static void _quickSort(List list, int n, int n2) {
        if (n2 > n) {
            int n3 = ((ResultObject)list.get(n2)).getHitNumber();
            int n4 = n - 1;
            int n5 = n2;
            while (true) {
                if (((ResultObject)list.get(++n4)).getHitNumber() > n3) {
                    continue;
                }
                while (((ResultObject)list.get(--n5)).getHitNumber() < n3 && n5 > 0) {
                }
                if (n4 >= n5) break;
                IndexFileQueryHandler._swapObject(list, n4, n5);
            }
            IndexFileQueryHandler._swapObject(list, n4, n2);
            IndexFileQueryHandler._quickSort(list, n, n4 - 1);
            IndexFileQueryHandler._quickSort(list, n4 + 1, n2);
        }
    }

    private static void _swapObject(List list, int n, int n2) {
        ResultObject resultObject = (ResultObject)list.get(n);
        list.set(n, list.get(n2));
        list.set(n2, resultObject);
    }

    private class SearchInterruptedError
    extends Error {
        public SearchInterruptedError(String string) {
            super(string);
        }
    }

    private class InputStreamWrapper {
        private InputStream _inStream;
        private long _pos;

        public InputStreamWrapper(InputStream inputStream) {
            this._inStream = inputStream;
            this._pos = 0L;
        }

        public long readUb4() throws IOException {
            long l = 0L;
            l = (long)this.readUb1() << 24 | (long)this.readUb1() << 16 | (long)this.readUb1() << 8 | (long)this.readUb1();
            return l;
        }

        public int readUb2() throws IOException {
            int n = this.readUb1() << 8 | this.readUb1();
            return n;
        }

        public int readUb1() throws IOException {
            int n = this._inStream.read();
            if (n < 0) {
                n += 256;
            }
            ++this._pos;
            return n;
        }

        public void skipToOffset(long l) throws IOException {
            long l2 = l - this._pos;
            while (l2 > 0L) {
                long l3 = this._inStream.skip(l2);
                if (l3 != -1L) {
                    l2 -= l3;
                    this._pos += l3;
                    continue;
                }
                throw new IOException("IndexFileQueryHandler attempting to skip past end of file: " + IndexFileQueryHandler.this._url);
            }
        }

        public String readLine() throws IOException {
            char c;
            int n = 40;
            StringBuffer stringBuffer = new StringBuffer(n);
            while ((c = (char)this._inStream.read()) != '\n') {
                if (stringBuffer.length() == n) {
                    stringBuffer.setLength(n += 40);
                }
                stringBuffer.append(c);
                ++this._pos;
            }
            ++this._pos;
            return stringBuffer.toString();
        }

        public void read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n3 != n2) {
                int n4 = this._inStream.read(byArray, n + n3, n2 - n3);
                if (n4 == -1) {
                    throw new IOException();
                }
                n3 += n4;
                this._pos += (long)n4;
            }
        }

        public long getPosition() {
            return this._pos;
        }
    }

    private class ResultObject
    implements QueryResult {
        public int fileno = -1;
        public String urlName = null;
        public String label = null;
        public boolean useful = false;
        public View view = null;
        private int _hitNumber = 0;

        private ResultObject() {
        }

        public Topic getResultTopic() {
            SimpleURLTarget simpleURLTarget = new SimpleURLTarget(this.view, this.urlName);
            SimpleTopic simpleTopic = new SimpleTopic(this.label, simpleURLTarget);
            return simpleTopic;
        }

        public int getResultScore() {
            return this._hitNumber;
        }

        public String getResultSource() {
            return IndexFileQueryHandler.this._sourceIdentifier;
        }

        public int getHitNumber() {
            return this._hitNumber;
        }

        public void setHitNumber(int n) {
            this._hitNumber = n;
        }
    }
}

