/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.xml;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.common.xml.XMLToken;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class HelpXmlPullParser
implements Parser {
    private static final Logger _LOGGER = Logger.getLogger(HelpXmlPullParser.class.getName(), "oracle.help.share.resource.LoggerBundle");
    private XMLNode _root;

    public HelpXmlPullParser(Reader reader, String string) {
        try {
            LaxParser laxParser = new LaxParser();
            laxParser.setInput(reader);
            this._processDocument(laxParser);
        }
        catch (XmlPullParserException xmlPullParserException) {
            if (string != null) {
                _LOGGER.log(Level.WARNING, "HELP-00001", string);
            }
            _LOGGER.log(Level.WARNING, xmlPullParserException.getLocalizedMessage(), xmlPullParserException);
        }
        catch (IOException iOException) {
            if (string != null) {
                _LOGGER.log(Level.WARNING, "HELP-00002", string);
            }
            _LOGGER.log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
        }
    }

    public HelpXmlPullParser(InputStream inputStream, String string) {
        try {
            LaxParser laxParser = new LaxParser();
            String string2 = null;
            if (!laxParser.getFeature("http://xmlpull.org/v1/doc/features.html#detect-encoding")) {
                string2 = "UTF-8";
            }
            laxParser.setInput(inputStream, string2);
            this._processDocument(laxParser);
        }
        catch (XmlPullParserException xmlPullParserException) {
            if (string != null) {
                _LOGGER.log(Level.WARNING, "HELP-00001", string);
            }
            _LOGGER.log(Level.WARNING, xmlPullParserException.getLocalizedMessage(), xmlPullParserException);
        }
        catch (IOException iOException) {
            if (string != null) {
                _LOGGER.log(Level.WARNING, "HELP-00002", string);
            }
            _LOGGER.log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
        }
    }

    private void _processDocument(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        String string = null;
        XMLNode xMLNode = new XMLNode();
        XMLNode xMLNode2 = new XMLNode();
        int n = xmlPullParser.getEventType();
        do {
            String string2 = xmlPullParser.getName();
            if (n == 0) {
                this._root = new XMLNode();
                this._root.setLineNumber(xmlPullParser.getLineNumber());
                xMLNode = this._root;
                xMLNode2 = null;
            } else if (n != 1) {
                Object object;
                if (n == 2) {
                    if (string == null) {
                        string = string2;
                    }
                    try {
                        object = new HashMap(11);
                        for (int i = 0; i < xmlPullParser.getAttributeCount(); ++i) {
                            ((HashMap)object).put(xmlPullParser.getAttributeName(i), xmlPullParser.getAttributeValue(i));
                        }
                        XMLToken xMLToken = new XMLToken(string2, 1, (HashMap)object);
                        xMLNode2 = new XMLNode(xMLToken, xMLNode);
                        xMLNode2.setLineNumber(xmlPullParser.getLineNumber());
                        xMLNode = xMLNode2;
                    }
                    catch (XMLParseException xMLParseException) {
                        _LOGGER.log(Level.WARNING, "", xMLParseException);
                    }
                } else if (n == 3) {
                    xMLNode = xMLNode.getParent();
                    if (string2.equals(string)) {
                        n = 1;
                        continue;
                    }
                } else if (n == 4) {
                    object = xmlPullParser.getText();
                    if (xMLNode2 != null && !((String)object).trim().equals("")) {
                        xMLNode2.setString((String)object);
                    }
                }
            }
            n = xmlPullParser.next();
        } while (n != 1);
    }

    public XMLNode getRoot() {
        return this._root;
    }

    private void _printRoot() {
        this.getRoot()._printTree("");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java HelpXmlPullParser <filename>");
            System.exit(1);
        }
        try {
            FileReader fileReader = new FileReader(stringArray[0]);
            HelpXmlPullParser helpXmlPullParser = new HelpXmlPullParser(fileReader, stringArray[0]);
            helpXmlPullParser._printRoot();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    private class LaxParser
    extends MXParser {
        private LaxParser() {
        }

        protected void parseXmlDecl(char c) throws XmlPullParserException, IOException {
            while ((c = this.more()) != '>') {
            }
        }

        protected char parseAttribute() throws XmlPullParserException, IOException {
            int n;
            block6: {
                n = 34;
                int n2 = this.posStart + this.bufAbsoluteStart;
                try {
                    n = super.parseAttribute();
                }
                catch (XmlPullParserException xmlPullParserException) {
                    boolean bl = false;
                    try {
                        String string = this.attributeName[this.attributeCount];
                        if ("default".equals(string)) {
                            char c;
                            while ('e' != (c = this.more())) {
                            }
                            this.attributeValue[this.attributeCount] = "false";
                            ++this.attributeCount;
                            this.posStart = n2 - this.bufAbsoluteStart;
                            n = 34;
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    if (bl) break block6;
                    throw xmlPullParserException;
                }
            }
            return (char)n;
        }
    }
}

