/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.library.helpset;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import oracle.help.common.AssociativeLink;
import oracle.help.common.IndirectTarget;
import oracle.help.common.SimpleTopic;
import oracle.help.common.util.LocaleUtils;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.library.Book;

public class XMLLinkParser {
    public static final String TAG_LINK = "link";
    public static final String TAG_LINKITEM = "linkitem";
    public static final String TAG_LINKENTRY = "linkentry";
    public static final String PROP_TOPIC = "topic";
    public static final String PROP_TARGET = "target";
    public static final String PROP_TEXT = "text";
    private ArrayList _links;

    public AssociativeLink[] parseLinkFile(URL uRL, String string, Book book) throws IOException, XMLParseException {
        InputStreamReader inputStreamReader = LocaleUtils.createInputStreamReader(uRL.openStream(), string);
        return this.parseLinkFile(inputStreamReader, book);
    }

    public AssociativeLink[] parseLinkFile(Reader reader, Book book) throws XMLParseException {
        Parser parser = ParserFactory.createParser(reader);
        XMLNode xMLNode = parser.getRoot();
        this._links = new ArrayList();
        this._handleLinks(xMLNode.getFirstChild(), book);
        AssociativeLink[] associativeLinkArray = null;
        if (this._links.size() > 0) {
            associativeLinkArray = new AssociativeLink[this._links.size()];
            this._links.toArray(associativeLinkArray);
        }
        return associativeLinkArray;
    }

    private void _handleLinks(XMLNode xMLNode, Book book) throws XMLParseException {
        if (xMLNode == null) {
            throw new XMLParseException("No toplevel tag");
        }
        if (!xMLNode.tokenEquals(TAG_LINK)) {
            throw new XMLParseException("Toplevel tag is not link: " + xMLNode.getTokenValue());
        }
        for (xMLNode = xMLNode.getFirstChild(); xMLNode != null; xMLNode = xMLNode.getNextSibling()) {
            this._handleLinkItem(xMLNode, book);
        }
    }

    private void _handleLinkItem(XMLNode xMLNode, Book book) throws XMLParseException {
        if (!xMLNode.tokenEquals(TAG_LINKITEM)) {
            throw new XMLParseException("Expecting linkitem, got: " + xMLNode.getTokenValue());
        }
        String string = xMLNode.getTokenProperty(PROP_TOPIC);
        if (string == null || string.equals("")) {
            throw new XMLParseException("Found null topic in linkitem");
        }
        AssociativeLink associativeLink = new AssociativeLink(string);
        for (xMLNode = xMLNode.getFirstChild(); xMLNode != null; xMLNode = xMLNode.getNextSibling()) {
            this._handleLinkEntry(xMLNode, associativeLink, book);
        }
        if (associativeLink.getTopicCount() > 0) {
            this._links.add(associativeLink);
        }
    }

    private void _handleLinkEntry(XMLNode xMLNode, AssociativeLink associativeLink, Book book) throws XMLParseException {
        if (!xMLNode.tokenEquals(TAG_LINKENTRY)) {
            throw new XMLParseException("Expecting linkentry, got: " + xMLNode.getTokenValue());
        }
        String string = xMLNode.getTokenProperty(PROP_TARGET);
        if (string == null || string.equals("")) {
            throw new XMLParseException("Found null target in linkentry");
        }
        String string2 = xMLNode.getTokenProperty(PROP_TEXT);
        if (string2 == null || string2.equals("")) {
            throw new XMLParseException("Found null title in linkentry");
        }
        IndirectTarget indirectTarget = new IndirectTarget(book, string);
        SimpleTopic simpleTopic = new SimpleTopic(string2, indirectTarget, book);
        associativeLink.addTopic(simpleTopic);
    }
}

