/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jline.Terminal;

public class WindowsTerminal
extends Terminal {
    private static final int ENABLE_LINE_INPUT = 2;
    private static final int ENABLE_ECHO_INPUT = 4;
    private static final int ENABLE_PROCESSED_INPUT = 1;
    private static final int ENABLE_WINDOW_INPUT = 8;
    private static final int ENABLE_MOUSE_INPUT = 16;
    private static final int ENABLE_PROCESSED_OUTPUT = 1;
    private static final int ENABLE_WRAP_AT_EOL_OUTPUT = 2;
    private Boolean directConsole;

    public WindowsTerminal() {
        String dir = System.getProperty("jline.WindowsTerminal.directConsole");
        if ("true".equals(dir)) {
            this.directConsole = Boolean.TRUE;
        } else if ("false".equals(dir)) {
            this.directConsole = Boolean.FALSE;
        }
    }

    private native int getConsoleMode();

    private native void setConsoleMode(int var1);

    private native int readByte();

    private native int getWindowsTerminalWidth();

    private native int getWindowsTerminalHeight();

    public int readCharacter(InputStream in) throws IOException {
        if (this.directConsole == Boolean.FALSE) {
            return super.readCharacter(in);
        }
        if (this.directConsole == Boolean.TRUE || in == System.in || in instanceof FileInputStream && ((FileInputStream)in).getFD() == FileDescriptor.in) {
            return this.readByte();
        }
        return super.readCharacter(in);
    }

    public void initializeTerminal() throws Exception {
        this.loadLibrary("jline");
        final int originalMode = this.getConsoleMode();
        this.setConsoleMode(originalMode & 0xFFFFFFFB);
        int newMode = originalMode & 0xFFFFFFF0;
        this.setConsoleMode(newMode);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void start() {
                    WindowsTerminal.this.setConsoleMode(originalMode);
                }
            });
        }
        catch (AbstractMethodError ame) {
            this.consumeException(ame);
        }
    }

    private void loadLibrary(String name) throws IOException {
        File f;
        block4: {
            String version = this.getClass().getPackage().getImplementationVersion();
            if (version == null) {
                version = "";
            }
            version = version.replace('.', '_');
            f = new File(System.getProperty("java.io.tmpdir"), name + "_" + version + ".dll");
            boolean exists = f.isFile();
            BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream(name + ".dll"));
            try {
                BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(f));
                byte[] bytes = new byte[10240];
                int n = 0;
                while (n != -1) {
                    ((OutputStream)fout).write(bytes, 0, n);
                    n = ((InputStream)in).read(bytes);
                }
                ((OutputStream)fout).close();
            }
            catch (IOException ioe) {
                if (exists) break block4;
                throw ioe;
            }
        }
        f.deleteOnExit();
        System.load(f.getAbsolutePath());
    }

    public int readVirtualKey(InputStream in) throws IOException {
        int c = this.readCharacter(in);
        if (c == 224) {
            c = this.readCharacter(in);
            if (c == 72) {
                return 16;
            }
            if (c == 80) {
                return 14;
            }
            if (c == 75) {
                return 2;
            }
            if (c == 77) {
                return 6;
            }
        }
        return c;
    }

    public boolean isSupported() {
        return true;
    }

    public boolean isANSISupported() {
        return false;
    }

    public boolean getEcho() {
        return false;
    }

    public int getTerminalWidth() {
        return this.getWindowsTerminalWidth();
    }

    public int getTerminalHeight() {
        return this.getWindowsTerminalHeight();
    }

    private void consumeException(Throwable e) {
    }

    public void setDirectConsole(Boolean directConsole) {
        this.directConsole = directConsole;
    }

    public Boolean getDirectConsole() {
        return this.directConsole;
    }
}

