/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler.boot;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeCore;
import oracle.ide.IdeStarter;
import oracle.ide.Version;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.javatools.util.FormatBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeStarter
extends IdeStarter {
    protected static final FormatBundle bundle = new FormatBundle(MakeStarter.class);
    private ArrayList<Workspace> workspaces;
    private ArrayList<Project> projects;
    private boolean rebuild;
    private boolean clean;

    private void $init$() {
        this.workspaces = new ArrayList();
        this.projects = new ArrayList();
        this.rebuild = false;
        this.clean = false;
    }

    public MakeStarter() {
        this.$init$();
    }

    public void startIde(String command, String[] arguments, IdeCore core) {
        if (arguments.length == 0 || arguments.length == 1 && "-help".equals(arguments[0])) {
            this.printUsage();
            System.exit(0);
        }
        System.setProperty("display.logger.mode", "headless");
        IdeArgs ideArgs = core.getIdeArgs();
        ideArgs.setCreateUI(false);
        core.useInvokeLaterForAddinsLoadedEvenThoughHeadless();
        Ide.startup((IdeCore)core);
        int i = 0;
        while (i < arguments.length) {
            if ("-rebuild".equals(arguments[i])) {
                this.rebuild = true;
            } else if ("-clean".equals(arguments[i])) {
                this.clean = true;
            } else if (arguments[i].endsWith(".jws")) {
                try {
                    File file = new File(arguments[i]);
                    if (file.exists()) {
                        this.workspaces.add((Workspace)NodeFactory.findOrCreate(Workspace.class, (URL)URLFactory.newFileURL((String)file.getCanonicalPath())));
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.exit(1);
                }
            } else if (arguments[i].endsWith(".jpr")) {
                try {
                    File file = new File(arguments[i]);
                    if (file.exists()) {
                        this.projects.add((Project)NodeFactory.findOrCreate(Project.class, (URL)URLFactory.newFileURL((String)arguments[i])));
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            ++i;
        }
    }

    public ArrayList<Workspace> getWorkspaces() {
        return this.workspaces;
    }

    public ArrayList<Project> getProjects() {
        return this.projects;
    }

    public boolean getRebuildOption() {
        return this.rebuild;
    }

    public boolean getCleanOption() {
        return this.clean;
    }

    private void printUsage() {
        this.printCopyright();
        System.out.println(bundle.get("make.usage.message"));
        System.out.println();
    }

    private void printCopyright() {
        System.out.println(bundle.get("make.copyright.message", new Object[]{Version.NAME_SHORT, Version.VER, Version.BUILD_NUM}));
        System.out.println();
    }
}

