/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.addin;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.RepaintManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.report.addin.ReportAddin;
import oracle.dbtools.raptor.report.addin.ReportEditorController;
import oracle.dbtools.raptor.report.navigatorV2.ReportEditorNode;
import oracle.dbtools.raptor.report.navigatorV2.ReportNavigatorContextMenu;
import oracle.dbtools.raptor.report.navigatorV2.ReportNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.jdevimpl.runner.run.RunArb;

public class ReportEditor
extends Editor
implements Controller,
IDBEditor {
    private DisplayPanel _panel;
    private Toolbar _toolbar;
    private DBConnectionComboBox _dbConns;
    private String _dbName;
    JEWTDialog dlg;
    private boolean _isPinned = false;
    private IdeAction pinAction;
    private JComboBox _timerInterval;
    private Timer _timer;
    private TimerTask _tt;
    private ArrayList<IdeAction> history = new ArrayList();
    MenuToolButton historyButton;
    public static final String HISTOY_CMD = "ReportEditor.HISTORY_CMD";
    public static final int HISTORY_CMD_ID = Ide.findOrCreateCmdID((String)"ReportEditor.HISTORY_CMD");
    AbstractAction sqlWorksheet;
    AbstractAction run;
    private ToggleToolButton _pinToggle;
    static final int PIN_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"VE_Pin_Editor");
    public static final String REPORT_CONN_NAME = "report.conn.name";

    public ReportEditor() {
        this.pinAction = IdeAction.get((int)PIN_EDITOR_CMD_ID, null, (String)IdeArb.getString((int)78), null, null, (Icon)IdeArb.getIcon((int)175), null, (boolean)true).newLocalAction((View)this);
        this.pinAction.addController((Controller)this);
    }

    public Object getPrintable() {
        return this._panel;
    }

    public JComboBox getTimer() {
        return this._timerInterval;
    }

    public static void disableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(true);
    }

    public DisplayPanel getPanel() {
        return this._panel;
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.init();
    }

    public Component getGUI() {
        this.updateContent();
        return this._panel;
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public Component getFixedTopMargin() {
        return this._panel.getToolbar();
    }

    public void openSQLEditor() {
        SqlEditor sqlEditor = SqlEditor.openNewEditor((String)this._dbConns.getCurrentConnectionName());
        try {
            sqlEditor.setDb(this._dbConns.getCurrentDatabase());
            String string = this._panel.getModel().getQuery(this.getConnection()).getSql();
            sqlEditor.setText(string.trim());
        }
        catch (DBException dBException) {
            DBException dBException2 = dBException.getCause() instanceof Exception ? (Exception)dBException.getCause() : dBException;
            ExceptionHandler.handleException((Exception)((Object)dBException2));
        }
    }

    private void buildToolbar() {
        this._pinToggle = this._toolbar.addToggleButton((ToggleAction)this.pinAction);
        this.run = new AbstractAction("Run Report", RunArb.getIcon((int)17)){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                Ide.getMainWindow().setCursor(new Cursor(3));
                ReportEditor.this._panel.promptForBindsOnNextRun(true);
                ReportEditor.this._panel.refresh(true);
                Ide.getMainWindow().setCursor(new Cursor(0));
            }
        };
        this.run.putValue("ShortDescription", "Run Report");
        this._toolbar.add((Action)this.run);
        this._toolbar.addSeparator();
        this.sqlWorksheet = new AbstractAction("Run Report in SQLWorksheet", CommonArb.getIcon((int)0)){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ReportEditor.this.openSQLEditor();
            }
        };
        this.sqlWorksheet.putValue("ShortDescription", "Run Report in SQLWorksheet");
        this._toolbar.add((Action)this.sqlWorksheet);
        this._dbConns = new DBConnectionComboBox();
        this._dbConns.getJComboBox().setSize(50, 20);
        JLabel jLabel = new JLabel("Refresh:");
        this._timerInterval = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this._timerInterval.getModel();
        defaultComboBoxModel.addElement("0");
        defaultComboBoxModel.addElement("5");
        defaultComboBoxModel.addElement("10");
        defaultComboBoxModel.addElement("15");
        defaultComboBoxModel.addElement("20");
        defaultComboBoxModel.addElement("25");
        defaultComboBoxModel.addElement("30");
        defaultComboBoxModel.addElement("60");
        defaultComboBoxModel.addElement("120");
        this._timerInterval.setMaximumSize(this._timerInterval.getMinimumSize());
        this._timerInterval.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    if (ReportEditor.this._timer != null) {
                        ReportEditor.this._timer.cancel();
                        ReportEditor.this._timer = null;
                    }
                    if (!ReportEditor.this._timerInterval.getSelectedItem().equals("0")) {
                        ReportEditor.this._timer = new Timer();
                        ReportEditor.this._tt = new TimerTask(){

                            public void run() {
                                ReportEditor.this._panel.refresh(false, true);
                            }
                        };
                        ReportEditor.this._timer.scheduleAtFixedRate(ReportEditor.this._tt, 0L, Long.parseLong((String)ReportEditor.this._timerInterval.getSelectedItem()) * 1000L);
                    }
                }
            }
        });
        this._toolbar.add((Component)jLabel);
        this._toolbar.add((Component)this._timerInterval);
        this._toolbar.addSeparator();
        int n = Ide.findOrCreateCmdID((String)"DRILL_UP.Back");
        IdeAction ideAction = IdeAction.get((int)n, null, (String)StringUtils.stripMnemonic((String)"Back"), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)"Back")), null, null, (boolean)true);
        this.historyButton = new MenuToolButton((ToggleAction)ideAction);
        this.historyButton.setEnabled(false);
        this.historyButton.setIcon(RaptorImage.getIcon((String)"navigate_back.gif"));
        this._toolbar.add((Component)this.historyButton);
        this._toolbar.add(Box.createHorizontalGlue());
        this._toolbar.add((Component)this._dbConns.getJComboBox(), (Object)"Center");
    }

    private IdeAction getAction(DisplayModel displayModel) {
        String string = displayModel.getName();
        int n = Ide.findOrCreateCmdID((String)("DRILL_UP." + string));
        IdeAction ideAction = IdeAction.get((int)n, null, (String)StringUtils.stripMnemonic((String)string), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), null, null, (boolean)true);
        ideAction.putValue("ID", (Object)displayModel.getID());
        ideAction.putValue("BINDS", (Object)displayModel.getQueriesBindMap());
        ideAction.addController((Controller)this);
        return ideAction;
    }

    private void updateToolbar() {
        this.historyButton.removeAllPopupItems();
        for (IdeAction ideAction : this.history) {
            this.historyButton.addPopupItem((ToggleAction)ideAction);
        }
        if (this.history.size() > 0) {
            this.historyButton.setEnabled(true);
        } else {
            this.historyButton.setEnabled(false);
        }
        this.historyButton.setIcon(RaptorImage.getIcon((String)"navigate_back.gif"));
    }

    private void init() {
        if (this._panel == null) {
            this._panel = new DisplayPanel(null);
            if (this.getContext() != null) {
                this._dbName = (String)this.getContext().getProperty(REPORT_CONN_NAME);
            }
            if (this._dbName == null) {
                this._dbName = ConnectionSelectorUI.getConnection((String)ConnectionArb.getString((int)32), (String)ConnectionArb.getString((int)31), (String)this._dbName, (boolean)true);
            }
            if (this._dbName == null) {
                this.close();
                return;
            }
            this._toolbar = this._panel.getToolbar();
            this.buildToolbar();
            this._dbConns.setCurrentConnection(this._dbName);
            this._dbConns.getJComboBox().addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    String string = ReportEditor.this._dbName;
                    if (itemEvent.getStateChange() == 1 && ReportEditor.this._panel != null) {
                        ReportEditor.this._dbName = ReportEditor.this._dbConns.getCurrentConnectionName();
                        ReportEditor.this.sqlWorksheet.setEnabled(true);
                        ReportEditor.this.run.setEnabled(true);
                        if (ReportEditor.this.getContext().getNode() != null && ReportEditor.this.getContext().getNode() instanceof ReportEditorNode) {
                            boolean bl;
                            boolean bl2 = bl = !ReportAddin.isUserDefinedReport(((ReportEditorNode)ReportEditor.this.getContext().getNode()).getReportNode().getURL());
                            if (ReportEditor.this._dbName != null && !ReportEditor.this._dbName.equals("") && !Connections.getInstance().isOracle(ReportEditor.this._dbName) && bl) {
                                ReportEditor.this._dbName = string;
                                ReportEditor.this._dbConns.setCurrentConnection(ReportEditor.this._dbName);
                                ReportAddin.showOracleOnlyReportMessage((Component)ReportEditor.this._panel);
                                return;
                            }
                            if (string != ReportEditor.this._dbName) {
                                ReportEditor.this._panel.setModel(null);
                            }
                        }
                        if (string != ReportEditor.this._dbName) {
                            ReportEditor.this.updateContent();
                        }
                    } else if (itemEvent.getStateChange() == 2) {
                        ReportEditor.this.sqlWorksheet.setEnabled(false);
                        ReportEditor.this.run.setEnabled(false);
                        ReportEditor.this._timer.cancel();
                        ReportEditor.this._timer = null;
                        ReportEditor.this._timerInterval.setSelectedItem("0");
                    }
                }
            });
        }
    }

    public void updateContent() {
        Ide.getMainWindow().setCursor(new Cursor(3));
        ReportEditorNode reportEditorNode = (ReportEditorNode)this.getContext().getNode();
        ReportNode reportNode = reportEditorNode.getReportNode();
        try {
            if (this._dbName == null || reportNode == null || reportNode.getReport() == null) {
                Ide.getMainWindow().setCursor(new Cursor(0));
                return;
            }
            Ide.getStatusBar().setText(Translate.translate((String)"Executing_Report"));
            reportNode.getReport().setConnName(this._dbName);
            if (reportNode.getReport().hasChildren()) {
                for (DisplayModel displayModel : reportNode.getReport().getChildren()) {
                    displayModel.setConnName(this._dbName);
                }
            }
            if (this._panel.getModel() == null || this._panel.getModel() != null && this._panel.getModel() != reportNode.getReport()) {
                if (reportNode.getReport().getParent() != null) {
                    this.history.add(this.getAction(reportNode.getReport().getParent()));
                    this.updateToolbar();
                } else {
                    this.history.clear();
                    this.updateToolbar();
                }
                this._panel.close();
                this._panel.setConnectionName(this.getConnectionName());
                this._panel.setModel(reportNode.getReport());
            }
            this._panel.validate();
            Ide.getMainWindow().setCursor(new Cursor(0));
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            Ide.getMainWindow().setCursor(new Cursor(0));
        }
    }

    public Object getEditorAttribute(String string) {
        boolean bl = false;
        if ("horizontal_scrollbar_policy".equals(string) && !bl) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(string) && !bl) {
            return new Integer(21);
        }
        if ("scrollable".equals(string) && !bl) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(string);
    }

    public void close() {
        super.close();
        this.history = new ArrayList();
        if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
        }
        try {
            this.getContext().getNode().close();
        }
        catch (IOException iOException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        if (this._panel != null) {
            this._panel.close();
            this._panel = null;
        }
    }

    public void setPinned(boolean bl) {
        this._isPinned = bl;
    }

    public boolean getPinned() {
        return this._isPinned;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getValue("ID") != null) {
            int n;
            DisplayModel displayModel = DisplayModelCache.getDisplayModel((String)((String)ideAction.getValue("ID")));
            if (ideAction.getValue("BINDS") != null) {
                displayModel.setQueriesBindMap((HashMap)ideAction.getValue("BINDS"));
            }
            if ((n = this.history.indexOf(ideAction)) == 0) {
                this.history = new ArrayList();
            } else {
                ArrayList<IdeAction> arrayList = new ArrayList<IdeAction>();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(this.history.get(i));
                }
                this.history = arrayList;
            }
            this.updateToolbar();
            ReportNavigatorContextMenu.getInstance().openReport(displayModel, false, (String)this.getContext().getProperty("ObjectAction.CONN_NAME"));
            return true;
        }
        this.setPinned(!this.getPinned());
        this.pinAction.setState(this.getPinned());
        if (!this.getPinned()) {
            this._pinToggle.setIcon(IdeArb.getIcon((int)175));
        } else {
            this._pinToggle.setIcon(RaptorImagesArb.getIcon((int)68));
        }
        return true;
    }

    public void editorShown() {
        ReportEditor.updateToolbarActions((Toolbar)this._toolbar);
        this.pinAction.setState(this.getPinned());
        if (!this.getPinned()) {
            this._pinToggle.setIcon(IdeArb.getIcon((int)175));
        } else {
            this._pinToggle.setIcon(RaptorImagesArb.getIcon((int)68));
        }
    }

    public void editorHidden() {
        ReportEditor.updateToolbarActions((Toolbar)this._toolbar);
        this.pinAction.setState(this.getPinned());
    }

    public void open() {
    }

    public Database getDatabase() {
        Database database = null;
        try {
            database = this._dbConns.getCurrentDatabase();
        }
        catch (DBException dBException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        return database;
    }

    public Connection getConnection() {
        return this._dbConns.getCurrentConnection();
    }

    public String getConnectionName() {
        return this._dbConns.getCurrentConnectionName();
    }

    public Controller getController() {
        return ReportEditorController.getInstance();
    }

    public DBConnectionComboBox getDBSelector() {
        return this._dbConns;
    }
}

