/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.navigatorV2;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Folder
implements Cloneable {
    private String name;
    private String description;
    private String tooltip;

    public Folder() {
        this(null);
    }

    public Folder(String string, String string2) {
        this.name = string;
        this.description = string2;
    }

    public Folder(Node node) {
        if (node != null) {
            this.name = XMLHelper.getNodeValue((Node)node, (String)"name");
            this.description = XMLHelper.getNodeValue((Node)node, (String)"description");
            this.tooltip = XMLHelper.getNodeValue((Node)node, (String)"tooltip");
        }
    }

    public String getName() {
        if (this.name.indexOf("/") > 0) {
            this.name = this.name.substring(this.name.lastIndexOf("/") + 1);
        }
        return this.name.replace("<#>", "/");
    }

    public String getDescription() {
        if (this.description == null) {
            return " ";
        }
        return this.description;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void settooltip(String string) {
        this.tooltip = string;
    }

    public String getTooltip() {
        return this.tooltip == null || this.tooltip.equals("null") ? this.getName() : this.tooltip;
    }

    public String toString() {
        return this.toXML(false);
    }

    public String toXML(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl) {
            stringBuilder.append("\t<folder>\n");
        }
        stringBuilder.append("\t\t<name><![CDATA[" + this.name + "]]></name>\n");
        stringBuilder.append("\t\t<description><![CDATA[" + this.description + "]]></description>\n");
        stringBuilder.append("\t\t<tooltip><![CDATA[" + this.tooltip + "]]></tooltip>\n");
        if (!bl) {
            stringBuilder.append("\t</folder>\n");
        }
        return stringBuilder.toString();
    }

    public Folder clone() {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            dOMParser.parse((Reader)new StringReader(this.toXML(false)));
        }
        catch (XMLParseException xMLParseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, xMLParseException.getStackTrace()[0].toString(), xMLParseException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        Node node = xMLDocument.getFirstChild();
        return new Folder(node);
    }
}

