/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.navigatorV2;

import java.net.URL;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.dbtools.raptor.report.addin.ReportAddin;
import oracle.dbtools.raptor.report.navigatorV2.Folder;
import oracle.dbtools.raptor.report.navigatorV2.ReportNode;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;

public class FolderNode
extends DefaultContainer
implements Cloneable {
    Folder _folder;
    boolean _editable = true;
    private boolean _temp;
    private Attributes m_attributes = new ElementAttributes();

    public FolderNode() {
    }

    public FolderNode(URL uRL) {
        super(uRL);
    }

    public FolderNode(URL uRL, Folder folder) {
        super(uRL);
        this._folder = folder;
    }

    public Icon getIcon() {
        return ReportAddin.folderIcon;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public boolean isTemp() {
        return this._temp;
    }

    public void setTemp(boolean bl) {
        this._temp = bl;
    }

    public String getLongLabel() {
        return this._folder == null ? "" : this._folder.getDescription();
    }

    public String getShortLabel() {
        return this._folder == null ? "" : this._folder.getName();
    }

    public String getToolTipText() {
        return this._folder == null ? "" : this._folder.getTooltip();
    }

    public void setEditable(boolean bl) {
        this._editable = bl;
    }

    public void setEditableRecursive(boolean bl) {
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof FolderNode) {
                ((FolderNode)e).setEditableRecursive(bl);
                continue;
            }
            if (!(e instanceof ReportNode)) continue;
            ((ReportNode)e).setEditable(bl);
        }
    }

    public Folder getFolder() {
        return this._folder;
    }

    public void setFolder(Folder folder) {
        this._folder = folder;
    }

    public String toXML(int n) {
        return this.toXML(new StringBuffer(), n).toString();
    }

    public StringBuffer toXML(StringBuffer stringBuffer, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "\t";
        }
        stringBuffer.append(string);
        stringBuffer.append("<folder>\n\t");
        stringBuffer.append(string);
        stringBuffer.append("<name><![CDATA[" + this._folder.getName() + "]]></name>\n\t");
        stringBuffer.append(string);
        stringBuffer.append("<tooltip><![CDATA[" + this._folder.getTooltip() + "]]></tooltip>\n\t");
        stringBuffer.append(string);
        stringBuffer.append("<description><![CDATA[" + this._folder.getDescription() + "]]></description>\n\t");
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof FolderNode) {
                ((FolderNode)e).toXML(stringBuffer, n + 1);
                continue;
            }
            if (!(e instanceof ReportNode)) continue;
            ((ReportNode)e).getReport().toXML(stringBuffer, n + 1);
        }
        stringBuffer.append(string);
        stringBuffer.append("</folder>\n");
        return stringBuffer;
    }

    public FolderNode clone(URL uRL) {
        FolderNode folderNode = new FolderNode(uRL, this._folder.clone());
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof FolderNode) {
                folderNode.add((Element)((FolderNode)e).clone(((FolderNode)e).getURL()));
                continue;
            }
            if (!(e instanceof ReportNode)) continue;
            folderNode.add((Element)((ReportNode)e).clone(((ReportNode)e).getURL()));
        }
        return folderNode;
    }

    public Attributes getAttributes() {
        return this.m_attributes;
    }
}

