/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.navigatorV2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.FilePanelAcc;
import oracle.dbtools.raptor.controls.JFileChooserFilter;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.report.addin.ReportAddin;
import oracle.dbtools.raptor.report.addin.ReportEditor;
import oracle.dbtools.raptor.report.navigatorV2.Folder;
import oracle.dbtools.raptor.report.navigatorV2.FolderNode;
import oracle.dbtools.raptor.report.navigatorV2.ReportEditorNode;
import oracle.dbtools.raptor.report.navigatorV2.ReportNavigatorWindow;
import oracle.dbtools.raptor.report.navigatorV2.ReportNode;
import oracle.dbtools.raptor.report.navigatorV2.ReportXMLUtil;
import oracle.dbtools.raptor.report.navigatorV2.RootNode;
import oracle.dbtools.raptor.report.navigatorV2.TreeUtils;
import oracle.dbtools.raptor.report.wizzard.ReportWizzard;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.LicenseUtils;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.GuidGen;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.explorer.CustomTree;
import oracle.ideimpl.explorer.ExplorerNode;
import oracle.javatools.dialogs.MessageDialog;

public class ReportNavigatorContextMenu
implements ContextMenuListener,
Controller {
    private static ReportNavigatorContextMenu _instance;
    boolean _actionsMade = false;
    private JEWTDialog dlg;
    private JEWTDialog dlg2;
    private Node _node;
    private DefaultContainer cNode;
    private DefaultContainer pNode;
    private ReportWizzard rDiag = null;
    private JTextField gName = null;
    private JTextField gDesc = null;
    private JTextField gTip = null;
    static final int ADD_FOLDER_CMD_ID;
    private static IdeAction addFolderAction;
    static final int ADD_REPORT_CMD_ID;
    private static IdeAction addReportAction;
    static final int EDIT_CMD_ID;
    private static IdeAction editAction;
    static final int EXPORT_CMD_ID;
    private static IdeAction exportAction;
    static final int IMPORT_CMD_ID;
    private static IdeAction importAction;
    static final int OPEN_CMD_ID;
    private static IdeAction openAction;
    static final int OPEN_NEW_CMD_ID;
    private static IdeAction openNewAction;
    static final int COPY_CMD_ID;
    private static IdeAction copyAction;
    static final int CUT_CMD_ID;
    private static IdeAction cutAction;
    static final int PASTE_CMD_ID;
    private static IdeAction pasteAction;
    static final int DELETE_CMD_ID;
    private static IdeAction deleteAction;
    private Context _ctx;
    private Node _Buffer = null;
    private Context _BufferParent;
    private String ACTION = "";
    private File _file;
    private String oldName = "";
    private static File _lastUrl;

    static void createActions() {
        exportAction = ReportNavigatorContextMenu.getAction(EXPORT_CMD_ID, Translate.translate((String)"Export"), "");
        importAction = ReportNavigatorContextMenu.getAction(IMPORT_CMD_ID, Translate.translate((String)"Import"), "");
        addFolderAction = ReportNavigatorContextMenu.getAction(ADD_FOLDER_CMD_ID, Translate.translate((String)"Add Folder"), "");
        addReportAction = ReportNavigatorContextMenu.getAction(ADD_REPORT_CMD_ID, Translate.translate((String)"Add Report"), "");
        editAction = ReportNavigatorContextMenu.getAction(EDIT_CMD_ID, Translate.translate((String)"Edit"), "");
        openAction = ReportNavigatorContextMenu.getAction(OPEN_CMD_ID, Translate.translate((String)"Open"), "");
        openNewAction = ReportNavigatorContextMenu.getAction(OPEN_NEW_CMD_ID, Translate.translate((String)"Open New"), "");
        copyAction = ReportNavigatorContextMenu.getAction(COPY_CMD_ID, Translate.translate((String)"Copy"), "");
        cutAction = ReportNavigatorContextMenu.getAction(CUT_CMD_ID, Translate.translate((String)"Cut"), "");
        pasteAction = ReportNavigatorContextMenu.getAction(PASTE_CMD_ID, Translate.translate((String)"Paste"), "");
        deleteAction = ReportNavigatorContextMenu.getAction(DELETE_CMD_ID, Translate.translate((String)"Delete"), "");
    }

    private static IdeAction getAction(int n, String string, String string2) {
        IdeAction ideAction = IdeAction.get((int)n, null, (String)string, null, null, (ResourceBundle)RaptorImage.getInstance(), (String)string2, null, (boolean)true);
        ideAction.addController((Controller)ReportNavigatorContextMenu.getInstance());
        return ideAction;
    }

    public void attachMouseListener(Component component) {
        JTree jTree = TreeUtils.findTree(component);
        jTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ExplorerNode explorerNode;
                Node node;
                TreePath treePath;
                if (mouseEvent.getButton() == 1 && mouseEvent.getSource() instanceof CustomTree && (ExplorerNode)((CustomTree)mouseEvent.getSource()).getLastSelectedPathComponent() != null && ((ExplorerNode)((CustomTree)mouseEvent.getSource()).getLastSelectedPathComponent()).getUserObject() != null && (treePath = ((CustomTree)mouseEvent.getSource()).getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && (node = (Node)(explorerNode = (ExplorerNode)treePath.getLastPathComponent()).getUserObject()) instanceof ReportNode) {
                    ((ReportNode)node).getReport().setParent(null);
                    ((ReportNode)node).getReport().setQueriesBindMap(null);
                    ((Component)mouseEvent.getSource()).setCursor(new Cursor(3));
                    ReportNavigatorContextMenu.this.openReport((ReportNode)node, false, null);
                    ((Component)mouseEvent.getSource()).setCursor(new Cursor(0));
                }
            }
        });
        jTree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    keyEvent.consume();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context;
        Element[] elementArray;
        if (!this._actionsMade) {
            ReportNavigatorContextMenu.createActions();
            this._actionsMade = true;
        }
        if ((elementArray = (context = contextMenu.getContext()).getSelection()).length == 1 && context.getView() instanceof ReportNavigatorWindow) {
            contextMenu.removeAll();
            Element element = ReportNavigatorContextMenu.getElement(context);
            if (element instanceof FolderNode) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)copyAction));
                if (element == RootNode.getInstance().getUserDefined()) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)pasteAction));
                    contextMenu.addSeparator();
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addFolderAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addReportAction));
                    contextMenu.addSeparator();
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)importAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)exportAction));
                } else if (((FolderNode)element).isEditable()) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)cutAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)pasteAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)deleteAction));
                    contextMenu.addSeparator();
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)editAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addFolderAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addReportAction));
                    contextMenu.addSeparator();
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)importAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)exportAction));
                } else {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)exportAction));
                }
            } else if (element instanceof ReportNode) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)openAction));
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)openNewAction));
                contextMenu.addSeparator();
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)copyAction));
                if (((ReportNode)element).isEditable()) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)editAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)cutAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)deleteAction));
                }
                contextMenu.addSeparator();
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)exportAction));
            }
        }
    }

    private static Element getElement(Context context) {
        Element element = null;
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length == 1) {
            element = elementArray[0];
        }
        return element;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        if (context.getNode() instanceof ReportNode) {
            this.openReport(context, false);
            return true;
        }
        return false;
    }

    public FolderNode getParent(Context context) {
        TNode tNode = ExplorerContext.getSingleTNode((Context)context);
        TNode tNode2 = (TNode)tNode.getParent();
        FolderNode folderNode = (FolderNode)tNode2.getData();
        return folderNode;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == ADD_FOLDER_CMD_ID) {
            this.ACTION = "ADD";
            this.oldName = "";
            this.folderDialog((FolderNode)context.getNode(), null);
            this.refresh(context);
            this.saveUserDefined();
            return true;
        }
        if (n == ADD_REPORT_CMD_ID) {
            this.ACTION = "ADD";
            this.oldName = "";
            this.reportDialog((FolderNode)context.getNode(), null);
            this.refresh(context);
            this.saveUserDefined();
            return true;
        }
        if (n == OPEN_CMD_ID) {
            this.ACTION = "OPEN";
            this.oldName = "";
            this.openReport(context, false);
            return true;
        }
        if (n == OPEN_NEW_CMD_ID) {
            this.ACTION = "OPEN";
            this.oldName = "";
            this.openReport(context, true);
            return true;
        }
        if (n == COPY_CMD_ID) {
            this.ACTION = "COPY";
            this.oldName = "";
            if (context.getNode() instanceof FolderNode) {
                this._Buffer = ((FolderNode)context.getNode()).clone(context.getNode().getURL());
                ((FolderNode)this._Buffer).setEditableRecursive(true);
            } else if (context.getNode() instanceof ReportNode) {
                this._Buffer = ((ReportNode)context.getNode()).clone(context.getNode().getURL());
                ((ReportNode)this._Buffer).setEditable(true);
            }
            return true;
        }
        if (n == EDIT_CMD_ID) {
            this.ACTION = "EDIT";
            if (context.getNode() instanceof FolderNode) {
                this.oldName = ((FolderNode)context.getNode()).getShortLabel();
                this.folderDialog(this.getParent(context), (FolderNode)context.getNode());
            } else if (context.getNode() instanceof ReportNode) {
                this.oldName = ((ReportNode)context.getNode()).getShortLabel();
                this.reportDialog(this.getParent(context), (ReportNode)context.getNode());
            }
            this.refresh(context);
            this.saveUserDefined();
            return true;
        }
        if (n == CUT_CMD_ID) {
            this.ACTION = "CUT";
            this.oldName = "";
            this._Buffer = context.getNode();
            this._BufferParent = context;
            return true;
        }
        if (n == PASTE_CMD_ID) {
            if (this._Buffer != null) {
                if (this.ACTION.equals("COPY")) {
                    Boolean bl = true;
                    String string = this._Buffer.getShortLabel();
                    String string2 = "";
                    if (context.getNode() instanceof FolderNode) {
                        Iterator iterator = ((FolderNode)context.getNode()).getChildren();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            if (e instanceof FolderNode) {
                                string2 = ((FolderNode)e).getFolder().getName();
                            } else if (e instanceof ReportNode) {
                                string2 = ((ReportNode)e).getReport().getName();
                            }
                            if (!string2.equals(string)) continue;
                            bl = false;
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Can not paste object name is already used.", (String)"Unable to paste", null);
                            break;
                        }
                        if (bl.booleanValue()) {
                            ((FolderNode)context.getNode()).add((Element)this._Buffer);
                            UpdateMessage.fireChildAdded((Subject)context.getNode(), (Element)this._Buffer);
                        }
                    }
                } else if (this.ACTION.equals("CUT")) {
                    Boolean bl = true;
                    String string = this._Buffer.getShortLabel();
                    String string3 = "";
                    if (context.getNode() instanceof FolderNode) {
                        Object object;
                        Iterator iterator = ((FolderNode)context.getNode()).getChildren();
                        while (iterator.hasNext()) {
                            object = iterator.next();
                            if (object instanceof FolderNode) {
                                string3 = ((FolderNode)object).getFolder().getName();
                            } else if (object instanceof ReportNode) {
                                string3 = ((ReportNode)object).getReport().getName();
                            }
                            if (!string3.equals(string)) continue;
                            bl = false;
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Can not paste object name is already used.", (String)"Unable to paste", null);
                            break;
                        }
                        if (bl.booleanValue()) {
                            try {
                                object = CommandProcessor.createCommand((String)"oracle.ide.cmd.DeleteTNodeCommand", (Context)this._BufferParent);
                                CommandProcessor.getInstance().invoke(object);
                                UpdateMessage.fireChildRemoved((Subject)this._BufferParent.getNode(), (Element)this._Buffer);
                                ((FolderNode)context.getNode()).add((Element)this._Buffer);
                                UpdateMessage.fireChildAdded((Subject)context.getNode(), (Element)this._Buffer);
                            }
                            catch (Exception exception) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            }
                        }
                    }
                }
                this.refresh(context);
                this.saveUserDefined();
                this._Buffer = null;
            }
            return true;
        }
        if (n == DELETE_CMD_ID) {
            this.ACTION = "DELETE";
            this.oldName = "";
            if (context.getNode() instanceof FolderNode) {
                this.deleteFolder(context);
            } else if (context.getNode() instanceof ReportNode) {
                this.deleteReport(context);
            }
            UpdateMessage.fireChildRemoved((Subject)context.getNode(), (Element)context.getNode());
            this.refresh(context);
            this.saveUserDefined();
            return true;
        }
        if (n == EXPORT_CMD_ID) {
            this.ACTION = "EXPORT";
            this.oldName = "";
            this.exportNode(context.getNode());
            return true;
        }
        if (n == IMPORT_CMD_ID) {
            this.ACTION = "IMPORT";
            this.oldName = "";
            this.importToNode(context.getNode());
            return true;
        }
        return false;
    }

    private void importToNode(Node node, URL uRL, String string) {
        ReportXMLUtil reportXMLUtil = new ReportXMLUtil();
        reportXMLUtil.setImport(true);
        try {
            FileInputStream fileInputStream = new FileInputStream(uRL.getFile());
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);
            reportXMLUtil.parseXML((DefaultContainer)node, inputStreamReader, true);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        reportXMLUtil.setImport(false);
        this.saveUserDefined();
    }

    private void importToNode(Node node) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setName("Choose File");
        jFileChooser.setAccessory((JComponent)new FilePanelAcc());
        if (this._file != null) {
            jFileChooser.setSelectedFile(this._file);
        }
        if (jFileChooser.showOpenDialog((Component)Ide.getMainWindow()) == 0) {
            this._file = jFileChooser.getSelectedFile();
            try {
                this.importToNode(node, jFileChooser.getSelectedFile().toURL(), "UTF-8");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            Iterator iterator = node.getChildren();
            while (iterator.hasNext()) {
                UpdateMessage.fireChildAdded((Subject)node, (Element)((Node)iterator.next()));
            }
        }
        this.saveUserDefined();
    }

    private void refresh(Context context) {
        TNode tNode = ExplorerContext.getSingleTNode((Context)context);
        TNode tNode2 = (TNode)tNode.getParent();
        try {
            ((ReportNavigatorWindow)((Object)context.getProperty("Context.VIEW"))).refresh(tNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((ReportNavigatorWindow)((Object)context.getProperty("Context.VIEW"))).refresh(tNode2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveUserDefined() {
        Iterator iterator = RootNode.getInstance().getUserDefined().getChildren();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        while (iterator.hasNext()) {
            arrayList.add((Node)iterator.next());
        }
        Node[] nodeArray = new Node[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nodeArray[i] = (Node)arrayList.get(i);
        }
        this.exportNodes(nodeArray, new File(ReportAddin.USER_REPORT_FILE), null);
    }

    public void exportNode(Node node, File file) {
        Node[] nodeArray = new Node[]{node};
        this.exportNodes(nodeArray, file, null);
    }

    public void exportNodes(Node[] nodeArray, File file, String string) {
        try {
            if (string == null) {
                string = "UTF-8";
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string);
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"" + string + "\" ?>");
            outputStreamWriter.write("<displays>");
            if (nodeArray != null) {
                for (Node node : nodeArray) {
                    if (node instanceof ReportNode) {
                        outputStreamWriter.write(((ReportNode)node).getReport().toXML(0));
                        continue;
                    }
                    if (!(node instanceof FolderNode)) continue;
                    outputStreamWriter.write(((FolderNode)node).toXML(0));
                }
            }
            outputStreamWriter.write("</displays>");
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Unable to open file.\n", (String)"Error", (String)"f1_exportbadfile_html");
        }
    }

    private void exportNode(Node node) {
        String string;
        JFileChooser jFileChooser = new JFileChooser(",");
        JFileChooserFilter jFileChooserFilter = new JFileChooserFilter("XML", ".xml");
        jFileChooser.addChoosableFileFilter((FileFilter)jFileChooserFilter);
        if (_lastUrl == null) {
            string = DBConfig.getInstance().getString("EXPORTDIR") + File.separator;
            if (string == null || string.equals("")) {
                string = System.getProperty("user.home");
            }
            File file = new File(string + "explain.xml");
            jFileChooser.setSelectedFile(file);
        } else {
            jFileChooser.setSelectedFile(_lastUrl);
        }
        if (jFileChooser.showSaveDialog(null) == 0) {
            int n;
            string = jFileChooser.getSelectedFile().toString();
            String string2 = string.substring(n = string.lastIndexOf(File.separator));
            _lastUrl = string2.lastIndexOf(".") > -1 ? jFileChooser.getSelectedFile() : new File(jFileChooser.getSelectedFile().toString() + ".xml");
        }
        if (_lastUrl != null) {
            this.exportNode(node, _lastUrl);
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public void openReport(DisplayModel displayModel, boolean bl, String string) {
        try {
            URL uRL = new URL(RootNode.getInstance().getURL() + "/" + displayModel.getName());
            ReportNode reportNode = new ReportNode(uRL, displayModel);
            this.openReport(reportNode, bl, string);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
        }
    }

    public synchronized void openReport(Context context, boolean bl) {
        this.openReport((ReportNode)context.getNode(), bl, null);
    }

    public void openReport(ReportNode reportNode, boolean bl, String string) {
        Object object;
        Object object22;
        List list;
        boolean bl2 = !ReportAddin.isUserDefinedReport(reportNode.getURL());
        DisplayModel displayModel = reportNode.getReport();
        HashMap hashMap = displayModel.getExtAttributes();
        if (hashMap != null && hashMap.get("requiredLic") != null && ((String)hashMap.get("requiredLic")).equals("diagnostics") && !LicenseUtils.requiresDiag()) {
            return;
        }
        ReportEditor reportEditor = null;
        if (!bl && EditorManager.getEditorManager().getAllEditors().size() > 0) {
            list = EditorManager.getEditorManager().getAllEditors();
            for (Object object22 : list) {
                if (!(object22 instanceof ReportEditor) || ((ReportEditor)((Object)object22)).getPinned()) continue;
                reportEditor = (ReportEditor)((Object)object22);
            }
        }
        list = null;
        if (reportEditor != null) {
            reportEditor.getTimer().setSelectedItem("0");
            object = (ReportEditorNode)reportEditor.getContext().getNode();
            if (string != null && !Connections.getInstance().isOracle(string) && bl2) {
                ReportAddin.showOracleOnlyReportMessage(reportEditor.getGUI());
                return;
            }
            object22 = reportEditor.getConnectionName();
            if (object22 != null && !Connections.getInstance().isOracle((String)object22) && bl2) {
                ReportAddin.showOracleOnlyReportMessage(reportEditor.getGUI());
                return;
            }
            ((ReportEditorNode)((Object)object)).setReportNode(reportNode);
            ((ReportEditorNode)((Object)object)).setViewedObject();
            list = Context.newIdeContext((Node)object);
        } else {
            object = string != null ? string : ConnectionSelectorUI.getConnection((String)ConnectionArb.getString((int)32), (String)ConnectionArb.getString((int)31), null, (boolean)bl2, (boolean)true);
            if (object != null && Connections.getInstance().isConnectionOpen((String)object)) {
                object22 = new ReportEditorNode();
                ((ReportEditorNode)((Object)object22)).setReportNode(reportNode);
                list = Context.newIdeContext((Node)object22);
                list.setProperty("report.conn.name", object);
            }
        }
        if (list != null) {
            object = new OpenEditorOptions((Context)list);
            object.setFlags(1);
            reportEditor = (ReportEditor)EditorManager.getEditorManager().openEditor((OpenEditorOptions)object);
            reportEditor.updateContent();
            reportEditor.toString();
        }
    }

    public static synchronized ReportNavigatorContextMenu getInstance() {
        if (_instance == null) {
            _instance = new ReportNavigatorContextMenu();
        }
        return _instance;
    }

    private int getChildCount(DefaultContainer defaultContainer) {
        int n = 0;
        Iterator iterator = defaultContainer.getChildren();
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    public void deleteFolder(Context context) {
        this._ctx = context;
        PropertyPanel propertyPanel = new PropertyPanel();
        this._node = context.getNode();
        int n = this.getChildCount((DefaultContainer)this._node);
        String string = Translate.translate((String)"Delete Folder Confirmation");
        JLabel jLabel = new JLabel(Translate.translate((String)"You are about to delete folder ") + ((FolderNode)this._node).getFolder().getName() + "\n");
        JLabel jLabel2 = new JLabel();
        if (n > 0) {
            jLabel2 = new JLabel(Translate.translate((String)"This folder contains ") + n + Translate.translate((String)" children.\n"));
        }
        JLabel jLabel3 = new JLabel(Translate.translate((String)"Are you sure?"));
        propertyPanel.addSingleComp((JComponent)jLabel);
        propertyPanel.addSingleComp((JComponent)new JLabel());
        propertyPanel.addSingleComp((JComponent)jLabel2);
        propertyPanel.addSingleComp((JComponent)new JLabel());
        propertyPanel.addSingleComp((JComponent)jLabel3);
        propertyPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)propertyPanel, null, (String)string, (int)10);
        this.dlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportNavigatorContextMenu.this.closeEditors(ReportNavigatorContextMenu.this._node);
                try {
                    Command command = CommandProcessor.createCommand((String)"oracle.ide.cmd.DeleteTNodeCommand", (Context)ReportNavigatorContextMenu.this._ctx);
                    CommandProcessor.getInstance().invoke(command);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                ReportNavigatorContextMenu.this.dlg.dispose();
            }
        });
        Dimension dimension = propertyPanel.getPreferredSize();
        int n2 = (int)dimension.getHeight() + 100;
        int n3 = (int)dimension.getWidth() + 100;
        this.dlg.setSize(n3, n2);
        this.dlg.setPreferredSize(n3, n2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    public void closeEditors(Node node) {
        if (node instanceof ReportNode) {
            List list = EditorManager.getEditorManager().getAllEditors();
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof ReportEditor) || ((ReportEditor)((Object)list.get(i))).getPanel().getModel() != ((ReportNode)node).getReport()) continue;
                ((ReportEditor)((Object)list.get(i))).close();
            }
        } else {
            Iterator iterator = node.getChildren();
            while (iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                this.closeEditors(node2);
            }
        }
    }

    public void deleteReport(Context context) {
        this._ctx = context;
        PropertyPanel propertyPanel = new PropertyPanel();
        this._node = context.getNode();
        String string = Translate.translate((String)"Delete Report Confirmation");
        JLabel jLabel = new JLabel(Translate.translate((String)"You are about to delete report ") + ((ReportNode)this._node).getReport().getName());
        JLabel jLabel2 = new JLabel(Translate.translate((String)"Are you sure?"));
        propertyPanel.addSingleComp((JComponent)jLabel);
        propertyPanel.addSingleComp((JComponent)new JLabel());
        propertyPanel.addSingleComp((JComponent)jLabel2);
        propertyPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)propertyPanel, null, (String)string, (int)10);
        this.dlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportNavigatorContextMenu.this.closeEditors(ReportNavigatorContextMenu.this._node);
                try {
                    Command command = CommandProcessor.createCommand((String)"oracle.ide.cmd.DeleteTNodeCommand", (Context)ReportNavigatorContextMenu.this._ctx);
                    CommandProcessor.getInstance().invoke(command);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                ReportNavigatorContextMenu.this.dlg.dispose();
            }
        });
        Dimension dimension = propertyPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 100;
        this.dlg.setSize(n2, n);
        this.dlg.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    public void reportDialog(DefaultContainer defaultContainer, DefaultContainer defaultContainer2) {
        this.pNode = defaultContainer;
        this.cNode = defaultContainer2;
        String string = Translate.translate((String)"Create Report Dialog");
        if (this.cNode == null) {
            this.rDiag = new ReportWizzard();
            this.rDiag.setPath(defaultContainer.getURL().getPath());
        } else {
            this.rDiag = new ReportWizzard(((ReportNode)this.cNode).getReport());
            this.rDiag.setPath(defaultContainer2.getURL().getPath());
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.rDiag, "f1_userdefinedreport_html");
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this.rDiag, null, (String)string, (int)14);
        this.dlg.setMinimumSize(this.rDiag.getPreferredSize());
        this.dlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ReportNavigatorContextMenu.this.rDiag.getAdvPanel().getTable().getCellEditor() != null) {
                    ReportNavigatorContextMenu.this.rDiag.getAdvPanel().getTable().getCellEditor().stopCellEditing();
                }
                boolean bl = true;
                if (!ReportNavigatorContextMenu.this.rDiag.getModel().getName().equals("")) {
                    Object object;
                    DefaultContainer defaultContainer;
                    Iterator iterator = ReportNavigatorContextMenu.this.pNode.getChildren();
                    while (iterator.hasNext()) {
                        defaultContainer = (DefaultContainer)iterator.next();
                        if (ReportNavigatorContextMenu.this.oldName.equals(defaultContainer.getShortLabel()) || !defaultContainer.getShortLabel().equals(ReportNavigatorContextMenu.this.rDiag.getModel().getName())) continue;
                        object = new PropertyPanel();
                        JLabel jLabel = new JLabel(Translate.translate((String)"Name already used please enter new one."));
                        object.add((Component)jLabel);
                        ReportNavigatorContextMenu.this.dlg2 = OnePageWizardDialogFactory.createJEWTDialog((Component)object, null, (String)Translate.translate((String)"Report Exists"), (int)1);
                        ReportNavigatorContextMenu.this.dlg2.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                ReportNavigatorContextMenu.this.dlg2.dispose();
                            }
                        });
                        ReportNavigatorContextMenu.this.dlg2.pack();
                        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)ReportNavigatorContextMenu.this.dlg2);
                        ReportNavigatorContextMenu.this.dlg2.setVisible(true);
                        bl = false;
                        break;
                    }
                    if (bl) {
                        defaultContainer = ReportNavigatorContextMenu.this.rDiag.getModel();
                        if (defaultContainer.getID() == null) {
                            defaultContainer.setID(GuidGen.toString((byte[])GuidGen.uuidCreate()));
                        }
                        DisplayModelCache.putDisplayModel((DisplayModel)defaultContainer);
                        try {
                            if (ReportNavigatorContextMenu.this.cNode == null) {
                                object = new ReportNode(new URL(ReportNavigatorContextMenu.this.pNode.getURL() + "/" + ReportNavigatorContextMenu.this.rDiag.getModel().getName()), (DisplayModel)defaultContainer);
                                ((ReportNode)object).setEditable(true);
                                ReportNavigatorContextMenu.this.pNode.add((Element)object);
                                UpdateMessage.fireStructureChanged((Subject)ReportNavigatorContextMenu.this.pNode);
                                UpdateMessage.fireObjectRenamed((Subject)ReportNavigatorContextMenu.this.pNode);
                            } else {
                                ReportNavigatorContextMenu.this.cNode.setURL(new URL(ReportNavigatorContextMenu.this.pNode.getURL() + "/" + ReportNavigatorContextMenu.this.rDiag.getModel().getName()));
                                ((ReportNode)ReportNavigatorContextMenu.this.cNode).setReport((DisplayModel)defaultContainer);
                                UpdateMessage.fireStructureChanged((Subject)ReportNavigatorContextMenu.this.cNode);
                                UpdateMessage.fireObjectRenamed((Subject)ReportNavigatorContextMenu.this.cNode);
                            }
                        }
                        catch (MalformedURLException malformedURLException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
                        }
                        ReportNavigatorContextMenu.this.dlg.dispose();
                    }
                } else {
                    PropertyPanel propertyPanel = new PropertyPanel();
                    JLabel jLabel = new JLabel(Translate.translate((String)"Name can not be null."));
                    propertyPanel.add((Component)jLabel);
                    ReportNavigatorContextMenu.this.dlg2 = OnePageWizardDialogFactory.createJEWTDialog((Component)propertyPanel, null, (String)Translate.translate((String)"Invalid Information"), (int)1);
                    ReportNavigatorContextMenu.this.dlg2.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ReportNavigatorContextMenu.this.dlg2.dispose();
                        }
                    });
                    ReportNavigatorContextMenu.this.dlg2.setSize(200, 125);
                    ReportNavigatorContextMenu.this.dlg2.setPreferredSize(200, 125);
                    IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)ReportNavigatorContextMenu.this.dlg2);
                    ReportNavigatorContextMenu.this.dlg2.pack();
                    ReportNavigatorContextMenu.this.dlg2.setVisible(true);
                }
            }
        });
        Dimension dimension = this.rDiag.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 100;
        this.dlg.setSize(n2, n);
        this.dlg.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    public void addNode(Node node, Node node2) {
    }

    public void folderDialog(FolderNode folderNode, FolderNode folderNode2) {
        this.gName = null;
        this.gDesc = null;
        this.gTip = null;
        this.pNode = folderNode;
        this.cNode = folderNode2;
        String string = Translate.translate((String)"Create Folder Dialog");
        PropertyPanel propertyPanel = new PropertyPanel();
        String string2 = new String(Translate.translate((String)"*Name"));
        this.gName = new JTextField();
        this.gName.setColumns(30);
        this.gName.setEditable(true);
        this.gName.setBorder(new LineBorder(Color.black, 1));
        if (folderNode2 != null) {
            string = Translate.translate((String)"Edit Folder Dialog");
            this.gName.setText(folderNode2.getFolder().getName().toString());
        }
        propertyPanel.addComp(string2, (JComponent)this.gName);
        String string3 = new String(Translate.translate((String)"Description"));
        this.gDesc = new JTextField();
        this.gDesc.setColumns(30);
        this.gDesc.setEditable(true);
        this.gDesc.setBorder(new LineBorder(Color.black, 1));
        if (folderNode2 != null) {
            this.gDesc.setText(folderNode2.getFolder().getDescription());
        }
        propertyPanel.addComp(string3, (JComponent)this.gDesc);
        String string4 = new String(Translate.translate((String)"ToolTip"));
        this.gTip = new JTextField();
        this.gTip.setColumns(30);
        this.gTip.setEditable(true);
        this.gTip.setBorder(new LineBorder(Color.black, 1));
        if (folderNode2 != null) {
            this.gTip.setText(folderNode2.getToolTipText());
        }
        propertyPanel.addComp(string4, (JComponent)this.gTip);
        propertyPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        propertyPanel.setSize(propertyPanel.getPreferredSize());
        HelpSystem.getHelpSystem().registerTopic((JComponent)propertyPanel, "f1_userdefinedreportfolder_html");
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)propertyPanel, null, (String)string, (int)14);
        this.dlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                if (!ReportNavigatorContextMenu.this.gName.getText().equals("")) {
                    Object object;
                    Object object2;
                    Iterator iterator = ReportNavigatorContextMenu.this.pNode.getChildren();
                    while (iterator.hasNext()) {
                        object2 = (DefaultContainer)iterator.next();
                        if (ReportNavigatorContextMenu.this.oldName.equals(object2.getShortLabel()) || !object2.getShortLabel().equals(ReportNavigatorContextMenu.this.gName.getText())) continue;
                        object = new PropertyPanel();
                        JLabel jLabel = new JLabel(Translate.translate((String)"Name already used please enter new one."));
                        object.add((Component)jLabel);
                        ReportNavigatorContextMenu.this.dlg2 = OnePageWizardDialogFactory.createJEWTDialog((Component)object, null, (String)Translate.translate((String)"Folder Exists"), (int)1);
                        ReportNavigatorContextMenu.this.dlg2.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                ReportNavigatorContextMenu.this.dlg2.dispose();
                            }
                        });
                        IdeUtil.centerWindow((Container)ReportNavigatorContextMenu.this.dlg, (Component)ReportNavigatorContextMenu.this.dlg2);
                        ReportNavigatorContextMenu.this.dlg2.pack();
                        ReportNavigatorContextMenu.this.dlg2.setVisible(true);
                        bl = false;
                        break;
                    }
                    if (bl) {
                        try {
                            object2 = new Folder(ReportNavigatorContextMenu.this.gName.getText(), ReportNavigatorContextMenu.this.gDesc.getText());
                            ((Folder)object2).settooltip(ReportNavigatorContextMenu.this.gTip.getText());
                            if (ReportNavigatorContextMenu.this.cNode == null) {
                                object = new FolderNode(new URL(ReportNavigatorContextMenu.this.pNode.getURL() + "/" + ReportNavigatorContextMenu.this.gName.getText()), (Folder)object2);
                                ReportNavigatorContextMenu.this.pNode.add((Element)object);
                                UpdateMessage.fireChildAdded((Subject)ReportNavigatorContextMenu.this.pNode, (Element)object);
                            } else {
                                ReportNavigatorContextMenu.this.cNode.setURL(new URL(ReportNavigatorContextMenu.this.pNode.getURL() + "/" + ReportNavigatorContextMenu.this.gName.getText()));
                                ((FolderNode)ReportNavigatorContextMenu.this.cNode).setFolder((Folder)object2);
                                UpdateMessage.fireStructureChanged((Subject)ReportNavigatorContextMenu.this.cNode);
                                UpdateMessage.fireObjectRenamed((Subject)ReportNavigatorContextMenu.this.cNode);
                            }
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                        ReportNavigatorContextMenu.this.dlg.dispose();
                    }
                }
            }
        });
        this.dlg.setSize(450, 200);
        this.dlg.setPreferredSize(450, 200);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    static {
        ADD_FOLDER_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.addFolder");
        ADD_REPORT_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.addReport");
        EDIT_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.edit");
        EXPORT_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.export");
        IMPORT_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.import");
        OPEN_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.open");
        OPEN_NEW_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.opennew");
        COPY_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.copy");
        CUT_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.cut");
        PASTE_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.paste");
        DELETE_CMD_ID = Ide.findOrCreateCmdID((String)"sqlreport.delete");
    }
}

