/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.navigatorV2;

import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.report.addin.RepNav;
import oracle.dbtools.raptor.report.navigatorV2.ReportNavigatorWindow;
import oracle.dbtools.raptor.report.navigatorV2.RootNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Folder;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ideri.navigator.DefaultNavigatorManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public class ReportNavigatorManager
extends DefaultNavigatorManager {
    private static final String REPORT_NAVIGATOR_WINDOW_ID = "ReportNavigatorWindow";
    private static final String RPT_NAV_CMD = "ReportNavigator.SHOW_NAVIGATOR";
    private static final int RPT_NAV_CMD_ID = Ide.findOrCreateCmdID((String)"ReportNavigator.SHOW_NAVIGATOR");

    private static String getNavigatorLabel() {
        return RepNav.getString(RaptorExtensionConstants.isStandAlone() ? 1 : 2);
    }

    protected IdeAction createShowNavigatorAction() {
        return IdeAction.get((int)RPT_NAV_CMD_ID, null, (String)ReportNavigatorManager.getNavigatorLabel(), null, (Integer)new Integer(82), (ResourceBundle)RaptorImage.getInstance(), (String)"report2.png", null, (boolean)true);
    }

    protected NavigatorWindow createNavigatorWindow() {
        return this.createNavigatorWindow((Folder)RootNode.getInstance(), true, RaptorExtensionConstants.isStandAlone() ? 1 : 0);
    }

    protected DefaultNavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        return new ReportNavigatorWindow(context, viewId.getId());
    }

    protected String getDefaultName() {
        return ReportNavigatorManager.getNavigatorLabel();
    }

    protected String getViewCategory() {
        return REPORT_NAVIGATOR_WINDOW_ID;
    }

    public void initialize() {
        super.initialize();
        IdeAction ideAction = this.getShowAction();
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_VIEW_CONNECTION_NAVIGATOR);
        JMenu jMenu = MenuManager.getJMenu((String)"View");
        menubar.add((Component)jMenuItem, jMenu, MenuConstants.SECTION_VIEW_NAVIGATOR);
    }

    protected DockingParam createNavigatorDockingParam() {
        DockingParam dockingParam = new DockingParam();
        NavigatorManager navigatorManager = DatabaseNavigatorManager.getInstance();
        if (navigatorManager.getNavigatorWindow() != null) {
            dockingParam.setTabbedWith((Dockable)navigatorManager.getNavigatorWindow());
        } else {
            ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
            Dockable dockable = null;
            if (explorerManager != null) {
                ViewId viewId = explorerManager.getDefaultViewId();
                dockable = DockStation.getDockStation().findDockable(viewId);
            }
            dockingParam.setPosition(dockable, 2, 0);
            NavigatorManager.setWorkspaceNavigatorManager((NavigatorManager)this);
        }
        return dockingParam;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_databasereports_html");
    }
}

