/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.navigatorV2;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.report.addin.ReportAddin;
import oracle.dbtools.raptor.report.navigatorV2.Folder;
import oracle.dbtools.raptor.report.navigatorV2.FolderNode;
import oracle.dbtools.raptor.report.navigatorV2.ReportXMLUtil;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.util.Resource;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;

public class RootNode
extends DefaultContainer {
    private static RootNode INSTANCE;
    private FolderNode _userReports;
    private FolderNode _sharedReports;
    ReportXMLUtil xmlUtil = new ReportXMLUtil();
    private Attributes m_attributes = new ElementAttributes();
    public static final String ROOTNODE_NAME = "All Reports";
    public static final String USER_DEFINED_REPORTS_NODE_NAME = "User Defined Reports";
    public static final String SHARED_REPORTS_NODE_NAME = "Shared Reports";
    private Logger logger = Logger.getLogger("ReportNavigator");

    public static synchronized RootNode getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RootNode();
        }
        return INSTANCE;
    }

    private RootNode() {
        this.setURL(URLFactory.newURL((String)"sqldev.reports", (String)ROOTNODE_NAME));
    }

    public FolderNode getUserDefined() {
        return this._userReports;
    }

    public FolderNode getSharedDefined() {
        return this._sharedReports;
    }

    public String getShortLabel() {
        return ROOTNODE_NAME;
    }

    public Icon getIcon() {
        return ReportAddin.rootIcon;
    }

    protected void openImpl() {
        final RootNode rootNode = this;
        Runnable runnable = new Runnable(){

            public void run() {
                Closeable closeable;
                String string;
                Object object;
                Iterator<String> iterator;
                try {
                    iterator = new Folder("Data Dictionary Reports", "Data Dictionary Reports");
                    URL object22 = new URL(RootNode.this.getURL().toString() + "/" + "Data Dictionary Reports");
                    object = new FolderNode(object22, (Folder)((Object)iterator));
                    ((FolderNode)object).setEditable(false);
                    RootNode.this.add((Element)object);
                    UpdateMessage.fireChildAdded((Subject)rootNode, (Element)object);
                    RootNode.this.addPackage("oracle.dbtools.raptor.report.reports");
                }
                catch (Exception exception) {
                    RootNode.this.logger.severe("*****\nCould not load System Reports" + exception.getMessage() + "\n*****");
                }
                try {
                    iterator = new Folder(Translate.translate((String)RootNode.USER_DEFINED_REPORTS_NODE_NAME), Translate.translate((String)RootNode.USER_DEFINED_REPORTS_NODE_NAME));
                    URL uRL = new URL(RootNode.this.getURL().toString() + "/" + Translate.translate((String)RootNode.USER_DEFINED_REPORTS_NODE_NAME));
                    RootNode.this._userReports = new FolderNode(uRL, (Folder)((Object)iterator));
                    RootNode.this.add((Element)RootNode.this._userReports);
                    UpdateMessage.fireChildAdded((Subject)rootNode, (Element)RootNode.this._userReports);
                    object = new File(ReportAddin.USER_REPORT_FILE);
                    string = "UTF-8";
                    closeable = new FileInputStream((File)object);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)closeable);
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, string);
                    RootNode.this.xmlUtil.parseXML(RootNode.this._userReports, inputStreamReader, true);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (Exception exception) {
                    RootNode.this.logger.severe("Could not load " + Translate.translate((String)RootNode.USER_DEFINED_REPORTS_NODE_NAME));
                }
                try {
                    if (ReportAddin.getRegisterReport().size() > 0) {
                        iterator = new Folder(Translate.translate((String)RootNode.SHARED_REPORTS_NODE_NAME), Translate.translate((String)RootNode.SHARED_REPORTS_NODE_NAME));
                        URL uRL = new URL(RootNode.this.getURL().toString() + "/" + Translate.translate((String)RootNode.SHARED_REPORTS_NODE_NAME));
                        RootNode.this._sharedReports = new FolderNode(uRL, (Folder)((Object)iterator));
                        RootNode.this._sharedReports.setEditable(false);
                        RootNode.this.add((Element)RootNode.this._sharedReports);
                        UpdateMessage.fireChildAdded((Subject)rootNode, (Element)RootNode.this._sharedReports);
                    }
                    for (URL uRL : ReportAddin.getRegisterReport()) {
                        try {
                            object = uRL.openStream();
                            string = "UTF-8";
                            closeable = new InputStreamReader((InputStream)object, string);
                            RootNode.this.xmlUtil.parseXML(RootNode.this._sharedReports, (InputStreamReader)closeable, false);
                        }
                        catch (Exception exception) {
                            RootNode.this.logger.severe("Could not load Report URL:" + uRL.toString());
                        }
                    }
                }
                catch (Exception exception) {
                    System.err.println("Could not load " + Translate.translate((String)RootNode.SHARED_REPORTS_NODE_NAME));
                }
                for (String string2 : ReportAddin.getRegisterReportPackages()) {
                    try {
                        RootNode.this.addPackage(string2);
                        UpdateMessage.fireStructureChanged((Subject)rootNode);
                    }
                    catch (Exception exception) {
                        RootNode.this.logger.severe("Could not load package file: " + string2);
                    }
                }
                RootNode.this.markDirty(false);
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void addPackage(String string) throws Exception {
        block3: {
            String string2;
            block2: {
                string2 = URLFileSystem.getPath((URL)Resource.getPath((String)(string = string.replaceAll("\\.", "\\/"))));
                if (string2.indexOf(".jar!") <= 0) break block2;
                String string3 = string2.toString().substring(0, string2.toString().indexOf("!"));
                JarFile jarFile = new JarFile(string3, false);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                JarEntry jarEntry = null;
                String string4 = null;
                while (enumeration.hasMoreElements()) {
                    jarEntry = enumeration.nextElement();
                    string4 = jarEntry.getName();
                    if (jarEntry.isDirectory() || !string4.startsWith(string) || !string4.endsWith("xml")) continue;
                    InputStream inputStream = URLFileSystem.openInputStream((URL)Resource.getPath((String)string4));
                    String string5 = "UTF-8";
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string5);
                    this.xmlUtil.parseXML(this, inputStreamReader, false);
                }
                break block3;
            }
            File file = new File(string2);
            if (file == null || !file.exists()) break block3;
            FilenameFilter filenameFilter = new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".xml");
                }
            };
            String string6 = "UTF-8";
            for (File file2 : file.listFiles(filenameFilter)) {
                FileInputStream fileInputStream = new FileInputStream(file2);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string6);
                this.xmlUtil.parseXML(this, inputStreamReader, false);
            }
        }
    }

    public Attributes getAttributes() {
        return this.m_attributes;
    }
}

