/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.wizzard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.raptor.query.Bind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable _table;
    private DefaultTableModel _model;
    private SpringLayout springLayout;

    public BindPanel() {
        this.init();
    }

    public BindPanel(List<Bind> list) {
        this.init();
        for (Bind bind : list) {
            this.addRow(bind.getName(), bind.getPrompt(), bind.getValue(), bind.getTooltip());
        }
    }

    public void setBinds(List<Bind> list) {
        for (Bind bind : list) {
            this.addRow(bind.getName(), bind.getPrompt(), bind.getValue(), bind.getTooltip());
        }
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this._model = new DefaultTableModel();
        this._table = new JTable(this._model);
        this._model.addColumn("Name");
        this._model.addColumn("Prompt");
        this._model.addColumn("Default");
        this._model.addColumn("ToolTip");
        jScrollPane.setViewportView(this._table);
        JButton jButton = new JButton();
        jButton.setText("Add Bind");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BindPanel.this.addRow(null, null, null, null);
            }
        });
        this.add((Component)jButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        JButton jButton2 = new JButton();
        jButton2.setText("Remove Bind");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                while (BindPanel.this._table.getSelectedRowCount() > 0) {
                    BindPanel.this._model.removeRow(BindPanel.this._table.getSelectedRow());
                }
            }
        });
        this.add((Component)jButton2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this._table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                if (BindPanel.this._table.getEditingColumn() > -1 && BindPanel.this._table.getEditingRow() > -1) {
                    BindPanel.this._table.getCellEditor(BindPanel.this._table.getEditingRow(), BindPanel.this._table.getEditingColumn()).stopCellEditing();
                }
            }
        });
    }

    public void addRow(String string, String string2, String string3, String string4) {
        this._model.addRow(new Object[]{string, string2, string3, string4});
    }

    public List<Bind> getBinds() {
        Bind bind = null;
        ArrayList<Bind> arrayList = new ArrayList<Bind>();
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            String string = (String)this._table.getModel().getValueAt(i, 2);
            if (string == null || string.equals("null") || string.equals("")) {
                string = "NULL_VALUE";
            }
            bind = new Bind((String)this._table.getModel().getValueAt(i, 0), null, (String)this._table.getModel().getValueAt(i, 1), string, (String)this._table.getModel().getValueAt(i, 3));
            arrayList.add(bind);
        }
        return arrayList;
    }
}

