/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.wizzard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import oracle.dbtools.raptor.query.Column;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnPanel
extends JPanel {
    private JTable _table;
    private DefaultTableModel _model = new DefaultTableModel();

    public ColumnPanel() {
        this.init();
    }

    public ColumnPanel(List<Column> list) {
        this.init();
        for (Column column : list) {
            this.addRow(column.getName(), column.getFormat(), column.getAlign(), column.getVAlign());
        }
    }

    public void setColumns(List<Column> list) {
        for (Column column : list) {
            this.addRow(column.getName(), column.getFormat(), column.getAlign(), column.getVAlign());
        }
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this._table = new JTable(this._model);
        this._model.addColumn("Name");
        this._model.addColumn("Format");
        this._model.addColumn("hAlign");
        this._model.addColumn("vAlign");
        jScrollPane.setViewportView(this._table);
        JButton jButton = new JButton();
        jButton.setText("Add Column");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColumnPanel.this.addRow(null, null, null, null);
            }
        });
        this.add((Component)jButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        JButton jButton2 = new JButton();
        jButton2.setText("Remove Column");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                while (ColumnPanel.this._table.getSelectedRowCount() > 0) {
                    ColumnPanel.this._model.removeRow(ColumnPanel.this._table.getSelectedRow());
                }
            }
        });
        this.add((Component)jButton2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        int n = 2;
        TableColumn tableColumn = this._table.getColumnModel().getColumn(n);
        tableColumn.setCellEditor(new HorizCellEditor());
        n = 3;
        tableColumn = this._table.getColumnModel().getColumn(n);
        tableColumn.setCellEditor(new VertCellEditor());
    }

    public void addRow(String string, String string2, String string3, String string4) {
        if (string3 == null) {
            string3 = "LEFT";
        }
        if (string4 == null) {
            string4 = "CENTER";
        }
        this._model.addRow(new Object[]{string, string2, string3, string4});
    }

    public List<Column> getColumns() {
        Column column = null;
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            column = new Column((String)this._table.getModel().getValueAt(i, 0), (String)this._table.getModel().getValueAt(i, 2), (String)this._table.getModel().getValueAt(i, 3), (String)this._table.getModel().getValueAt(i, 1));
            arrayList.add(column);
        }
        return arrayList;
    }

    public class HorizCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component = new JComboBox<String>(new DefaultComboBoxModel<String>(new String[]{"LEFT", "RIGHT"}));

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (bl) {
                // empty if block
            }
            ((JComboBox)this.component).getModel().setSelectedItem((String)object);
            return this.component;
        }

        public Object getCellEditorValue() {
            return ((JComboBox)this.component).getModel().getSelectedItem();
        }
    }

    public class VertCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component = new JComboBox<String>(new DefaultComboBoxModel<String>(new String[]{"TOP", "BOTTOM", "CENTER"}));

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (bl) {
                // empty if block
            }
            ((JComboBox)this.component).getModel().setSelectedItem((String)object);
            return this.component;
        }

        public Object getCellEditorValue() {
            return ((JComboBox)this.component).getModel().getSelectedItem();
        }
    }
}

