/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.wizzard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SpringLayout;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.controls.display.DisplayRegistry;
import oracle.dbtools.raptor.controls.display.IDisplayDetail;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.report.wizzard.AdvancedPanel;
import oracle.dbtools.raptor.report.wizzard.BindPanel;
import oracle.dbtools.raptor.report.wizzard.ChildPanel;
import oracle.dbtools.raptor.report.wizzard.ColumnPanel;
import oracle.dbtools.raptor.report.wizzard.MainPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Translate;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.javatools.db.DBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportWizzard
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JSplitPane _sp;
    private CustomTabbedPane _mainTab;
    private CustomTabbedPane _mainSubTab;
    private MainPanel _main = new MainPanel();
    private ColumnPanel _mainCol = new ColumnPanel();
    private BindPanel _mainBind = new BindPanel();
    private AdvancedPanel _advPanel = new AdvancedPanel();
    private CustomTabbedPane _childTab;
    private String _dbName;
    private IDisplayDetail _details = null;
    private DisplayModel _model;
    private DisplayModel _modelHolder;
    private SpringLayout springLayout = new SpringLayout();
    private String _path;

    public ReportWizzard() {
        this.setLayout(this.springLayout);
        this.setPreferredSize(new Dimension(650, 600));
        this.init();
    }

    public ReportWizzard(DisplayModel displayModel) {
        this.setLayout(this.springLayout);
        this.setPreferredSize(new Dimension(650, 600));
        this._model = displayModel;
        this.init();
        this._main.setInfo(displayModel.getName(), displayModel.getDescription(), displayModel.getToolTip(), displayModel.getQuery().getSql(), displayModel.getStyle());
        this._mainCol.setColumns(displayModel.getQuery().getCols());
        this._mainBind.setBinds(displayModel.getQuery().getReportBinds());
        this._advPanel.setModel(displayModel);
        if (displayModel.getChildren() != null) {
            this.addChildren(displayModel.getChildren());
        }
    }

    public void setPath(String string) {
        this._path = string;
    }

    public void init() {
        this._mainTab = new CustomTabbedPane(1);
        this._mainSubTab = new CustomTabbedPane(3);
        this._mainTab.addTab(null, "Master", (Component)this._mainSubTab);
        this._mainSubTab.addTab(null, "Details", (Component)this._main);
        this._mainSubTab.addTab(null, "Columns", (Component)this._mainCol);
        this._mainSubTab.addTab(null, "Binds", (Component)this._mainBind);
        this._mainSubTab.addTab(null, "Advanced", (Component)this._advPanel);
        this._childTab = new CustomTabbedPane(1);
        this._sp = new JSplitPane();
        this._sp.setTopComponent((Component)this._mainTab);
        this._sp.setBottomComponent((Component)this._childTab);
        this._sp.setOrientation(0);
        this._sp.setDividerSize(1);
        this._sp.setDividerLocation(100000);
        this._sp.setOneTouchExpandable(true);
        this._sp.setContinuousLayout(true);
        this.add((Component)this._sp, "Center");
        this.springLayout.putConstraint("South", (Component)this._sp, -20, "South", (Component)this);
        this.springLayout.putConstraint("East", (Component)this._sp, -20, "East", (Component)this);
        this.springLayout.putConstraint("North", (Component)this._sp, 5, "North", (Component)this);
        this.springLayout.putConstraint("West", (Component)this._sp, 5, "West", (Component)this);
        try {
            if (DisplayRegistry.hasDetails((String)this._main.getStyle()).booleanValue()) {
                this._details = DisplayRegistry.getDetailPanel((String)this._main.getStyle());
                if (this._model != null && this._model.getExtValues() != null) {
                    this._details.setValues(this._model.getExtValues());
                }
                this._mainSubTab.addTab(null, this._main.getStyle() + " Details", (Component)((JPanel)this._details));
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        this.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                if (ReportWizzard.this._childTab.getNumberOfTabs() == 0) {
                    ReportWizzard.this._sp.setDividerLocation(60000);
                }
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        this._main.addChildButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTabbedPane customTabbedPane = new CustomTabbedPane(3);
                ChildPanel childPanel = new ChildPanel();
                childPanel.removeButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ReportWizzard.this._childTab.removeSelectedTab();
                        int n = ReportWizzard.this._childTab.getNumberOfTabs();
                        if (n == 0) {
                            ReportWizzard.this._sp.setDividerSize(1);
                            ReportWizzard.this._sp.setDividerLocation(60000);
                            Container container = ReportWizzard.this._sp;
                            while (!(container instanceof JEWTDialog)) {
                                container = ((Component)container).getParent();
                            }
                            ((JEWTDialog)container).setSize(750, 600);
                            ((JEWTDialog)container).setMinimumSize(750, 600);
                        }
                    }
                });
                childPanel._style.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        CustomTabbedPane customTabbedPane = null;
                        ChildPanel childPanel = null;
                        try {
                            Object object = itemEvent.getSource();
                            while (!(object instanceof CustomTabbedPane)) {
                                if ((object = ((Component)object).getParent()) instanceof ChildPanel) {
                                    childPanel = (ChildPanel)object;
                                }
                                if (!(object instanceof CustomTabbedPane)) continue;
                                customTabbedPane = (CustomTabbedPane)object;
                            }
                            if (itemEvent.getStateChange() == 2 && customTabbedPane.getNumberOfTabs() == 3) {
                                customTabbedPane.setSelectedIndex(2);
                                customTabbedPane.removeSelectedTab();
                                customTabbedPane.setSelectedIndex(0);
                            }
                            if (itemEvent.getStateChange() == 1) {
                                IDisplayDetail iDisplayDetail = null;
                                if (DisplayRegistry.hasDetails((String)childPanel.getStyle()).booleanValue()) {
                                    iDisplayDetail = DisplayRegistry.getDetailPanel((String)childPanel.getStyle());
                                    if (ReportWizzard.this._model != null) {
                                        iDisplayDetail.setValues(ReportWizzard.this._model.getExtValues());
                                    }
                                    customTabbedPane.addTab(null, childPanel.getStyle() + " Details", (Component)((JPanel)iDisplayDetail));
                                }
                            }
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    }
                });
                int n = ReportWizzard.this._childTab.getNumberOfTabs();
                customTabbedPane.addTab(null, "Details", (Component)childPanel);
                customTabbedPane.addTab(null, "Columns", (Component)new ColumnPanel());
                ReportWizzard.this._childTab.addTab(null, "Child" + (n + 1), (Component)customTabbedPane);
                if (n == 0) {
                    ReportWizzard.this._sp.setDividerSize(8);
                    ReportWizzard.this._sp.setDividerLocation(320);
                    Container container = ReportWizzard.this._sp;
                    while (!(container instanceof JEWTDialog)) {
                        container = ((Component)container).getParent();
                    }
                    ((JEWTDialog)container).setSize(750, 800);
                    ((JEWTDialog)container).setMinimumSize(750, 800);
                }
            }
        });
        this._main._style.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    if (itemEvent.getStateChange() == 2 && ReportWizzard.this._details != null) {
                        ReportWizzard.this._mainSubTab.setSelectedIndex(4);
                        ReportWizzard.this._mainSubTab.removeSelectedTab();
                        ReportWizzard.this._mainSubTab.setSelectedIndex(0);
                        ReportWizzard.this._details = null;
                    }
                    if (itemEvent.getStateChange() == 1) {
                        if (DisplayRegistry.hasDetails((String)ReportWizzard.this._main.getStyle()).booleanValue()) {
                            ReportWizzard.this._details = DisplayRegistry.getDetailPanel((String)ReportWizzard.this._main.getStyle());
                            if (ReportWizzard.this._model != null && ReportWizzard.this._model.getExtValues() != null) {
                                ReportWizzard.this._details.setValues(ReportWizzard.this._model.getExtValues());
                            }
                            ReportWizzard.this._mainSubTab.addTab(null, ReportWizzard.this._main.getStyle() + " Details", (Component)((JPanel)ReportWizzard.this._details));
                        }
                        ((ReportWizzard)ReportWizzard.this)._main.addChildButton.setEnabled(DisplayRegistry.allowChildren((String)ReportWizzard.this._main.getStyle()));
                        if (!DisplayRegistry.allowChildren((String)ReportWizzard.this._main.getStyle()).booleanValue()) {
                            ReportWizzard.this._childTab.removeAllTabs();
                            ReportWizzard.this._sp.setDividerSize(1);
                            ReportWizzard.this._sp.setDividerLocation(600);
                            Container container = ReportWizzard.this._sp;
                            try {
                                while (!(container instanceof JEWTDialog)) {
                                    container = ((Component)container).getParent();
                                }
                                ((JEWTDialog)container).setSize(750, 600);
                                ((JEWTDialog)container).setMinimumSize(750, 600);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        });
        this._main.testReportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ReportWizzard.this._main.getSql().equals("")) {
                    ReportWizzard.this.showTest(ReportWizzard.this.getModel());
                } else {
                    JPanel jPanel = new JPanel();
                    JLabel jLabel = new JLabel(Translate.translate((String)"You must enter a Sql statement."));
                    jPanel.add(jLabel);
                    Dimension dimension = new Dimension(300, 200);
                    JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)"Report Test Error", (int)2);
                    jEWTDialog.setPreferredSize(dimension);
                    jEWTDialog.setSize(dimension);
                    jEWTDialog.setLocation(500, 500);
                    jEWTDialog.setVisible(true);
                }
            }
        });
        this._advPanel.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }

    public void showTest(DisplayModel displayModel) {
        if (this._dbName == null) {
            this.getNewConn();
        }
        try {
            Connections.getInstance().getConnection(this._dbName);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (this._dbName != null && Connections.getInstance().isConnectionOpen(this._dbName)) {
            displayModel.setConnName(this._dbName);
            DisplayPanel displayPanel = new DisplayPanel(displayModel);
            displayPanel.refresh();
            Dimension dimension = new Dimension(300, 400);
            JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)displayPanel, null, (String)"Report Test", (int)2);
            jEWTDialog.setPreferredSize(dimension);
            jEWTDialog.setSize(dimension);
            jEWTDialog.setLocation(300, 20);
            jEWTDialog.setVisible(true);
        }
    }

    public void addChildren(List<DisplayModel> list) {
        Iterator<DisplayModel> iterator = list.iterator();
        while (iterator.hasNext()) {
            DisplayModel displayModel;
            this._modelHolder = displayModel = iterator.next();
            CustomTabbedPane customTabbedPane = new CustomTabbedPane(3);
            ChildPanel childPanel = new ChildPanel();
            childPanel.removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ReportWizzard.this._childTab.removeSelectedTab();
                    int n = ReportWizzard.this._childTab.getNumberOfTabs();
                    if (n == 0) {
                        ReportWizzard.this._sp.setDividerSize(1);
                        ReportWizzard.this._sp.setDividerLocation(600);
                        Container container = ReportWizzard.this._sp;
                        while (!(container instanceof JEWTDialog)) {
                            container = ((Component)container).getParent();
                        }
                        ((JEWTDialog)container).setSize(600, 600);
                        ((JEWTDialog)container).setMinimumSize(600, 600);
                    }
                }
            });
            int n = this._childTab.getNumberOfTabs();
            customTabbedPane.addTab(null, "Details", (Component)childPanel);
            ColumnPanel columnPanel = new ColumnPanel();
            columnPanel.setColumns(displayModel.getQuery().getCols());
            customTabbedPane.addTab(null, "Columns", (Component)columnPanel);
            this._childTab.addTab(null, "Child" + (n + 1), (Component)customTabbedPane);
            this._sp.setDividerSize(8);
            this._sp.setSize(550, 600);
            this._sp.setDividerLocation(320);
            childPanel._style.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    CustomTabbedPane customTabbedPane = null;
                    ChildPanel childPanel = null;
                    try {
                        Object object = itemEvent.getSource();
                        while (!(object instanceof CustomTabbedPane)) {
                            if ((object = ((Component)object).getParent()) instanceof ChildPanel) {
                                childPanel = (ChildPanel)object;
                            }
                            if (!(object instanceof CustomTabbedPane)) continue;
                            customTabbedPane = (CustomTabbedPane)object;
                        }
                        if (itemEvent.getStateChange() == 2 && customTabbedPane.getNumberOfTabs() == 3) {
                            customTabbedPane.setSelectedIndex(2);
                            customTabbedPane.removeSelectedTab();
                            customTabbedPane.setSelectedIndex(0);
                        }
                        if (itemEvent.getStateChange() == 1) {
                            IDisplayDetail iDisplayDetail = null;
                            if (DisplayRegistry.hasDetails((String)childPanel.getStyle()).booleanValue()) {
                                iDisplayDetail = DisplayRegistry.getDetailPanel((String)childPanel.getStyle());
                                if (ReportWizzard.this._modelHolder != null) {
                                    iDisplayDetail.setValues(ReportWizzard.this._modelHolder.getExtValues());
                                }
                                customTabbedPane.addTab(null, childPanel.getStyle() + " Details", (Component)((JPanel)iDisplayDetail));
                            }
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
            });
            childPanel.setInfo(displayModel.getName(), displayModel.getDescription(), displayModel.getToolTip(), displayModel.getQuery().getSql(), displayModel.getType(), displayModel.getStyle());
        }
    }

    public DisplayModel getModel() {
        Object object;
        Object object2;
        DisplayModel displayModel = new DisplayModel(this._main.getName(), this._main.getDesc(), "true", this._main.getTip());
        displayModel.setStyle(this._main.getStyle());
        displayModel.setID(this._advPanel.getId());
        displayModel.setActions(this._advPanel.getActions());
        displayModel.setPath(this._path);
        Query query = new Query();
        query.setSql(this._main.getSql().replaceAll("\r\n", "\n"));
        query.setBinds(this._mainBind.getBinds());
        query.setCols(this._mainCol.getColumns());
        ArrayList<Query> arrayList = new ArrayList<Query>();
        arrayList.add(query);
        displayModel.setQueries(arrayList);
        DefaultListModel defaultListModel = this._mainTab.getTabModel();
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            object2 = (CustomTabbedPane)((DefaultCustomTabPage)defaultListModel.getElementAt(i)).getUserObject();
            DefaultListModel defaultListModel2 = object2.getTabModel();
            for (int j = 0; j < defaultListModel2.getSize(); ++j) {
                object = ((DefaultCustomTabPage)defaultListModel2.getElementAt(j)).getUserObject();
                if (!(object instanceof IDisplayDetail)) continue;
                displayModel.setExtValues(((IDisplayDetail)object).getValues());
            }
        }
        DefaultListModel defaultListModel3 = this._childTab.getTabModel();
        object2 = new ArrayList();
        for (int i = 0; i < defaultListModel3.getSize(); ++i) {
            CustomTabbedPane customTabbedPane = (CustomTabbedPane)((DefaultCustomTabPage)defaultListModel3.getElementAt(i)).getUserObject();
            object = customTabbedPane.getTabModel();
            DisplayModel displayModel2 = new DisplayModel();
            Query query2 = new Query();
            ArrayList<Query> arrayList2 = new ArrayList<Query>();
            arrayList2.add(query2);
            displayModel2.setQueries(arrayList2);
            for (int j = 0; j < ((DefaultListModel)object).getSize(); ++j) {
                Object object3 = ((DefaultCustomTabPage)((DefaultListModel)object).getElementAt(j)).getUserObject();
                if (object3 instanceof ChildPanel) {
                    displayModel2.setName(((ChildPanel)object3).getName());
                    displayModel2.setDescription(((ChildPanel)object3).getDesc());
                    displayModel2.setToolTip(((ChildPanel)object3).getTip());
                    displayModel2.setEnable(Boolean.valueOf(true));
                    displayModel2.setType(((ChildPanel)object3).getType());
                    displayModel2.setStyle(((ChildPanel)object3).getStyle());
                    displayModel2.getQuery().setSql(((ChildPanel)object3).getSql());
                    continue;
                }
                if (object3 instanceof ColumnPanel) {
                    displayModel2.getQuery().setCols(((ColumnPanel)object3).getColumns());
                    continue;
                }
                if (!(object3 instanceof IDisplayDetail)) continue;
                displayModel2.setExtValues(((IDisplayDetail)object3).getValues());
            }
            ((ArrayList)object2).add(displayModel2);
        }
        displayModel.setChildren((List)object2);
        return displayModel;
    }

    public void getNewConn() {
        this._dbName = ConnectionSelectorUI.getConnection((String)ConnectionArb.getString((int)32), (String)ConnectionArb.getString((int)31), (String)this._dbName, (boolean)true);
        if (this._dbName == null) {
            return;
        }
    }

    public AdvancedPanel getAdvPanel() {
        return this._advPanel;
    }
}

