/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.SQLServer2000CaptureQueries;
import oracle.dbtools.migration.workbench.plugin.SQLServer7CaptureObjectsOnlineCapturer;
import oracle.dbtools.migration.workbench.plugin.SQLServer7OnlineCapturerPrivilegeExtra;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLServer2000CaptureObjectsOnlineCapturer
extends SQLServer7CaptureObjectsOnlineCapturer {
    private static SQLServer2000CaptureQueries s_captureQueries;

    @Override
    protected String getShowUsersInDatabase(String database) {
        return "use [" + database + "] SELECT l.name, u.name, u.uid FROM [" + database + "]..sysusers u, master..syslogins l " + " where l.sid  =* u.sid and u.uid < 16384 and u.uid<>u.gid ";
    }

    @Override
    protected String andExistsTablesOrProcedures(String database) {
        return " and exists (select 1 from [" + database + "]..sysobjects o where ObjectProperty(o.id, " + "'IsMSShipped') = 0 and o.uid=u.uid) ";
    }

    @Override
    protected String getXTypeWhere() {
        return " a2.xtype = 'U' ";
    }

    @Override
    protected String getXTypeWhereInIndex() {
        return " o.xtype = 'U' ";
    }

    @Override
    protected String getForCaptureIndex() {
        return " i.name NOT LIKE '_WA_Sys%' ";
    }

    @Override
    protected String getWhereForStoredPrograms() {
        return " ( a.xtype = 'P' OR a.xtype = 'FN' OR a.xtype = 'TF' OR a.xtype = 'IF') ";
    }

    @Override
    protected void capturePrivileges(Connection sourceConnection, MigrationStorer storer, CaptureContext context, ArrayList<MdGroup> groupAL, MdGroup role, MdUser user) throws SQLException, PersistenceException {
        new SQLServer7OnlineCapturerPrivilegeExtra().capturePrivileges(this.getRepositoryConnection(), this.getStorer(), context, groupAL, role, user, this.m_online);
    }

    @Override
    protected void captureRoleMembership(Connection sourceConnection, MigrationStorer storer, CaptureContext context, ArrayList<MdGroup> groupAL) throws SQLException, PersistenceException {
        new SQLServer7OnlineCapturerPrivilegeExtra().captureRoleMembership(this.getRepositoryConnection(), storer, context, groupAL, this.m_online);
    }

    @Override
    public String getModelName() throws CaptureException {
        return null;
    }

    public SQLServer2000CaptureObjectsOnlineCapturer(MigrationStorer storer, Connection sourceConnection) {
        super(storer, sourceConnection);
        this.m_online = true;
        this.setStorer(storer);
        this.m_repositoryConnection = sourceConnection;
    }

    @Override
    public String getSourceURL() throws CaptureException {
        return "/tmp/sqlserver7";
    }

    @Override
    public void setStorer(MigrationStorer storer) {
        this.m_storer = storer;
    }

    @Override
    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    @Override
    public Connection getRepositoryConnection() {
        return this.m_repositoryConnection;
    }

    @Override
    public void setRepositoryConnection(Connection repositoryConnection) {
        this.m_repositoryConnection = repositoryConnection;
    }
}

