/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.GenerateDSMLFormattedFiles;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.MetadataFileParser;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.ObjectStatusList;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.OracleDatatypeIdentifiers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLServer2000DoOfflineCaptureLoad
implements OracleDatatypeIdentifiers {
    private HashMap<File, ArrayList<File>> _dbXMLMetadataList = new HashMap();
    private HashMap<File, ObjectStatusList> m_dSMLMap = null;
    private String _currentTableName = null;
    private int _currentDbId = 0;
    public String currValue = "";
    private HashMap<String, String[]> m_tableTypes = new HashMap();
    private Connection m_conn = null;

    public SQLServer2000DoOfflineCaptureLoad(Connection inConn) {
        this.m_conn = inConn;
        this.populateTableTypes();
    }

    public void loadSourceModel(HashMap<File, ObjectStatusList> dbs) throws OfflineCaptureException {
        this.m_dSMLMap = dbs;
        Statement stmt = null;
        Connection repConnection = null;
        Object rs = null;
        try {
            repConnection = this.m_conn;
            stmt = repConnection.createStatement();
            GenerateDSMLFormattedFiles dsmlFormattedFiles = new GenerateDSMLFormattedFiles(this.m_dSMLMap);
            this._dbXMLMetadataList = dsmlFormattedFiles.getDSMLFormattedFilesTable();
            File dbFile = this.getDbFile("MASTER");
            if (dbFile == null) {
                throw new OfflineCaptureException(new Exception());
            }
            this._currentDbId = 1;
            this.populateSourceModel(repConnection, dbFile, 1);
            for (File dbFilename : this._dbXMLMetadataList.keySet()) {
                int dbId;
                if (dbFilename.getName().equalsIgnoreCase("MASTER")) continue;
                this._currentDbId = dbId = this.getDbId(repConnection, dbFilename.getName());
                if (dbId == 0) continue;
                this.populateSourceModel(repConnection, dbFilename, dbId);
            }
            this.sourceModelIndexCreate(repConnection);
            repConnection.commit();
        }
        catch (SQLException e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw new OfflineCaptureException((Exception)e);
        }
        catch (Exception e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw new OfflineCaptureException(e);
        }
    }

    private File getDbFile(String dbName) {
        File dbFile = null;
        for (File file : this.m_dSMLMap.keySet()) {
            String nextDbName = file.getName();
            if (!nextDbName.equalsIgnoreCase(dbName)) continue;
            dbFile = file;
            break;
        }
        return dbFile;
    }

    private int getDbId(Connection repConnection, String dbName) throws OfflineCaptureException {
        Statement repStatement = null;
        ResultSet rs = null;
        int dbId = 0;
        try {
            repStatement = repConnection.createStatement();
            String sql = " SELECT DBID FROM SS2K_SYSDATABASES  WHERE UPPER(NAME) = '" + dbName.toUpperCase() + "' ";
            rs = repStatement.executeQuery(sql);
            while (rs.next()) {
                dbId = rs.getInt(1);
            }
            return dbId;
        }
        catch (SQLException e) {
            throw new OfflineCaptureException((Exception)e);
        }
    }

    private void populateSourceModel(Connection repConnection, File dbName, int dbId) throws OfflineCaptureException {
        try {
            ArrayList<File> xMLMetadataFiles = this._dbXMLMetadataList.get(dbName);
            Iterator<File> i$ = xMLMetadataFiles.iterator();
            while (i$.hasNext()) {
                File f;
                File filename = f = i$.next();
                this._currentTableName = GenerateDSMLFormattedFiles.getUnqualifiedName(filename.getName());
                String[] fieldTypes = this.getFieldTypes(this._currentTableName);
                if (fieldTypes == null) continue;
                MetadataFileParser metaParser = new MetadataFileParser(this._currentDbId, SQLServer2000DoOfflineCaptureLoad.fileToURL(filename), this._currentTableName);
                metaParser.createPrepardStatement(repConnection, fieldTypes);
                int numRecordsLoaded = metaParser.loadData();
            }
        }
        catch (Exception excep) {
            throw new OfflineCaptureException(excep);
        }
    }

    private String[] getFieldTypes(String tableName) {
        String[] tableTypes = null;
        for (String nextElement : this.m_tableTypes.keySet()) {
            if (!tableName.equalsIgnoreCase(nextElement)) continue;
            tableTypes = this.m_tableTypes.get(nextElement.toUpperCase());
            break;
        }
        return tableTypes;
    }

    private void populateTableTypes() {
        String[] columnList1 = new String[]{"3", "6", "3", "5", "5", "5", "3", "3", "3", "3", "3", "1", "1", "1", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "1", "3"};
        this.m_tableTypes.put("SS2K_SYSLOGINS", columnList1);
        String[] columnList2 = new String[]{"3", "1", "3", "6", "3", "3", "3", "5", "5", "3", "3", "1", "3"};
        this.m_tableTypes.put("SS2K_SYSDATABASES", columnList2);
        String[] columnList3 = new String[]{"3", "3", "3", "1", "6", "7", "5", "5", "3", "6", "3", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K_SYSUSERS", columnList3);
        String[] columnList4 = new String[]{"3", "3", "3", "3", "3", "3", "6", "6", "6", "6", "6", "6"};
        this.m_tableTypes.put("SS2K_SYSPERMISSIONS", columnList4);
        String[] columnList5 = new String[]{"3", "3", "3", "3", "3", "6", "3"};
        this.m_tableTypes.put("SS2K_SYSPROTECTS", columnList5);
        String[] columnList6 = new String[]{"3", "1", "3", "8", "3", "3", "3", "3", "3", "3", "5", "3", "3", "3", "8", "3", "3", "3", "5", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K_SYSOBJECTS", columnList6);
        String[] columnList7 = new String[]{"3", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "1", "3", "3", "3", "3", "3", "1", "6"};
        this.m_tableTypes.put("SS2K_SYSCOLUMNS", columnList7);
        String[] columnList8 = new String[]{"3", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "1", "3", "3", "1"};
        this.m_tableTypes.put("SS2K_SYSTYPES", columnList8);
        String[] columnList9 = new String[]{"3", "3", "3", "6", "3", "6", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "6", "3", "3", "3", "6", "1", "11", "3", "3"};
        this.m_tableTypes.put("SS2K_SYSINDEXES", columnList9);
        String[] columnList10 = new String[]{"3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K_SYSINDEXKEYS", columnList10);
        String[] columnList11 = new String[]{"3", "3", "3", "3", "3", "3", "6", "6", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K_SYSREFERENCES", columnList11);
        String[] columnList12 = new String[]{"3", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K_SYSCONSTRAINTS", columnList12);
        String[] columnList13 = new String[]{"3", "3", "3", "3", "3", "3", "3", "3", "3", "4"};
        this.m_tableTypes.put("SS2K_SYSCOMMENTS", columnList13);
        String[] columnList14 = new String[]{"3", "3", "3", "3", "3", "3", "3", "3", "1", "1"};
        this.m_tableTypes.put("SS2K_SYSFILES", columnList14);
        String[] columnList15 = new String[]{"3", "3", "3"};
        this.m_tableTypes.put("SS2K_SYSMEMBERS", columnList15);
        String[] columnList16 = new String[]{"3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K_SYSFOREIGNKEYS", columnList16);
        String[] columnList17 = new String[]{"3", "3", "3", "3", "1", "1"};
        this.m_tableTypes.put("SS2K_SYSPROPERTIES", columnList17);
    }

    private static URL fileToURL(File file) {
        String path = file.getAbsolutePath();
        String fSep = System.getProperty("file.separator");
        if (fSep != null && fSep.length() == 1) {
            path = path.replace(fSep.charAt(0), '/');
        }
        if (path.length() > 0 && path.charAt(0) != '/') {
            path = '/' + path;
        }
        try {
            return new URL("file", null, path);
        }
        catch (MalformedURLException e) {
            throw new Error("Unexpected MalformedURLException");
        }
    }

    private void sourceModelIndexCreate(Connection repConn) throws OfflineCaptureException {
        Statement stmt1 = null;
        ArrayList<String> indexStatements = new ArrayList<String>();
        try {
            indexStatements.add("CREATE INDEX SS2K_syslogins_sid on SS2K_syslogins (\"SID\")");
            indexStatements.add("CREATE INDEX SS2K_sysdatabases_db_id on SS2K_sysdatabases (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K_sysdatabases_name on SS2K_sysdatabases (\"NAME\")");
            indexStatements.add("CREATE INDEX SS2K_sysdatabases_dbid on SS2K_sysdatabases (\"DBID\")");
            indexStatements.add("CREATE INDEX SS2K_sysusers_uid on SS2K_sysusers (\"UID\")");
            indexStatements.add("CREATE INDEX SS2K_sysusers_sid on SS2K_sysusers (\"SID\")");
            indexStatements.add("CREATE INDEX SS2K_sysusers_gid on SS2K_sysusers (\"GID\")");
            indexStatements.add("CREATE INDEX SS2K_sysusers_db_id on SS2K_sysusers (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K_permissions_db_id on SS2K_syspermissions (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K_permissions_id on SS2K_syspermissions (\"ID\")");
            indexStatements.add("CREATE INDEX SS2K_sysprotects_db_id on SS2K_sysprotects (DB_ID)");
            indexStatements.add("CREATE INDEX SS2K_sysprotects_id on SS2K_sysprotects (\"ID\")");
            indexStatements.add("CREATE INDEX SS2K_sysprotects_uid on SS2K_sysprotects (\"UID\")");
            indexStatements.add("CREATE INDEX SS2K_sysprotects_action on SS2K_sysprotects (\"ACTION\")");
            indexStatements.add("CREATE INDEX SS2K_sysprotects_protecttype on SS2K_sysprotects (\"PROTECTTYPE\")");
            indexStatements.add("CREATE INDEX SS2K_sysobj_db_id on SS2K_sysobjects (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K_sysobj_id on SS2K_sysobjects (\"ID\")");
            indexStatements.add("CREATE INDEX SS2K_sysobj_name on SS2K_sysobjects (\"NAME\")");
            indexStatements.add("CREATE INDEX SS2K_sysobj_xtype on SS2K_sysobjects (\"XTYPE\")");
            indexStatements.add("CREATE INDEX SS2K_sysobj_uid on SS2K_sysobjects (\"UID\")");
            indexStatements.add("CREATE INDEX SS2K_syscol_id on SS2K_syscolumns (\"ID\")");
            indexStatements.add("CREATE INDEX SS2K_syscol_db_id on SS2K_syscolumns (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K_systypes_xutype on SS2K_systypes (\"XUSERTYPE\")");
            indexStatements.add("CREATE INDEX SS2K_systypes_db_id on SS2K_systypes (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K_systypes_name on SS2K_systypes (\"NAME\")");
            indexStatements.add("CREATE INDEX SS2K_sysindex_db_id on SS2K_sysindexes (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K_sysindex_id on SS2K_sysindexes (\"ID\")");
            indexStatements.add("CREATE INDEX SS2K_sysindex_indid on SS2K_sysindexes (\"INDID\")");
            indexStatements.add("CREATE INDEX SS2K_sysindexkeys_db_id on SS2K_sysindexkeys (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K_sysindexkeys_id on SS2K_sysindexkeys (\"ID\")");
            indexStatements.add("CREATE INDEX SS2K_sysindexkeys_indid on SS2K_sysindexkeys (\"INDID\")");
            indexStatements.add("CREATE INDEX SS2K_sysreferences_rkeyid on SS2K_sysreferences (\"RKEYID\")");
            indexStatements.add("CREATE INDEX SS2K_sysreferences_Fkeyid on SS2K_sysreferences (\"FKEYID\")");
            indexStatements.add("CREATE INDEX SS2K_sysreferences_constid on SS2K_sysreferences (\"CONSTID\")");
            indexStatements.add("CREATE INDEX SS2K_sysreferences_db_id on SS2K_sysreferences (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K_sysconstraints_constid on SS2K_sysconstraints (\"CONSTID\")");
            indexStatements.add("CREATE INDEX SS2K_sysconstraints_db_id on SS2K_sysconstraints (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K_sysconstraints_id on SS2K_sysconstraints (\"ID\")");
            indexStatements.add("CREATE INDEX SS2K_syscomments_dbid on SS2K_syscomments (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K_syscomments_id on SS2K_syscomments (\"ID\")");
            indexStatements.add("CREATE INDEX SS2K_syscomments_colid on SS2K_syscomments (\"COLID\")");
            indexStatements.add("CREATE INDEX SS2K_sysfiles_db_id on SS2K_sysfiles (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K_sysfiles_fileid on SS2K_sysfiles (\"FILEID\")");
            indexStatements.add("CREATE INDEX SS2K_sysmembers_db_id on SS2K_sysmembers (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K_sysmembers_memberuid on SS2K_sysmembers (\"MEMBERUID\")");
            indexStatements.add("CREATE INDEX SS2K_sysmembers_groupuid on SS2K_sysmembers (\"GROUPUID\")");
            indexStatements.add("CREATE INDEX SS2K_sysforeignkeys_db_id on SS2K_sysforeignkeys (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K_sysforeignkeys_constid on SS2K_sysforeignkeys (\"CONSTID\")");
            indexStatements.add("CREATE INDEX SS2K_sysforeignkeys_fkeyid on SS2K_sysforeignkeys (\"FKEYID\")");
            indexStatements.add("CREATE INDEX SS2K_sysforeignkeys_rkeyid on SS2K_sysforeignkeys (\"RKEYID\")");
            stmt1 = repConn.createStatement();
            Iterator i$ = indexStatements.iterator();
            while (i$.hasNext()) {
                String s;
                String sql = s = (String)i$.next();
                try {
                    stmt1.execute(sql);
                }
                catch (SQLException e2) {
                    throw new OfflineCaptureException((Exception)e2);
                }
            }
            stmt1.close();
            indexStatements.clear();
        }
        catch (SQLException e) {
            try {
                if (stmt1 != null) {
                    stmt1.close();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw new OfflineCaptureException((Exception)e);
        }
    }
}

