/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.SQLServer2000CaptureObjectsOfflineCapturer;
import oracle.dbtools.migration.workbench.plugin.SQLServer2000CaptureQueries;
import oracle.dbtools.migration.workbench.plugin.SQLServer2000DoOfflineCaptureLoad;
import oracle.dbtools.migration.workbench.plugin.SQLServer2000OfflineCaptureTables;
import oracle.dbtools.migration.workbench.plugin.SQLServer7OfflineCapturer;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.ObjectStatusList;
import oracle.dbtools.util.Resource;

public class SQLServer2000OfflineCapturer
extends SQLServer7OfflineCapturer {
    protected Connection m_repositoryConnection = null;
    protected MigrationStorer m_storer = null;
    protected SQLServer2000CaptureObjectsOfflineCapturer m_captureObjectsOfflineCapturer = null;
    private String m_modelName;
    private static SQLServer2000CaptureQueries s_captureQueries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String captureInitializeImpl(String inputDirectory, Properties props) throws OfflineCaptureException {
        this.setRepositoryConnection(MigrationAddin.getPersistenceManager().getConn());
        this.m_captureObjectsOfflineCapturer = new SQLServer2000CaptureObjectsOfflineCapturer(this.getStorer(), MigrationAddin.getPersistenceManager().getConn());
        HashMap<File, ObjectStatusList> m_DSMLMap = new HashMap<File, ObjectStatusList>();
        ObjectStatusList objStatusList = null;
        Connection conn = this.getRepositoryConnection();
        Statement stmt = null;
        try {
            String[] createTables;
            SQLServer2000OfflineCaptureTables ss2000;
            try {
                ss2000 = new SQLServer2000OfflineCaptureTables();
                for (String drop : createTables = ss2000.getDropStatements()) {
                    try {
                        stmt = conn.createStatement();
                        stmt.executeUpdate(drop);
                    }
                    catch (SQLException e) {
                    }
                    finally {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException e) {}
                        }
                    }
                }
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
            ss2000 = new SQLServer2000OfflineCaptureTables();
            for (String create : createTables = ss2000.getCreateStatements()) {
                try {
                    stmt = conn.createStatement();
                    stmt.executeUpdate(create);
                }
                catch (SQLException e) {
                    throw new OfflineCaptureException((Exception)e);
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                        }
                    }
                }
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
        }
        File r = new File(inputDirectory);
        String[] first = r.list();
        for (String f : first) {
            String[] second;
            if (!new File(inputDirectory + File.separator + f).isDirectory()) continue;
            File dir = new File(inputDirectory + File.separator + f);
            objStatusList = new ObjectStatusList();
            for (String f2 : second = dir.list()) {
                if (!f2.endsWith(".dat") && !f2.endsWith(".DAT")) continue;
                objStatusList.add(new File(inputDirectory + File.separator + f + File.separator + f2), "Available");
            }
            m_DSMLMap.put(dir, objStatusList);
        }
        SQLServer2000DoOfflineCaptureLoad dsml = new SQLServer2000DoOfflineCaptureLoad(conn);
        try {
            dsml.loadSourceModel(m_DSMLMap);
        }
        catch (Exception e) {
            throw new OfflineCaptureException(e);
        }
        return "SQLServer2000" + inputDirectory;
    }

    public void cleanUp() throws OfflineCaptureException {
        Connection conn = this.getRepositoryConnection();
        Statement stmt = null;
        try {
            SQLServer2000OfflineCaptureTables ss2000 = new SQLServer2000OfflineCaptureTables();
            String[] dropTables = ss2000.getDropStatements();
            stmt = conn.createStatement();
            for (String drop : dropTables) {
                try {
                    stmt = conn.createStatement();
                    stmt.executeUpdate(drop);
                }
                catch (SQLException e) {
                    throw new OfflineCaptureException((Exception)e);
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e) {}
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OfflineCaptureException((Exception)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    public String[] getScriptFiles(int platformCode) throws OfflineCaptureException {
        return null;
    }

    public String[] generateScripts(String outputDirectory, int platformCode) throws OfflineCaptureException {
        this.writeFile(outputDirectory, "sqlserver2000files", "OMWB_OFFLINE_CAPTURE.BAT");
        this.writeFile(outputDirectory, "sqlserver2000files", "SS2K_BCP_SCRIPT.BAT");
        this.writeFile(outputDirectory, "sqlserver2000files", "properties.sql");
        this.writeFile(outputDirectory, "sqlserver2000files", "sqlserver2000.ocp");
        String[] stringArray = new String[]{"OMWB_OFFLINE_CAPTURE.BAT", "sqlserver2000.ocp", "properties.sql", "SS2K_BCP_SCRIPT.BAT"};
        return stringArray;
    }

    public String writeFile(String outputDirectory, String subDir, String fileName) throws OfflineCaptureException {
        InputStream stream = null;
        FilterOutputStream bOutput = null;
        try {
            String retVal;
            stream = new BufferedInputStream(Resource.getResourceAsStream(((Object)((Object)this)).getClass(), (String)(subDir + "/" + fileName)));
            File permanentFile = null;
            permanentFile = new File(outputDirectory + File.separator + fileName);
            if (!permanentFile.exists()) {
                bOutput = new BufferedOutputStream(new FileOutputStream(permanentFile));
                byte[] b = new byte[10000];
                int v = 0;
                while ((v = stream.read(b)) > -1) {
                    ((BufferedOutputStream)bOutput).write(b, 0, v);
                }
                ((BufferedOutputStream)bOutput).flush();
                stream.close();
            }
            String string = retVal = permanentFile.getPath();
            return string;
        }
        catch (FileNotFoundException e) {
            throw new OfflineCaptureException((Exception)e);
        }
        catch (IOException e) {
            throw new OfflineCaptureException((Exception)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
            if (bOutput != null) {
                try {
                    bOutput.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public SQLServer2000OfflineCapturer(MigrationStorer storer, Connection sourceConnection) {
        super(storer, sourceConnection);
    }

    public void captureObjects(String objType, CaptureContext context, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        this.m_captureObjectsOfflineCapturer.captureObjects(objType, context, filter);
    }

    public String getModelName() throws CaptureException {
        return "SQLServer2000";
    }

    public String getSourceURL() throws CaptureException {
        return "/tmp/sqlserver2000";
    }

    public void setStorer(MigrationStorer storer) {
        this.m_storer = storer;
    }

    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    public Connection getRepositoryConnection() {
        return this.m_repositoryConnection;
    }

    public void setRepositoryConnection(Connection repositoryConnection) {
        this.m_repositoryConnection = repositoryConnection;
    }
}

