/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPluginPreferences;
import oracle.dbtools.migration.workbench.plugin.SQLServer2000DbProvider;
import oracle.dbtools.migration.workbench.plugin.SQLServer2000OfflineCapturer;
import oracle.dbtools.migration.workbench.plugin.SQLServer7Plugin;

public class SQLServer2000Plugin
extends SQLServer7Plugin {
    public String getVersionNumber() {
        return "8.0.0";
    }

    public String getPublishedVersion() {
        return "2000";
    }

    public ThirdPartyDbProvider getProvider(String url) throws MigrationPluginException {
        try {
            SQLServer2000Plugin.loadDriver();
            Connection conn = DriverManager.getConnection(url);
            return new SQLServer2000DbProvider(conn);
        }
        catch (SQLException sqlex) {
            throw new MigrationPluginException((Throwable)sqlex);
        }
    }

    public ThirdPartyDbProvider getProvider(String url, Properties info) throws MigrationPluginException {
        SQLServer2000Plugin.loadDriver();
        try {
            SQLServer2000Plugin.loadDriver();
            Connection conn = DriverManager.getConnection(url, info);
            return new SQLServer2000DbProvider(conn);
        }
        catch (SQLException sqlex) {
            throw new MigrationPluginException((Throwable)sqlex);
        }
    }

    public ThirdPartyDbProvider getProvider(Connection conn) throws MigrationPluginException {
        return new SQLServer2000DbProvider(conn);
    }

    public ThirdPartyDbProvider getProvider(String url, String user, String password) throws MigrationPluginException {
        try {
            SQLServer2000Plugin.loadDriver();
            Connection conn = DriverManager.getConnection(url, user, password);
            return new SQLServer2000DbProvider(conn);
        }
        catch (SQLException sqlex) {
            throw new MigrationPluginException((Throwable)sqlex);
        }
    }

    protected static void loadDriver() throws MigrationPluginException {
        if (!s_driverLoaded) {
            try {
                Class.forName("net.sourceforge.jtds.jdbc.Driver").newInstance();
                s_driverLoaded = true;
            }
            catch (ClassNotFoundException cnfe) {
                throw new MigrationPluginException((Throwable)cnfe);
            }
            catch (InstantiationException ie) {
                throw new MigrationPluginException((Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                throw new MigrationPluginException((Throwable)iae);
            }
        }
    }

    public MigrationPluginPreferences getPreferencePanel() {
        return null;
    }

    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String platform, int major, int minor, String productversion) {
        if (platform.equals(this.getPlatformName()) && major == 8) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
    }

    public int getPlatformMask() {
        return 32;
    }

    public OfflineCapturer getOfflineCapturer() {
        return new SQLServer2000OfflineCapturer(null, null);
    }
}

