/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.metadata.persistence.PrepareClobHelper;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.core.MigrationContext;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.plugin.SQLServer2005Arb;
import oracle.dbtools.migration.workbench.plugin.SQLServer2005CaptureQueries;
import oracle.dbtools.migration.workbench.plugin.SQLServer7CapturerColumnInfo;
import oracle.dbtools.migration.workbench.plugin.SQLServer7CapturerColumnsBySelect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQLServer2005AbstractCapturer {
    protected Connection m_repositoryConnection = null;
    protected MigrationStorer m_storer = null;
    public static final String MY_LANGUAGE_ID = "MSTSQL";
    public static final String NEWID_FUNCTION = "(newid())";
    private static String[] s_sqlServerDatabasesToSkip = new String[]{"master", "msdb", "tempdb", "model"};
    private static String s_sqlServerDatabaseToUse = null;
    private static SQLServer2005CaptureQueries s_captureQueries;
    private boolean m_privilegeWarningWritten = false;
    private static int s_chunkSize;
    protected boolean m_online = true;

    public SQLServer2005AbstractCapturer(MigrationStorer storer, Connection sourceConnection) {
    }

    public static String getSqlServerDatabaseToUse() {
        return s_sqlServerDatabaseToUse;
    }

    public static void setSqlServerDatabaseToUse(String inDatabase) {
        s_sqlServerDatabaseToUse = inDatabase;
    }

    protected String getXTypeWhere() {
        return " a2.type IN ('U', 'V', 'U ', 'V ') ";
    }

    protected String getXTypeWhereInIndex() {
        return " o.type IN ('U', 'V', 'U ', 'V ')  ";
    }

    protected String getForCaptureIndex() {
        return " i.name NOT LIKE '_WA_Sys%' ";
    }

    protected String getWhereForStoredPrograms() {
        return " ( a.type = 'P' OR a.type = 'FN' OR a.type = 'TF' OR a.type = 'IF') ";
    }

    public CaptureQueries getCaptureQueries() {
        if (s_captureQueries == null) {
            s_captureQueries = new SQLServer2005CaptureQueries();
        }
        return s_captureQueries;
    }

    protected abstract String andExistsTablesOrProcedures();

    protected abstract String getDatabasesString();

    protected abstract String getSchemasString(String var1);

    protected abstract String getSchemaOwnerString(String var1);

    protected abstract String getSchemaString(String var1);

    protected abstract String getTablesString(String var1);

    protected abstract String getColumnsString(String var1, int var2);

    protected abstract String getIdentityString(String var1, int var2, int var3);

    protected abstract String getBaseTypeString(String var1, int var2);

    protected abstract String getColumnDefaultString(String var1, int var2);

    protected abstract String getCaptureIndexString(String var1);

    protected abstract String getIndexString(String var1, int var2, int var3);

    protected abstract String captureUniqueAndPrimaryKeysString(String var1);

    protected abstract String captureForeignKeysStringString(String var1);

    protected abstract String captureTableLevelCheckConstraintString(String var1);

    protected abstract String captureColumnLevelCheckConstraintString(String var1);

    protected abstract String captureRulesString(String var1);

    protected abstract String captureRulesTextString(String var1);

    protected abstract String captureViewOuterString(String var1);

    protected abstract String captureViewInnerString(String var1);

    protected abstract String captureStoredProgramOuterString(String var1);

    protected abstract String captureStoredProgramInnerString(String var1, String var2);

    protected abstract String captureTriggersString(String var1);

    protected abstract String captureCommentsString();

    protected abstract String captureRolesString(String var1);

    protected abstract void capturePrivileges(Connection var1, MigrationStorer var2, CaptureContext var3, ArrayList<MdGroup> var4, MdGroup var5, MdUser var6) throws SQLException, PersistenceException;

    protected abstract void captureRoleMembership(Connection var1, MigrationStorer var2, CaptureContext var3, ArrayList<MdGroup> var4) throws SQLException, PersistenceException;

    public void captureObjects(String objType, CaptureContext context, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        try {
            int noop = 0;
            if (objType.equals("MD_CATALOGS")) {
                this.captureCatalog(context, filter);
            } else if (objType.equals("MD_SCHEMAS")) {
                this.captureSchema(context, filter);
            } else if (objType.equals("MD_USERS")) {
                this.captureUser(context, filter);
            } else if (objType.equals("MD_TABLES")) {
                this.captureTable(context, filter);
            } else if (objType.equals("MD_COLUMNS")) {
                ++noop;
            } else if (objType.equals("MD_INDEXES")) {
                this.captureIndex(context);
            } else if (objType.equals("MD_INDEX_DETAILS")) {
                ++noop;
            } else if (objType.equals("MD_CONSTRAINTS")) {
                this.captureUniqueAndPrimaryKeys(context);
                this.captureForeignKeys(context);
                this.captureTableLevelCheckConstraint(context);
                this.captureColumnLevelCheckConstraint(context);
                this.captureRules(context);
            } else if (objType.equals("MD_CONSTRAINT_DETAILS")) {
                ++noop;
            } else if (objType.equals("MD_VIEWS")) {
                this.captureView(context, filter);
            } else if (objType.equals("MD_STORED_PROGRAMS")) {
                this.captureStoredProgram(context, filter);
            } else if (objType.equals("MD_TRIGGERS")) {
                this.captureTriggers(context);
            } else if (objType.equals("MD_GROUPS")) {
                this.captureRoles(context, filter);
            }
        }
        catch (SQLException e) {
            throw new CaptureException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureCatalog(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        this.m_privilegeWarningWritten = false;
        Statement stmt = null;
        ResultSet rs = null;
        SQLServer7CapturerColumnsBySelect.clearHashSet();
        try {
            String query = this.getDatabasesString();
            HashSet<String> nameFilter = null;
            if (filter != null && !filter.getObjectType().equals("MD_CATALOGS")) {
                throw new IllegalArgumentException("Filter is of incorrect type " + filter.getObjectType());
            }
            if (filter != null && filter.getFilterType() == 2) {
                query = query + " and d.name " + filter.getWhereClause();
            }
            if (filter != null && filter.getFilterType() == 1) {
                nameFilter = new HashSet<String>();
                for (String name : filter.getObjectNames()) {
                    nameFilter.add(name);
                }
            }
            DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
            stmt = this.getRepositoryConnection().createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String databaseName;
                String sourceDatabase = null;
                sourceDatabase = rs.getString(1);
                boolean match = false;
                if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(databaseName = sourceDatabase)) {
                    match = true;
                }
                for (String dbToSkip : s_sqlServerDatabasesToSkip) {
                    if (!sourceDatabase.toLowerCase().equals(dbToSkip)) continue;
                    match = true;
                    break;
                }
                if (SQLServer2005AbstractCapturer.getSqlServerDatabaseToUse() != null && !sourceDatabase.toLowerCase().equals(SQLServer2005AbstractCapturer.getSqlServerDatabaseToUse().toLowerCase())) {
                    match = true;
                }
                if (match) continue;
                MdCatalog catalog = new MdCatalog(connectionId);
                catalog.setCatalogName(sourceDatabase);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)142), catalog.getCatalogName());
                context.getAudience().fireListeners(event);
                catalog = (MdCatalog)this.getStorer().storeObject((PersistableObject)catalog);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(stmt, rs);
            throw throwable;
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void captureSchema(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        PreparedStatement stmtInner = null;
        ResultSet rsInner = null;
        MdCatalog catalog = (MdCatalog)context.getContextVariable("CATALOG");
        try {
            String sourceDatabase = catalog.getCatalogName();
            String query = this.getSchemasString(sourceDatabase);
            HashSet<String> nameFilter = null;
            if (filter != null && !filter.getObjectType().equals("MD_SCHEMAS")) {
                throw new IllegalArgumentException("Filter is of incorrect type " + filter.getObjectType());
            }
            if (filter != null && filter.getFilterType() == 2) {
                query = query + " and s.name " + filter.getWhereClause();
            }
            if (filter != null && filter.getFilterType() == 1) {
                nameFilter = new HashSet<String>();
                for (String name : filter.getObjectNames()) {
                    nameFilter.add(name);
                }
            }
            stmtInner = this.getRepositoryConnection().prepareStatement(query);
            if (!this.m_online) {
                stmtInner.setString(1, this.getDatabase((MigrationContext)context));
            }
            rsInner = stmtInner.executeQuery();
            while (rsInner.next()) {
                String schema = rsInner.getString(1);
                boolean match = true;
                if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(schema)) {
                    match = false;
                }
                if (!match) continue;
                MdSchema migrSchema = new MdSchema(catalog.getKey());
                migrSchema.setName(schema);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)141), schema);
                context.getAudience().fireListeners(event);
                migrSchema = (MdSchema)this.getStorer().storeObject((PersistableObject)migrSchema);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
        }
        catch (SQLException e) {
            CloseableResultSet.close(stmtInner, rsInner);
            catch (Throwable throwable) {
                CloseableResultSet.close(stmtInner, rsInner);
                throw throwable;
            }
        }
        CloseableResultSet.close((Statement)stmtInner, (ResultSet)rsInner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureUser(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        MdCatalog catalog = (MdCatalog)context.getContextVariable("CATALOG");
        MdSchema schema = (MdSchema)context.getContextVariable("SCHEMAOBJ");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sourceDatabase = catalog.getCatalogName();
        String schemaOwner = "";
        String ownerQuery = this.getSchemaOwnerString(sourceDatabase);
        try {
            stmt = this.getRepositoryConnection().prepareStatement(ownerQuery);
            if (!this.m_online) {
                stmt.setString(1, this.getDatabase((MigrationContext)context));
                stmt.setString(2, schema.getName());
            } else {
                stmt.setString(1, schema.getName());
            }
            rs = stmt.executeQuery();
            if (rs.next()) {
                schemaOwner = rs.getString(1);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close((Statement)stmt, rs);
            throw throwable;
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
        try {
            String query = this.getSchemaString(sourceDatabase);
            HashSet<String> nameFilter = null;
            if (filter != null && !filter.getObjectType().equals("MD_USERS")) {
                throw new IllegalArgumentException("Filter is of incorrect type " + filter.getObjectType());
            }
            if (filter != null && filter.getFilterType() == 2) {
                query = query + " AND d.name " + filter.getWhereClause();
            }
            if (filter != null && filter.getFilterType() == 1) {
                nameFilter = new HashSet<String>();
                for (String name : filter.getObjectNames()) {
                    nameFilter.add(name);
                }
            }
            stmt = this.getRepositoryConnection().prepareStatement(query);
            if (!this.m_online) {
                stmt.setString(1, this.getDatabase((MigrationContext)context));
                stmt.setString(2, schema.getName());
            } else {
                stmt.setString(1, schema.getName());
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                String userString = rs.getString(1);
                boolean match = true;
                if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(userString)) {
                    match = false;
                }
                if (!match) continue;
                MdUser migrUser = new MdUser(schema.getKey(), userString);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)144), userString);
                context.getAudience().fireListeners(event);
                AdditionalProperty newProp = new AdditionalProperty("Login", rs.getString(2));
                migrUser.addProperty(newProp, catalog.getConnectionId());
                if (userString.equals(schemaOwner)) {
                    migrUser = (MdUser)this.getStorer().storeObject((PersistableObject)migrUser);
                    AdditionalProperty newProp2 = new AdditionalProperty("Schema Owner", migrUser.getKey().toString());
                    schema.addProperty(newProp2, catalog.getConnectionId());
                    schema = (MdSchema)this.getStorer().storeObject((PersistableObject)schema);
                }
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
        }
        finally {
            CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
        }
    }

    protected void captureTable(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        MdSchema schema = null;
        schema = (MdSchema)context.getContextVariable("SCHEMAOBJ");
        this.mapTable(schema, context, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mapTable(MdSchema schema, CaptureContext context, MigrationObjectFilter filter) throws SQLException {
        block58: {
            DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
            String database = this.getDatabase((MigrationContext)context);
            PreparedStatement stmt = null;
            PreparedStatement stmtOuter = null;
            ResultSet rsOuter = null;
            ResultSet rs = null;
            try {
                String query = this.getTablesString(database);
                HashSet<String> nameFilter = null;
                if (filter != null && !filter.getObjectType().equals("MD_TABLES")) {
                    throw new IllegalArgumentException("Filter is of incorrect type " + filter.getObjectType());
                }
                if (filter != null && filter.getFilterType() == 2) {
                    query = query + " and a.name " + filter.getWhereClause();
                }
                if (filter != null && filter.getFilterType() == 1) {
                    nameFilter = new HashSet<String>();
                    for (String name : filter.getObjectNames()) {
                        nameFilter.add(name);
                    }
                }
                stmtOuter = this.getRepositoryConnection().prepareStatement(query);
                if (!this.m_online) {
                    stmtOuter.setString(1, database);
                    stmtOuter.setString(2, schema.getName());
                } else {
                    stmtOuter.setString(1, schema.getName());
                }
                String tableName = "";
                int tableId = 0;
                rsOuter = stmtOuter.executeQuery();
                while (rsOuter.next()) {
                    tableName = rsOuter.getString(1);
                    boolean match = true;
                    if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(tableName)) {
                        match = false;
                    }
                    if (!match) continue;
                    tableId = rsOuter.getInt(2);
                    int order = 1;
                    int userType = 0;
                    int columnTypeNumber = 0;
                    int columnDefaultId = 0;
                    rs = null;
                    try {
                        boolean columnsFound = false;
                        String sql = this.getColumnsString(database, tableId);
                        stmt = this.getRepositoryConnection().prepareStatement(sql);
                        if (!this.m_online) {
                            stmt.setString(1, database);
                        }
                        rs = stmt.executeQuery();
                        MdTable table = null;
                        Hashtable<Integer, MdColumn> columnHt = new Hashtable<Integer, MdColumn>();
                        int columnNum = 0;
                        while (rs.next()) {
                            String colType;
                            boolean identityFound;
                            boolean lastValueIsNull;
                            long lastValue;
                            boolean incrementIsNull;
                            long increment;
                            boolean seedValueIsNull;
                            long seedValue;
                            ResultSet iRs;
                            PreparedStatement iStmt;
                            block57: {
                                ++columnNum;
                                if (!columnsFound) {
                                    String qualifiedName = "[" + database + "].[" + schema.getName() + "].[" + tableName + "]";
                                    table = new MdTable(schema.getKey(), tableName, qualifiedName);
                                    try {
                                        String comment_sql = this.captureCommentsString();
                                        PreparedStatement comment_stmt = this.getRepositoryConnection().prepareStatement(comment_sql);
                                        comment_stmt.setInt(1, tableId);
                                        comment_stmt.setInt(2, 0);
                                        ResultSet comment_rs = comment_stmt.executeQuery();
                                        comment_rs.next();
                                        String tableComment = comment_rs.getString(1);
                                        comment_rs.close();
                                        comment_stmt.close();
                                        table.setComments(tableComment);
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)138), tableName);
                                    context.getAudience().fireListeners(event);
                                    table = (MdTable)this.getStorer().storeObject((PersistableObject)table);
                                    event.setEventId(4);
                                    context.getAudience().fireListeners(event);
                                }
                                columnsFound = true;
                                String identitySql = this.getIdentityString(database, tableId, rs.getInt(4));
                                iStmt = null;
                                iRs = null;
                                seedValue = 0L;
                                seedValueIsNull = false;
                                increment = 0L;
                                incrementIsNull = false;
                                lastValue = 0L;
                                lastValueIsNull = false;
                                identityFound = false;
                                try {
                                    iStmt = this.getRepositoryConnection().prepareStatement(identitySql);
                                    if (!this.m_online) {
                                        iStmt.setString(1, database);
                                    }
                                    if (!(iRs = iStmt.executeQuery()).next()) break block57;
                                    identityFound = true;
                                    seedValue = iRs.getLong(1);
                                    seedValueIsNull = iRs.wasNull();
                                    increment = iRs.getLong(2);
                                    incrementIsNull = iRs.wasNull();
                                    lastValue = iRs.getLong(3);
                                    lastValueIsNull = iRs.wasNull();
                                }
                                catch (SQLException e) {
                                    try {
                                        MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
                                    }
                                    catch (Throwable throwable) {
                                        CloseableResultSet.close((Statement)iStmt, iRs);
                                        throw throwable;
                                    }
                                    CloseableResultSet.close((Statement)iStmt, (ResultSet)iRs);
                                }
                            }
                            CloseableResultSet.close((Statement)iStmt, (ResultSet)iRs);
                            SQLServer7CapturerColumnInfo column = new SQLServer7CapturerColumnInfo();
                            tableName = rs.getString(1);
                            String origColType = colType = rs.getString(5);
                            column.setNativeColumnName(rs.getString(3));
                            column.setNativeColumnType(colType);
                            int nativeLen = rs.getInt(6);
                            boolean lengthIsNull = rs.wasNull();
                            if (lengthIsNull) {
                                column.setNativeColumnLength(null);
                            } else {
                                column.setNativeColumnLength(nativeLen);
                            }
                            int scale = rs.getInt(8);
                            if (rs.wasNull()) {
                                column.setNativeColumnScale(null);
                            } else {
                                column.setNativeColumnScale(scale);
                            }
                            if (rs.getInt(9) == 0) {
                                column.setStatus(0);
                            } else {
                                column.setStatus(rs.getInt(9));
                            }
                            int precision = rs.getInt(7);
                            boolean precisionWasNull = rs.wasNull();
                            userType = rs.getInt(10);
                            columnTypeNumber = rs.getInt(11);
                            columnDefaultId = rs.getInt(12);
                            String baseType = this.baseType(columnTypeNumber, database);
                            column.setColumnDefaultText(this.columnDefault(columnDefaultId, database, baseType));
                            boolean precisionSet = false;
                            if (userType > 256) {
                                if (this.baseTypeIsNotHandled(baseType)) {
                                    Logger.getLogger("oracle.dbtools.migration").warning(SQLServer2005Arb.format(0, "[" + database + "].[" + schema.getName() + "].[" + tableName + "]", column.getNativeColumnName()));
                                    baseType = "varbinary";
                                    column.setStatus(1);
                                    column.setNativeColumnPrecision(8000);
                                    precisionSet = true;
                                }
                                column.setNativeColumnType(baseType);
                            }
                            if (!precisionSet) {
                                colType = column.getNativeColumnType();
                                if (colType.equalsIgnoreCase("varchar") || colType.equalsIgnoreCase("nvarchar") || colType.equalsIgnoreCase("nchar") || colType.equalsIgnoreCase("char") || colType.equalsIgnoreCase("varbinary") || colType.equalsIgnoreCase("binary")) {
                                    if (lengthIsNull) {
                                        column.setNativeColumnPrecision(null);
                                    } else {
                                        column.setNativeColumnPrecision(nativeLen);
                                    }
                                } else if (precisionWasNull) {
                                    column.setNativeColumnPrecision(null);
                                } else {
                                    column.setNativeColumnPrecision(precision);
                                }
                            }
                            Integer[] threeInt = SQLServer7CapturerColumnsBySelect.getPrecisionScaleIdentity(column.getNativeColumnType(), column.getNativeColumnPrecision(), column.getNativeColumnScale());
                            column.setNativeColumnPrecision(threeInt[0]);
                            column.setNativeColumnScale(threeInt[1]);
                            MdColumn migrColumn = null;
                            if (identityFound) {
                                if (!(seedValueIsNull || incrementIsNull || lastValueIsNull)) {
                                    migrColumn = new MdIdentityColumn(table.getKey(), column.getNativeColumnName(), Integer.valueOf(columnNum), seedValue, increment, lastValue, connectionId);
                                } else if (!seedValueIsNull && !incrementIsNull) {
                                    migrColumn = new MdIdentityColumn(table.getKey(), column.getNativeColumnName(), Integer.valueOf(columnNum), seedValue, increment, connectionId);
                                } else {
                                    if (seedValueIsNull) {
                                        // empty if block
                                    }
                                    migrColumn = new MdIdentityColumn(table.getKey(), column.getNativeColumnName(), Integer.valueOf(columnNum), seedValue, connectionId);
                                }
                            } else {
                                migrColumn = new MdColumn(table.getKey(), column.getNativeColumnName(), Integer.valueOf(order));
                            }
                            migrColumn.setColumnType(column.getNativeColumnType());
                            migrColumn.setDefaultValue(column.getColumnDefaultText());
                            if (column.getColumnDefaultText().equalsIgnoreCase(NEWID_FUNCTION)) {
                                migrColumn.addProperty(NEWID_FUNCTION, "Y", connectionId);
                            }
                            if (column.getStatus() == 0) {
                                migrColumn.setNullable("N");
                            } else {
                                migrColumn.setNullable("Y");
                            }
                            String lowerNativeColumnType = column.getNativeColumnType().toLowerCase();
                            if (column.getNativeColumnPrecision() != null && column.getNativeColumnPrecision() == -1 && (lowerNativeColumnType.equals("varchar") || lowerNativeColumnType.equals("nvarchar") || lowerNativeColumnType.equals("varbinary"))) {
                                migrColumn.setPrecision(Integer.valueOf(-999));
                            } else {
                                migrColumn.setPrecision(column.getNativeColumnPrecision());
                            }
                            migrColumn.setScale(column.getNativeColumnScale());
                            try {
                                String comment_sql = this.captureCommentsString();
                                PreparedStatement comment_stmt = this.getRepositoryConnection().prepareStatement(comment_sql);
                                comment_stmt.setInt(1, tableId);
                                comment_stmt.setInt(2, columnNum);
                                ResultSet comment_rs = comment_stmt.executeQuery();
                                comment_rs.next();
                                String columnComment = comment_rs.getString(1);
                                comment_rs.close();
                                comment_stmt.close();
                                migrColumn.setComments(columnComment);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            columnHt.put(new Integer(columnNum), migrColumn);
                            if (userType > 256) {
                                SQLServer7CapturerColumnsBySelect.registerUserDefinedType(this.getStorer(), origColType, schema, column, migrColumn);
                            }
                            ++order;
                        }
                        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
                        if (this.m_online) {
                            this.m_privilegeWarningWritten = SQLServer7CapturerColumnsBySelect.saveColumns(columnHt, "[" + database + "].[" + schema.getName() + "].[" + tableName + "]", this.getRepositoryConnection(), this.getStorer(), table, connectionId, context, database, schema.getName(), tableName, this.m_privilegeWarningWritten);
                            continue;
                        }
                        for (int i = 1; i <= columnHt.size(); ++i) {
                            MdColumn migrColumn = (MdColumn)columnHt.get(new Integer(i));
                            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)134), migrColumn.getColumnName());
                            context.getAudience().fireListeners(event);
                            migrColumn = (MdColumn)this.getStorer().storeObject((PersistableObject)migrColumn);
                            event.setEventId(4);
                            context.getAudience().fireListeners(event);
                        }
                    }
                    catch (SQLException e) {
                        MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
                        CloseableResultSet.close(stmt, rs);
                    }
                }
                CloseableResultSet.close(stmt, rs);
            }
            catch (Exception e) {
                MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
                break block58;
            }
            finally {
                CloseableResultSet.close(stmt, rs);
                CloseableResultSet.close(stmtOuter, rsOuter);
            }
            CloseableResultSet.close((Statement)stmtOuter, (ResultSet)rsOuter);
        }
    }

    private boolean baseTypeIsNotHandled(String baseTypeIn) {
        if (baseTypeIn == null) {
            return true;
        }
        String baseTypeUpper = baseTypeIn.toUpperCase();
        boolean returnValue = true;
        if (baseTypeUpper.equals("BIGINT")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("DECIMAL")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("INT")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("NUMERIC")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("SMALLINT")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("MONEY")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("TINYINT")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("SMALLMONEY")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("BIT")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("FLOAT")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("REAL")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("DATETIME")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("SMALLDATETIME")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("CHAR")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("TEXT")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("VARCHAR")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("VARCHAR")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("SYSNAME")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("NCHAR")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("NTEXT")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("NVARCHAR")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("NVARCHAR")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("BINARY")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("IMAGE")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("VARBINARY")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("VARBINARY")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("CURSOR")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("TIMESTAMP")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("SQL_VARIANT")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("UNIQUEIDENTIFIER")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("TABLE")) {
            returnValue = false;
        } else if (baseTypeUpper.equals("XML")) {
            returnValue = false;
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String baseType(int typeNumber, String databaseName) {
        ResultSet rs;
        PreparedStatement stmt;
        String baseDataType;
        block5: {
            baseDataType = null;
            stmt = null;
            rs = null;
            try {
                stmt = this.getRepositoryConnection().prepareStatement(this.getBaseTypeString(databaseName, typeNumber));
                if (!this.m_online) {
                    stmt.setString(1, databaseName);
                }
                if (!(rs = stmt.executeQuery()).next()) break block5;
                baseDataType = rs.getString(1);
            }
            catch (SQLException e) {
                try {
                    MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close(stmt, rs);
                    throw throwable;
                }
                CloseableResultSet.close((Statement)stmt, rs);
            }
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
        return baseDataType;
    }

    /*
     * Exception decompiling
     */
    private String columnDefault(int defaultId, String databaseName, String baseType) throws CaptureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void captureIndex(CaptureContext context) throws SQLException, PersistenceException {
        String database = this.getDatabase((MigrationContext)context);
        String showIndexQuery = this.getCaptureIndexString(database);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String tableName = (String)context.getContextVariable("TABLE");
            String schemaName = (String)context.getContextVariable("SCHEMA");
            PreparedStatement stmt2 = null;
            ResultSet rs2 = null;
            try {
                stmt2 = this.getRepositoryConnection().prepareStatement(showIndexQuery);
                if (!this.m_online) {
                    stmt2.setString(1, database);
                    stmt2.setString(2, schemaName);
                    stmt2.setString(3, tableName);
                } else {
                    stmt2.setString(1, schemaName);
                    stmt2.setString(2, tableName);
                }
                rs2 = stmt2.executeQuery();
                while (rs2.next()) {
                    int indId = rs2.getInt(2);
                    String srcIndName = rs2.getString(3);
                    int status = rs2.getInt(4);
                    int tableId = rs2.getInt(6);
                    MdIndexe index = new MdIndexe((DBObjectId)context.getContextVariable("TABLEID"));
                    index.setIndexName(srcIndName);
                    if (status == 1) {
                        index.setIndexType("UNIQUE");
                    } else {
                        index.setIndexType("NON_UNIQUE");
                    }
                    PreparedStatement columnStmt = null;
                    ResultSet columnRs = null;
                    boolean indexSaved = false;
                    try {
                        String sql = this.getIndexString(database, tableId, indId);
                        columnStmt = this.getRepositoryConnection().prepareStatement(sql);
                        if (!this.m_online) {
                            columnStmt.setString(1, database);
                        }
                        columnRs = columnStmt.executeQuery();
                        PersistenceUtility util = this.getStorer().getPersistenceUtility();
                        boolean detailOrder = true;
                        while (columnRs.next()) {
                            MdIndexDetail detail;
                            CaptureEvent event;
                            DBObjectId colid = null;
                            try {
                                colid = util.getIdForColumn(index.getTableId(), columnRs.getString(2));
                                if (!indexSaved) {
                                    indexSaved = true;
                                    event = new CaptureEvent(3, MigrationAddinArb.getString((int)140), srcIndName);
                                    context.getAudience().fireListeners(event);
                                    index = (MdIndexe)this.getStorer().storeObject((PersistableObject)index);
                                    event.setEventId(4);
                                    context.getAudience().fireListeners(event);
                                }
                                detail = new MdIndexDetail(index.getKey(), colid, Integer.valueOf(columnRs.getInt(1)));
                            }
                            catch (PersistenceException e) {
                                Logger.getLogger("oracle.dbtools.migration").log(Level.WARNING, "SQLSERVER.COLUMN_NOT_FOUND", index.getIndexName());
                                continue;
                            }
                            event = new CaptureEvent(3, MigrationAddinArb.getString((int)143), index.getIndexName());
                            context.getAudience().fireListeners(event);
                            event.setEventId(4);
                            context.getAudience().fireListeners(event);
                            detail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)detail);
                        }
                    }
                    catch (Throwable throwable) {
                        CloseableResultSet.close(columnStmt, columnRs);
                        throw throwable;
                    }
                    CloseableResultSet.close((Statement)columnStmt, (ResultSet)columnRs);
                }
            }
            catch (Throwable throwable) {
                CloseableResultSet.close((Statement)stmt2, rs2);
                throw throwable;
            }
            CloseableResultSet.close((Statement)stmt2, (ResultSet)rs2);
            return;
        }
        finally {
            CloseableResultSet.close(stmt, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureUniqueAndPrimaryKeys(CaptureContext context) throws SQLException, PersistenceException {
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String database = null;
        database = this.getDatabase((MigrationContext)context);
        boolean firstTime = true;
        long id = 0L;
        String sQuery = this.captureUniqueAndPrimaryKeysString(database);
        try {
            stmt = this.getRepositoryConnection().prepareStatement(sQuery);
            String tableName = (String)context.getContextVariable("TABLE");
            String schemaName = (String)context.getContextVariable("SCHEMA");
            if (!this.m_online) {
                stmt.setString(1, database);
                stmt.setString(2, tableName);
                stmt.setString(3, schemaName);
            } else {
                stmt.setString(1, tableName);
                stmt.setString(2, schemaName);
            }
            rs = stmt.executeQuery();
            MdConstraint constraint = null;
            int detailOrder = 1;
            while (rs.next()) {
                if (firstTime || rs.getLong(3) != id) {
                    firstTime = false;
                    id = rs.getLong(3);
                    String xtype = rs.getString(8);
                    constraint = new MdConstraint((DBObjectId)context.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                    if (xtype.trim().equals("PK")) {
                        xtype = "PK";
                    } else if (xtype.trim().equals("UQ")) {
                        xtype = "UNIQUE";
                    }
                    constraint.setConstraintType(xtype);
                    constraint.setName(rs.getString(1));
                    CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), constraint.getName());
                    context.getAudience().fireListeners(event);
                    constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
                    detailOrder = 1;
                    event.setEventId(4);
                    context.getAudience().fireListeners(event);
                }
                String columnName = rs.getString(5);
                MdConstraintDetail constraintdetail = new MdConstraintDetail(constraint.getKey(), Integer.valueOf(detailOrder++));
                constraintdetail.setColumnId(util.getIdForColumn(constraint.getTableId(), columnName));
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)147), constraint.getName());
                context.getAudience().fireListeners(event);
                constraintdetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)constraintdetail);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close((Statement)stmt, rs);
            throw throwable;
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureForeignKeys(CaptureContext context) throws SQLException, PersistenceException {
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String database = null;
        database = this.getDatabase((MigrationContext)context);
        String sQuery = this.captureForeignKeysStringString(database);
        stmt = this.getRepositoryConnection().prepareStatement(sQuery);
        String schemaName = (String)context.getContextVariable("SCHEMA");
        String tableName = (String)context.getContextVariable("TABLE");
        if (!this.m_online) {
            stmt.setString(1, database);
            stmt.setString(2, schemaName);
            stmt.setString(3, tableName);
        } else {
            stmt.setString(1, schemaName);
            stmt.setString(2, tableName);
        }
        rs = stmt.executeQuery();
        MdConstraint constraint = null;
        boolean firstTime = true;
        boolean storeMe = false;
        int lastConstraintId = -1;
        try {
            int detailOrder = 1;
            while (rs.next()) {
                DBObjectId refTableId;
                String foreignColumnName;
                String foreignTableName;
                String foreignSchemaName;
                int thisConstraintId = rs.getInt(2);
                if (firstTime || thisConstraintId != lastConstraintId) {
                    DBObjectId refTableId2;
                    storeMe = true;
                    firstTime = false;
                    lastConstraintId = thisConstraintId;
                    constraint = new MdConstraint((DBObjectId)context.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                    constraint.setConstraintType("FOREIGN KEY");
                    constraint.setName(rs.getString(1));
                    foreignSchemaName = rs.getString(4);
                    foreignTableName = rs.getString(5);
                    foreignColumnName = rs.getString(6);
                    DBObjectId foreignSchemaId = util.getIdForSchema((DBObjectId)context.getContextVariable("CATALOGID"), foreignSchemaName);
                    if (foreignSchemaId == null) continue;
                    try {
                        refTableId2 = util.getIdForTable(foreignSchemaId, foreignTableName);
                    }
                    catch (PersistenceException e) {
                        continue;
                    }
                    constraint.setReftableId(refTableId2);
                    CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), constraint.getName());
                    context.getAudience().fireListeners(event);
                    constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
                    detailOrder = 1;
                    event.setEventId(4);
                    context.getAudience().fireListeners(event);
                }
                foreignSchemaName = rs.getString(4);
                foreignTableName = rs.getString(5);
                foreignColumnName = rs.getString(6);
                String localColumnName = rs.getString(3);
                DBObjectId foreignSchemaId = util.getIdForSchema((DBObjectId)context.getContextVariable("CATALOGID"), foreignSchemaName);
                if (foreignSchemaId == null) continue;
                try {
                    refTableId = util.getIdForTable(foreignSchemaId, foreignTableName);
                }
                catch (PersistenceException e) {
                    continue;
                }
                MdConstraintDetail constraintdetail = new MdConstraintDetail(constraint.getKey(), Integer.valueOf(detailOrder));
                try {
                    constraintdetail.setColumnId(util.getIdForColumn(constraint.getTableId(), localColumnName));
                }
                catch (PersistenceException e) {
                    MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
                    continue;
                }
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)147), constraint.getName());
                context.getAudience().fireListeners(event);
                constraintdetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)constraintdetail);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
                constraintdetail = new MdConstraintDetail(constraint.getKey(), Integer.valueOf(detailOrder++));
                try {
                    constraintdetail.setColumnId(util.getIdForColumn(refTableId, foreignColumnName));
                }
                catch (PersistenceException e) {
                    MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
                    continue;
                }
                constraintdetail.setRefFlag("Y");
                event = new CaptureEvent(3, MigrationAddinArb.getString((int)147), constraint.getName());
                context.getAudience().fireListeners(event);
                constraintdetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)constraintdetail);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
        }
        finally {
            CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureTableLevelCheckConstraint(CaptureContext context) throws SQLException, PersistenceException, CaptureException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String database = null;
        try {
            database = this.getDatabase((MigrationContext)context);
            String sQuery = this.captureTableLevelCheckConstraintString(database);
            stmt = this.getRepositoryConnection().prepareStatement(sQuery);
            String tableName = (String)context.getContextVariable("TABLE");
            String schemaName = (String)context.getContextVariable("SCHEMA");
            if (!this.m_online) {
                stmt.setString(1, database);
                stmt.setString(2, tableName);
                stmt.setString(3, schemaName);
            } else {
                stmt.setString(1, tableName);
                stmt.setString(2, schemaName);
            }
            rs = stmt.executeQuery();
            MdConstraint constraint = null;
            while (rs.next()) {
                String xtype = "CHECK";
                constraint = new MdConstraint((DBObjectId)context.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                constraint.setConstraintType(xtype);
                constraint.setName(rs.getString(1));
                Reader reader = null;
                if (!this.m_online) {
                    Clob clob = rs.getClob(2);
                    reader = clob.getCharacterStream();
                } else {
                    reader = rs.getCharacterStream(2);
                }
                StringBuffer buf = new StringBuffer();
                String result = null;
                char[] buffer = new char[s_chunkSize];
                int length = 0;
                if (reader != null) {
                    try {
                        while ((length = reader.read(buffer)) != -1) {
                            buf.append(new String(buffer, 0, length));
                        }
                        result = buf.toString();
                    }
                    catch (IOException io) {
                        throw new CaptureException((Throwable)io);
                    }
                }
                constraint.setConstraintText(result);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), constraint.getName());
                context.getAudience().fireListeners(event);
                constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(stmt, rs);
            throw throwable;
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureColumnLevelCheckConstraint(CaptureContext context) throws SQLException, PersistenceException, CaptureException {
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String database = null;
        try {
            database = this.getDatabase((MigrationContext)context);
            String sQuery = this.captureColumnLevelCheckConstraintString(database);
            stmt = this.getRepositoryConnection().prepareStatement(sQuery);
            String tableName = (String)context.getContextVariable("TABLE");
            String schemaName = (String)context.getContextVariable("SCHEMA");
            if (!this.m_online) {
                stmt.setString(1, database);
                stmt.setString(2, tableName);
                stmt.setString(3, schemaName);
            } else {
                stmt.setString(1, tableName);
                stmt.setString(2, schemaName);
            }
            rs = stmt.executeQuery();
            MdConstraint constraint = null;
            while (rs.next()) {
                String xtype = "CHECK";
                constraint = new MdConstraint((DBObjectId)context.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                constraint.setConstraintType(xtype);
                constraint.setName(rs.getString(1));
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), constraint.getName());
                context.getAudience().fireListeners(event);
                constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
                MdConstraintDetail constraintdetail = new MdConstraintDetail(constraint.getKey(), Integer.valueOf(1));
                Reader reader = null;
                if (!this.m_online) {
                    Clob clob = rs.getClob(4);
                    reader = clob.getCharacterStream();
                } else {
                    reader = rs.getCharacterStream(4);
                }
                StringBuffer buf = new StringBuffer();
                String result = null;
                char[] buffer = new char[s_chunkSize];
                int length = 0;
                if (reader != null) {
                    try {
                        while ((length = reader.read(buffer)) != -1) {
                            buf.append(new String(buffer, 0, length));
                        }
                        result = buf.toString();
                    }
                    catch (IOException io) {
                        throw new CaptureException((Throwable)io);
                    }
                }
                constraintdetail.setConstraintText(result);
                String columnName = rs.getString(6);
                CloseableIterator getColumns = util.getColumnsForTableId((DBObjectId)context.getContextVariable("TABLEID"));
                DBObjectId columnId = null;
                while (getColumns.hasNext()) {
                    MdColumn column = (MdColumn)getColumns.next();
                    if (!column.getColumnName().equals(columnName)) continue;
                    columnId = column.getKey();
                }
                constraintdetail.setColumnId(columnId);
                event = new CaptureEvent(3, MigrationAddinArb.getString((int)147), constraint.getName());
                context.getAudience().fireListeners(event);
                constraintdetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)constraintdetail);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(stmt, rs);
            throw throwable;
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void captureRules(CaptureContext context) throws SQLException, PersistenceException, CaptureException {
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String database = null;
        try {
            database = this.getDatabase((MigrationContext)context);
            String sQuery = this.captureRulesString(database);
            stmt = this.getRepositoryConnection().prepareStatement(sQuery);
            String tableName = (String)context.getContextVariable("TABLE");
            String schemaName = (String)context.getContextVariable("SCHEMA");
            DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
            if (!this.m_online) {
                stmt.setString(1, database);
                stmt.setString(2, tableName);
                stmt.setString(3, schemaName);
            } else {
                stmt.setString(1, tableName);
                stmt.setString(2, schemaName);
            }
            rs = stmt.executeQuery();
            MdConstraint constraint = null;
            while (rs.next()) {
                String columnName = rs.getString(2);
                int columnRuleId = rs.getInt(4);
                String xtype = "CHECK";
                if (columnRuleId == 0) continue;
                String ruleName = "rul_" + tableName + "_" + columnName;
                PreparedStatement textStmt = null;
                ResultSet textRs = null;
                String ruleText = "";
                String sqltext = this.captureRulesTextString(database);
                try {
                    textStmt = this.getRepositoryConnection().prepareStatement(sqltext);
                    if (!this.m_online) {
                        textStmt.setString(1, database);
                        textStmt.setInt(2, columnRuleId);
                    } else {
                        textStmt.setInt(1, columnRuleId);
                    }
                    textRs = textStmt.executeQuery();
                    while (textRs.next()) {
                        Reader reader = null;
                        if (!this.m_online) {
                            Clob clob = rs.getClob(1);
                            reader = clob.getCharacterStream();
                        } else {
                            reader = rs.getCharacterStream(1);
                        }
                        StringBuffer buf = new StringBuffer();
                        String result = null;
                        char[] buffer = new char[s_chunkSize];
                        int length = 0;
                        if (reader != null) {
                            try {
                                while ((length = reader.read(buffer)) != -1) {
                                    buf.append(new String(buffer, 0, length));
                                }
                                result = buf.toString();
                            }
                            catch (IOException io) {
                                throw new CaptureException((Throwable)io);
                            }
                        }
                        ruleText = result;
                    }
                    constraint = new MdConstraint((DBObjectId)context.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                    constraint.setConstraintType(xtype);
                    constraint.setName(ruleName);
                    constraint.addProperty("TYPE", "RULE", connectionId);
                    CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), constraint.getName());
                    context.getAudience().fireListeners(event);
                    constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
                    event.setEventId(4);
                    context.getAudience().fireListeners(event);
                    MdConstraintDetail constraintdetail = new MdConstraintDetail(constraint.getKey(), Integer.valueOf(1));
                    CloseableIterator getColumns = util.getColumnsForTableId((DBObjectId)context.getContextVariable("TABLEID"));
                    DBObjectId columnId = null;
                    while (getColumns.hasNext()) {
                        MdColumn column = (MdColumn)getColumns.next();
                        if (!column.getColumnName().equals(columnName)) continue;
                        columnId = column.getKey();
                    }
                    constraintdetail.setColumnId(columnId);
                    constraintdetail.setConstraintText(ruleText);
                    event = new CaptureEvent(3, MigrationAddinArb.getString((int)147), constraint.getName());
                    context.getAudience().fireListeners(event);
                    constraintdetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)constraintdetail);
                    event.setEventId(4);
                    context.getAudience().fireListeners(event);
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close((Statement)textStmt, textRs);
                    throw throwable;
                }
                CloseableResultSet.close((Statement)textStmt, (ResultSet)textRs);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(stmt, rs);
            throw throwable;
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
    }

    protected void captureView(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException, CaptureException {
        PreparedStatement stmt = null;
        PreparedStatement outerStmt = null;
        ResultSet rs = null;
        ResultSet outerRs = null;
        String database = null;
        PrepareClobHelper pch = null;
        try {
            database = this.getDatabase((MigrationContext)context);
            String queryAdd = "";
            HashSet<String> nameFilter = null;
            if (filter != null && !filter.getObjectType().equals("MD_VIEWS")) {
                throw new IllegalArgumentException("Filter is of incorrect type " + filter.getObjectType());
            }
            if (filter != null && filter.getFilterType() == 2) {
                queryAdd = " AND a.name " + filter.getWhereClause();
            }
            if (filter != null && filter.getFilterType() == 1) {
                nameFilter = new HashSet<String>();
                for (String name : filter.getObjectNames()) {
                    nameFilter.add(name);
                }
            }
            String outerQuery = this.captureViewOuterString(database) + queryAdd;
            String sQuery = this.captureViewInnerString(database) + queryAdd;
            outerStmt = this.getRepositoryConnection().prepareStatement(outerQuery);
            String schemaName = (String)context.getContextVariable("SCHEMA");
            if (!this.m_online) {
                outerStmt.setString(1, database);
                outerStmt.setString(2, schemaName);
            } else {
                outerStmt.setString(1, schemaName);
            }
            outerRs = outerStmt.executeQuery();
            while (outerRs.next()) {
                int id = outerRs.getInt(1);
                String viewName = outerRs.getString(2);
                if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(viewName)) continue;
                stmt = this.getRepositoryConnection().prepareStatement(sQuery);
                if (!this.m_online) {
                    stmt.setString(1, database);
                    stmt.setInt(2, id);
                } else {
                    stmt.setInt(1, id);
                }
                rs = stmt.executeQuery();
                MdView view = null;
                viewName = null;
                pch = new PrepareClobHelper();
                while (rs.next()) {
                    viewName = rs.getString(1);
                    try {
                        Reader reader = null;
                        if (!this.m_online) {
                            Clob clob = rs.getClob(3);
                            reader = clob.getCharacterStream();
                        } else {
                            reader = rs.getCharacterStream(3);
                        }
                        StringBuffer buf = new StringBuffer();
                        String result = null;
                        char[] buffer = new char[s_chunkSize];
                        int length = 0;
                        if (reader != null) {
                            while ((length = reader.read(buffer)) != -1) {
                                buf.append(new String(buffer, 0, length));
                            }
                            result = buf.toString();
                        }
                        pch.append(result);
                    }
                    catch (Exception e) {
                        pch.append("");
                    }
                }
                if (viewName != null) {
                    view = new MdView((DBObjectId)context.getContextVariable("SCHEMAID"), MY_LANGUAGE_ID);
                    view.setViewName(viewName);
                    ClobHelper ch = pch.getClobHelper();
                    if (ch == null || ch.getLength() == 0L) {
                        pch = new PrepareClobHelper();
                        pch.append("/* ddl not accessible */");
                        ch = pch.getClobHelper();
                    }
                    view.setNativeSql(ch);
                    try {
                        String comment_sql = this.captureCommentsString();
                        PreparedStatement comment_stmt = this.getRepositoryConnection().prepareStatement(comment_sql);
                        comment_stmt.setInt(1, id);
                        comment_stmt.setInt(2, 0);
                        ResultSet comment_rs = comment_stmt.executeQuery();
                        comment_rs.next();
                        String Comment = comment_rs.getString(1);
                        comment_rs.close();
                        comment_stmt.close();
                        view.setComments(Comment);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)137), viewName);
                    context.getAudience().fireListeners(event);
                    view = (MdView)this.getStorer().storeObject((PersistableObject)view);
                    event.setEventId(4);
                    context.getAudience().fireListeners(event);
                }
                if (pch != null) {
                    pch.close();
                }
                CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
            }
            CloseableResultSet.close((Statement)outerStmt, (ResultSet)outerRs);
        }
        catch (IOException io) {
            try {
                throw new CaptureException((Throwable)io);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(stmt, rs);
                CloseableResultSet.close(outerStmt, outerRs);
                if (pch != null) {
                    try {
                        pch.close();
                    }
                    catch (Exception io2) {
                        MigrationLogUtil.logThrowable((String)io2.getLocalizedMessage(), (String)"Capture", (Throwable)io2);
                    }
                }
                throw throwable;
            }
        }
        CloseableResultSet.close(stmt, rs);
        CloseableResultSet.close((Statement)outerStmt, (ResultSet)outerRs);
        if (pch != null) {
            try {
                pch.close();
            }
            catch (Exception io) {
                MigrationLogUtil.logThrowable((String)io.getLocalizedMessage(), (String)"Capture", (Throwable)io);
            }
        }
    }

    protected void captureStoredProgram(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException, CaptureException {
        PreparedStatement stmt = null;
        PreparedStatement outerStmt = null;
        ResultSet rs = null;
        ResultSet outerRs = null;
        String database = null;
        PrepareClobHelper pch = null;
        try {
            database = this.getDatabase((MigrationContext)context);
            String queryAdd = "";
            HashSet<String> nameFilter = null;
            if (filter != null && !filter.getObjectType().equals("MD_STORED_PROGRAMS")) {
                throw new IllegalArgumentException("Filter is of incorrect type " + filter.getObjectType());
            }
            if (filter != null && filter.getFilterType() == 2) {
                queryAdd = " AND a.name " + filter.getWhereClause();
            }
            if (filter != null && filter.getFilterType() == 1) {
                nameFilter = new HashSet<String>();
                for (String name : filter.getObjectNames()) {
                    nameFilter.add(name);
                }
            }
            String outerQuery = this.captureStoredProgramOuterString(database) + queryAdd;
            String sQuery = this.captureStoredProgramInnerString(database, queryAdd);
            outerStmt = this.getRepositoryConnection().prepareStatement(outerQuery);
            String userName = (String)context.getContextVariable("SCHEMA");
            if (!this.m_online) {
                outerStmt.setString(1, database);
                outerStmt.setString(2, userName);
            } else {
                outerStmt.setString(1, userName);
            }
            outerRs = outerStmt.executeQuery();
            while (outerRs.next()) {
                int id = outerRs.getInt(1);
                String viewName = outerRs.getString(2);
                if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(viewName)) continue;
                stmt = this.getRepositoryConnection().prepareStatement(sQuery);
                if (!this.m_online) {
                    stmt.setString(1, database);
                    stmt.setInt(2, id);
                } else {
                    stmt.setInt(1, id);
                }
                rs = stmt.executeQuery();
                MdStoredProgram storedProgram = null;
                String storedProgramName = "";
                String storedProgramType = "";
                pch = new PrepareClobHelper();
                while (rs.next()) {
                    if (storedProgram == null) {
                        storedProgramName = rs.getString(1);
                        storedProgramType = rs.getString(5);
                        storedProgram = new MdStoredProgram((DBObjectId)context.getContextVariable("SCHEMAID"), MY_LANGUAGE_ID);
                    }
                    String result = null;
                    try {
                        Reader reader = null;
                        if (!this.m_online) {
                            Clob clob = rs.getClob(4);
                            reader = clob.getCharacterStream();
                        } else {
                            reader = rs.getCharacterStream(4);
                        }
                        StringBuffer buf = new StringBuffer();
                        char[] buffer = new char[s_chunkSize];
                        int length = 0;
                        if (reader != null) {
                            while ((length = reader.read(buffer)) != -1) {
                                buf.append(new String(buffer, 0, length));
                            }
                            result = buf.toString();
                        }
                    }
                    catch (Exception e) {
                        result = "";
                    }
                    if (result == null) continue;
                    pch.append(result);
                }
                if (storedProgram != null) {
                    storedProgram.setName(storedProgramName);
                    ClobHelper ch = pch.getClobHelper();
                    if (ch == null || ch.getLength() == 0L) {
                        pch = new PrepareClobHelper();
                        pch.append("/* ddl not accessible */");
                        ch = pch.getClobHelper();
                    }
                    storedProgram.setNativeSql(ch);
                    String additionalProperty = storedProgramType;
                    if (storedProgramType.trim().equals("P")) {
                        additionalProperty = "PROCEDURE";
                        storedProgramType = "PROCEDURE";
                    } else if (storedProgramType.equals("FN")) {
                        additionalProperty = "SCALAR FUNCTION";
                        storedProgramType = "FUNCTION";
                    } else if (storedProgramType.equals("TF")) {
                        additionalProperty = "TABLE FUNCTION";
                        storedProgramType = "FUNCTION";
                    } else if (storedProgramType.equals("IF")) {
                        additionalProperty = "INLINED T. FUNCTION";
                        storedProgramType = "FUNCTION";
                    } else {
                        storedProgramType = "PROCEDURE";
                    }
                    DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
                    storedProgram.addProperty("TYPE", additionalProperty, connectionId);
                    storedProgram.setProgramtype(storedProgramType);
                    try {
                        String comment_sql = this.captureCommentsString();
                        PreparedStatement comment_stmt = this.getRepositoryConnection().prepareStatement(comment_sql);
                        comment_stmt.setInt(1, id);
                        comment_stmt.setInt(2, 0);
                        ResultSet comment_rs = comment_stmt.executeQuery();
                        comment_rs.next();
                        String Comment = comment_rs.getString(1);
                        comment_rs.close();
                        comment_stmt.close();
                        storedProgram.setComments(Comment);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)136), storedProgramName);
                    context.getAudience().fireListeners(event);
                    storedProgram = (MdStoredProgram)this.getStorer().storeObject((PersistableObject)storedProgram);
                    event.setEventId(4);
                    context.getAudience().fireListeners(event);
                }
                if (pch != null) {
                    pch.close();
                }
                CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
            }
            CloseableResultSet.close((Statement)outerStmt, (ResultSet)outerRs);
        }
        catch (IOException io) {
            try {
                throw new CaptureException((Throwable)io);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(stmt, rs);
                CloseableResultSet.close(outerStmt, outerRs);
                if (pch != null) {
                    try {
                        pch.close();
                    }
                    catch (Exception io2) {
                        MigrationLogUtil.logThrowable((String)io2.getLocalizedMessage(), (String)"Capture", (Throwable)io2);
                    }
                }
                throw throwable;
            }
        }
        CloseableResultSet.close(stmt, rs);
        CloseableResultSet.close((Statement)outerStmt, (ResultSet)outerRs);
        if (pch != null) {
            try {
                pch.close();
            }
            catch (Exception io) {
                MigrationLogUtil.logThrowable((String)io.getLocalizedMessage(), (String)"Capture", (Throwable)io);
            }
        }
    }

    protected void captureTriggers(CaptureContext context) throws SQLException, PersistenceException, CaptureException {
        PrepareClobHelper pch;
        ResultSet rs;
        PreparedStatement stmt;
        block26: {
            DBObjectId tableOrViewId;
            String sTriggerOn;
            stmt = null;
            rs = null;
            String database = null;
            pch = null;
            String s = (String)context.getContextVariable("PER_CONTEXT");
            String tableOrView = null;
            if (s.equals("MD_TABLES")) {
                sTriggerOn = "T";
                tableOrViewId = (DBObjectId)context.getContextVariable("TABLEID");
                tableOrView = (String)context.getContextVariable("TABLE");
            } else {
                sTriggerOn = "V";
                tableOrViewId = (DBObjectId)context.getContextVariable("VIEWID");
                tableOrView = (String)context.getContextVariable("VIEW");
            }
            try {
                CaptureEvent event;
                ClobHelper ch;
                database = this.getDatabase((MigrationContext)context);
                String sQuery = this.captureTriggersString(database);
                stmt = this.getRepositoryConnection().prepareStatement(sQuery);
                String userName = (String)context.getContextVariable("SCHEMA");
                if (!this.m_online) {
                    stmt.setString(1, database);
                    stmt.setString(2, userName);
                    stmt.setString(3, tableOrView);
                } else {
                    stmt.setString(1, userName);
                    stmt.setString(2, tableOrView);
                }
                rs = stmt.executeQuery();
                MdTrigger trigger = null;
                boolean firstTime = true;
                String triggerName = "";
                while (rs.next()) {
                    if (firstTime || !triggerName.equals(rs.getString(1))) {
                        if (!firstTime) {
                            trigger.setTriggerName(triggerName);
                            ch = pch.getClobHelper();
                            if (ch == null || ch.getLength() == 0L) {
                                pch = new PrepareClobHelper();
                                pch.append("/* ddl not accessible */");
                                ch = pch.getClobHelper();
                            }
                            trigger.setNativeSql(ch);
                            event = new CaptureEvent(3, MigrationAddinArb.getString((int)135), triggerName);
                            context.getAudience().fireListeners(event);
                            trigger = (MdTrigger)this.getStorer().storeObject((PersistableObject)trigger);
                            event.setEventId(4);
                            context.getAudience().fireListeners(event);
                        }
                        if (pch != null) {
                            pch.close();
                        }
                        pch = new PrepareClobHelper();
                        triggerName = rs.getString(1);
                        firstTime = false;
                        trigger = new MdTrigger(tableOrViewId, sTriggerOn, MY_LANGUAGE_ID);
                    }
                    String result = null;
                    try {
                        Reader reader = null;
                        if (!this.m_online) {
                            Clob clob = rs.getClob(4);
                            reader = clob.getCharacterStream();
                        } else {
                            reader = rs.getCharacterStream(4);
                        }
                        StringBuffer buf = new StringBuffer();
                        char[] buffer = new char[s_chunkSize];
                        int length = 0;
                        if (reader != null) {
                            while ((length = reader.read(buffer)) != -1) {
                                buf.append(new String(buffer, 0, length));
                            }
                            result = buf.toString();
                        }
                    }
                    catch (Exception e) {
                        result = "";
                    }
                    if (result == null) continue;
                    pch.append(result);
                }
                if (trigger == null) break block26;
                trigger.setTriggerName(triggerName);
                ch = pch.getClobHelper();
                if (ch == null || ch.getLength() == 0L) {
                    pch = new PrepareClobHelper();
                    pch.append("/* ddl not accessible */");
                    ch = pch.getClobHelper();
                }
                trigger.setNativeSql(ch);
                event = new CaptureEvent(3, MigrationAddinArb.getString((int)135), triggerName);
                context.getAudience().fireListeners(event);
                trigger = (MdTrigger)this.getStorer().storeObject((PersistableObject)trigger);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
            catch (IOException io) {
                try {
                    throw new CaptureException((Throwable)io);
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close(stmt, rs);
                    if (pch != null) {
                        try {
                            pch.close();
                        }
                        catch (Exception io2) {
                            MigrationLogUtil.logThrowable((String)io2.getLocalizedMessage(), (String)"Capture", (Throwable)io2);
                        }
                    }
                    throw throwable;
                }
            }
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
        if (pch != null) {
            try {
                pch.close();
            }
            catch (Exception io) {
                MigrationLogUtil.logThrowable((String)io.getLocalizedMessage(), (String)"Capture", (Throwable)io);
            }
        }
    }

    protected void captureRoles(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException, CaptureException {
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        PrepareClobHelper pch = null;
        ArrayList<MdGroup> groupAL = new ArrayList<MdGroup>();
        try {
            String database = this.getDatabase((MigrationContext)context);
            String sql = this.captureRolesString(database);
            HashSet<String> nameFilter = null;
            if (filter != null && !filter.getObjectType().equals("MD_GROUPS")) {
                throw new IllegalArgumentException("Filter is of incorrect type " + filter.getObjectType());
            }
            if (filter != null && filter.getFilterType() == 2) {
                sql = sql + " where b.name " + filter.getWhereClause();
            }
            if (filter != null && filter.getFilterType() == 1) {
                nameFilter = new HashSet<String>();
                for (String name : filter.getObjectNames()) {
                    nameFilter.add(name);
                }
            }
            stmt = this.getRepositoryConnection().prepareStatement(sql);
            if (!this.m_online) {
                stmt.setString(1, this.getDatabase((MigrationContext)context));
            }
            rs = stmt.executeQuery();
            MdGroup role = null;
            while (rs.next()) {
                DBObjectId schemaId;
                String schemaName;
                String roleName;
                block22: {
                    roleName = rs.getString(1);
                    if (nameFilter != null && nameFilter.contains(roleName)) continue;
                    schemaName = rs.getString(2);
                    if (rs.wasNull()) {
                        schemaName = "dbo";
                    }
                    pch = new PrepareClobHelper();
                    try {
                        schemaId = util.getIdForSchema((DBObjectId)context.getContextVariable("CATALOGID"), schemaName);
                        if (schemaId != null) break block22;
                        schemaName = "dbo";
                        schemaId = util.getIdForSchema((DBObjectId)context.getContextVariable("CATALOGID"), schemaName);
                        if (schemaId == null) {
                        }
                    }
                    catch (PersistenceException e1) {}
                    continue;
                }
                pch.append("sp_addrole " + roleName + ", " + schemaName);
                role = new MdGroup(schemaId);
                role.setGroupFlag("R");
                role.setGroupName(roleName);
                role.setNativeSql(pch.getClobHelper());
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)145), roleName);
                context.getAudience().fireListeners(event);
                role = (MdGroup)this.getStorer().storeObject((PersistableObject)role);
                event.setEventId(4);
                this.capturePrivileges(this.getRepositoryConnection(), this.getStorer(), context, groupAL, role, null);
                groupAL.add(role);
                context.getAudience().fireListeners(event);
                pch.close();
            }
            this.captureRoleMembership(this.getRepositoryConnection(), this.getStorer(), context, groupAL);
            CloseableIterator schemas = util.getSchemasforCatalogId((DBObjectId)context.getContextVariable("CATALOGID"));
            while (schemas.hasNext()) {
                CloseableIterator users = util.getUsersforSchemaId(((MdSchema)schemas.next()).getKey());
                while (users.hasNext()) {
                    MdUser mdUser = (MdUser)users.next();
                    this.capturePrivileges(this.getRepositoryConnection(), this.getStorer(), context, groupAL, null, mdUser);
                }
            }
        }
        catch (IOException io) {
            try {
                throw new CaptureException((Throwable)io);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(stmt, rs);
                if (pch != null) {
                    try {
                        pch.close();
                    }
                    catch (Exception io2) {
                        MigrationLogUtil.logThrowable((String)io2.getLocalizedMessage(), (String)"Capture", (Throwable)io2);
                    }
                }
                throw throwable;
            }
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
        if (pch != null) {
            try {
                pch.close();
            }
            catch (Exception io) {
                MigrationLogUtil.logThrowable((String)io.getLocalizedMessage(), (String)"Capture", (Throwable)io);
            }
        }
    }

    protected String getDatabase(MigrationContext context) throws SQLException {
        String database = null;
        MdCatalog catalog = (MdCatalog)context.getContextVariable("CATALOG");
        database = catalog.getCatalogName();
        return database;
    }

    public boolean isPrivilegeWarningWritten() {
        return this.m_privilegeWarningWritten;
    }

    public void setPrivilegeWarningWritten(boolean warningWritten) {
        this.m_privilegeWarningWritten = warningWritten;
    }

    public String getModelName() throws CaptureException {
        return null;
    }

    public String getSourceURL() throws CaptureException {
        return "/tmp/sqlserver7";
    }

    public void setStorer(MigrationStorer storer) {
        this.m_storer = storer;
    }

    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    public Connection getRepositoryConnection() {
        return this.m_repositoryConnection;
    }

    public void setRepositoryConnection(Connection repositoryConnection) {
        this.m_repositoryConnection = repositoryConnection;
    }

    static {
        s_chunkSize = 4096;
    }
}

