/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdGroupMember;
import oracle.dbtools.metadata.persistence.MdGroupPrivilege;
import oracle.dbtools.metadata.persistence.MdPrivilege;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdUserPrivilege;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.metadata.persistence.PrepareClobHelper;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.core.MigrationContext;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQLServer2005AbstractCapturerPrivilegeExtra {
    private static int s_overSize = 5000;

    protected abstract String capturePrivilegesString(String var1);

    protected abstract String captureRoleMembershipString(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void capturePrivileges(Connection sourceConnection, MigrationStorer storer, CaptureContext context, ArrayList<MdGroup> groupAL, MdGroup role, MdUser user, boolean isOnline) throws SQLException, PersistenceException {
        PersistenceUtility util = storer.getPersistenceUtility();
        String database = SQLServer2005AbstractCapturerPrivilegeExtra.getDatabase(sourceConnection, (MigrationContext)context);
        String privinfo = this.capturePrivilegesString(database);
        PreparedStatement privStmt = null;
        ResultSet privRs = null;
        PrepareClobHelper pch2 = null;
        try {
            String sql = privinfo;
            privStmt = sourceConnection.prepareStatement(sql);
            boolean isRole = true;
            String roleName = null;
            if (role == null) {
                isRole = false;
                roleName = user.getUsername();
            } else {
                roleName = role.getGroupName();
            }
            if (!isOnline) {
                privStmt.setString(1, database);
                privStmt.setString(2, roleName);
            } else {
                privStmt.setString(1, roleName);
            }
            privRs = privStmt.executeQuery();
            while (privRs.next()) {
                String action = privRs.getString(4);
                if (action.equals("REFERENCES")) {
                    action = "REFERENCES";
                } else if (action.equals("SELECT")) {
                    action = "SELECT";
                } else if (action.equals("INSERT")) {
                    action = "INSERT";
                } else if (action.equals("UPDATE")) {
                    action = "UPDATE";
                } else if (action.equals("DELETE")) {
                    action = "DELETE";
                }
                pch2 = new PrepareClobHelper();
                pch2.append("GRANT " + action + " ON [" + database + "].[" + privRs.getString(2) + "].[" + privRs.getString(3) + "] TO " + roleName);
                DBObjectId schemaIdGrantor = null;
                DBObjectId schemaIdOwner = null;
                try {
                    String grantor = privRs.getString(1);
                    schemaIdGrantor = SQLServer2005AbstractCapturerPrivilegeExtra.getSchemaIdForRoleUser(util, (DBObjectId)context.getContextVariable("CATALOGID"), grantor);
                    String owner = privRs.getString(2);
                    schemaIdOwner = util.getIdForSchema((DBObjectId)context.getContextVariable("CATALOGID"), owner);
                }
                catch (PersistenceException e1) {
                    if (pch2 == null) continue;
                    try {
                        pch2.close();
                    }
                    catch (IOException e) {
                        MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
                    }
                    continue;
                }
                MdPrivilege mdPrivilege = new MdPrivilege(schemaIdGrantor, "TABLE:[" + database + "].[" + privRs.getString(2) + "].[" + privRs.getString(3) + "]:" + action, "MD_TABLES", privRs.getString(4), pch2.getClobHelper());
                pch2.close();
                if (privRs.getString(5).equals("NO")) {
                    mdPrivilege.setAdminOption("Y");
                } else {
                    mdPrivilege.setAdminOption("N");
                }
                DBObjectId objectId = null;
                try {
                    objectId = SQLServer2005AbstractCapturerPrivilegeExtra.getIdInRepo(util, "U", schemaIdOwner, privRs.getString(3));
                    if (objectId == null) {
                        continue;
                    }
                }
                catch (PersistenceException e) {
                    if (objectId == null) continue;
                    throw e;
                }
                mdPrivilege.setPrivelegeObjectId(objectId);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)150), privRs.getString(3));
                context.getAudience().fireListeners(event);
                mdPrivilege = (MdPrivilege)storer.storeObject((PersistableObject)mdPrivilege);
                event.setEventId(4);
                if (isRole) {
                    MdGroupPrivilege mdGroupPrivilege = new MdGroupPrivilege(role.getKey(), mdPrivilege.getKey());
                    mdGroupPrivilege = (MdGroupPrivilege)storer.storeObject((PersistableObject)mdGroupPrivilege);
                    continue;
                }
                MdUserPrivilege mdUserPrivilege = new MdUserPrivilege(user.getKey());
                mdUserPrivilege.setPrivilegeId(mdPrivilege.getKey());
                mdUserPrivilege = (MdUserPrivilege)storer.storeObject((PersistableObject)mdUserPrivilege);
            }
        }
        catch (IOException ioe) {
            try {
                MigrationLogUtil.logThrowable((String)ioe.getLocalizedMessage(), (String)"Capture", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(privStmt, privRs);
                if (pch2 != null) {
                    try {
                        pch2.close();
                    }
                    catch (IOException e) {
                        MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
                    }
                }
                throw throwable;
            }
            CloseableResultSet.close((Statement)privStmt, privRs);
            if (pch2 != null) {
                try {
                    pch2.close();
                }
                catch (IOException e) {
                    MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
                }
            }
        }
        CloseableResultSet.close((Statement)privStmt, (ResultSet)privRs);
        if (pch2 != null) {
            try {
                pch2.close();
            }
            catch (IOException e) {
                MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void captureRoleMembership(Connection sourceConnection, MigrationStorer storer, CaptureContext context, ArrayList<MdGroup> groupAL, boolean isOnline) throws SQLException, PersistenceException {
        PersistenceUtility util = storer.getPersistenceUtility();
        Statement stmt = null;
        ResultSet rs = null;
        Object pch = null;
        PreparedStatement privStmt = null;
        ResultSet privRs = null;
        try {
            String database = SQLServer2005AbstractCapturerPrivilegeExtra.getDatabase(sourceConnection, (MigrationContext)context);
            CloseableIterator schemas = util.getSchemasforCatalogId((DBObjectId)context.getContextVariable("CATALOGID"));
            ArrayList<MdUser> usersAL = new ArrayList<MdUser>();
            while (schemas.hasNext()) {
                CloseableIterator users = util.getUsersforSchemaId(((MdSchema)schemas.next()).getKey());
                while (users.hasNext()) {
                    MdUser mdUser = (MdUser)users.next();
                    usersAL.add(mdUser);
                }
            }
            for (MdGroup agroup : groupAL) {
                String roleName = agroup.getGroupName();
                if (roleName.equals("public")) {
                    for (MdUser auser : usersAL) {
                        MdGroupMember mdGroupMember = new MdGroupMember(agroup.getKey());
                        mdGroupMember.setUserId(auser.getKey());
                        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)146), roleName);
                        context.getAudience().fireListeners(event);
                        mdGroupMember = (MdGroupMember)storer.storeObject((PersistableObject)mdGroupMember);
                        event.setEventId(4);
                    }
                    continue;
                }
                String memberinfo = this.captureRoleMembershipString(database);
                privStmt = null;
                privRs = null;
                try {
                    String sql = memberinfo;
                    privStmt = sourceConnection.prepareStatement(sql);
                    if (!isOnline) {
                        privStmt.setString(1, database);
                        privStmt.setString(2, roleName);
                    } else {
                        privStmt.setString(1, roleName);
                    }
                    privRs = privStmt.executeQuery();
                    while (privRs.next()) {
                        String member = privRs.getString(1);
                        DBObjectId userIdMatch = null;
                        DBObjectId groupIdMatch = null;
                        for (MdUser mdUser : usersAL) {
                            if (!mdUser.getUsername().equals(member)) continue;
                            userIdMatch = mdUser.getKey();
                            break;
                        }
                        if (userIdMatch == null) {
                            for (MdGroup agroup2 : groupAL) {
                                if (!agroup2.getGroupName().equals(member)) continue;
                                groupIdMatch = agroup2.getKey();
                                break;
                            }
                        }
                        if (userIdMatch == null && groupIdMatch == null) continue;
                        MdGroupMember mdGroupMember = new MdGroupMember(agroup.getKey());
                        if (userIdMatch != null) {
                            mdGroupMember.setUserId(userIdMatch);
                        } else {
                            if (groupIdMatch == null) continue;
                            mdGroupMember.setGroupMemberId(groupIdMatch);
                        }
                        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)146), roleName);
                        context.getAudience().fireListeners(event);
                        mdGroupMember = (MdGroupMember)storer.storeObject((PersistableObject)mdGroupMember);
                        event.setEventId(4);
                    }
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close(privStmt, privRs);
                    throw throwable;
                    return;
                }
                CloseableResultSet.close((Statement)privStmt, (ResultSet)privRs);
            }
        }
        finally {
            CloseableResultSet.close(stmt, rs);
            if (pch != null) {
                try {
                    pch.close();
                }
                catch (Exception io) {
                    MigrationLogUtil.logThrowable((String)io.getLocalizedMessage(), (String)"Capture", (Throwable)io);
                }
            }
        }
    }

    public static DBObjectId getIdInRepo(PersistenceUtility util, String type, DBObjectId schemaId, String name) throws PersistenceException {
        if (type.equals("FN") || type.equals("IF") || type.trim().equals("P") || type.equals("TF") || type.trim().equals("X")) {
            return util.getIdForStoredProgram(schemaId, name);
        }
        if (type.trim().equals("U")) {
            return util.getIdForTable(schemaId, name);
        }
        if (type.trim().equals("V")) {
            return util.getIdForView(schemaId, name);
        }
        return null;
    }

    public static DBObjectId getSchemaIdForRoleUser(PersistenceUtility util, DBObjectId catalogId, String roleUser) throws PersistenceException {
        try {
            return util.getSchemaIdForUser(catalogId, roleUser);
        }
        catch (PersistenceException e) {
            return util.getSchemaIdForGroup(catalogId, roleUser);
        }
    }

    public static String getDatabase(Connection sourceConnection, MigrationContext context) {
        String database = null;
        MdCatalog catalog = (MdCatalog)context.getContextVariable("CATALOG");
        database = catalog.getCatalogName();
        return database;
    }
}

