/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.SQLServer2005AbstractCapturer;
import oracle.dbtools.migration.workbench.plugin.SQLServer2005CaptureQueries;
import oracle.dbtools.migration.workbench.plugin.SQLServer2005OfflineCapturerPrivilegeExtra;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLServer2005CaptureObjectsOfflineCapturer
extends SQLServer2005AbstractCapturer {
    private static SQLServer2005CaptureQueries s_captureQueries;

    @Override
    protected String andExistsTablesOrProcedures() {
        return "and exists (select 1 from SS2k5_objects o where o.schema_id = s.schema_id and o.db_id = d.database_id) ";
    }

    @Override
    protected String getDatabasesString() {
        return "select d.name from SS2K5_DATABASES d where d.db_id=1 and d.DATABASE_ID in  (select distinct(s.db_id) from SS2K5_SCHEMAS s)";
    }

    @Override
    protected String getSchemasString(String database) {
        return "select s.name from SS2K5_SCHEMAS s, SS2K5_DATABASES d where d.name = ? and  s.schema_id<16384 and s.db_id = d.database_id  and s.NAME!='INFORMATION_SCHEMA' and s.name!='sys' " + this.andExistsTablesOrProcedures();
    }

    @Override
    protected String getSchemaOwnerString(String database) {
        return "select s.SCHEMA_OWNER from SS2K5_SCHEMATA s, SS2K5_DATABASES d  where d.name = ? and s.db_id = d.database_id and s.SCHEMA_NAME=? ";
    }

    @Override
    protected String getSchemaString(String database) {
        return "select d.name, s.name from SS2K5_DATABASE_PRINCIPALS  d,  SS2K5_SERVER_PRINCIPALS s, SS2K5_DATABASES dd where dd.name = ? and s.db_id = dd.database_id  and d.db_id = dd.database_id  and ((s.sid = d.sid )OR(d.name='dbo' and s.name='sa')) and d.default_schema_name= ? and (d.type='U' or d.type='S')";
    }

    @Override
    protected String getTablesString(String database) {
        return "Select a.name, a.object_id from SS2K5_TABLES a, SS2K5_SCHEMAS b, SS2K5_DATABASES d where  d.name = ? and b.db_id = d.database_id and a.db_id = d.database_id and b.name = ? and a.schema_id = b.schema_id ";
    }

    @Override
    protected String getColumnsString(String database, int tableId) {
        return "select DISTINCT a.\"NAME\", 'dummy',  c.\"NAME\", c.\"COLUMN_ID\", d.\"NAME\",  c.\"MAX_LENGTH\", c.\"PRECISION\", c.\"SCALE\", c.\"IS_NULLABLE\",  c.\"USER_TYPE_ID\", c.\"SYSTEM_TYPE_ID\", c.\"DEFAULT_OBJECT_ID\",  UPPER(a.\"NAME\") from SS2K5_OBJECTS a, SS2K5_COLUMNS c, SS2K5_TYPES d,  SS2K5_DATABASES dd where dd.name = ? and  dd.database_id = c.db_id and d.db_id =  dd.database_id and a.db_id = dd.database_id  and a.\"TYPE\"='U'  and a.object_id = " + tableId + " and a.object_id = c.object_id " + " and d.\"USER_TYPE_ID\" = c.\"USER_TYPE_ID\" " + " order by UPPER(a.\"NAME\"), c.\"COLUMN_ID\" ";
    }

    @Override
    protected String getIdentityString(String database, int tableId, int colId) {
        return "select cast(seed_value as  number(10,0)), cast(increment_value as  number(10,0)),  cast(last_value as  number(10,0)) from SS2K5_IDENTITY_COLUMNS i, SS2K5_DATABASES d where d.name = ? and i.db_id = d.database_id and i.object_id=" + tableId + " and i.column_id=" + colId;
    }

    @Override
    protected String getBaseTypeString(String database, int typeNumber) {
        return " SELECT a.\"NAME\"  FROM SS2K5_TYPES a, SS2K5_DATABASES d  WHERE d.name = ? and a.db_id=d.database_id and a.\"SYSTEM_TYPE_ID\" = " + typeNumber + " ORDER BY a.\"USER_TYPE_ID\" ";
    }

    @Override
    protected String getColumnDefaultString(String database, int defaultId) {
        return "SELECT a.\"DEFINITION\"  FROM SS2K5_DEFAULT_CONSTRAINTS a, SS2K5_DATABASES d  WHERE d.name = ? and a.db_id = d.database_id and a.\"OBJECT_ID\" = " + defaultId;
    }

    @Override
    protected String getCaptureIndexString(String database) {
        return " SELECT i.\"OBJECT_ID\", i.\"INDEX_ID\", i.\"NAME\",  i.\"IS_UNIQUE\", o.\"NAME\", o.\"OBJECT_ID\"  FROM  SS2K5_INDEXES i, SS2K5_OBJECTS o,  SS2K5_DATABASES d WHERE d.name = ? and i.db_id = d.database_id and o.db_id = d.database_id and " + this.getXTypeWhereInIndex() + " AND   o.\"OBJECT_ID\" = i.\"OBJECT_ID\"        " + " AND " + this.getForCaptureIndex() + " AND   o.schema_id=(select s.schema_id from SS2K5_SCHEMAS s where s.db_id = d.database_id and s.name = ?) AND o.\"NAME\" " + " = ? and i.is_primary_key = 0 ";
    }

    @Override
    protected String getIndexString(String database, int tableId, int indId) {
        return " SELECT a.index_column_id, b.name  FROM SS2K5_INDEX_COLUMNS a , SS2K5_COLUMNS b, SS2K5_DATABASES d  WHERE d.name = ? and d.database_id = b.db_id and a.db_id=d.database_id and a.object_id = " + tableId + " AND b.object_id = a.object_id " + " AND b.column_id = a.column_id " + " AND a.index_id = " + indId;
    }

    @Override
    protected String captureUniqueAndPrimaryKeysString(String database) {
        return " SELECT a.NAME, a2.name,  a.object_id, c.index_column_id, d.name, c.object_id, b.index_id , a.TYPE/*, a.status */  FROM SS2K5_OBJECTS a2, SS2K5_OBJECTS a, SS2K5_INDEXES b, SS2K5_INDEX_COLUMNS c, SS2K5_COLUMNS d,  SS2K5_OBJECTS e, SS2K5_DATABASES dd  WHERE dd.name = ? and dd.database_id = b.db_id  and dd.database_id=c.db_id  and dd.database_id=d.db_id and dd.database_id=e.db_id and a.db_id = dd.database_id and  (a.type='PK' OR a.type='UQ')  AND a2.object_id = a.parent_object_id  AND a.name=b.name and a2.name = ?  and e.schema_id = (select s.schema_id from SS2K5_SCHEMAS s where s.db_id = dd.database_id  and s.name = ?) AND  c.object_id = b.object_id AND c.index_id = b.index_id  and  b.object_id=a.parent_object_id  AND d.object_id = c.object_id  AND d.column_id = c.column_id AND e.object_id = a.object_id  AND " + this.getXTypeWhere() + " ORDER BY a.object_id, c.column_id";
    }

    @Override
    protected String captureForeignKeysStringString(String database) {
        return "select fk.name, fkc.constraint_object_id, lc.name,  (select s.name from SS2K5_SCHEMAS s where s.db_id = d.database_id and s.schema_id = rt.schema_id),  rt.name, rc.name, fkc.constraint_column_id from SS2K5_FOREIGN_KEYS fk, SS2K5_FOREIGN_KEY_COLUMNS  fkc, SS2K5_COLUMNS lc, SS2K5_COLUMNS rc, SS2K5_TABLES rt, SS2K5_TABLES lt, SS2K5_DATABASES d  where d.name = ? and fk.db_id=d.database_id and fkc.db_id=d.database_id and d.database_id=  lc.db_id and d.database_id=rc.db_id and d.database_id=rt.db_id and d.database_id=lt.db_id and  fk.object_id = fkc.constraint_object_id and lc.object_id = fkc.parent_object_id and  lc.column_id = fkc.parent_column_id and rc.object_id = fkc.referenced_object_id and  rc.column_id = fkc.referenced_column_id and fkc.referenced_object_id = rt.object_id and  rt.type = 'U' and fkc.parent_object_id = lt.object_id and lt.schema_id=(select s.schema_id  from SS2K5_SCHEMAS s where s.db_id = d.database_id and s.name = ?) and  lt.name=? order by fkc.constraint_object_id, fkc.constraint_column_id ";
    }

    @Override
    protected String captureTableLevelCheckConstraintString(String database) {
        return "SELECT a.\"NAME\", d.\"DEFINITION\", d.\"OBJECT_ID\"  FROM SS2K5_OBJECTS a, SS2K5_OBJECTS a2, SS2K5_OBJECTS c, SS2K5_CHECK_CONSTRAINTS d, SS2K5_DATABASES dd  WHERE  dd.name = ? and a.db_id=dd.database_id and dd.database_id=a2.db_id and dd.database_id  = c.db_id and dd.database_id = d.db_id and a.\"TYPE\"='C'  AND a.object_id = c.object_id   AND d.\"OBJECT_ID\" = a.\"OBJECT_ID\"  AND d.\"PARENT_COLUMN_ID\" = 0 AND a.parent_object_id = a2.object_id and a2.name= ?  AND c.schema_id = (select s.schema_id from SS2K5_SCHEMAS s where s.db_id = dd.database_id and s.name = ?) ";
    }

    @Override
    protected String captureColumnLevelCheckConstraintString(String database) {
        return "SELECT a.\"NAME\", 1 ,  d.\"PARENT_COLUMN_ID\", d.\"DEFINITION\", d.\"OBJECT_ID\",  s.\"NAME\" FROM SS2K5_OBJECTS a, SS2K5_OBJECTS a2, SS2K5_OBJECTS c, SS2K5_CHECK_CONSTRAINTS d  , SS2K5_COLUMNS s, SS2K5_DATABASES dd  WHERE  dd.name = ? and a.db_id=dd.database_id and dd.database_id=a2.db_id and dd.database_id=c.db_id  and dd.database_id=d.db_id and dd.database_id=s.db_id and a.\"TYPE\"='C'  AND a.\"OBJECT_ID\" =  c.object_id   AND d.\"OBJECT_ID\" = a.\"OBJECT_ID\"  AND d.\"PARENT_COLUMN_ID\" <> 0 AND a.parent_object_id =  a2.object_id and a2.name= ?  AND c.schema_id = (select s.schema_id from SS2K5_SCHEMAS s where s.db_id = dd.database_id and s.name  = ?) and a2.object_id = s.object_id and d.\"PARENT_COLUMN_ID\" = s.column_id ";
    }

    @Override
    protected String captureRulesString(String database) {
        return " SELECT DISTINCT a.\"NAME\",  b.\"NAME\", b.\"NAME\", b.\"RULE_OBJECT_ID\"  FROM SS2K5_OBJECTS a, SS2K5_COLUMNS b, SS2K5_OBJECTS c, SS2K5_DATABASES d WHERE d.name = ? and a.db_id=d.database_id and d.database_id = b.db_id and d.database_id = c.db_id and  a.\"NAME\" = ?  AND c.schema_id = (select s.schema_id from SS2K5_SCHEMAS s where s.db_id = d.database_id and s.name = ?)  AND a.\"TYPE\" = 'U'  AND b.\"OBJECT_ID\" = a.\"OBJECT_ID\"  AND c.object_id = a.\"OBJECT_ID\"  AND b.\"RULE_OBJECT_ID\" >  0 ";
    }

    @Override
    protected String captureRulesTextString(String database) {
        return " SELECT m.\"DEFINITION\" FROM SS2K5_SQL_MODULES m, SS2K5_DATABASES d WHERE d.name = ? and m.db_id  =d.database_id and m.\"OBJECT_ID\" = ? ";
    }

    @Override
    protected String captureViewOuterString(String database) {
        return "SELECT a.\"OBJECT_ID\", a.\"NAME\"  FROM SS2K5_OBJECTS a, SS2K5_OBJECTS b, SS2K5_DATABASES d  WHERE d.name = ? and a.db_id=d.database_id and d.database_id = b.db_id and a.\"TYPE\"='V'  AND a.\"OBJECT_ID\" = b.object_id  and b.schema_id=(select s.schema_id from SS2K5_SCHEMAS s  where s.db_id = d.database_id and s.name = ?) and a.is_ms_shipped=0 ";
    }

    @Override
    protected String captureViewInnerString(String database) {
        return "SELECT a.\"NAME\", 1, b.DEFINITION  FROM SS2K5_OBJECTS a, SS2K5_SQL_MODULES b, SS2K5_OBJECTS c,  SS2K5_DATABASES d  WHERE d.name = ? and a.db_id=d.database_id and d.database_id=b.db_id and d.database_id=c.db_id and  a.\"TYPE\"='V' AND a.\"OBJECT_ID\" = b.\"OBJECT_ID\" AND a.\"OBJECT_ID\" = ? AND a.\"OBJECT_ID\" = c.object_id  AND a.\"OBJECT_ID\" = b.\"OBJECT_ID\" and a.is_ms_shipped=0  ";
    }

    @Override
    protected String captureStoredProgramOuterString(String database) {
        return "SELECT  a.\"OBJECT_ID\", a.\"NAME\"  FROM   SS2K5_OBJECTS a, SS2K5_OBJECTS b, SS2K5_DATABASES d   WHERE d.name = ? and a.db_id=d.database_id and d.database_id = b.db_id and " + this.getWhereForStoredPrograms() + " AND a.object_id = b.object_id  " + " AND a.is_ms_shipped=0 " + " AND b.schema_id = (select s.schema_id from SS2K5_SCHEMAS s where s.db_id = d.database_id and s.name = ?)";
    }

    @Override
    protected String captureStoredProgramInnerString(String database, String queryAdd) {
        return " SELECT a.\"NAME\", a.\"OBJECT_ID\", 1, b.DEFINITION, a.type   FROM   SS2K5_OBJECTS a, SS2K5_SQL_MODULES b, SS2K5_OBJECTS c, SS2K5_DATABASES d   WHERE d.name = ? and a.db_id = d.database_id and d.database_id = b.db_id and d.database_id=c.db_id and " + this.getWhereForStoredPrograms() + " AND a.\"OBJECT_ID\" = b.\"OBJECT_ID\"  " + " AND a.object_id = c.object_id  " + " AND a.is_ms_shipped=0 " + " AND a.\"OBJECT_ID\" = ? " + queryAdd;
    }

    @Override
    protected String captureTriggersString(String database) {
        return " SELECT a.\"NAME\", a.\"OBJECT_ID\", 1, b.DEFINITION  FROM   SS2K5_OBJECTS a, SS2K5_SQL_MODULES b, SS2K5_OBJECTS c, SS2K5_OBJECTS d, SS2K5_DATABASES dd  WHERE dd.name = ? and a.db_id=dd.database_id and dd.database_id = b.db_id and dd.database_id =  c.db_id and dd.database_id=d.db_id and a.\"TYPE\" = 'TR'  AND a.\"OBJECT_ID\" = b.\"OBJECT_ID\"   AND d.\"OBJECT_ID\" = c.object_id   AND a.is_ms_shipped=0  AND c.schema_id = (select s.schema_id from SS2K5_SCHEMAS s where s.db_id =  dd.database_id and s.name = ?)  AND d.\"NAME\" = ?  AND a.parent_object_id=d.object_id  order by a.\"OBJECT_ID\" ";
    }

    @Override
    protected String captureRolesString(String database) {
        return "select b.name, a.default_schema_name from SS2K5_DATABASE_PRINCIPALS a, SS2K5_DATABASE_PRINCIPALS b,  SS2K5_DATABASES d where d.name = ? and a.db_id=d.database_id and d.database_id = b.db_id and b.type = 'R' and b.owning_principal_id=a.principal_id ";
    }

    public SQLServer2005CaptureObjectsOfflineCapturer(MigrationStorer storer, Connection sourceConnection) {
        super(storer, sourceConnection);
        this.m_online = false;
        this.setStorer(storer);
        this.m_repositoryConnection = sourceConnection;
    }

    @Override
    protected void capturePrivileges(Connection sourceConnection, MigrationStorer storer, CaptureContext context, ArrayList<MdGroup> groupAL, MdGroup role, MdUser user) throws SQLException, PersistenceException {
        new SQLServer2005OfflineCapturerPrivilegeExtra().capturePrivileges(this.getRepositoryConnection(), this.getStorer(), context, groupAL, role, user, this.m_online);
    }

    @Override
    protected void captureRoleMembership(Connection sourceConnection, MigrationStorer storer, CaptureContext context, ArrayList<MdGroup> groupAL) throws SQLException, PersistenceException {
        new SQLServer2005OfflineCapturerPrivilegeExtra().captureRoleMembership(this.getRepositoryConnection(), this.getStorer(), context, groupAL, this.m_online);
    }

    @Override
    public String getModelName() throws CaptureException {
        return null;
    }

    @Override
    public String getSourceURL() throws CaptureException {
        return "/tmp/sqlserver2005";
    }

    @Override
    public void setStorer(MigrationStorer storer) {
        this.m_storer = storer;
    }

    @Override
    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    @Override
    public Connection getRepositoryConnection() {
        return this.m_repositoryConnection;
    }

    @Override
    public void setRepositoryConnection(Connection repositoryConnection) {
        this.m_repositoryConnection = repositoryConnection;
    }

    @Override
    protected String captureCommentsString() {
        return "select value from SS2K5_SYSPROPERTIES where major_id=? and minor_id=?";
    }
}

