/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.SQLServer2005AbstractCapturer;
import oracle.dbtools.migration.workbench.plugin.SQLServer2005CaptureQueries;
import oracle.dbtools.migration.workbench.plugin.SQLServer2005OnlineCapturerPrivilegeExtra;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLServer2005CaptureObjectsOnlineCapturer
extends SQLServer2005AbstractCapturer {
    private static SQLServer2005CaptureQueries s_captureQueries;

    @Override
    protected String andExistsTablesOrProcedures() {
        return " and exists (select 1 from [{0}].sys.objects o where o.schema_id = s.schema_id) ";
    }

    @Override
    protected String getDatabasesString() {
        return "select d.name from master.sys.databases d where 1=1";
    }

    @Override
    protected String getSchemasString(String database) {
        return MessageFormat.format("select s.name from [{0}].sys.schemas s where s.schema_id<16384  and s.name!=''INFORMATION_SCHEMA'' and s.name!=''sys'' " + this.andExistsTablesOrProcedures(), database);
    }

    @Override
    protected String getSchemaOwnerString(String database) {
        return "select SCHEMA_OWNER from [" + database + "].INFORMATION_SCHEMA.SCHEMATA " + " where SCHEMA_NAME=? ";
    }

    @Override
    protected String getSchemaString(String database) {
        return "select d.name, s.name from [" + database + "].sys.database_principals " + " d,  [" + database + "].sys.server_principals s where " + " ((s.sid = d.sid )OR(d.name='dbo' and s.name='sa')) and d.default_schema_name= ? " + "and (d.type='U' or d.type='S')";
    }

    @Override
    protected String getTablesString(String database) {
        return "Select a.name, a.object_id from [" + database + "].sys.tables a, [" + database + "].sys.schemas b where b.name = ? and a.schema_id = b.schema_id";
    }

    @Override
    protected String getColumnsString(String database, int tableId) {
        return "select DISTINCT a.name, 'dummy',  c.name, c.column_id, d.name,  c.max_length, c.precision, c.scale, c.is_nullable,  c.user_type_id, c.system_type_id, c.default_object_id,  UPPER(a.name) from [" + database + "].sys.objects a, [" + database + "].sys.columns c, " + " [" + database + "].sys.types d" + " where a.\"TYPE\"='U' " + " and a.object_id = " + tableId + " and a.object_id = c.object_id " + " and d.user_type_id = c.user_type_id " + " order by UPPER(a.name), c.column_id ";
    }

    @Override
    protected String getIdentityString(String database, int tableId, int colId) {
        return "select cast(seed_value as bigint), cast(increment_value as bigint),  cast(last_value as bigint) from [" + database + "].sys.identity_columns i where i.object_id=" + tableId + " and i.column_id=" + colId;
    }

    @Override
    protected String getBaseTypeString(String database, int typeNumber) {
        return " SELECT a.name  FROM [" + database + "].sys.types a " + " WHERE a.system_type_id = " + typeNumber + " ORDER BY a.user_type_id ";
    }

    @Override
    protected String getColumnDefaultString(String database, int defaultId) {
        return "SELECT a.definition  FROM [" + database + "].sys.default_constraints a " + " WHERE a.object_id = " + defaultId;
    }

    @Override
    protected String getCaptureIndexString(String database) {
        return " SELECT i.object_id, i.index_id, i.name,  i.is_unique, o.name, o.object_id  FROM  [" + database + "].sys.indexes i, [" + database + "].sys.objects o " + " WHERE " + this.getXTypeWhereInIndex() + " AND   o.object_id = i.object_id        " + " AND " + this.getForCaptureIndex() + " AND   o.schema_id=schema_id(?) AND o.name = ? and i.is_primary_key = 0 ";
    }

    @Override
    protected String getIndexString(String database, int tableId, int indId) {
        return " SELECT a.index_column_id, b.name  FROM [" + database + "].sys.index_columns a , [" + database + "].sys.columns b " + " WHERE a.object_id = " + tableId + " AND b.object_id = a.object_id " + " AND b.column_id = a.column_id " + " AND a.index_id = " + indId;
    }

    @Override
    protected String captureUniqueAndPrimaryKeysString(String database) {
        return " SELECT a.name, a2.name,  a.object_id, c.index_column_id, d.name, c.object_id, b.index_id , a.type  /*, a.status */  FROM [" + database + "].sys.objects a2, [" + database + "].sys.objects a, [" + database + "].sys.indexes b, [" + database + "].sys.index_columns c, [" + database + "].sys.columns d, [" + database + "].sys.objects e  WHERE (a.type='PK' OR a.type='UQ') AND a2.object_id = a.parent_object_id " + " AND a.name=b.name and a2.name = ? " + " and e.schema_id = schema_id(?) AND c.object_id = b.object_id AND c.index_id = b.index_id " + " and  b.object_id=a.parent_object_id " + " AND d.object_id = c.object_id  AND d.column_id = c.column_id AND e.object_id = a.object_id " + " AND " + this.getXTypeWhere() + " ORDER BY a.object_id, c.column_id";
    }

    @Override
    protected String captureForeignKeysStringString(String database) {
        return "use [" + database + "] select fk.name, fkc.constraint_object_id, lc.name, " + " schema_name(rt.schema_id), rt.name, rc.name, fkc.constraint_column_id from [" + database + "].sys.foreign_keys fk, " + "[" + database + "].sys.foreign_key_columns fkc, [" + database + "].sys.columns lc, [" + database + "].sys.columns rc, [" + database + "].sys.tables rt, [" + database + "].sys.tables lt " + "where fk.object_id = fkc.constraint_object_id and lc.object_id = fkc.parent_object_id and " + "lc.column_id = fkc.parent_column_id and rc.object_id = fkc.referenced_object_id and " + "rc.column_id = fkc.referenced_column_id and fkc.referenced_object_id = rt.object_id and " + "rt.type = 'U' and fkc.parent_object_id = lt.object_id and schema_name(lt.schema_id)=? and " + "lt.name=? order by fkc.constraint_object_id, fkc.constraint_column_id ";
    }

    @Override
    protected String captureTableLevelCheckConstraintString(String database) {
        return "use [" + database + "] SELECT a.name, d.definition, d.object_id " + "FROM [" + database + "].sys.objects a, [" + database + "].sys.objects a2, [" + database + "].sys.objects c, [" + database + "].sys.check_constraints d " + " WHERE a.type='C' " + " AND a.object_id = c.object_id  " + " AND d.object_id = a.object_id " + " AND d.parent_column_id = 0 AND a.parent_object_id = a2.object_id and a2.name= ? " + " AND c.schema_id = schema_id(?) ";
    }

    @Override
    protected String captureColumnLevelCheckConstraintString(String database) {
        return "use [" + database + "] SELECT a.name, 1 , " + " d.parent_column_id, d.definition, d.object_id, " + " s.name FROM [" + database + "].sys.objects a, [" + database + "].sys.objects a2, [" + database + "].sys.objects c, [" + database + "].sys.check_constraints d " + " , [" + database + "].sys.columns s " + " WHERE a.type='C' " + " AND a.object_id = c.object_id  " + " AND d.object_id = a.object_id " + " AND d.parent_column_id <> 0 AND " + " a.parent_object_id = a2.object_id and a2.name= ? " + " AND c.schema_id = schema_id(?) and a2.object_id = s.object_id and " + " d.parent_column_id = s.column_id ";
    }

    @Override
    protected String captureRulesString(String database) {
        return " SELECT DISTINCT a.name,  b.name, b.name, b.rule_object_id  FROM [" + database + "].sys.objects a, [" + database + "].sys.columns b, [" + database + "].sys.objects c" + " WHERE a.name = ? AND c.schema_id = schema_id(?) " + " AND a.type = 'U' " + " AND b.object_id = a.object_id " + " AND c.object_id = a.object_id " + " AND b.rule_object_id >  0 ";
    }

    @Override
    protected String captureRulesTextString(String database) {
        return " SELECT definition FROM [" + database + "].sys.sql_modules " + " WHERE object_id = ? ";
    }

    @Override
    protected String captureViewOuterString(String database) {
        return "use [" + database + "] SELECT a.object_id, a.name " + " FROM [" + database + "].sys.objects a, [" + database + "].sys.objects b " + " WHERE a.type='V' " + " AND a.object_id = b.object_id " + " and b.schema_id=schema_id(?) and a.is_ms_shipped=0 ";
    }

    @Override
    protected String captureViewInnerString(String database) {
        return "SELECT DISTINCT a.name, 1, b.definition  FROM [" + database + "].sys.objects a, [" + database + "].sys.sql_modules b, [" + database + "].sys.objects c " + " WHERE a.type='V' AND a.object_id = b.object_id AND a.object_id = ? " + " AND a.object_id = c.object_id " + " AND a.object_id = b.object_id and a.is_ms_shipped=0  ";
    }

    @Override
    protected String captureStoredProgramOuterString(String database) {
        return " use [" + database + "] SELECT  a.object_id, a.name " + " FROM   [" + database + "].sys.objects a, [" + database + "].sys.objects b  " + " WHERE  " + this.getWhereForStoredPrograms() + " AND a.object_id = b.object_id  " + " AND a.is_ms_shipped=0 " + " AND b.schema_id = schema_id(?)";
    }

    @Override
    protected String captureStoredProgramInnerString(String database, String queryAdd) {
        return " SELECT a.name, a.object_id, 1, b.definition, a.type   FROM   [" + database + "].sys.objects a, [" + database + "].sys.sql_modules b, [" + database + "].sys.objects c  " + " WHERE  " + this.getWhereForStoredPrograms() + " AND a.object_id = b.object_id  " + " AND a.object_id = c.object_id  " + " AND a.is_ms_shipped=0 " + " AND a.object_id = ? " + queryAdd;
    }

    @Override
    protected String captureTriggersString(String database) {
        return " SELECT a.name, a.object_id, 1, b.definition  FROM   [" + database + "].sys.objects a, [" + database + "].sys.sql_modules b, [" + database + "].sys.objects c,  " + "[" + database + "].sys.objects d " + " WHERE  a.type = 'TR' " + " AND a.object_id = b.object_id  " + " AND d.object_id = c.object_id  " + " AND a.is_ms_shipped=0 " + " AND c.schema_id = schema_id(?) " + " AND d.name = ? " + " AND a.parent_object_id=d.object_id " + " order by a.object_id ";
    }

    @Override
    protected String captureRolesString(String database) {
        return "select b.name, a.default_schema_name from [" + database + "].sys.database_principals a, [" + database + "].sys.database_principals b where b.type = 'R' " + "and b.owning_principal_id=a.principal_id ";
    }

    @Override
    protected void capturePrivileges(Connection sourceConnection, MigrationStorer storer, CaptureContext context, ArrayList<MdGroup> groupAL, MdGroup role, MdUser user) throws SQLException, PersistenceException {
        new SQLServer2005OnlineCapturerPrivilegeExtra().capturePrivileges(this.getRepositoryConnection(), this.getStorer(), context, groupAL, role, user, this.m_online);
    }

    @Override
    protected void captureRoleMembership(Connection sourceConnection, MigrationStorer storer, CaptureContext context, ArrayList<MdGroup> groupAL) throws SQLException, PersistenceException {
        new SQLServer2005OnlineCapturerPrivilegeExtra().captureRoleMembership(this.getRepositoryConnection(), storer, context, groupAL, this.m_online);
    }

    @Override
    public String getModelName() throws CaptureException {
        return null;
    }

    public SQLServer2005CaptureObjectsOnlineCapturer(MigrationStorer storer, Connection sourceConnection) {
        super(storer, sourceConnection);
        this.m_online = true;
        this.setStorer(storer);
        this.m_repositoryConnection = sourceConnection;
    }

    @Override
    public String getSourceURL() throws CaptureException {
        return "/tmp/sqlserver2005";
    }

    @Override
    public void setStorer(MigrationStorer storer) {
        this.m_storer = storer;
    }

    @Override
    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    @Override
    public Connection getRepositoryConnection() {
        return this.m_repositoryConnection;
    }

    @Override
    public void setRepositoryConnection(Connection repositoryConnection) {
        this.m_repositoryConnection = repositoryConnection;
    }

    @Override
    protected String captureCommentsString() {
        return "select value from sys.extended_properties where major_id=? and minor_id=?";
    }
}

