/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.GenerateDSMLFormattedFiles;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.MetadataFileParser;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.ObjectStatusList;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.OracleDatatypeIdentifiers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLServer2005DoOfflineCaptureLoad
implements OracleDatatypeIdentifiers {
    private HashMap<File, ArrayList<File>> _dbXMLMetadataList = new HashMap();
    private HashMap<File, ObjectStatusList> m_dSMLMap = null;
    private String _currentTableName = null;
    private int _currentDbId = 0;
    public String currValue = "";
    private HashMap<String, String[]> m_tableTypes = new HashMap();
    private Connection m_conn = null;

    public SQLServer2005DoOfflineCaptureLoad(Connection inConn) {
        this.m_conn = inConn;
        this.populateTableTypes();
    }

    public void loadSourceModel(HashMap<File, ObjectStatusList> dbs) throws OfflineCaptureException {
        this.m_dSMLMap = dbs;
        Statement stmt = null;
        Connection repConnection = null;
        Object rs = null;
        try {
            repConnection = this.m_conn;
            stmt = repConnection.createStatement();
            GenerateDSMLFormattedFiles dsmlFormattedFiles = new GenerateDSMLFormattedFiles(this.m_dSMLMap);
            this._dbXMLMetadataList = dsmlFormattedFiles.getDSMLFormattedFilesTable();
            File dbFile = this.getDbFile("MASTER");
            if (dbFile == null) {
                throw new OfflineCaptureException(new Exception());
            }
            this._currentDbId = 1;
            this.populateSourceModel(repConnection, dbFile, 1);
            for (File dbFilename : this._dbXMLMetadataList.keySet()) {
                int dbId;
                if (dbFilename.getName().equalsIgnoreCase("MASTER")) continue;
                this._currentDbId = dbId = this.getDbId(repConnection, dbFilename.getName());
                if (dbId == 0) continue;
                this.populateSourceModel(repConnection, dbFilename, dbId);
            }
            this.sourceModelIndexCreate(repConnection);
            repConnection.commit();
        }
        catch (SQLException e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw new OfflineCaptureException((Exception)e);
        }
        catch (Exception e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw new OfflineCaptureException(e);
        }
    }

    private File getDbFile(String dbName) {
        File dbFile = null;
        for (File file : this.m_dSMLMap.keySet()) {
            String nextDbName = file.getName();
            if (!nextDbName.equalsIgnoreCase(dbName)) continue;
            dbFile = file;
            break;
        }
        return dbFile;
    }

    private int getDbId(Connection repConnection, String dbName) throws OfflineCaptureException {
        Statement repStatement = null;
        ResultSet rs = null;
        int dbId = 0;
        try {
            repStatement = repConnection.createStatement();
            String sql = " SELECT database_id FROM SS2K5_DATABASES  WHERE UPPER(NAME) = '" + dbName.toUpperCase() + "' ";
            rs = repStatement.executeQuery(sql);
            while (rs.next()) {
                dbId = rs.getInt(1);
            }
            return dbId;
        }
        catch (SQLException e) {
            throw new OfflineCaptureException((Exception)e);
        }
    }

    private void populateSourceModel(Connection repConnection, File dbName, int dbId) throws OfflineCaptureException {
        try {
            ArrayList<File> xMLMetadataFiles = this._dbXMLMetadataList.get(dbName);
            Iterator<File> i$ = xMLMetadataFiles.iterator();
            while (i$.hasNext()) {
                File f;
                File filename = f = i$.next();
                this._currentTableName = GenerateDSMLFormattedFiles.getUnqualifiedName(filename.getName());
                String[] fieldTypes = this.getFieldTypes(this._currentTableName);
                if (fieldTypes == null) continue;
                MetadataFileParser metaParser = new MetadataFileParser(this._currentDbId, SQLServer2005DoOfflineCaptureLoad.fileToURL(filename), this._currentTableName);
                metaParser.createPrepardStatement(repConnection, fieldTypes);
                int numRecordsLoaded = metaParser.loadData();
            }
        }
        catch (Exception excep) {
            throw new OfflineCaptureException(excep);
        }
    }

    private String[] getFieldTypes(String tableName) {
        String[] tableTypes = null;
        for (String nextElement : this.m_tableTypes.keySet()) {
            if (!tableName.equalsIgnoreCase(nextElement)) continue;
            tableTypes = this.m_tableTypes.get(nextElement.toUpperCase());
            break;
        }
        return tableTypes;
    }

    private void populateTableTypes() {
        String[] columnList1 = new String[]{"3", "1", "3"};
        this.m_tableTypes.put("SS2K5_DATABASES", columnList1);
        String[] columnList2 = new String[]{"3", "1", "1"};
        this.m_tableTypes.put("SS2K5_SCHEMATA", columnList2);
        String[] columnList3 = new String[]{"3", "1", "1", "1", "1", "1", "1"};
        this.m_tableTypes.put("SS2K5_TABLE_PRIVILEGES", columnList3);
        String[] columnList4 = new String[]{"3", "3", "3", "4"};
        this.m_tableTypes.put("SS2K5_CHECK_CONSTRAINTS", columnList4);
        String[] columnList5 = new String[]{"3", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K5_COLUMNS", columnList5);
        String[] columnList6 = new String[]{"3", "1", "8", "3", "3", "1", "6"};
        this.m_tableTypes.put("SS2K5_DATABASE_PRINCIPALS", columnList6);
        String[] columnList7 = new String[]{"3", "3", "3"};
        this.m_tableTypes.put("SS2K5_DATABASE_ROLE_MEMBERS", columnList7);
        String[] columnList8 = new String[]{"3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K5_FOREIGN_KEY_COLUMNS", columnList8);
        String[] columnList9 = new String[]{"3", "1", "3"};
        this.m_tableTypes.put("SS2K5_FOREIGN_KEYS", columnList9);
        String[] columnList10 = new String[]{"3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K5_IDENTITY_COLUMNS", columnList10);
        String[] columnList11 = new String[]{"3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K5_INDEX_COLUMNS", columnList11);
        String[] columnList12 = new String[]{"3", "3", "3", "1", "3", "3"};
        this.m_tableTypes.put("SS2K5_INDEXES", columnList12);
        String[] columnList13 = new String[]{"3", "3", "3", "1", "8", "3", "3"};
        this.m_tableTypes.put("SS2K5_OBJECTS", columnList13);
        String[] columnList14 = new String[]{"3", "3", "1"};
        this.m_tableTypes.put("SS2K5_SCHEMAS", columnList14);
        String[] columnList15 = new String[]{"3", "1", "6", "8"};
        this.m_tableTypes.put("SS2K5_SERVER_PRINCIPALS", columnList15);
        String[] columnList16 = new String[]{"3", "4", "3"};
        this.m_tableTypes.put("SS2K5_SQL_MODULES", columnList16);
        String[] columnList17 = new String[]{"3", "1", "3", "3", "8"};
        this.m_tableTypes.put("SS2K5_TABLES", columnList17);
        String[] columnList18 = new String[]{"3", "1", "3", "3"};
        this.m_tableTypes.put("SS2K5_TYPES", columnList18);
        String[] columnList19 = new String[]{"3", "4", "3"};
        this.m_tableTypes.put("SS2K5_DEFAULT_CONSTRAINTS", columnList19);
        String[] columnList20 = new String[]{"3", "3", "3", "1", "1"};
        this.m_tableTypes.put("SS7_SYSPROPERTIES", columnList20);
    }

    private static URL fileToURL(File file) {
        String path = file.getAbsolutePath();
        String fSep = System.getProperty("file.separator");
        if (fSep != null && fSep.length() == 1) {
            path = path.replace(fSep.charAt(0), '/');
        }
        if (path.length() > 0 && path.charAt(0) != '/') {
            path = '/' + path;
        }
        try {
            return new URL("file", null, path);
        }
        catch (MalformedURLException e) {
            System.out.println("EXCEPTION :SQLServer2KDisconnSourceModelLoad.fileToURL(): " + e.toString());
            throw new Error("Unexpected MalformedURLException");
        }
    }

    private void sourceModelIndexCreate(Connection repConn) throws OfflineCaptureException {
        Statement stmt1 = null;
        ArrayList<String> indexStatements = new ArrayList<String>();
        try {
            indexStatements.add("CREATE INDEX SS2K5_DATABASES_DB_ID ON SS2K5_DATABASES (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_DATABASES_NAME ON SS2K5_DATABASES (\"NAME\")");
            indexStatements.add("CREATE INDEX SS2K5_DATABASES_DATABASE_ID ON SS2K5_DATABASES (\"DATABASE_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_SCHEMATA_DB_ID ON SS2K5_SCHEMATA (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_SCHEMATA_SCHEMA_NAME ON SS2K5_SCHEMATA (\"SCHEMA_NAME\")");
            indexStatements.add("CREATE INDEX SS2K5_TABLE_PRIVILEGES_DB_ID ON SS2K5_TABLE_PRIVILEGES (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_T_P_TABLE_SCHEMA ON SS2K5_TABLE_PRIVILEGES  (\"TABLE_SCHEMA\")");
            indexStatements.add("CREATE INDEX SS2K5_T_P_TABLE_NAME ON SS2K5_TABLE_PRIVILEGES (\"TABLE_NAME\")");
            indexStatements.add("CREATE INDEX SS2K5_CHECK_CONSTRAINTS_DB_ID ON SS2K5_CHECK_CONSTRAINTS (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_C_C_OBJECT_ID ON SS2K5_CHECK_CONSTRAINTS (\"OBJECT_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_COLUMNS_DB_ID ON SS2K5_COLUMNS (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_COLUMNS_COLUMN_ID ON SS2K5_COLUMNS (\"COLUMN_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_D_P_DB_ID ON SS2K5_DATABASE_PRINCIPALS (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_D_P_SID ON SS2K5_DATABASE_PRINCIPALS (\"SID\")");
            indexStatements.add("CREATE INDEX SS2K5_D_P_DEFAULT_SCHEMA_NAME  ON SS2K5_DATABASE_PRINCIPALS (\"DEFAULT_SCHEMA_NAME\")");
            indexStatements.add("CREATE INDEX SS2K5_D_R_M_DB_ID ON SS2K5_DATABASE_ROLE_MEMBERS (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_D_R_M_MEMBER_P_ID  ON SS2K5_DATABASE_ROLE_MEMBERS (\"MEMBER_PRINCIPAL_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_D_R_M_ROLE_PRINCIPAL_ID  ON SS2K5_DATABASE_ROLE_MEMBERS (\"ROLE_PRINCIPAL_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_F_K_C_DB_ID ON SS2K5_FOREIGN_KEY_COLUMNS (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_F_K_C_PARENT_OBJECT_ID  ON SS2K5_FOREIGN_KEY_COLUMNS (\"PARENT_OBJECT_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_F_K_C_R_O_ID  ON SS2K5_FOREIGN_KEY_COLUMNS (\"REFERENCED_OBJECT_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_FOREIGN_KEYS_DB_ID ON SS2K5_FOREIGN_KEYS (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_FOREIGN_KEYS_OBJECT_ID ON SS2K5_FOREIGN_KEYS (\"OBJECT_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_IDENTITY_COLUMNS_DB_ID ON SS2K5_IDENTITY_COLUMNS (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_I_C_OBJECT_ID ON SS2K5_IDENTITY_COLUMNS (\"OBJECT_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_INDEX_COLUMNS_DB_ID ON SS2K5_INDEX_COLUMNS (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_INDEX_COLUMNS_OBJECT_ID ON SS2K5_INDEX_COLUMNS (\"OBJECT_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_INDEXES_DB_ID ON SS2K5_INDEXES (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_INDEXES_OBJECT_ID ON SS2K5_INDEXES (\"OBJECT_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_OBJECTS_DB_ID ON SS2K5_OBJECTS (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_OBJECTS_OBJECT_ID ON SS2K5_OBJECTS (\"OBJECT_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_OBJECTS_SCHEMA_ID ON SS2K5_OBJECTS (\"SCHEMA_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_SCHEMAS_DB_ID ON SS2K5_SCHEMAS (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_SCHEMAS_NAME ON SS2K5_SCHEMAS (\"NAME\")");
            indexStatements.add("CREATE INDEX SS2K5_SERVER_PRINCIPALS_DB_ID ON SS2K5_SERVER_PRINCIPALS (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_SERVER_PRINCIPALS_NAME ON SS2K5_SERVER_PRINCIPALS (\"NAME\")");
            indexStatements.add("CREATE INDEX SS2K5_SERVER_PRINCIPALS_SID ON SS2K5_SERVER_PRINCIPALS (\"SID\")");
            indexStatements.add("CREATE INDEX SS2K5_SQL_MODULES_DB_ID ON SS2K5_SQL_MODULES (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_SQL_MODULES_OBJECT_ID ON SS2K5_SQL_MODULES (\"OBJECT_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_DEFAULT_DB_ID ON SS2K5_DEFAULT_CONSTRAINTS (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_DEFAULT_OBJECT_ID ON SS2K5_DEFAULT_CONSTRAINTS (\"OBJECT_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_TABLES_DB_ID ON SS2K5_TABLES (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_TABLES_OBJECT_ID ON SS2K5_TABLES (\"OBJECT_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_TABLES_SCHEMA_ID ON SS2K5_TABLES (\"SCHEMA_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_TYPES_DB_ID ON SS2K5_TYPES (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_TYPES_SYSTEM_TYPE_ID ON SS2K5_TYPES (\"SYSTEM_TYPE_ID\")");
            indexStatements.add("CREATE INDEX SS2K5_TYPES_USER_TYPE_ID ON SS2K5_TYPES (\"USER_TYPE_ID\")");
            stmt1 = repConn.createStatement();
            Iterator i$ = indexStatements.iterator();
            while (i$.hasNext()) {
                String s;
                String sql = s = (String)i$.next();
                try {
                    stmt1.execute(sql);
                }
                catch (SQLException e2) {
                    throw new OfflineCaptureException((Exception)e2);
                }
            }
            stmt1.close();
            indexStatements.clear();
        }
        catch (SQLException e) {
            try {
                if (stmt1 != null) {
                    stmt1.close();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw new OfflineCaptureException((Exception)e);
        }
    }
}

