/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPluginPreferences;
import oracle.dbtools.migration.workbench.plugin.SQLServer2000Plugin;
import oracle.dbtools.migration.workbench.plugin.SQLServer2005DbProvider;
import oracle.dbtools.migration.workbench.plugin.SQLServer2005OfflineCapturer;

public class SQLServer2005Plugin
extends SQLServer2000Plugin {
    protected String getSupportedMapsXMLFileName() {
        return "SQLServer2005SupportedDataTypesMap.xml";
    }

    public String getVersionNumber() {
        return "9.0.0";
    }

    public ThirdPartyDbProvider getProvider(String url) throws MigrationPluginException {
        try {
            SQLServer2005Plugin.loadDriver();
            Connection conn = DriverManager.getConnection(url);
            return new SQLServer2005DbProvider(conn);
        }
        catch (SQLException sqlex) {
            throw new MigrationPluginException((Throwable)sqlex);
        }
    }

    public ThirdPartyDbProvider getProvider(String url, Properties info) throws MigrationPluginException {
        SQLServer2005Plugin.loadDriver();
        try {
            SQLServer2005Plugin.loadDriver();
            Connection conn = DriverManager.getConnection(url, info);
            return new SQLServer2005DbProvider(conn);
        }
        catch (SQLException sqlex) {
            throw new MigrationPluginException((Throwable)sqlex);
        }
    }

    public ThirdPartyDbProvider getProvider(String url, String user, String password) throws MigrationPluginException {
        try {
            SQLServer2005Plugin.loadDriver();
            Connection conn = DriverManager.getConnection(url, user, password);
            return new SQLServer2005DbProvider(conn);
        }
        catch (SQLException sqlex) {
            throw new MigrationPluginException((Throwable)sqlex);
        }
    }

    public ThirdPartyDbProvider getProvider(Connection conn) throws MigrationPluginException {
        return new SQLServer2005DbProvider(conn);
    }

    protected static void loadDriver() throws MigrationPluginException {
        if (!s_driverLoaded) {
            try {
                Class.forName("net.sourceforge.jtds.jdbc.Driver").newInstance();
                s_driverLoaded = true;
            }
            catch (ClassNotFoundException cnfe) {
                throw new MigrationPluginException((Throwable)cnfe);
            }
            catch (InstantiationException ie) {
                throw new MigrationPluginException((Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                throw new MigrationPluginException((Throwable)iae);
            }
        }
    }

    public MigrationPluginPreferences getPreferencePanel() {
        return null;
    }

    public String getPublishedVersion() {
        return "2005";
    }

    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String platform, int major, int minor, String productversion) {
        if (platform.equals(this.getPlatformName()) && major == 9) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
    }

    public int getPlatformMask() {
        return 64;
    }

    public OfflineCapturer getOfflineCapturer() {
        return new SQLServer2005OfflineCapturer(null, null);
    }
}

