/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.metadata.persistence.PrepareClobHelper;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.core.MigrationContext;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.plugin.SQLServer7CaptureQueries;
import oracle.dbtools.migration.workbench.plugin.SQLServer7CapturerColumnInfo;
import oracle.dbtools.migration.workbench.plugin.SQLServer7CapturerColumnsBySelect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQLServer7AbstractCapturer {
    protected Connection m_repositoryConnection = null;
    protected MigrationStorer m_storer = null;
    public static final String MY_LANGUAGE_ID = "MSTSQL";
    public static final String NEWID_FUNCTION = "(newid())";
    public static final String DDL_NOT_ACCESSIBLE = "/* ddl not accessible */";
    protected boolean m_online = true;
    public static String[] s_sqlServerDatabasesToSkip = new String[]{"master", "msdb", "tempdb", "model"};
    private static String s_sqlServerDatabaseToUse = null;
    private static SQLServer7CaptureQueries s_captureQueries;

    public static String getSqlServerDatabaseToUse() {
        return s_sqlServerDatabaseToUse;
    }

    public static void setSqlServerDatabaseToUse(String inDatabase) {
        s_sqlServerDatabaseToUse = inDatabase;
    }

    protected abstract String getShowUsersInDatabase(String var1);

    protected abstract String andExistsTablesOrProcedures(String var1);

    protected String getXTypeWhere() {
        return " a2.xtype = 'U' ";
    }

    protected String getXTypeWhereInIndex() {
        return " o.xtype = 'U' ";
    }

    protected String getForCaptureIndex() {
        return " i.reserved > 0 ";
    }

    protected String getWhereForStoredPrograms() {
        return " ( a.xtype = 'P' OR a.xtype = 'FN' OR a.xtype = 'TF' OR a.xtype = 'IF') ";
    }

    protected abstract String getDatabasesString();

    protected abstract String getTablesString(String var1);

    protected abstract String getColumnsString(String var1, int var2);

    protected abstract String getBaseTypeString(String var1, int var2);

    protected abstract String getColumnDefaultString(String var1, int var2);

    protected abstract String getCaptureIndexString(String var1);

    protected abstract String getPrimaryKeyString(String var1);

    protected abstract String getIndexString(String var1, int var2, int var3);

    protected abstract String captureUniqueAndPrimaryKeysString(String var1);

    protected abstract String captureForeignKeysStringString(String var1);

    protected abstract String getTableNameAndUserString(String var1, int var2);

    protected abstract String captureTableLevelCheckConstraintString(String var1);

    protected abstract String captureColumnLevelCheckConstraintString(String var1);

    protected abstract String captureRulesString(String var1);

    protected abstract String captureRulesTextString(String var1);

    protected abstract String captureViewOuterString(String var1);

    protected abstract String captureViewInnerString(String var1);

    protected abstract String captureStoredProgramOuterString(String var1);

    protected abstract String captureStoredProgramInnerString(String var1, String var2);

    protected abstract String captureCommentsString();

    protected abstract String captureTriggersString(String var1);

    protected abstract String captureRolesString(String var1);

    protected abstract String getColumnNameString(String var1);

    protected abstract void capturePrivileges(Connection var1, MigrationStorer var2, CaptureContext var3, ArrayList<MdGroup> var4, MdGroup var5, MdUser var6) throws SQLException, PersistenceException;

    protected abstract void captureRoleMembership(Connection var1, MigrationStorer var2, CaptureContext var3, ArrayList<MdGroup> var4) throws SQLException, PersistenceException;

    public CaptureQueries getCaptureQueries() {
        if (s_captureQueries == null) {
            s_captureQueries = new SQLServer7CaptureQueries();
        }
        return s_captureQueries;
    }

    public void captureObjects(String objType, CaptureContext context, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        try {
            int noop = 0;
            if (objType.equals("MD_CATALOGS")) {
                this.captureCatalog(context, filter);
            } else if (objType.equals("MD_SCHEMAS")) {
                this.captureSchema(context, filter);
            } else if (objType.equals("MD_USERS")) {
                this.captureUser(context, filter);
            } else if (objType.equals("MD_TABLES")) {
                this.captureTable(context, filter);
            } else if (objType.equals("MD_COLUMNS")) {
                ++noop;
            } else if (objType.equals("MD_INDEXES")) {
                this.captureIndex(context);
            } else if (objType.equals("MD_INDEX_DETAILS")) {
                ++noop;
            } else if (objType.equals("MD_CONSTRAINTS")) {
                this.captureUniqueAndPrimaryKeys(context);
                this.captureForeignKeys(context);
                this.captureTableLevelCheckConstraint(context);
                this.captureColumnLevelCheckConstraint(context);
                this.captureRules(context);
            } else if (objType.equals("MD_CONSTRAINT_DETAILS")) {
                ++noop;
            } else if (objType.equals("MD_VIEWS")) {
                this.captureView(context, filter);
            } else if (objType.equals("MD_STORED_PROGRAMS")) {
                this.captureStoredProgram(context, filter);
            } else if (objType.equals("MD_TRIGGERS")) {
                this.captureTriggers(context);
            } else if (objType.equals("MD_GROUPS")) {
                this.captureRoles(context, filter);
            }
        }
        catch (SQLException e) {
            throw new CaptureException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureCatalog(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        Statement stmt = null;
        ResultSet rs = null;
        boolean catalogFound = false;
        SQLServer7CapturerColumnsBySelect.clearHashSet();
        try {
            String query = this.getDatabasesString();
            HashSet<String> nameFilter = null;
            if (filter != null && !filter.getObjectType().equals("MD_CATALOGS")) {
                throw new IllegalArgumentException("Filter is of incorrect type " + filter.getObjectType());
            }
            if (filter != null && filter.getFilterType() == 2) {
                query = query + " and name " + filter.getWhereClause();
            }
            if (filter != null && filter.getFilterType() == 1) {
                nameFilter = new HashSet<String>();
                for (String name : filter.getObjectNames()) {
                    nameFilter.add(name);
                }
            }
            DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
            stmt = this.getRepositoryConnection().createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String databaseName;
                String sourceDatabase = null;
                sourceDatabase = rs.getString(1);
                boolean match = false;
                if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(databaseName = sourceDatabase)) {
                    match = true;
                }
                for (String dbToSkip : s_sqlServerDatabasesToSkip) {
                    if (!sourceDatabase.toLowerCase().equals(dbToSkip)) continue;
                    match = true;
                    break;
                }
                if (SQLServer7AbstractCapturer.getSqlServerDatabaseToUse() != null && !sourceDatabase.toLowerCase().equals(SQLServer7AbstractCapturer.getSqlServerDatabaseToUse().toLowerCase())) {
                    match = true;
                }
                if (match) continue;
                MdCatalog catalog = new MdCatalog(connectionId);
                catalog.setCatalogName(sourceDatabase);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)142), catalog.getCatalogName());
                context.getAudience().fireListeners(event);
                catalog = (MdCatalog)this.getStorer().storeObject((PersistableObject)catalog);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
                catalogFound = true;
            }
            if (!catalogFound) {
                Logger.getLogger("oracle.dbtools.migration").log(Level.INFO, "SQLSERVER.NO_CATALOGS", s_sqlServerDatabasesToSkip);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(stmt, rs);
            throw throwable;
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureSchema(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        PreparedStatement stmtInner = null;
        ResultSet rsInner = null;
        MdCatalog catalog = (MdCatalog)context.getContextVariable("CATALOG");
        try {
            String sourceDatabase = catalog.getCatalogName();
            String query = this.getShowUsersInDatabase(this.getDatabase((MigrationContext)context)) + " " + this.andExistsTablesOrProcedures(this.getDatabase((MigrationContext)context));
            HashSet<String> nameFilter = null;
            if (filter != null && !filter.getObjectType().equals("MD_SCHEMAS")) {
                throw new IllegalArgumentException("Filter is of incorrect type " + filter.getObjectType());
            }
            if (filter != null && filter.getFilterType() == 2) {
                query = query + " and u.name " + filter.getWhereClause();
            }
            if (filter != null && filter.getFilterType() == 1) {
                nameFilter = new HashSet<String>();
                for (String name : filter.getObjectNames()) {
                    nameFilter.add(name);
                }
            }
            stmtInner = this.getRepositoryConnection().prepareStatement(query);
            if (!this.m_online) {
                stmtInner.setString(1, this.getDatabase((MigrationContext)context));
            }
            rsInner = stmtInner.executeQuery();
            while (rsInner.next()) {
                String login = rsInner.getString(1);
                String user = rsInner.getString(2);
                boolean match = true;
                if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(user)) {
                    match = false;
                }
                if (!match) continue;
                MdSchema migrSchema = new MdSchema(catalog.getKey());
                migrSchema.setName(user);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)141), user);
                context.getAudience().fireListeners(event);
                AdditionalProperty newProp = new AdditionalProperty("Login", login);
                migrSchema.addProperty(newProp, catalog.getConnectionId());
                migrSchema = (MdSchema)this.getStorer().storeObject((PersistableObject)migrSchema);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
            CloseableResultSet.close((Statement)stmtInner, (ResultSet)rsInner);
        }
        catch (SQLException e) {
            MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
        }
        finally {
            CloseableResultSet.close(stmtInner, rsInner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureUser(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        MdSchema schema = (MdSchema)context.getContextVariable("SCHEMAOBJ");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String query = "select ? name ";
            HashSet<String> nameFilter = null;
            if (filter != null && !filter.getObjectType().equals("MD_USERS")) {
                throw new IllegalArgumentException("Filter is of incorrect type " + filter.getObjectType());
            }
            if (filter != null && filter.getFilterType() == 2) {
                query = query + " where name " + filter.getWhereClause();
            }
            if (filter != null && filter.getFilterType() == 1) {
                nameFilter = new HashSet<String>();
                for (String name : filter.getObjectNames()) {
                    nameFilter.add(name);
                }
            }
            boolean whereMatch = false;
            if (filter != null && filter.getFilterType() == 2) {
                stmt = this.getRepositoryConnection().prepareStatement(query);
                stmt.setString(1, schema.getName());
                rs = stmt.executeQuery();
                if (rs.next()) {
                    whereMatch = true;
                }
            } else {
                whereMatch = true;
            }
            boolean match = true;
            if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(schema.getName())) {
                match = false;
            }
            if (match && whereMatch) {
                MdUser migrUser = new MdUser(schema.getKey(), schema.getName());
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)144), schema.getName());
                context.getAudience().fireListeners(event);
                migrUser = (MdUser)this.getStorer().storeObject((PersistableObject)migrUser);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(stmt, rs);
            throw throwable;
        }
        CloseableResultSet.close((Statement)stmt, rs);
    }

    protected void captureTable(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        MdSchema schema = null;
        schema = (MdSchema)context.getContextVariable("SCHEMAOBJ");
        this.mapTable(schema, context, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mapTable(MdSchema schema, CaptureContext context, MigrationObjectFilter filter) throws SQLException {
        block39: {
            DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
            String database = this.getDatabase((MigrationContext)context);
            PreparedStatement stmt = null;
            PreparedStatement stmtOuter = null;
            ResultSet rsOuter = null;
            ResultSet rs = null;
            try {
                String query = this.getTablesString(database);
                HashSet<String> nameFilter = null;
                if (filter != null && !filter.getObjectType().equals("MD_TABLES")) {
                    throw new IllegalArgumentException("Filter is of incorrect type " + filter.getObjectType());
                }
                if (filter != null && filter.getFilterType() == 2) {
                    query = query + " and a.name " + filter.getWhereClause();
                }
                if (filter != null && filter.getFilterType() == 1) {
                    nameFilter = new HashSet<String>();
                    for (String name : filter.getObjectNames()) {
                        nameFilter.add(name);
                    }
                }
                stmtOuter = this.getRepositoryConnection().prepareStatement(query);
                if (!this.m_online) {
                    stmtOuter.setString(1, database);
                    stmtOuter.setString(2, schema.getName());
                } else {
                    stmtOuter.setString(1, schema.getName());
                }
                String tableName = "";
                int tableId = 0;
                rsOuter = stmtOuter.executeQuery();
                while (rsOuter.next()) {
                    tableName = rsOuter.getString(1);
                    tableId = rsOuter.getInt(2);
                    boolean match = true;
                    if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(tableName)) {
                        match = false;
                    }
                    if (!match) continue;
                    int order = 1;
                    int userType = 0;
                    int columnTypeNumber = 0;
                    int columnDefaultId = 0;
                    rs = null;
                    try {
                        String sql = this.getColumnsString(database, tableId);
                        stmt = this.getRepositoryConnection().prepareStatement(sql);
                        if (!this.m_online) {
                            stmt.setString(1, database);
                        }
                        rs = stmt.executeQuery();
                        boolean tableSaved = false;
                        MdTable table = null;
                        while (rs.next()) {
                            String colType;
                            if (!tableSaved) {
                                tableSaved = true;
                                String qualifiedName = "[" + database + "].[" + schema.getName() + "].[" + tableName + "]";
                                table = new MdTable(schema.getKey(), tableName, qualifiedName);
                                try {
                                    String comment_sql = this.captureCommentsString();
                                    PreparedStatement comment_stmt = this.getRepositoryConnection().prepareStatement(comment_sql);
                                    comment_stmt.setInt(1, tableId);
                                    comment_stmt.setInt(2, 0);
                                    ResultSet comment_rs = comment_stmt.executeQuery();
                                    comment_rs.next();
                                    String tableComment = comment_rs.getString(1);
                                    comment_rs.close();
                                    comment_stmt.close();
                                    table.setComments(tableComment);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)138), tableName);
                                context.getAudience().fireListeners(event);
                                table = (MdTable)this.getStorer().storeObject((PersistableObject)table);
                                event.setEventId(4);
                                context.getAudience().fireListeners(event);
                            }
                            SQLServer7CapturerColumnInfo column = new SQLServer7CapturerColumnInfo();
                            tableName = rs.getString(1);
                            String origColType = colType = rs.getString(5);
                            column.setNativeColumnName(rs.getString(3));
                            column.setColumnOrder(rs.getInt(4));
                            column.setNativeColumnType(colType);
                            int nativeLen = rs.getInt(6);
                            boolean lengthIsNull = rs.wasNull();
                            if (lengthIsNull) {
                                column.setNativeColumnLength(null);
                            } else {
                                column.setNativeColumnLength(nativeLen);
                            }
                            int precision = rs.getInt(7);
                            boolean precisionWasNull = rs.wasNull();
                            int scale = rs.getInt(8);
                            if (rs.wasNull()) {
                                column.setNativeColumnScale(null);
                            } else {
                                column.setNativeColumnScale(scale);
                            }
                            if (rs.getInt(9) == 16) {
                                column.setStatus(0);
                            } else {
                                column.setStatus(rs.getInt(9));
                            }
                            userType = rs.getInt(10);
                            columnTypeNumber = rs.getInt(11);
                            columnDefaultId = rs.getInt(12);
                            String baseType = this.baseType(columnTypeNumber, database);
                            column.setColumnDefaultText(this.columnDefault(columnDefaultId, database, baseType));
                            if (userType > 256) {
                                column.setNativeColumnType(baseType);
                            }
                            if ((colType = column.getNativeColumnType()).equalsIgnoreCase("varchar") || colType.equalsIgnoreCase("nvarchar") || colType.equalsIgnoreCase("nchar") || colType.equalsIgnoreCase("char") || colType.equalsIgnoreCase("varbinary") || colType.equalsIgnoreCase("binary")) {
                                if (lengthIsNull) {
                                    column.setNativeColumnPrecision(null);
                                } else {
                                    column.setNativeColumnPrecision(nativeLen);
                                }
                            } else if (precisionWasNull) {
                                column.setNativeColumnPrecision(null);
                            } else {
                                column.setNativeColumnPrecision(precision);
                            }
                            Integer[] threeInt = SQLServer7CapturerColumnsBySelect.getPrecisionScaleIdentity(column.getNativeColumnType(), column.getNativeColumnPrecision(), column.getNativeColumnScale());
                            column.setNativeColumnPrecision(threeInt[0]);
                            column.setNativeColumnScale(threeInt[1]);
                            Object migrColumn = null;
                            migrColumn = column.getStatus() == 128 ? new MdIdentityColumn(table.getKey(), column.getNativeColumnName(), Integer.valueOf(order), 1L, connectionId) : new MdColumn(table.getKey(), column.getNativeColumnName(), Integer.valueOf(order));
                            migrColumn.setColumnType(column.getNativeColumnType());
                            migrColumn.setDefaultValue(column.getColumnDefaultText());
                            if (column.getColumnDefaultText().equalsIgnoreCase(NEWID_FUNCTION)) {
                                migrColumn.addProperty(NEWID_FUNCTION, "Y", connectionId);
                            }
                            if (column.getStatus() == 0) {
                                migrColumn.setNullable("N");
                            } else {
                                migrColumn.setNullable("Y");
                            }
                            migrColumn.setPrecision(column.getNativeColumnPrecision());
                            migrColumn.setScale(column.getNativeColumnScale());
                            try {
                                String comment_sql = this.captureCommentsString();
                                PreparedStatement comment_stmt = this.getRepositoryConnection().prepareStatement(comment_sql);
                                comment_stmt.setInt(1, tableId);
                                comment_stmt.setInt(2, order);
                                ResultSet comment_rs = comment_stmt.executeQuery();
                                comment_rs.next();
                                String columnComment = comment_rs.getString(1);
                                comment_rs.close();
                                comment_stmt.close();
                                migrColumn.setComments(columnComment);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)134), column.getNativeColumnName());
                            context.getAudience().fireListeners(event);
                            migrColumn = (MdColumn)this.getStorer().storeObject((PersistableObject)migrColumn);
                            event.setEventId(4);
                            context.getAudience().fireListeners(event);
                            if (userType > 256) {
                                SQLServer7CapturerColumnsBySelect.registerUserDefinedType(this.getStorer(), origColType, schema, column, migrColumn);
                            }
                            ++order;
                        }
                        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
                    }
                    catch (SQLException e) {
                        MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
                        CloseableResultSet.close((Statement)stmt, rs);
                    }
                }
                CloseableResultSet.close(stmt, rs);
            }
            catch (Exception e) {
                MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
                break block39;
            }
            finally {
                CloseableResultSet.close(stmt, rs);
                CloseableResultSet.close(stmtOuter, rsOuter);
            }
            CloseableResultSet.close((Statement)stmtOuter, (ResultSet)rsOuter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String baseType(int typeNumber, String databaseName) {
        String baseDataType = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getRepositoryConnection().prepareStatement(this.getBaseTypeString(databaseName, typeNumber));
            if (!this.m_online) {
                stmt.setString(1, databaseName);
            }
            rs = stmt.executeQuery();
            rs.next();
            baseDataType = rs.getString(1);
        }
        catch (SQLException e) {
            try {
                MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(stmt, rs);
                throw throwable;
            }
            CloseableResultSet.close((Statement)stmt, rs);
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
        return baseDataType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String columnDefault(int defaultId, String databaseName, String baseType) {
        String columnDefaultText = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getRepositoryConnection().prepareStatement(this.getColumnDefaultString(databaseName, defaultId));
            if (!this.m_online) {
                stmt.setString(1, databaseName);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                columnDefaultText = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(stmt, rs);
                throw throwable;
            }
            CloseableResultSet.close((Statement)stmt, rs);
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
        return columnDefaultText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void captureIndex(CaptureContext context) throws SQLException, PersistenceException {
        String database = this.getDatabase((MigrationContext)context);
        String showIndexQuery = this.getCaptureIndexString(database);
        String tableName = (String)context.getContextVariable("TABLE");
        String userName = (String)context.getContextVariable("SCHEMA");
        PreparedStatement stmt2 = null;
        ResultSet rs2 = null;
        try {
            stmt2 = this.getRepositoryConnection().prepareStatement(showIndexQuery);
            if (!this.m_online) {
                stmt2.setString(1, database);
                stmt2.setString(2, userName);
                stmt2.setString(3, tableName);
            } else {
                stmt2.setString(1, userName);
                stmt2.setString(2, tableName);
            }
            rs2 = stmt2.executeQuery();
            while (rs2.next()) {
                ResultSet rs3;
                PreparedStatement stmt3;
                block16: {
                    int indId = rs2.getInt(2);
                    String srcIndName = rs2.getString(3);
                    int status = rs2.getInt(4);
                    int tableId = rs2.getInt(6);
                    stmt3 = null;
                    rs3 = null;
                    try {
                        stmt3 = this.getRepositoryConnection().prepareStatement(this.getPrimaryKeyString(database));
                        if (!this.m_online) {
                            stmt3.setString(1, database);
                            stmt3.setString(2, srcIndName);
                        } else {
                            stmt3.setString(1, srcIndName);
                        }
                        rs3 = stmt3.executeQuery();
                        if (rs3.next()) {
                            int noop = 1;
                            ++noop;
                            break block16;
                        }
                        MdIndexe index = new MdIndexe((DBObjectId)context.getContextVariable("TABLEID"));
                        index.setIndexName(srcIndName);
                        if ((status & 2) == 2) {
                            index.setIndexType("UNIQUE");
                        } else {
                            index.setIndexType("NON_UNIQUE");
                        }
                        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)140), srcIndName);
                        context.getAudience().fireListeners(event);
                        index = (MdIndexe)this.getStorer().storeObject((PersistableObject)index);
                        event.setEventId(4);
                        context.getAudience().fireListeners(event);
                        PreparedStatement columnStmt = null;
                        ResultSet columnRs = null;
                        try {
                            String sql = this.getIndexString(database, tableId, indId);
                            columnStmt = this.getRepositoryConnection().prepareStatement(sql);
                            if (!this.m_online) {
                                columnStmt.setString(1, database);
                            }
                            columnRs = columnStmt.executeQuery();
                            PersistenceUtility util = this.getStorer().getPersistenceUtility();
                            while (columnRs.next()) {
                                MdIndexDetail detail = new MdIndexDetail(index.getKey(), util.getIdForColumn(index.getTableId(), columnRs.getString(2)), Integer.valueOf(columnRs.getInt(1)));
                                event = new CaptureEvent(3, MigrationAddinArb.getString((int)143), index.getIndexName());
                                context.getAudience().fireListeners(event);
                                detail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)detail);
                                event.setEventId(4);
                                context.getAudience().fireListeners(event);
                            }
                        }
                        catch (Throwable throwable) {
                            CloseableResultSet.close(columnStmt, columnRs);
                            throw throwable;
                        }
                        CloseableResultSet.close((Statement)columnStmt, (ResultSet)columnRs);
                    }
                    catch (Throwable throwable) {
                        CloseableResultSet.close(stmt3, rs3);
                        throw throwable;
                    }
                }
                CloseableResultSet.close((Statement)stmt3, (ResultSet)rs3);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close((Statement)stmt2, rs2);
            throw throwable;
        }
        CloseableResultSet.close((Statement)stmt2, (ResultSet)rs2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureUniqueAndPrimaryKeys(CaptureContext context) throws SQLException, PersistenceException {
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String database = null;
        try {
            database = this.getDatabase((MigrationContext)context);
            boolean firstTime = true;
            long id = 0L;
            String sQuery = this.captureUniqueAndPrimaryKeysString(database);
            stmt = this.getRepositoryConnection().prepareStatement(sQuery);
            String tableName = (String)context.getContextVariable("TABLE");
            String userName = (String)context.getContextVariable("SCHEMA");
            if (!this.m_online) {
                stmt.setString(1, database);
                stmt.setString(2, tableName);
                stmt.setString(3, userName);
            } else {
                stmt.setString(1, tableName);
                stmt.setString(2, userName);
            }
            rs = stmt.executeQuery();
            MdConstraint constraint = null;
            int detailOrder = 1;
            while (rs.next()) {
                if (firstTime || rs.getLong(3) != id) {
                    firstTime = false;
                    id = rs.getLong(3);
                    String xtype = rs.getString(8);
                    constraint = new MdConstraint((DBObjectId)context.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                    if (xtype.trim().equals("PK")) {
                        xtype = "PK";
                    } else if (xtype.trim().equals("UQ")) {
                        xtype = "UNIQUE";
                    }
                    constraint.setConstraintType(xtype);
                    constraint.setName(rs.getString(1));
                    CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), constraint.getName());
                    context.getAudience().fireListeners(event);
                    constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
                    detailOrder = 1;
                    event.setEventId(4);
                    context.getAudience().fireListeners(event);
                }
                String columnName = rs.getString(5);
                MdConstraintDetail constraintdetail = new MdConstraintDetail(constraint.getKey(), Integer.valueOf(detailOrder++));
                constraintdetail.setColumnId(util.getIdForColumn(constraint.getTableId(), columnName));
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)147), constraint.getName());
                context.getAudience().fireListeners(event);
                constraintdetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)constraintdetail);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(stmt, rs);
            throw throwable;
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureForeignKeys(CaptureContext context) throws SQLException, CaptureException, PersistenceException {
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String database = null;
        try {
            database = this.getDatabase((MigrationContext)context);
            String sQuery = this.captureForeignKeysStringString(database);
            stmt = this.getRepositoryConnection().prepareStatement(sQuery);
            String tableName = (String)context.getContextVariable("TABLE");
            String userName = (String)context.getContextVariable("SCHEMA");
            if (!this.m_online) {
                stmt.setString(1, database);
                stmt.setString(2, tableName);
                stmt.setString(3, userName);
            } else {
                stmt.setString(1, tableName);
                stmt.setString(2, userName);
            }
            rs = stmt.executeQuery();
            MdConstraint constraint = null;
            int detailOrder = 1;
            while (rs.next()) {
                MdConstraintDetail constraintdetail;
                int order;
                int i;
                DBObjectId refTableId;
                String foreignUserName;
                String foreignTableName;
                ResultSet innerRs;
                PreparedStatement innerStmt;
                block14: {
                    constraint = new MdConstraint((DBObjectId)context.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                    constraint.setConstraintType("FOREIGN KEY");
                    constraint.setName(rs.getString(1));
                    String getTableNameAndUser = this.getTableNameAndUserString(database, rs.getInt(3));
                    innerStmt = null;
                    innerRs = null;
                    foreignTableName = null;
                    foreignUserName = null;
                    try {
                        innerStmt = this.getRepositoryConnection().prepareStatement(getTableNameAndUser);
                        if (!this.m_online) {
                            innerStmt.setString(1, database);
                        }
                        if (!(innerRs = innerStmt.executeQuery()).next()) break block14;
                        foreignTableName = innerRs.getString(1);
                        foreignUserName = innerRs.getString(2);
                    }
                    catch (SQLException se) {
                        try {
                            throw se;
                        }
                        catch (Throwable throwable) {
                            CloseableResultSet.close((Statement)innerStmt, innerRs);
                            throw throwable;
                        }
                    }
                }
                CloseableResultSet.close((Statement)innerStmt, (ResultSet)innerRs);
                continue;
                CloseableResultSet.close((Statement)innerStmt, (ResultSet)innerRs);
                DBObjectId foreignSchemaId = util.getIdForSchema((DBObjectId)context.getContextVariable("CATALOGID"), foreignUserName);
                if (foreignSchemaId == null) continue;
                try {
                    refTableId = util.getIdForTable(foreignSchemaId, foreignTableName);
                }
                catch (PersistenceException e) {
                    continue;
                }
                constraint.setReftableId(refTableId);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), constraint.getName());
                context.getAudience().fireListeners(event);
                constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
                detailOrder = 1;
                event.setEventId(4);
                context.getAudience().fireListeners(event);
                for (i = 0; i < 16; ++i) {
                    order = rs.getInt(i + 5);
                    if (order == 0) continue;
                    constraintdetail = new MdConstraintDetail(constraint.getKey(), Integer.valueOf(detailOrder++));
                    constraintdetail.setColumnId(util.getIdForColumn(constraint.getTableId(), this.getColumnName(database, userName, tableName, order)));
                    event = new CaptureEvent(3, MigrationAddinArb.getString((int)147), constraint.getName());
                    context.getAudience().fireListeners(event);
                    constraintdetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)constraintdetail);
                    event.setEventId(4);
                    context.getAudience().fireListeners(event);
                }
                for (i = 0; i < 16; ++i) {
                    order = rs.getInt(21 + i);
                    if (order == 0) continue;
                    constraintdetail = new MdConstraintDetail(constraint.getKey(), Integer.valueOf(detailOrder++));
                    constraintdetail.setColumnId(util.getIdForColumn(refTableId, this.getColumnName(database, foreignUserName, foreignTableName, order)));
                    constraintdetail.setRefFlag("Y");
                    event = new CaptureEvent(3, MigrationAddinArb.getString((int)147), constraint.getName());
                    context.getAudience().fireListeners(event);
                    constraintdetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)constraintdetail);
                    event.setEventId(4);
                    context.getAudience().fireListeners(event);
                }
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(stmt, rs);
            throw throwable;
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureTableLevelCheckConstraint(CaptureContext context) throws SQLException, PersistenceException, CaptureException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String database = null;
        try {
            database = this.getDatabase((MigrationContext)context);
            String sQuery = this.captureTableLevelCheckConstraintString(database);
            stmt = this.getRepositoryConnection().prepareStatement(sQuery);
            String tableName = (String)context.getContextVariable("TABLE");
            String userName = (String)context.getContextVariable("SCHEMA");
            if (!this.m_online) {
                stmt.setString(1, database);
                stmt.setString(2, tableName);
                stmt.setString(3, userName);
            } else {
                stmt.setString(1, tableName);
                stmt.setString(2, userName);
            }
            rs = stmt.executeQuery();
            MdConstraint constraint = null;
            while (rs.next()) {
                String xtype = "CHECK";
                constraint = new MdConstraint((DBObjectId)context.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                constraint.setConstraintType(xtype);
                constraint.setName(rs.getString(1));
                constraint.setConstraintText(rs.getString(2));
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), constraint.getName());
                context.getAudience().fireListeners(event);
                constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(stmt, rs);
            throw throwable;
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureColumnLevelCheckConstraint(CaptureContext context) throws SQLException, PersistenceException, CaptureException {
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String database = null;
        try {
            database = this.getDatabase((MigrationContext)context);
            String sQuery = this.captureColumnLevelCheckConstraintString(database);
            stmt = this.getRepositoryConnection().prepareStatement(sQuery);
            String tableName = (String)context.getContextVariable("TABLE");
            String userName = (String)context.getContextVariable("SCHEMA");
            if (!this.m_online) {
                stmt.setString(1, database);
                stmt.setString(2, tableName);
                stmt.setString(3, userName);
            } else {
                stmt.setString(1, tableName);
                stmt.setString(2, userName);
            }
            rs = stmt.executeQuery();
            MdConstraint constraint = null;
            while (rs.next()) {
                String rsName = rs.getString(1);
                int id = rs.getInt(3);
                String constraintText = rs.getString(4);
                String xtype = "CHECK";
                constraint = new MdConstraint((DBObjectId)context.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                constraint.setConstraintType(xtype);
                constraint.setName(rsName);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), constraint.getName());
                context.getAudience().fireListeners(event);
                constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
                MdConstraintDetail constraintdetail = new MdConstraintDetail(constraint.getKey(), Integer.valueOf(1));
                CloseableIterator getColumns = util.getColumnsForTableId((DBObjectId)context.getContextVariable("TABLEID"));
                DBObjectId columnId = null;
                while (getColumns.hasNext()) {
                    MdColumn column = (MdColumn)getColumns.next();
                    if (column.getColumnOrder() != id) continue;
                    columnId = column.getKey();
                }
                constraintdetail.setColumnId(columnId);
                constraintdetail.setConstraintText(constraintText);
                event = new CaptureEvent(3, MigrationAddinArb.getString((int)147), constraint.getName());
                context.getAudience().fireListeners(event);
                constraintdetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)constraintdetail);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(stmt, rs);
            throw throwable;
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void captureRules(CaptureContext context) throws SQLException, PersistenceException, CaptureException {
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String database = null;
        try {
            database = this.getDatabase((MigrationContext)context);
            String sQuery = this.captureRulesString(database);
            stmt = this.getRepositoryConnection().prepareStatement(sQuery);
            String tableName = (String)context.getContextVariable("TABLE");
            String userName = (String)context.getContextVariable("SCHEMA");
            DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
            if (!this.m_online) {
                stmt.setString(1, database);
                stmt.setString(2, tableName);
                stmt.setString(3, userName);
            } else {
                stmt.setString(1, tableName);
                stmt.setString(2, userName);
            }
            rs = stmt.executeQuery();
            MdConstraint constraint = null;
            while (rs.next()) {
                String columnName = rs.getString(2);
                int columnOrder = rs.getInt(3);
                int columnRuleId = rs.getInt(4);
                String xtype = "CHECK";
                if (columnRuleId == 0) continue;
                String ruleName = "rul_" + tableName + "_" + columnName;
                PreparedStatement textStmt = null;
                ResultSet textRs = null;
                String ruleText = "";
                String sqltext = this.captureRulesTextString(database);
                try {
                    textStmt = this.getRepositoryConnection().prepareStatement(sqltext);
                    if (!this.m_online) {
                        textStmt.setString(1, database);
                        textStmt.setInt(2, columnRuleId);
                    } else {
                        textStmt.setInt(1, columnRuleId);
                    }
                    textRs = textStmt.executeQuery();
                    while (textRs.next()) {
                        ruleText = ruleText + textRs.getString(1);
                    }
                    constraint = new MdConstraint((DBObjectId)context.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                    constraint.setConstraintType(xtype);
                    constraint.setName(ruleName);
                    constraint.addProperty("TYPE", "RULE", connectionId);
                    CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), constraint.getName());
                    context.getAudience().fireListeners(event);
                    constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
                    event.setEventId(4);
                    context.getAudience().fireListeners(event);
                    MdConstraintDetail constraintdetail = new MdConstraintDetail(constraint.getKey(), Integer.valueOf(1));
                    CloseableIterator getColumns = util.getColumnsForTableId((DBObjectId)context.getContextVariable("TABLEID"));
                    DBObjectId columnId = null;
                    while (getColumns.hasNext()) {
                        MdColumn column = (MdColumn)getColumns.next();
                        if (column.getColumnOrder() != columnOrder) continue;
                        columnId = column.getKey();
                    }
                    constraintdetail.setColumnId(columnId);
                    constraintdetail.setConstraintText(ruleText);
                    event = new CaptureEvent(3, MigrationAddinArb.getString((int)147), constraint.getName());
                    context.getAudience().fireListeners(event);
                    constraintdetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)constraintdetail);
                    event.setEventId(4);
                    context.getAudience().fireListeners(event);
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close((Statement)textStmt, textRs);
                    throw throwable;
                }
                CloseableResultSet.close((Statement)textStmt, (ResultSet)textRs);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(stmt, rs);
            throw throwable;
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
    }

    protected void captureView(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException, CaptureException {
        PreparedStatement stmt = null;
        PreparedStatement outerStmt = null;
        ResultSet rs = null;
        ResultSet outerRs = null;
        String database = null;
        PrepareClobHelper pch = null;
        try {
            database = this.getDatabase((MigrationContext)context);
            String queryAdd = "";
            HashSet<String> nameFilter = null;
            if (filter != null && !filter.getObjectType().equals("MD_VIEWS")) {
                throw new IllegalArgumentException("Filter is of incorrect type " + filter.getObjectType());
            }
            if (filter != null && filter.getFilterType() == 2) {
                queryAdd = " AND a.name " + filter.getWhereClause();
            }
            if (filter != null && filter.getFilterType() == 1) {
                nameFilter = new HashSet<String>();
                for (String name : filter.getObjectNames()) {
                    nameFilter.add(name);
                }
            }
            String outerQuery = this.captureViewOuterString(database) + queryAdd;
            String query = this.captureViewInnerString(database);
            outerStmt = this.getRepositoryConnection().prepareStatement(outerQuery);
            String userName = (String)context.getContextVariable("SCHEMA");
            if (!this.m_online) {
                outerStmt.setString(1, database);
                outerStmt.setString(2, userName);
            } else {
                outerStmt.setString(1, userName);
            }
            outerRs = outerStmt.executeQuery();
            while (outerRs.next()) {
                int id = outerRs.getInt(1);
                String viewName = outerRs.getString(2);
                if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(viewName)) continue;
                stmt = this.getRepositoryConnection().prepareStatement(query);
                if (!this.m_online) {
                    stmt.setString(1, database);
                    stmt.setInt(2, id);
                } else {
                    stmt.setInt(1, id);
                }
                rs = stmt.executeQuery();
                MdView view = null;
                pch = new PrepareClobHelper();
                boolean viewExists = false;
                while (rs.next()) {
                    viewExists = true;
                    viewName = rs.getString(1);
                    String viewBody = null;
                    try {
                        viewBody = rs.getString(3);
                    }
                    catch (Exception e) {
                        viewBody = "";
                    }
                    pch.append(viewBody);
                }
                if (viewExists) {
                    view = new MdView((DBObjectId)context.getContextVariable("SCHEMAID"), MY_LANGUAGE_ID);
                    view.setViewName(viewName);
                    ClobHelper ch = pch.getClobHelper();
                    if (ch == null || ch.getLength() == 0L) {
                        pch = new PrepareClobHelper();
                        pch.append(DDL_NOT_ACCESSIBLE);
                        ch = pch.getClobHelper();
                    }
                    view.setNativeSql(ch);
                    try {
                        String comment_sql = this.captureCommentsString();
                        PreparedStatement comment_stmt = this.getRepositoryConnection().prepareStatement(comment_sql);
                        comment_stmt.setInt(1, id);
                        comment_stmt.setInt(2, 0);
                        ResultSet comment_rs = comment_stmt.executeQuery();
                        comment_rs.next();
                        String Comment = comment_rs.getString(1);
                        comment_rs.close();
                        comment_stmt.close();
                        view.setComments(Comment);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)137), viewName);
                    context.getAudience().fireListeners(event);
                    view = (MdView)this.getStorer().storeObject((PersistableObject)view);
                    event.setEventId(4);
                    context.getAudience().fireListeners(event);
                }
                if (pch != null) {
                    pch.close();
                }
                CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
            }
            CloseableResultSet.close((Statement)outerStmt, (ResultSet)outerRs);
        }
        catch (IOException io) {
            try {
                throw new CaptureException((Throwable)io);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(stmt, rs);
                CloseableResultSet.close(outerStmt, outerRs);
                if (pch != null) {
                    try {
                        pch.close();
                    }
                    catch (Exception io2) {
                        MigrationLogUtil.logThrowable((String)io2.getLocalizedMessage(), (String)"Capture", (Throwable)io2);
                    }
                }
                throw throwable;
            }
        }
        CloseableResultSet.close(stmt, rs);
        CloseableResultSet.close((Statement)outerStmt, (ResultSet)outerRs);
        if (pch != null) {
            try {
                pch.close();
            }
            catch (Exception io) {
                MigrationLogUtil.logThrowable((String)io.getLocalizedMessage(), (String)"Capture", (Throwable)io);
            }
        }
    }

    protected void captureStoredProgram(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException, CaptureException {
        PreparedStatement stmt = null;
        PreparedStatement outerStmt = null;
        ResultSet rs = null;
        ResultSet outerRs = null;
        String database = null;
        PrepareClobHelper pch = null;
        try {
            database = this.getDatabase((MigrationContext)context);
            String queryAdd = "";
            HashSet<String> nameFilter = null;
            if (filter != null && !filter.getObjectType().equals("MD_STORED_PROGRAMS")) {
                throw new IllegalArgumentException("Filter is of incorrect type " + filter.getObjectType());
            }
            if (filter != null && filter.getFilterType() == 2) {
                queryAdd = " AND a.name " + filter.getWhereClause();
            }
            if (filter != null && filter.getFilterType() == 1) {
                nameFilter = new HashSet<String>();
                for (String name : filter.getObjectNames()) {
                    nameFilter.add(name);
                }
            }
            String outerQuery = this.captureStoredProgramOuterString(database) + queryAdd;
            String userName = (String)context.getContextVariable("SCHEMA");
            outerStmt = this.getRepositoryConnection().prepareStatement(outerQuery);
            if (!this.m_online) {
                outerStmt.setString(1, database);
                outerStmt.setString(2, userName);
            } else {
                outerStmt.setString(1, userName);
            }
            outerRs = outerStmt.executeQuery();
            while (outerRs.next()) {
                if (filter != null && filter.getFilterType() == 1 && nameFilter.contains(outerRs.getString(1))) continue;
                int id = outerRs.getInt(2);
                String query = this.captureStoredProgramInnerString(database, queryAdd);
                stmt = this.getRepositoryConnection().prepareStatement(query);
                if (!this.m_online) {
                    stmt.setString(1, database);
                    stmt.setInt(2, id);
                } else {
                    stmt.setInt(1, id);
                }
                rs = stmt.executeQuery();
                MdStoredProgram storedProgram = null;
                String storedProgramName = "";
                String storedProgramType = "";
                boolean match = false;
                pch = new PrepareClobHelper();
                while (rs.next()) {
                    storedProgramName = rs.getString(1);
                    String procBody = null;
                    try {
                        procBody = rs.getString(4);
                    }
                    catch (Exception e) {
                        procBody = "";
                    }
                    pch.append(procBody);
                    storedProgramType = rs.getString(5);
                    match = true;
                }
                if (match) {
                    ClobHelper ch = pch.getClobHelper();
                    if (ch == null || ch.getLength() == 0L) {
                        pch = new PrepareClobHelper();
                        pch.append(DDL_NOT_ACCESSIBLE);
                        ch = pch.getClobHelper();
                    }
                    storedProgram = new MdStoredProgram((DBObjectId)context.getContextVariable("SCHEMAID"), MY_LANGUAGE_ID);
                    storedProgram.setName(storedProgramName);
                    storedProgram.setNativeSql(ch);
                    String additionalProperty = storedProgramType;
                    if (storedProgramType.trim().equals("P")) {
                        additionalProperty = "PROCEDURE";
                        storedProgramType = "PROCEDURE";
                    } else if (storedProgramType.equals("FN")) {
                        additionalProperty = "SCALAR FUNCTION";
                        storedProgramType = "FUNCTION";
                    } else if (storedProgramType.equals("TF")) {
                        additionalProperty = "TABLE FUNCTION";
                        storedProgramType = "FUNCTION";
                    } else if (storedProgramType.equals("IF")) {
                        additionalProperty = "INLINED T. FUNCTION";
                        storedProgramType = "FUNCTION";
                    } else {
                        storedProgramType = "PROCEDURE";
                    }
                    DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
                    storedProgram.addProperty("TYPE", additionalProperty, connectionId);
                    storedProgram.setProgramtype(storedProgramType);
                    try {
                        String comment_sql = this.captureCommentsString();
                        PreparedStatement comment_stmt = this.getRepositoryConnection().prepareStatement(comment_sql);
                        comment_stmt.setInt(1, id);
                        comment_stmt.setInt(2, 0);
                        ResultSet comment_rs = comment_stmt.executeQuery();
                        comment_rs.next();
                        String Comment = comment_rs.getString(1);
                        comment_rs.close();
                        comment_stmt.close();
                        storedProgram.setComments(Comment);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)136), storedProgramName);
                    context.getAudience().fireListeners(event);
                    storedProgram = (MdStoredProgram)this.getStorer().storeObject((PersistableObject)storedProgram);
                    event.setEventId(4);
                    context.getAudience().fireListeners(event);
                }
                if (pch != null) {
                    pch.close();
                }
                CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
            }
            CloseableResultSet.close((Statement)outerStmt, (ResultSet)outerRs);
        }
        catch (IOException io) {
            try {
                throw new CaptureException((Throwable)io);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(stmt, rs);
                CloseableResultSet.close(outerStmt, outerRs);
                if (pch != null) {
                    try {
                        pch.close();
                    }
                    catch (Exception io2) {
                        MigrationLogUtil.logThrowable((String)io2.getLocalizedMessage(), (String)"Capture", (Throwable)io2);
                    }
                }
                throw throwable;
            }
        }
        CloseableResultSet.close(stmt, rs);
        CloseableResultSet.close((Statement)outerStmt, (ResultSet)outerRs);
        if (pch != null) {
            try {
                pch.close();
            }
            catch (Exception io) {
                MigrationLogUtil.logThrowable((String)io.getLocalizedMessage(), (String)"Capture", (Throwable)io);
            }
        }
    }

    protected void captureTriggers(CaptureContext context) throws SQLException, PersistenceException, CaptureException {
        PrepareClobHelper pch;
        ResultSet rs;
        PreparedStatement stmt;
        block22: {
            DBObjectId tableOrViewId;
            String sTriggerOn;
            stmt = null;
            rs = null;
            String database = null;
            pch = null;
            String s = (String)context.getContextVariable("PER_CONTEXT");
            String tableOrView = null;
            if (s.equals("MD_TABLES")) {
                sTriggerOn = "T";
                tableOrViewId = (DBObjectId)context.getContextVariable("TABLEID");
                tableOrView = (String)context.getContextVariable("TABLE");
            } else {
                sTriggerOn = "V";
                tableOrViewId = (DBObjectId)context.getContextVariable("VIEWID");
                tableOrView = (String)context.getContextVariable("VIEW");
            }
            try {
                CaptureEvent event;
                ClobHelper ch;
                database = this.getDatabase((MigrationContext)context);
                String sQuery = this.captureTriggersString(database);
                stmt = this.getRepositoryConnection().prepareStatement(sQuery);
                String userName = (String)context.getContextVariable("SCHEMA");
                if (!this.m_online) {
                    stmt.setString(1, database);
                    stmt.setString(2, userName);
                    stmt.setString(3, tableOrView);
                } else {
                    stmt.setString(1, userName);
                    stmt.setString(2, tableOrView);
                }
                rs = stmt.executeQuery();
                MdTrigger trigger = null;
                boolean firstTime = true;
                String triggerName = "";
                while (rs.next()) {
                    if (firstTime || !triggerName.equals(rs.getString(1))) {
                        if (!firstTime) {
                            trigger.setTriggerName(triggerName);
                            ch = pch.getClobHelper();
                            if (ch == null || ch.getLength() == 0L) {
                                pch = new PrepareClobHelper();
                                pch.append(DDL_NOT_ACCESSIBLE);
                                ch = pch.getClobHelper();
                            }
                            trigger.setNativeSql(ch);
                            event = new CaptureEvent(3, MigrationAddinArb.getString((int)135), triggerName);
                            context.getAudience().fireListeners(event);
                            trigger = (MdTrigger)this.getStorer().storeObject((PersistableObject)trigger);
                            event.setEventId(4);
                            context.getAudience().fireListeners(event);
                        }
                        if (pch != null) {
                            pch.close();
                        }
                        pch = new PrepareClobHelper();
                        triggerName = rs.getString(1);
                        firstTime = false;
                        trigger = new MdTrigger(tableOrViewId, sTriggerOn, MY_LANGUAGE_ID);
                    }
                    String triggerBody = "";
                    try {
                        triggerBody = rs.getString(4);
                    }
                    catch (Exception e) {
                        triggerBody = "";
                    }
                    pch.append(triggerBody);
                }
                if (trigger == null) break block22;
                trigger.setTriggerName(triggerName);
                ch = pch.getClobHelper();
                if (ch == null || ch.getLength() == 0L) {
                    pch = new PrepareClobHelper();
                    pch.append(DDL_NOT_ACCESSIBLE);
                    ch = pch.getClobHelper();
                }
                trigger.setNativeSql(ch);
                event = new CaptureEvent(3, MigrationAddinArb.getString((int)135), triggerName);
                context.getAudience().fireListeners(event);
                trigger = (MdTrigger)this.getStorer().storeObject((PersistableObject)trigger);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
            catch (IOException io) {
                try {
                    throw new CaptureException((Throwable)io);
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close(stmt, rs);
                    if (pch != null) {
                        try {
                            pch.close();
                        }
                        catch (Exception io2) {
                            MigrationLogUtil.logThrowable((String)io2.getLocalizedMessage(), (String)"Capture", (Throwable)io2);
                        }
                    }
                    throw throwable;
                }
            }
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
        if (pch != null) {
            try {
                pch.close();
            }
            catch (Exception io) {
                MigrationLogUtil.logThrowable((String)io.getLocalizedMessage(), (String)"Capture", (Throwable)io);
            }
        }
    }

    protected void captureRoles(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException, CaptureException {
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        PrepareClobHelper pch = null;
        ArrayList<MdGroup> groupAL = new ArrayList<MdGroup>();
        try {
            String database = this.getDatabase((MigrationContext)context);
            String sql = this.captureRolesString(database);
            HashSet<String> nameFilter = null;
            if (filter != null && !filter.getObjectType().equals("MD_GROUPS")) {
                throw new IllegalArgumentException("Filter is of incorrect type " + filter.getObjectType());
            }
            if (filter != null && filter.getFilterType() == 2) {
                sql = sql + " where b.name " + filter.getWhereClause();
            }
            if (filter != null && filter.getFilterType() == 1) {
                nameFilter = new HashSet<String>();
                for (String name : filter.getObjectNames()) {
                    nameFilter.add(name);
                }
            }
            stmt = this.getRepositoryConnection().prepareStatement(sql);
            if (!this.m_online) {
                stmt.setString(1, this.getDatabase((MigrationContext)context));
            }
            rs = stmt.executeQuery();
            MdGroup role = null;
            while (rs.next()) {
                DBObjectId schemaId;
                String schemaName;
                String roleName;
                block21: {
                    roleName = rs.getString(1);
                    if (nameFilter != null && nameFilter.contains(roleName)) continue;
                    schemaName = rs.getString(2);
                    pch = new PrepareClobHelper();
                    try {
                        schemaId = util.getIdForSchema((DBObjectId)context.getContextVariable("CATALOGID"), schemaName);
                        if (schemaId != null) break block21;
                        schemaName = "dbo";
                        schemaId = util.getIdForSchema((DBObjectId)context.getContextVariable("CATALOGID"), schemaName);
                        if (schemaId == null) {
                        }
                    }
                    catch (PersistenceException e1) {}
                    continue;
                }
                pch.append("sp_addrole " + roleName + ", " + schemaName);
                role = new MdGroup(schemaId);
                role.setGroupFlag("R");
                role.setGroupName(roleName);
                role.setNativeSql(pch.getClobHelper());
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)145), roleName);
                context.getAudience().fireListeners(event);
                role = (MdGroup)this.getStorer().storeObject((PersistableObject)role);
                event.setEventId(4);
                this.capturePrivileges(this.getRepositoryConnection(), this.getStorer(), context, groupAL, role, null);
                groupAL.add(role);
                context.getAudience().fireListeners(event);
                pch.close();
            }
            this.captureRoleMembership(this.getRepositoryConnection(), this.getStorer(), context, groupAL);
            CloseableIterator schemas = util.getSchemasforCatalogId((DBObjectId)context.getContextVariable("CATALOGID"));
            while (schemas.hasNext()) {
                CloseableIterator users = util.getUsersforSchemaId(((MdSchema)schemas.next()).getKey());
                while (users.hasNext()) {
                    MdUser mdUser = (MdUser)users.next();
                    this.capturePrivileges(this.getRepositoryConnection(), this.getStorer(), context, groupAL, null, mdUser);
                }
            }
        }
        catch (IOException io) {
            try {
                throw new CaptureException((Throwable)io);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(stmt, rs);
                if (pch != null) {
                    try {
                        pch.close();
                    }
                    catch (Exception io2) {
                        MigrationLogUtil.logThrowable((String)io2.getLocalizedMessage(), (String)"Capture", (Throwable)io2);
                    }
                }
                throw throwable;
            }
        }
        CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
        if (pch != null) {
            try {
                pch.close();
            }
            catch (Exception io) {
                MigrationLogUtil.logThrowable((String)io.getLocalizedMessage(), (String)"Capture", (Throwable)io);
            }
        }
    }

    protected String getColumnName(String database, String schema, String table, int order) throws SQLException, CaptureException {
        block5: {
            String string;
            PreparedStatement stmt = null;
            String sql = this.getColumnNameString(database);
            ResultSet rs = null;
            try {
                stmt = this.getRepositoryConnection().prepareStatement(sql);
                if (!this.m_online) {
                    stmt.setString(1, database);
                    stmt.setString(2, schema);
                    stmt.setString(3, table);
                    stmt.setInt(4, order);
                } else {
                    stmt.setString(1, schema);
                    stmt.setString(2, table);
                    stmt.setInt(3, order);
                }
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                string = rs.getString(1);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close((Statement)stmt, rs);
                throw throwable;
            }
            CloseableResultSet.close((Statement)stmt, (ResultSet)rs);
            return string;
        }
        throw new CaptureException((Throwable)new Exception("foreign key column not found in table " + table));
    }

    protected String getDatabase(MigrationContext context) throws SQLException {
        String database = null;
        MdCatalog catalog = (MdCatalog)context.getContextVariable("CATALOG");
        database = catalog.getCatalogName();
        return database;
    }

    public String getModelName() throws CaptureException {
        return null;
    }

    public String getSourceURL() throws CaptureException {
        return "/tmp/sqlserver7";
    }

    public void setStorer(MigrationStorer storer) {
        this.m_storer = storer;
    }

    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    public Connection getRepositoryConnection() {
        return this.m_repositoryConnection;
    }

    public void setRepositoryConnection(Connection repositoryConnection) {
        this.m_repositoryConnection = repositoryConnection;
    }
}

