/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdGroupMember;
import oracle.dbtools.metadata.persistence.MdGroupPrivilege;
import oracle.dbtools.metadata.persistence.MdPrivilege;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdUserPrivilege;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.metadata.persistence.PrepareClobHelper;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.core.MigrationContext;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQLServer7AbstractCapturerPrivilegeExtra {
    protected static int s_overSize = 5000;

    protected abstract String capturePrivilegesString(String var1);

    protected abstract String captureRoleMembershipString(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void capturePrivileges(Connection sourceConnection, MigrationStorer storer, CaptureContext context, ArrayList<MdGroup> groupAL, MdGroup role, MdUser user, boolean isOnline) throws SQLException, PersistenceException {
        PersistenceUtility util = storer.getPersistenceUtility();
        String database = SQLServer7AbstractCapturerPrivilegeExtra.getDatabase((MigrationContext)context);
        String privinfo = this.capturePrivilegesString(database);
        PreparedStatement privStmt = null;
        ResultSet privRs = null;
        PrepareClobHelper pch2 = null;
        try {
            String sql = privinfo;
            privStmt = sourceConnection.prepareStatement(sql);
            boolean isRole = true;
            String roleName = null;
            if (role == null) {
                isRole = false;
                roleName = user.getUsername();
            } else {
                roleName = role.getGroupName();
            }
            if (!isOnline) {
                privStmt.setString(1, database);
                privStmt.setString(2, roleName);
            } else {
                privStmt.setString(1, roleName);
            }
            privRs = privStmt.executeQuery();
            block18: while (privRs.next()) {
                String admin = privRs.getString(1);
                String action = privRs.getString(2);
                if (admin.equals("GRANT_W_GRANT")) {
                    admin = "GRANT_W_GRANT";
                } else if (admin.equals("GRANT")) {
                    admin = "GRANT";
                } else if (admin.equals("DENY")) {
                    admin = "DENY";
                }
                if (action.equals("REFERENCES")) {
                    action = "REFERENCES";
                } else if (action.equals("SELECT")) {
                    action = "SELECT";
                } else if (action.equals("INSERT")) {
                    action = "INSERT";
                } else if (action.equals("UPDATE")) {
                    action = "UPDATE";
                } else if (action.equals("DELETE")) {
                    action = "DELETE";
                } else if (action.equals("CREATE TABLE")) {
                    action = "CREATE TABLE";
                } else if (action.equals("CREATE DATABASE")) {
                    action = "CREATE DATABASE";
                } else if (action.equals("CREATE VIEW")) {
                    action = "CREATE VIEW";
                } else if (action.equals("CREATE PROCEDURE")) {
                    action = "CREATE PROCEDURE";
                } else if (action.equals("EXECUTE")) {
                    action = "EXECUTE";
                } else if (action.equals("BACKUP DEFAULT")) {
                    action = "BACKUP DEFAULT";
                } else if (action.equals("CREATE DEFAULT")) {
                    action = "CREATE DEFAULT";
                } else if (action.equals("BACKUP LOG")) {
                    action = "BACKUP LOG";
                }
                if (action.equalsIgnoreCase("CREATE RULE")) {
                    Logger.getLogger("oracle.dbtools.migration").log(Level.INFO, "SQLSERVER.SKIP_CREATE_RULE");
                    continue;
                }
                InputStream columRefStream = privRs.getBinaryStream(9);
                int overSize = s_overSize;
                byte[] permanentByteStore = new byte[overSize];
                int currentSize = 0;
                if (columRefStream != null) {
                    boolean exit = false;
                    int bytesGot = 0;
                    BufferedInputStream bis = new BufferedInputStream(columRefStream);
                    while (!exit) {
                        bytesGot = bis.read(permanentByteStore, currentSize, overSize - currentSize);
                        if (bytesGot == -1 || bytesGot + currentSize == overSize) {
                            exit = true;
                            continue;
                        }
                        currentSize += bytesGot;
                    }
                }
                DBObjectId schemaIdGrantor = null;
                DBObjectId schemaIdOwner = null;
                try {
                    schemaIdGrantor = util.getIdForSchema((DBObjectId)context.getContextVariable("CATALOGID"), privRs.getString(6));
                    schemaIdOwner = util.getIdForSchema((DBObjectId)context.getContextVariable("CATALOGID"), privRs.getString(8));
                }
                catch (PersistenceException e1) {
                    continue;
                }
                if (schemaIdGrantor == null || schemaIdOwner == null) continue;
                pch2 = new PrepareClobHelper();
                pch2.append(admin + " " + action + " ON " + privRs.getString(3) + " TO " + privRs.getString(5));
                MdPrivilege mdPrivilege = null;
                if (privRs.getString(4).trim().equals("U")) {
                    mdPrivilege = new MdPrivilege(schemaIdGrantor, privRs.getString(1), "MD_TABLES", privRs.getString(2), pch2.getClobHelper());
                } else {
                    if (!privRs.getString(4).trim().equals("V")) continue;
                    mdPrivilege = new MdPrivilege(schemaIdGrantor, privRs.getString(1), "MD_VIEWS", privRs.getString(2), pch2.getClobHelper());
                }
                pch2.close();
                if (admin.equals("GRANT_W_GRANT")) {
                    mdPrivilege.setAdminOption("Y");
                } else {
                    mdPrivilege.setAdminOption("N");
                }
                DBObjectId objectId = null;
                try {
                    objectId = SQLServer7AbstractCapturerPrivilegeExtra.getIdInRepo(util, privRs.getString(4), schemaIdOwner, privRs.getString(7));
                    if (objectId == null) {
                        continue;
                    }
                }
                catch (PersistenceException e) {
                    if (objectId == null) continue;
                    throw e;
                }
                mdPrivilege.setPrivelegeObjectId(objectId);
                if (privRs.getString(4).trim().equals("U") && currentSize > 0 && (currentSize != 1 || permanentByteStore[0] != 1)) {
                    int column = 0;
                    boolean columnPrivSaved = false;
                    while (true) {
                        int byteNumber = ++column / 8;
                        int bitNumber = column % 8;
                        if (byteNumber > currentSize) continue block18;
                        int interrum = permanentByteStore[byteNumber] >>> bitNumber & 1;
                        if (interrum != 1) continue;
                        MdPrivilege mdPrivilege2 = null;
                        try {
                            mdPrivilege2 = new MdPrivilege(schemaIdGrantor, admin, "MD_COLUMNS", action, pch2.getClobHelper());
                        }
                        catch (IOException e) {
                            MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
                            continue;
                        }
                        mdPrivilege2.setAdminOption(mdPrivilege.getAdminOption());
                        try {
                            mdPrivilege2.setPrivelegeObjectId(util.getIdForColumn(objectId, column));
                        }
                        catch (PersistenceException e) {
                            continue;
                        }
                        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)150), privRs.getString(7));
                        context.getAudience().fireListeners(event);
                        mdPrivilege2 = (MdPrivilege)storer.storeObject((PersistableObject)mdPrivilege2);
                        columnPrivSaved = true;
                        event.setEventId(4);
                        if (isRole) {
                            MdGroupPrivilege mdGroupPrivilege = new MdGroupPrivilege(role.getKey(), mdPrivilege2.getKey());
                            mdGroupPrivilege = (MdGroupPrivilege)storer.storeObject((PersistableObject)mdGroupPrivilege);
                            continue;
                        }
                        MdUserPrivilege mdUserPrivilege = new MdUserPrivilege(user.getKey());
                        mdUserPrivilege.setPrivilegeId(mdPrivilege2.getKey());
                        mdUserPrivilege = (MdUserPrivilege)storer.storeObject((PersistableObject)mdUserPrivilege);
                    }
                }
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)150), privRs.getString(7));
                context.getAudience().fireListeners(event);
                mdPrivilege = (MdPrivilege)storer.storeObject((PersistableObject)mdPrivilege);
                event.setEventId(4);
                if (isRole) {
                    MdGroupPrivilege mdGroupPrivilege = new MdGroupPrivilege(role.getKey(), mdPrivilege.getKey());
                    mdGroupPrivilege = (MdGroupPrivilege)storer.storeObject((PersistableObject)mdGroupPrivilege);
                    continue;
                }
                MdUserPrivilege mdUserPrivilege = new MdUserPrivilege(user.getKey());
                mdUserPrivilege.setPrivilegeId(mdPrivilege.getKey());
                mdUserPrivilege = (MdUserPrivilege)storer.storeObject((PersistableObject)mdUserPrivilege);
            }
        }
        catch (IOException ioe) {
            try {
                MigrationLogUtil.logThrowable((String)ioe.getLocalizedMessage(), (String)"Capture", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(privStmt, privRs);
                if (pch2 != null) {
                    try {
                        pch2.close();
                    }
                    catch (IOException e) {
                        MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
                    }
                }
                throw throwable;
            }
            CloseableResultSet.close((Statement)privStmt, privRs);
            if (pch2 != null) {
                try {
                    pch2.close();
                }
                catch (IOException e) {
                    MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
                }
            }
        }
        CloseableResultSet.close((Statement)privStmt, (ResultSet)privRs);
        if (pch2 != null) {
            try {
                pch2.close();
            }
            catch (IOException e) {
                MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void captureRoleMembership(Connection sourceConnection, MigrationStorer storer, CaptureContext context, ArrayList<MdGroup> groupAL, boolean isOnline) throws SQLException, PersistenceException {
        PersistenceUtility util = storer.getPersistenceUtility();
        Statement stmt = null;
        ResultSet rs = null;
        Object pch = null;
        PreparedStatement privStmt = null;
        ResultSet privRs = null;
        try {
            String database = SQLServer7AbstractCapturerPrivilegeExtra.getDatabase((MigrationContext)context);
            CloseableIterator schemas = util.getSchemasforCatalogId((DBObjectId)context.getContextVariable("CATALOGID"));
            ArrayList<MdUser> usersAL = new ArrayList<MdUser>();
            while (schemas.hasNext()) {
                CloseableIterator users = util.getUsersforSchemaId(((MdSchema)schemas.next()).getKey());
                while (users.hasNext()) {
                    MdUser mdUser = (MdUser)users.next();
                    usersAL.add(mdUser);
                }
            }
            for (MdGroup agroup : groupAL) {
                String roleName = agroup.getGroupName();
                if (roleName.equals("public")) {
                    for (MdUser auser : usersAL) {
                        MdGroupMember mdGroupMember = new MdGroupMember(agroup.getKey());
                        mdGroupMember.setUserId(auser.getKey());
                        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)146), roleName);
                        context.getAudience().fireListeners(event);
                        mdGroupMember = (MdGroupMember)storer.storeObject((PersistableObject)mdGroupMember);
                        event.setEventId(4);
                    }
                    continue;
                }
                String memberinfo = this.captureRoleMembershipString(database);
                privStmt = null;
                privRs = null;
                try {
                    String sql = memberinfo;
                    privStmt = sourceConnection.prepareStatement(sql);
                    if (!isOnline) {
                        privStmt.setString(1, database);
                        privStmt.setString(2, roleName);
                    } else {
                        privStmt.setString(1, roleName);
                    }
                    privRs = privStmt.executeQuery();
                    while (privRs.next()) {
                        String member = privRs.getString(1);
                        DBObjectId userIdMatch = null;
                        DBObjectId groupIdMatch = null;
                        for (MdUser mdUser : usersAL) {
                            if (!mdUser.getUsername().equals(member)) continue;
                            userIdMatch = mdUser.getKey();
                            break;
                        }
                        if (userIdMatch == null) {
                            for (MdGroup agroup2 : groupAL) {
                                if (!agroup2.getGroupName().equals(member)) continue;
                                groupIdMatch = agroup2.getKey();
                                break;
                            }
                        }
                        if (userIdMatch == null && groupIdMatch == null) continue;
                        MdGroupMember mdGroupMember = new MdGroupMember(agroup.getKey());
                        if (userIdMatch != null) {
                            mdGroupMember.setUserId(userIdMatch);
                        } else {
                            if (groupIdMatch == null) continue;
                            mdGroupMember.setGroupMemberId(groupIdMatch);
                        }
                        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)146), roleName);
                        context.getAudience().fireListeners(event);
                        mdGroupMember = (MdGroupMember)storer.storeObject((PersistableObject)mdGroupMember);
                        event.setEventId(4);
                    }
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close(privStmt, privRs);
                    throw throwable;
                    return;
                }
                CloseableResultSet.close((Statement)privStmt, (ResultSet)privRs);
            }
        }
        finally {
            CloseableResultSet.close(stmt, rs);
            if (pch != null) {
                try {
                    pch.close();
                }
                catch (Exception io) {
                    MigrationLogUtil.logThrowable((String)io.getLocalizedMessage(), (String)"Capture", (Throwable)io);
                }
            }
        }
    }

    public static DBObjectId getIdInRepo(PersistenceUtility util, String type, DBObjectId schemaId, String name) throws PersistenceException {
        if (type.equals("FN") || type.equals("IF") || type.trim().equals("P") || type.equals("TF") || type.trim().equals("X")) {
            return util.getIdForStoredProgram(schemaId, name);
        }
        if (type.trim().equals("U")) {
            return util.getIdForTable(schemaId, name);
        }
        if (type.trim().equals("V")) {
            return util.getIdForView(schemaId, name);
        }
        return null;
    }

    public static String getDatabase(MigrationContext context) throws SQLException {
        String database = null;
        MdCatalog catalog = (MdCatalog)context.getContextVariable("CATALOG");
        database = catalog.getCatalogName();
        return database;
    }
}

