/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.SQLServer7AbstractCapturer;
import oracle.dbtools.migration.workbench.plugin.SQLServer7CaptureQueries;
import oracle.dbtools.migration.workbench.plugin.SQLServer7OnlineCapturerPrivilegeExtra;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLServer7CaptureObjectsOnlineCapturer
extends SQLServer7AbstractCapturer {
    private static SQLServer7CaptureQueries s_captureQueries;

    @Override
    protected String getShowUsersInDatabase(String database) {
        return "use [" + database + "] SELECT l.name, u.name, u.uid FROM [" + database + "]..sysusers u, master..syslogins l " + " where l.suid  =* u.suid and u.uid < 16384 and u.uid<>u.gid and u.name <> 'sys' and " + " u.name <> 'INFORMATION_SCHEMA' ";
    }

    @Override
    protected String andExistsTablesOrProcedures(String database) {
        return " and exists (select 1 from [" + database + "]..sysobjects o where ObjectProperty(o.id, " + "'IsMSShipped') = 0 and o.uid=u.uid) ";
    }

    @Override
    protected String getDatabasesString() {
        return "select name from master..sysdatabases where name = db_name() ";
    }

    @Override
    protected String getTablesString(String database) {
        return "SELECT a.name , a.id FROM [" + database + "]..sysobjects a, [" + database + "]..sysusers b" + " WHERE b.name=? and " + " a.xtype='U' " + " and b.uid = a.uid ";
    }

    @Override
    protected String getColumnsString(String database, int tableId) {
        return "select DISTINCT a.name, b.name,  c.name, c.colid, d.name,  c.length, c.prec, c.scale, c.status,  c.xusertype, c.xtype, c.cdefault,  UPPER(a.name) from [" + database + "]..sysobjects a, [" + database + "]..sysusers b, [" + database + "]..syscolumns c, " + " [" + database + "]..systypes d" + " where a.xtype='U' " + " and a.id = " + tableId + " and b.uid = a.uid " + " and a.id = c.id " + " and d.xusertype = c.xusertype " + " order by UPPER(a.name), c.colid ";
    }

    @Override
    protected String getBaseTypeString(String database, int typeNumber) {
        return " SELECT a.name  FROM [" + database + "]..systypes a " + " WHERE a.xusertype = " + typeNumber + " ORDER BY a.usertype ";
    }

    @Override
    protected String getColumnDefaultString(String database, int defaultId) {
        return "SELECT CASE WHEN (a.encrypted = 1) then '/* ddl not accessible */' else a.text end FROM [" + database + "]..syscomments a " + " WHERE a.id = " + defaultId;
    }

    @Override
    protected String getCaptureIndexString(String database) {
        return " SELECT i.id, i.indid, i.name,          i.status, o.name, o.id  FROM  [" + database + "]..sysindexes i, [" + database + "]..sysobjects o,  [" + database + "]..sysusers u " + " WHERE " + this.getXTypeWhereInIndex() + " AND   o.id = i.id        " + " AND   i.keycnt > 0           " + " AND   o.uid = u.uid      " + " AND   i.indid >0 and i.indid < 255 " + " AND " + this.getForCaptureIndex() + " AND   u.name = ? AND o.name = ? ";
    }

    @Override
    protected String getPrimaryKeyString(String database) {
        return "SELECT * FROM [" + database + "]..sysobjects" + " WHERE name = ?" + " AND type = 'K' ";
    }

    @Override
    protected String getIndexString(String database, int tableId, int indId) {
        return " SELECT a.keyno, b.name  FROM [" + database + "]..sysindexkeys a , [" + database + "]..syscolumns b " + " WHERE a.id = " + tableId + " AND b.id = a.id " + " AND b.colid = a.colid " + " AND a.indid = " + indId;
    }

    @Override
    protected String captureUniqueAndPrimaryKeysString(String database) {
        return " SELECT a.name, a2.name,  a.id, c.keyno, d.name, c.id ,b.indid , a.xtype ,a.status  FROM [" + database + "]..sysobjects a2, [" + database + "]..sysobjects a, [" + database + "]..sysindexes b, [" + database + "]..sysindexkeys c, [" + database + "]..syscolumns d, [" + database + "]..sysusers e  WHERE a.type='K' AND a2.id = a.parent_obj " + " AND a.name=b.name and a2.name = ? " + " and e.name = ? AND c.id = b.id AND c.indid = b.indid " + " and  b.id=a.parent_obj " + " AND d.id = c.id  AND d.colid = c.colid  AND e.uid = a.uid " + " AND " + this.getXTypeWhere() + " ORDER BY a.id, c.keyno";
    }

    @Override
    protected String captureForeignKeysStringString(String database) {
        return " select b.name, a.fkeyid, a.rkeyid, a.keycnt,  a.fkey1, a.fkey2, a.fkey3, a.fkey4, a.fkey5, a.fkey6,  a.fkey7, a.fkey8, a.fkey9, a.fkey10, a.fkey11, a.fkey12,  a.fkey13, a.fkey14, a.fkey15, a.fkey16,  a.rkey1, a.rkey2, a.rkey3, a.rkey4, a.rkey5, a.rkey6,  a.rkey7, a.rkey8, a.rkey9, a.rkey10, a.rkey11, a.rkey12,  a.rkey13, a.rkey14, a.rkey15, a.rkey16  from [" + database + "]..sysreferences a, [" + database + "]..sysobjects b, [" + database + "]..sysobjects b2, [" + database + "]..sysusers c, [" + database + "]..sysusers e " + " where a.fkeyid = b2.id and b2.name = ? " + " and e.uid=b2.uid and e.name= ? " + " and b.id = a.constid " + " and b.xtype = 'F' " + " and b.uid = c.uid ";
    }

    @Override
    protected String getTableNameAndUserString(String database, int id) {
        return "SELECT a.name , b.name  FROM [" + database + "]..sysobjects a, [" + database + "]..sysusers b" + " WHERE a.id=" + id + " and b.uid = a.uid ";
    }

    @Override
    protected String captureTableLevelCheckConstraintString(String database) {
        return "SELECT a.name, CASE WHEN (b.encrypted = 1) then '/* ddl not accessible */' else b.text end, d.id FROM [" + database + "]..sysobjects a, [" + database + "]..sysobjects a2, [" + database + "]..syscomments b, [" + database + "]..sysusers c, [" + database + "]..sysconstraints d " + " WHERE a.xtype='C' " + " AND a.id = b.id " + " AND a.uid = c.uid  " + " AND d.constid = a.id " + " AND d.colid = 0 AND a.parent_obj = a2.id and a2.name= ? " + " AND c.name = ? ";
    }

    @Override
    protected String captureColumnLevelCheckConstraintString(String database) {
        return "SELECT a.name, b.colid,  d.colid, CASE WHEN (b.encrypted = 1) then '/* ddl not accessible */' else b.text end, d.id FROM [" + database + "]..sysobjects a, [" + database + "]..sysobjects a2, [" + database + "]..syscomments b, [" + database + "]..sysusers c, [" + database + "]..sysconstraints d " + " WHERE a.xtype='C' " + " AND a.id = b.id " + " AND a.uid = c.uid  " + " AND d.constid = a.id " + " AND d.colid <> 0 AND a.parent_obj = a2.id and a2.name= ? " + " AND c.name = ? ";
    }

    @Override
    protected String captureRulesString(String database) {
        return " SELECT DISTINCT a.name,  b.name, b.colid, b.domain  FROM [" + database + "]..sysobjects a, [" + database + "]..syscolumns b, [" + database + "]..sysusers c" + " WHERE a.name = ? AND c.name = ? " + " AND a.xtype = 'U' " + " AND b.id = a.id " + " AND c.uid = a.uid " + " AND b.domain >  0 " + " ORDER BY b.colid ";
    }

    @Override
    protected String captureRulesTextString(String database) {
        return " SELECT CASE WHEN (encrypted = 1) then '/* ddl not accessible */' else text end FROM [" + database + "]..syscomments " + " WHERE id = ? ";
    }

    @Override
    protected String captureViewOuterString(String database) {
        return "SELECT a.id, a.name  FROM [" + database + "]..sysobjects a, [" + database + "]..sysusers b " + " WHERE a.xtype='V' " + " AND a.uid = b.uid " + " and b.name=? and a.category=0 ";
    }

    @Override
    protected String captureViewInnerString(String database) {
        return "SELECT DISTINCT a.name, b.colid, CASE WHEN (b.encrypted = 1) then '/* ddl not accessible */' else b.text end  FROM [" + database + "]..sysobjects a, [" + database + "]..syscomments b " + " WHERE a.id = ? and a.xtype='V' AND a.id = b.id " + " AND a.id = b.id and a.category=0 ORDER BY b.colid ";
    }

    @Override
    protected String captureStoredProgramOuterString(String database) {
        return " SELECT a.name, a.id  FROM   [" + database + "]..sysobjects a, [" + database + "]..sysusers b  " + " WHERE  " + this.getWhereForStoredPrograms() + " AND a.uid = b.uid  " + " AND a.category = 0 " + " AND b.name = ? ";
    }

    @Override
    protected String captureStoredProgramInnerString(String database, String queryAdd) {
        return " SELECT a.name, a.id, b.colid, CASE WHEN (b.encrypted = 1) then '/* ddl not accessible */' else b.text end, a.xtype   FROM   [" + database + "]..sysobjects a, [" + database + "]..syscomments b " + " WHERE  a.id = ? AND " + this.getWhereForStoredPrograms() + " AND a.id = b.id  " + " AND a.category = 0 " + queryAdd + " order by b.colid ";
    }

    @Override
    protected String captureTriggersString(String database) {
        return " SELECT a.name, a.id, b.colid, CASE WHEN (b.encrypted = 1) then '/* ddl not accessible */' else b.text end  FROM   [" + database + "]..sysobjects a, [" + database + "]..syscomments b, [" + database + "]..sysusers c,  " + "[" + database + "]..sysobjects d " + " WHERE  a.xtype = 'TR' " + " AND a.id = b.id  " + " AND d.uid = c.uid  " + " AND a.category = 0 " + " AND c.name = ? " + " AND d.name = ? " + " AND a.parent_obj=d.id " + " order by a.id, b.colid";
    }

    @Override
    protected String captureRolesString(String database) {
        return "select b.name, a.name from [" + database + "]..sysusers a, [" + database + "]..sysusers b where b.issqlrole=1 " + "and b.altuid=a.uid ";
    }

    @Override
    protected String getColumnNameString(String database) {
        return "select a.name from [" + database + "]..syscolumns a, [" + database + "]..sysobjects b, [" + database + "]..sysusers c where a.id = b.id and b.uid = c.uid and c.name = ? " + " and b.name = ? and a.colid = ? ";
    }

    @Override
    protected void capturePrivileges(Connection sourceConnection, MigrationStorer storer, CaptureContext context, ArrayList<MdGroup> groupAL, MdGroup role, MdUser user) throws SQLException, PersistenceException {
        new SQLServer7OnlineCapturerPrivilegeExtra().capturePrivileges(this.getRepositoryConnection(), this.getStorer(), context, groupAL, role, user, this.m_online);
    }

    @Override
    protected void captureRoleMembership(Connection sourceConnection, MigrationStorer storer, CaptureContext context, ArrayList<MdGroup> groupAL) throws SQLException, PersistenceException {
        new SQLServer7OnlineCapturerPrivilegeExtra().captureRoleMembership(this.getRepositoryConnection(), storer, context, groupAL, this.m_online);
    }

    @Override
    public String getModelName() throws CaptureException {
        return null;
    }

    public SQLServer7CaptureObjectsOnlineCapturer(MigrationStorer storer, Connection sourceConnection) {
        this.m_online = true;
        this.setStorer(storer);
        this.m_repositoryConnection = sourceConnection;
    }

    @Override
    public String getSourceURL() throws CaptureException {
        return "/tmp/sqlserver7";
    }

    @Override
    public void setStorer(MigrationStorer storer) {
        this.m_storer = storer;
    }

    @Override
    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    @Override
    public Connection getRepositoryConnection() {
        return this.m_repositoryConnection;
    }

    @Override
    public void setRepositoryConnection(Connection repositoryConnection) {
        this.m_repositoryConnection = repositoryConnection;
    }

    @Override
    protected String captureCommentsString() {
        return "select value from sysproperties where id=? and smallid=?";
    }
}

