/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.AbstractOnlineCapturer;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.SQLServer7CaptureObjectsOnlineCapturer;
import oracle.dbtools.migration.workbench.plugin.SQLServer7CaptureQueries;

public class SQLServer7Capturer
extends AbstractOnlineCapturer {
    protected SQLServer7CaptureObjectsOnlineCapturer m_7CaptureObjectsOnlineCapturer = null;
    private String m_modelName;
    public static final String MY_LANGUAGE_ID = "MSTSQL";
    public static final String NEWID_FUNCTION = "(newid())";
    private static String s_sqlServerDatabaseToUse = null;
    private static SQLServer7CaptureQueries s_captureQueries;

    public SQLServer7Capturer(MigrationStorer storer, Connection sourceConnection) {
        super(storer, sourceConnection);
        this.m_7CaptureObjectsOnlineCapturer = new SQLServer7CaptureObjectsOnlineCapturer(storer, sourceConnection);
    }

    public static String getSqlServerDatabaseToUse() {
        return SQLServer7CaptureObjectsOnlineCapturer.getSqlServerDatabaseToUse();
    }

    public static void setSqlServerDatabaseToUse(String inDatabase) {
        SQLServer7CaptureObjectsOnlineCapturer.setSqlServerDatabaseToUse(inDatabase);
    }

    public CaptureQueries getCaptureQueries() {
        if (s_captureQueries == null) {
            s_captureQueries = new SQLServer7CaptureQueries();
        }
        return s_captureQueries;
    }

    public void captureObjects(String objType, CaptureContext context, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        this.m_7CaptureObjectsOnlineCapturer.captureObjects(objType, context, filter);
    }

    public String getModelName() throws CaptureException {
        if (this.m_modelName == null) {
            try {
                DatabaseMetaData dbmd = this.m_sourceConnection.getMetaData();
                String url = dbmd.getURL();
                String[] parts = url.split("/");
                this.m_modelName = "\\\\" + parts[2] + "\\" + this.m_sourceConnection.getCatalog() + " (" + dbmd.getDatabaseProductName() + ")";
            }
            catch (SQLException sqlex) {
                throw new CaptureException((Throwable)sqlex);
            }
        }
        return this.m_modelName;
    }
}

