/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdUserDefinedDataType;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.plugin.SQLServer7CapturerColumnInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SQLServer7CapturerColumnsBySelect {
    private static MigrationStorer prevStorer = null;
    private static HashSet<String> hSet = new HashSet();

    private SQLServer7CapturerColumnsBySelect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveColumns(Hashtable<Integer, MdColumn> columnHt, String tableRef, Connection con, MigrationStorer storer, MdTable table, DBObjectId connectionId, CaptureContext context, String catalogS, String schemaS, String tableS, boolean privilegeWarn) throws SQLException, PersistenceException {
        boolean privilegeReturn = privilegeWarn;
        String query = "select * from " + tableRef + " where 1 = 2";
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            int i;
            block14: {
                s = con.prepareStatement(query);
                rs = s.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                int numberOfColumns = rsmd.getColumnCount();
                if (numberOfColumns == columnHt.size()) break block14;
                if (!privilegeReturn) {
                    privilegeReturn = true;
                    Logger.getLogger("oracle.dbtools.migration").log(Level.INFO, "SQLSERVER.PRIVILEGES_MISSING");
                }
                for (i = 1; i <= numberOfColumns; ++i) {
                    ResultSet rs2;
                    Object migrColumn;
                    Integer[] retVal;
                    block13: {
                        if (columnHt.get(new Integer(i)) != null) continue;
                        retVal = SQLServer7CapturerColumnsBySelect.getPrecisionScaleIdentity(rsmd.getColumnTypeName(i), rsmd.getPrecision(i), rsmd.getScale(i));
                        migrColumn = null;
                        migrColumn = retVal[2] != null || rsmd.isAutoIncrement(i) ? new MdIdentityColumn(table.getKey(), rsmd.getColumnName(i), Integer.valueOf(i), 1L, connectionId) : new MdColumn(table.getKey(), rsmd.getColumnName(i), Integer.valueOf(i));
                        migrColumn.setColumnType(rsmd.getColumnTypeName(i));
                        rs2 = null;
                        try {
                            rs2 = con.getMetaData().getColumns(catalogS, schemaS, tableS, rsmd.getColumnName(i));
                            if (rs2.next() && rs2.getString(1).equals(catalogS) && rs2.getString(2).equals(schemaS) && rs2.getString(3).equals(tableS) && rs2.getString(4).equals(rsmd.getColumnName(i))) {
                                String sDefValue = rs2.getString(13);
                                migrColumn.setDefaultValue(sDefValue);
                                if (sDefValue != null && sDefValue.equals("(newid())")) {
                                    migrColumn.addProperty("(newid())", "Y", connectionId);
                                }
                                break block13;
                            }
                            migrColumn.setDefaultValue(null);
                        }
                        catch (SQLException se) {
                            try {
                                Logger.getLogger(SQLServer7CapturerColumnsBySelect.class.getClass().getName()).log(Level.WARNING, se.getStackTrace()[0].toString(), se);
                                migrColumn.setDefaultValue(null);
                            }
                            catch (Throwable throwable) {
                                CloseableResultSet.close(null, rs2);
                                throw throwable;
                            }
                            CloseableResultSet.close(null, (ResultSet)rs2);
                        }
                    }
                    CloseableResultSet.close(null, (ResultSet)rs2);
                    if (rsmd.isNullable(i) == 0) {
                        migrColumn.setNullable("N");
                    } else {
                        migrColumn.setNullable("Y");
                    }
                    migrColumn.setPrecision(retVal[0]);
                    migrColumn.setScale(retVal[1]);
                    columnHt.put(new Integer(i), (MdColumn)migrColumn);
                }
            }
            for (i = 1; i <= columnHt.size(); ++i) {
                MdColumn migrColumn = columnHt.get(new Integer(i));
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)134), migrColumn.getColumnName());
                context.getAudience().fireListeners(event);
                migrColumn = (MdColumn)storer.storeObject((PersistableObject)migrColumn);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close((Statement)s, rs);
            throw throwable;
        }
        CloseableResultSet.close((Statement)s, (ResultSet)rs);
        return privilegeReturn;
    }

    public static Integer[] getPrecisionScaleIdentity(String type, Integer precisionIn, Integer scaleIn) {
        String lowerType = type.toLowerCase().trim();
        Integer precision = precisionIn;
        Integer scale = scaleIn;
        Integer identityValue = null;
        if (lowerType.endsWith("identity")) {
            lowerType = lowerType.substring(0, lowerType.indexOf("identity")).trim();
            identityValue = 1;
        }
        if (lowerType.equals("bigint")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("int")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("smallint")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("money")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("tinyint")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("smallmoney")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("bit")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("float")) {
            if (precision != null && precision == 0) {
                precision = null;
            }
            scale = null;
        } else if (lowerType.equals("real")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("datetime")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("smalldatetime")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("char")) {
            scale = null;
        } else if (lowerType.equals("text")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("varchar")) {
            scale = null;
        } else if (lowerType.equals("sysname")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("nchar")) {
            scale = null;
        } else if (lowerType.equals("ntext")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("nvarchar")) {
            scale = null;
        } else if (lowerType.equals("binary")) {
            scale = null;
        } else if (lowerType.equals("image")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("varbinary")) {
            scale = null;
        } else if (lowerType.equals("cursor")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("timestamp")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("sql_variant")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("uniqueidentifier")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("table")) {
            precision = null;
            scale = null;
        } else if (lowerType.equals("xml")) {
            precision = null;
            scale = null;
        }
        return new Integer[]{precision, scale, identityValue};
    }

    public static void clearHashSet() {
        prevStorer = null;
        hSet = new HashSet();
    }

    public static void registerUserDefinedType(MigrationStorer storer, String origColType, MdSchema schema, SQLServer7CapturerColumnInfo column, MdColumn migrColumn) throws PersistenceException {
        try {
            String def = "test";
            String baseType = column.getNativeColumnType();
            Integer precision = migrColumn.getPrecision();
            Integer scale = column.getNativeColumnScale();
            String lowerType = baseType.toLowerCase();
            if (prevStorer == null || !storer.equals(prevStorer)) {
                prevStorer = storer;
                hSet = new HashSet();
            }
            if (!hSet.add(origColType)) {
                return;
            }
            if (lowerType.equals("bigint")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("int")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("smallint")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("money")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("tinyint")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("smallmoney")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("bit")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("float")) {
                if (precision != null && precision == 0) {
                    precision = null;
                }
                scale = null;
            } else if (lowerType.equals("real")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("datetime")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("smalldatetime")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("char")) {
                scale = null;
            } else if (lowerType.equals("text")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("varchar")) {
                scale = null;
            } else if (lowerType.equals("sysname")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("nchar")) {
                scale = null;
            } else if (lowerType.equals("ntext")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("nvarchar")) {
                scale = null;
            } else if (lowerType.equals("binary")) {
                scale = null;
            } else if (lowerType.equals("image")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("varbinary")) {
                scale = null;
            } else if (lowerType.equals("cursor")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("timestamp")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("sql_variant")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("uniqueidentifier")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("table")) {
                precision = null;
                scale = null;
            } else if (lowerType.equals("xml")) {
                precision = null;
                scale = null;
            }
            String precisionString = "";
            if (precision != null && precision == -999) {
                precisionString = "MAX";
                precision = 1;
            } else {
                precisionString = precision != null ? precision.toString() : "";
            }
            def = baseType;
            if (precision != null) {
                def = scale != null ? baseType + "(" + precisionString + ", " + scale.toString() + ")" : baseType + "(" + precisionString + ")";
            }
            ClobHelper chDef = new ClobHelper(def);
            MdUserDefinedDataType mdUDT = new MdUserDefinedDataType(schema.getKey(), origColType, def, chDef);
            mdUDT = (MdUserDefinedDataType)storer.storeObject((PersistableObject)mdUDT);
            return;
        }
        catch (Exception e) {
            MigrationLogUtil.logThrowable((String)e.getLocalizedMessage(), (String)"Capture", (Throwable)e);
            return;
        }
    }
}

