/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.convert.AbstractConverter;
import oracle.dbtools.migration.convert.ConvertException;
import oracle.dbtools.migration.convert.ConvertResult;
import oracle.dbtools.migration.convert.ConvertResultImpl;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.parser.ParserFactory;
import oracle.dbtools.migration.translation.api.ITranslator;

public class SQLServer7Converter
extends AbstractConverter {
    private static final String GUID_TRIGGER_BODY = "create or replace TRIGGER %s BEFORE INSERT ON %s\nFOR EACH ROW\nDECLARE\nv_guid RAW(16) := SYS_GUID;\nbegin\n  if :new.%s is null then\n    :new.%s := substr(v_guid,1,8) || '-' || substr(v_guid,9,4) || '-' || substr(v_guid,13,4) || '-' || substr(v_guid,17,4) || '-' || substr(v_guid, 21);\n  end if;\nend;\n";

    public ITranslator getPlaformTranslator() {
        return ParserFactory.getParser((String)"oracle.dbtools.migration.parser.tsql.TSQLParserMain");
    }

    public String getDefaultValueMappingXML() {
        return "SQLServerDefaultValuesMappingRules.xml";
    }

    public ConvertResult convertObject(PersistableObject schemaObj, String matchingKey, PersistenceManager pman) throws ConvertException {
        ConvertResultImpl res = null;
        if (matchingKey.equals("(newid())")) {
            MdColumn col = (MdColumn)schemaObj;
            res = new ConvertResultImpl(schemaObj);
            col.setDefaultValue(null);
            try {
                MdTable parent = MdTable.retrieveExistingInstance((PersistenceManager)pman, (DBObjectId)col.getTableId());
                MdTrigger trigger = new MdTrigger(parent.getKey(), "T", "OracleSQL");
                String sTriggerName = ConvertUtils.generateName((String)(parent.getTableName() + "_" + col.getColumnName() + "_GUIDTRG"));
                String triggerText = String.format(GUID_TRIGGER_BODY, sTriggerName, parent.getTableName(), col.getColumnName(), col.getColumnName());
                trigger.setTriggerName(sTriggerName);
                trigger.setNativeSql(triggerText);
                res.addNewDerivedObject((PersistableObject)trigger);
            }
            catch (PersistenceException e) {
                throw new ConvertException((Exception)((Object)e));
            }
            catch (NoSuchObjectException e) {
                throw new ConvertException((Exception)((Object)e));
            }
        }
        return res;
    }

    public String[] getPropertyKeyList() {
        return new String[]{"(newid())"};
    }
}

