/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.GenerateDSMLFormattedFiles;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.MetadataFileParser;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.ObjectStatusList;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.OracleDatatypeIdentifiers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLServer7DoOfflineCaptureLoad
implements OracleDatatypeIdentifiers {
    private HashMap<File, ArrayList<File>> _dbXMLMetadataList = new HashMap();
    private HashMap<File, ObjectStatusList> m_dSMLMap = null;
    private String _currentTableName = null;
    private int _currentDbId = 0;
    public String currValue = "";
    private HashMap<String, String[]> m_tableTypes = new HashMap();
    private Connection conn = null;

    public SQLServer7DoOfflineCaptureLoad(Connection inConn) {
        this.conn = inConn;
        this.populateTableTypes();
    }

    private void errorIfFilesAreMissing(HashMap<File, ObjectStatusList> dbs) {
    }

    public void loadSourceModel(HashMap<File, ObjectStatusList> dbs) throws OfflineCaptureException {
        this.m_dSMLMap = dbs;
        Statement stmt = null;
        Connection repConnection = null;
        Object rs = null;
        Object rowDelimiter = null;
        Object colDelimiter = null;
        this.errorIfFilesAreMissing(dbs);
        try {
            repConnection = this.conn;
            stmt = repConnection.createStatement();
            GenerateDSMLFormattedFiles dsmlFormattedFiles = new GenerateDSMLFormattedFiles(this.m_dSMLMap);
            this._dbXMLMetadataList = dsmlFormattedFiles.getDSMLFormattedFilesTable();
            File dbFile = this.getDbFile("MASTER");
            if (dbFile == null) {
                throw new OfflineCaptureException(new Exception());
            }
            this._currentDbId = 1;
            this.populateSourceModel(repConnection, dbFile, 1);
            for (File dbFilename : this._dbXMLMetadataList.keySet()) {
                int dbId;
                if (dbFilename.getName().equalsIgnoreCase("MASTER")) continue;
                this._currentDbId = dbId = this.getDbId(repConnection, dbFilename.getName());
                if (dbId == 0) continue;
                this.populateSourceModel(repConnection, dbFilename, dbId);
            }
            this.sourceModelIndexCreate(repConnection);
            repConnection.commit();
        }
        catch (SQLException e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw new OfflineCaptureException((Exception)e);
        }
        catch (Exception e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw new OfflineCaptureException(e);
        }
    }

    private File getDbFile(String dbName) {
        File dbFile = null;
        for (File file : this.m_dSMLMap.keySet()) {
            String nextDbName = file.getName();
            if (!nextDbName.equalsIgnoreCase(dbName)) continue;
            dbFile = file;
            break;
        }
        return dbFile;
    }

    private int getDbId(Connection repConnection, String dbName) throws OfflineCaptureException {
        Statement repStatement = null;
        ResultSet rs = null;
        int dbId = 0;
        try {
            repStatement = repConnection.createStatement();
            String sql = " SELECT DBID FROM SS7_SYSDATABASES  WHERE UPPER(NAME) = '" + dbName.toUpperCase() + "' ";
            rs = repStatement.executeQuery(sql);
            while (rs.next()) {
                dbId = rs.getInt(1);
            }
            return dbId;
        }
        catch (SQLException e) {
            throw new OfflineCaptureException((Exception)e);
        }
    }

    private void populateSourceModel(Connection repConnection, File dbName, int dbId) throws OfflineCaptureException {
        try {
            ArrayList<File> xMLMetadataFiles = this._dbXMLMetadataList.get(dbName);
            Iterator<File> i$ = xMLMetadataFiles.iterator();
            while (i$.hasNext()) {
                File f;
                File filename = f = i$.next();
                this._currentTableName = GenerateDSMLFormattedFiles.getUnqualifiedName(filename.getName());
                String[] fieldTypes = this.getFieldTypes(this._currentTableName);
                if (fieldTypes == null) continue;
                MetadataFileParser metaParser = new MetadataFileParser(this._currentDbId, SQLServer7DoOfflineCaptureLoad.fileToURL(filename), this._currentTableName);
                metaParser.createPrepardStatement(repConnection, fieldTypes);
                int numRecordsLoaded = metaParser.loadData();
            }
        }
        catch (SQLException e) {
            throw new OfflineCaptureException((Exception)e);
        }
    }

    private String[] getFieldTypes(String tableName) {
        String[] tableTypes = null;
        for (String nextElement : this.m_tableTypes.keySet()) {
            if (!tableName.equalsIgnoreCase(nextElement)) continue;
            tableTypes = this.m_tableTypes.get(nextElement.toUpperCase());
            break;
        }
        return tableTypes;
    }

    private void populateTableTypes() {
        String[] columnList1 = new String[]{"3", "3", "6", "3", "5", "5", "5", "3", "3", "3", "3", "3", "1", "1", "1", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "1"};
        this.m_tableTypes.put("SS7_SYSLOGINS", columnList1);
        String[] columnList2 = new String[]{"3", "1", "3", "6", "3", "3", "3", "5", "5", "3", "3", "1", "3", "3"};
        this.m_tableTypes.put("SS7_SYSDATABASES", columnList2);
        String[] columnList3 = new String[]{"3", "3", "3", "1", "6", "7", "5", "5", "3", "6", "3", "3", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS7_SYSUSERS", columnList3);
        String[] columnList4 = new String[]{"3", "3", "3", "3", "3", "3", "6", "6", "6", "6", "6", "6"};
        this.m_tableTypes.put("SS7_SYSPERMISSIONS", columnList4);
        String[] columnList5 = new String[]{"3", "3", "3", "3", "3", "6", "3"};
        this.m_tableTypes.put("SS7_SYSPROTECTS", columnList5);
        String[] columnList6 = new String[]{"3", "1", "3", "8", "3", "3", "3", "3", "3", "3", "5", "3", "3", "3", "8", "3", "3", "3", "5", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS7_SYSOBJECTS", columnList6);
        String[] columnList7 = new String[]{"3", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "6", "3", "3", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS7_SYSCOLUMNS", columnList7);
        String[] columnList8 = new String[]{"3", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "1", "3", "3"};
        this.m_tableTypes.put("SS7_SYSTYPES", columnList8);
        String[] columnList9 = new String[]{"3", "3", "3", "6", "3", "6", "3", "3", "3", "3", "3", "3", "6", "3", "3", "3", "3", "3", "3", "3", "3", "6", "3", "3", "3", "6", "1", "3", "3"};
        this.m_tableTypes.put("SS7_SYSINDEXES", columnList9);
        String[] columnList10 = new String[]{"3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS7_SYSINDEXKEYS", columnList10);
        String[] columnList11 = new String[]{"3", "3", "3", "3", "3", "3", "6", "6", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS7_SYSREFERENCES", columnList11);
        String[] columnList12 = new String[]{"3", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS7_SYSCONSTRAINTS", columnList12);
        String[] columnList13 = new String[]{"3", "3", "3", "3", "3", "3", "3", "3", "3", "4"};
        this.m_tableTypes.put("SS7_SYSCOMMENTS", columnList13);
        String[] columnList14 = new String[]{"3", "3", "3", "3", "3", "3", "3", "3", "1", "1"};
        this.m_tableTypes.put("SS7_SYSFILES", columnList14);
        String[] columnList15 = new String[]{"3", "3", "3"};
        this.m_tableTypes.put("SS7_SYSMEMBERS", columnList15);
        String[] columnList16 = new String[]{"3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS7_SYSFOREIGNKEYS", columnList16);
        String[] columnList17 = new String[]{"3", "3", "3", "3", "1", "1"};
        this.m_tableTypes.put("SS7_SYSPROPERTIES", columnList17);
    }

    private static URL fileToURL(File file) {
        String path = file.getAbsolutePath();
        String fSep = System.getProperty("file.separator");
        if (fSep != null && fSep.length() == 1) {
            path = path.replace(fSep.charAt(0), '/');
        }
        if (path.length() > 0 && path.charAt(0) != '/') {
            path = '/' + path;
        }
        try {
            return new URL("file", null, path);
        }
        catch (MalformedURLException e) {
            System.out.println("Exception :SQLServer7DisconnSourceModelLoad.fileToURL(): " + e.toString());
            throw new Error("Unexpected MalformedURLException");
        }
    }

    private void sourceModelIndexCreate(Connection repConn) throws OfflineCaptureException {
        Statement stmt1 = null;
        ArrayList<String> indexStatements = new ArrayList<String>();
        try {
            indexStatements.add("CREATE INDEX SS7_syslogins_sid on SS7_syslogins (\"SID\")");
            indexStatements.add("CREATE INDEX SS7_sysdatabases_db_id on SS7_sysdatabases (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS7_sysdatabases_name on SS7_sysdatabases (\"NAME\")");
            indexStatements.add("CREATE INDEX SS7_sysdatabases_dbid on SS7_sysdatabases (\"DBID\")");
            indexStatements.add("CREATE INDEX SS7_sysusers_uid on SS7_sysusers (\"UID\")");
            indexStatements.add("CREATE INDEX SS7_sysusers_suid on SS7_sysusers (\"SUID\")");
            indexStatements.add("CREATE INDEX SS7_sysusers_gid on SS7_sysusers (\"GID\")");
            indexStatements.add("CREATE INDEX SS7_sysusers_db_id on SS7_sysusers (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS7_permissions_db_id on SS7_syspermissions (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS7_permissions_id on SS7_syspermissions (\"ID\")");
            indexStatements.add("CREATE INDEX SS7_sysprotects_db_id on SS7_sysprotects (DB_ID)");
            indexStatements.add("CREATE INDEX SS7_sysprotects_id on SS7_sysprotects (\"ID\")");
            indexStatements.add("CREATE INDEX SS7_sysprotects_uid on SS7_sysprotects (\"UID\")");
            indexStatements.add("CREATE INDEX SS7_sysprotects_action on SS7_sysprotects (\"ACTION\")");
            indexStatements.add("CREATE INDEX SS7_sysprotects_protecttype on SS7_sysprotects (\"PROTECTTYPE\")");
            indexStatements.add("CREATE INDEX SS7_sysobj_db_id on SS7_sysobjects (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS7_sysobj_id on SS7_sysobjects (\"ID\")");
            indexStatements.add("CREATE INDEX SS7_sysobj_name on SS7_sysobjects (\"NAME\")");
            indexStatements.add("CREATE INDEX SS7_sysobj_xtype on SS7_sysobjects (\"XTYPE\")");
            indexStatements.add("CREATE INDEX SS7_sysobj_uid on SS7_sysobjects (\"UID\")");
            indexStatements.add("CREATE INDEX SS7_syscol_id on SS7_syscolumns (\"ID\")");
            indexStatements.add("CREATE INDEX SS7_syscol_db_id on SS7_syscolumns (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS7_systypes_xutype on SS7_systypes (\"XUSERTYPE\")");
            indexStatements.add("CREATE INDEX SS7_systypes_db_id on SS7_systypes (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS7_systypes_name on SS7_systypes (\"NAME\")");
            indexStatements.add("CREATE INDEX SS7_sysindex_db_id on SS7_sysindexes (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS7_sysindex_id on SS7_sysindexes (\"ID\")");
            indexStatements.add("CREATE INDEX SS7_sysindex_indid on SS7_sysindexes (\"INDID\")");
            indexStatements.add("CREATE INDEX SS7_sysindexkeys_db_id on SS7_sysindexkeys (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS7_sysindexkeys_id on SS7_sysindexkeys (\"ID\")");
            indexStatements.add("CREATE INDEX SS7_sysindexkeys_indid on SS7_sysindexkeys (\"INDID\")");
            indexStatements.add("CREATE INDEX SS7_sysreferences_rkeyid on SS7_sysreferences (\"RKEYID\")");
            indexStatements.add("CREATE INDEX SS7_sysreferences_Fkeyid on SS7_sysreferences (\"FKEYID\")");
            indexStatements.add("CREATE INDEX SS7_sysreferences_constid on SS7_sysreferences (\"CONSTID\")");
            indexStatements.add("CREATE INDEX SS7_sysreferences_db_id on SS7_sysreferences (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS7_sysconstraints_constid on SS7_sysconstraints (\"CONSTID\")");
            indexStatements.add("CREATE INDEX SS7_sysconstraints_db_id on SS7_sysconstraints (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS7_sysconstraints_id on SS7_sysconstraints (\"ID\")");
            indexStatements.add("CREATE INDEX SS7_syscomments_dbid on SS7_syscomments (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS7_syscomments_id on SS7_syscomments (\"ID\")");
            indexStatements.add("CREATE INDEX SS7_syscomments_colid on SS7_syscomments (\"COLID\")");
            indexStatements.add("CREATE INDEX SS7_sysfiles_db_id on SS7_sysfiles (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS7_sysfiles_fileid on SS7_sysfiles (\"FILEID\")");
            indexStatements.add("CREATE INDEX SS7_sysmembers_db_id on SS7_sysmembers (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS7_sysmembers_memberuid on SS7_sysmembers (\"MEMBERUID\")");
            indexStatements.add("CREATE INDEX SS7_sysmembers_groupuid on SS7_sysmembers (\"GROUPUID\")");
            indexStatements.add("CREATE INDEX SS7_sysforeignkeys_db_id on SS7_sysforeignkeys (\"DB_ID\")");
            indexStatements.add("CREATE INDEX SS7_sysforeignkeys_constid on SS7_sysforeignkeys (\"CONSTID\")");
            indexStatements.add("CREATE INDEX SS7_sysforeignkeys_fkeyid on SS7_sysforeignkeys (\"FKEYID\")");
            indexStatements.add("CREATE INDEX SS7_sysforeignkeys_rkeyid on SS7_sysforeignkeys (\"RKEYID\")");
            stmt1 = repConn.createStatement();
            Iterator i$ = indexStatements.iterator();
            while (i$.hasNext()) {
                String s;
                String sql = s = (String)i$.next();
                try {
                    stmt1.execute(sql);
                }
                catch (SQLException e2) {
                    throw new OfflineCaptureException((Exception)e2);
                }
            }
            stmt1.close();
            indexStatements.clear();
        }
        catch (SQLException e) {
            try {
                if (stmt1 != null) {
                    stmt1.close();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw new OfflineCaptureException((Exception)e);
        }
    }

    private void sourceModelIndexDrop(Connection repConn) throws OfflineCaptureException {
        Statement stmt = null;
        ArrayList<String> indexStatements = new ArrayList<String>();
        try {
            stmt = repConn.createStatement();
            indexStatements.add("DROP INDEX SS7_syslogins_sid");
            indexStatements.add("DROP INDEX SS7_sysdatabases_db_id");
            indexStatements.add("DROP INDEX SS7_sysdatabases_name");
            indexStatements.add("DROP INDEX SS7_sysdatabases_dbid");
            indexStatements.add("DROP INDEX SS7_sysusers_uid");
            indexStatements.add("DROP INDEX SS7_sysusers_suid");
            indexStatements.add("DROP INDEX SS7_sysusers_gid");
            indexStatements.add("DROP INDEX SS7_sysusers_db_id");
            indexStatements.add("DROP INDEX SS7_permissions_db_id");
            indexStatements.add("DROP INDEX SS7_permissions_id");
            indexStatements.add("DROP INDEX SS7_sysprotects_db_id");
            indexStatements.add("DROP INDEX SS7_sysprotects_id");
            indexStatements.add("DROP INDEX SS7_sysprotects_uid");
            indexStatements.add("DROP INDEX SS7_sysprotects_action");
            indexStatements.add("DROP INDEX SS7_sysprotects_protecttype");
            indexStatements.add("DROP INDEX SS7_sysobj_db_id");
            indexStatements.add("DROP INDEX SS7_sysobj_id");
            indexStatements.add("DROP INDEX SS7_sysobj_xtype");
            indexStatements.add("DROP INDEX SS7_sysobj_name");
            indexStatements.add("DROP INDEX SS7_sysobj_uid");
            indexStatements.add("DROP INDEX SS7_syscol_id");
            indexStatements.add("DROP INDEX SS7_syscol_db_id");
            indexStatements.add("DROP INDEX SS7_systypes_xutype");
            indexStatements.add("DROP INDEX SS7_systypes_db_id");
            indexStatements.add("DROP INDEX SS7_systypes_name");
            indexStatements.add("DROP INDEX SS7_sysindex_db_id");
            indexStatements.add("DROP INDEX SS7_sysindex_id");
            indexStatements.add("DROP INDEX SS7_sysindex_indid");
            indexStatements.add("DROP INDEX SS7_sysindexkeys_db_id");
            indexStatements.add("DROP INDEX SS7_sysindexkeys_id");
            indexStatements.add("DROP INDEX SS7_sysindexkeys_indid");
            indexStatements.add("DROP INDEX SS7_sysreferences_rkeyid");
            indexStatements.add("DROP INDEX SS7_sysreferences_fkeyid");
            indexStatements.add("DROP INDEX SS7_sysreferences_constid");
            indexStatements.add("DROP INDEX SS7_sysreferences_db_id");
            indexStatements.add("DROP INDEX SS7_sysconstraints_constid");
            indexStatements.add("DROP INDEX SS7_sysconstraints_db_id");
            indexStatements.add("DROP INDEX SS7_sysconstraints_id");
            indexStatements.add("DROP INDEX SS7_syscomments_dbid");
            indexStatements.add("DROP INDEX SS7_syscomments_id");
            indexStatements.add("DROP INDEX SS7_syscomments_colid");
            indexStatements.add("DROP INDEX SS7_sysfiles_db_id");
            indexStatements.add("DROP INDEX SS7_sysfiles_fileid");
            indexStatements.add("DROP INDEX SS7_sysmembers_db_id");
            indexStatements.add("DROP INDEX SS7_sysmembers_memberuid");
            indexStatements.add("DROP INDEX SS7_sysmembers_groupuid");
            indexStatements.add("DROP INDEX SS7_sysforeignkeys_db_id");
            indexStatements.add("DROP INDEX SS7_sysforeignkeys_constid");
            indexStatements.add("DROP INDEX SS7_sysforeignkeys_fkeyid");
            indexStatements.add("DROP INDEX SS7_sysforeignkeys_rkeyid");
            Iterator i$ = indexStatements.iterator();
            while (i$.hasNext()) {
                String s;
                String sql = s = (String)i$.next();
                try {
                    stmt.execute(sql);
                }
                catch (SQLException e2) {
                    throw new OfflineCaptureException((Exception)e2);
                }
            }
            stmt.close();
            indexStatements = new ArrayList();
        }
        catch (SQLException e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e1) {
                throw new OfflineCaptureException((Exception)e1);
            }
            throw new OfflineCaptureException((Exception)e);
        }
    }
}

