/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.AbstractOfflineCapturer;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.SQLServer7CaptureObjectsOfflineCapturer;
import oracle.dbtools.migration.workbench.plugin.SQLServer7CaptureQueries;
import oracle.dbtools.migration.workbench.plugin.SQLServer7DoOfflineCaptureLoad;
import oracle.dbtools.migration.workbench.plugin.SQLServer7OfflineCaptureTables;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.ObjectStatusList;
import oracle.dbtools.util.Resource;

public class SQLServer7OfflineCapturer
extends AbstractOfflineCapturer {
    protected Connection m_repositoryConnection = null;
    protected MigrationStorer m_storer = null;
    protected SQLServer7CaptureObjectsOfflineCapturer m_captureObjectsOfflineCapturer = null;
    private static SQLServer7CaptureQueries s_captureQueries;

    public String[] getScriptFiles(int platformCode) throws OfflineCaptureException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String captureInitializeImpl(String inputDirectory, Properties props) throws OfflineCaptureException {
        this.setRepositoryConnection(MigrationAddin.getPersistenceManager().getConn());
        this.m_captureObjectsOfflineCapturer = new SQLServer7CaptureObjectsOfflineCapturer(this.getStorer(), MigrationAddin.getPersistenceManager().getConn());
        HashMap<File, ObjectStatusList> dSMLMap = new HashMap<File, ObjectStatusList>();
        ObjectStatusList objStatusList = null;
        Connection conn = this.getRepositoryConnection();
        Statement stmt = null;
        try {
            String[] createTables;
            SQLServer7OfflineCaptureTables ss7;
            try {
                ss7 = new SQLServer7OfflineCaptureTables();
                for (String drop : createTables = ss7.getDropStatements()) {
                    try {
                        stmt = conn.createStatement();
                        stmt.executeUpdate(drop);
                    }
                    catch (SQLException e) {
                    }
                    finally {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException e) {}
                        }
                    }
                }
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
            ss7 = new SQLServer7OfflineCaptureTables();
            for (String create : createTables = ss7.getCreateStatements()) {
                try {
                    stmt = conn.createStatement();
                    stmt.executeUpdate(create);
                }
                catch (SQLException e) {
                    throw new OfflineCaptureException((Exception)e);
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e) {}
                    }
                }
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
        }
        File r = new File(inputDirectory);
        String[] first = r.list();
        for (String f : first) {
            String[] second;
            if (!new File(inputDirectory + File.separator + f).isDirectory()) continue;
            File dir = new File(inputDirectory + File.separator + f);
            objStatusList = new ObjectStatusList();
            for (String f2 : second = dir.list()) {
                if (!f2.endsWith(".dat") && !f2.endsWith(".DAT")) continue;
                objStatusList.add(new File(inputDirectory + File.separator + f + File.separator + f2), "Available");
            }
            dSMLMap.put(dir, objStatusList);
        }
        SQLServer7DoOfflineCaptureLoad dsml = new SQLServer7DoOfflineCaptureLoad(conn);
        try {
            dsml.loadSourceModel(dSMLMap);
        }
        catch (Exception e) {
            throw new OfflineCaptureException(e);
        }
        return "SQLServer7" + inputDirectory;
    }

    public void cleanUp() throws OfflineCaptureException {
        Connection conn = this.getRepositoryConnection();
        Statement stmt = null;
        try {
            SQLServer7OfflineCaptureTables ss7 = new SQLServer7OfflineCaptureTables();
            String[] dropTables = ss7.getDropStatements();
            stmt = conn.createStatement();
            for (String drop : dropTables) {
                try {
                    stmt = conn.createStatement();
                    stmt.executeUpdate(drop);
                }
                catch (SQLException e) {
                    throw new OfflineCaptureException((Exception)e);
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e) {}
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OfflineCaptureException((Exception)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    public String[] generateScripts(String outputDirectory, int platformCode) throws OfflineCaptureException {
        this.writeFile(outputDirectory, "sqlserver7files", "create_ss7_emulation_views.sql");
        this.writeFile(outputDirectory, "sqlserver7files", "OMWB_OFFLINE_CAPTURE.BAT");
        this.writeFile(outputDirectory, "sqlserver7files", "SS7_BCP_SCRIPT.BAT");
        this.writeFile(outputDirectory, "sqlserver7files", "drop_ss7_emulation_views.sql");
        this.writeFile(outputDirectory, "sqlserver7files", "properties.sql");
        this.writeFile(outputDirectory, "sqlserver7files", "sqlserver7.ocp");
        String[] stringArray = new String[]{"OMWB_OFFLINE_CAPTURE.BAT", "sqlserver7.ocp", "properties.sql", "drop_ss7_emulation_views.sql", "SS7_BCP_SCRIPT.BAT", "create_ss7_emulation_views.sql"};
        return stringArray;
    }

    public String writeFile(String outputDirectory, String subDir, String fileName) throws OfflineCaptureException {
        InputStream stream = null;
        FilterOutputStream bOutput = null;
        try {
            String retVal;
            stream = new BufferedInputStream(Resource.getResourceAsStream(((Object)((Object)this)).getClass(), (String)(subDir + "/" + fileName)));
            File permanentFile = null;
            permanentFile = new File(outputDirectory + File.separator + fileName);
            if (!permanentFile.exists()) {
                bOutput = new BufferedOutputStream(new FileOutputStream(permanentFile));
                byte[] b = new byte[10000];
                int v = 0;
                while ((v = stream.read(b)) > -1) {
                    ((BufferedOutputStream)bOutput).write(b, 0, v);
                }
                ((BufferedOutputStream)bOutput).flush();
                stream.close();
            }
            String string = retVal = permanentFile.getPath();
            return string;
        }
        catch (FileNotFoundException e) {
            throw new OfflineCaptureException((Exception)e);
        }
        catch (IOException e) {
            throw new OfflineCaptureException((Exception)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
            if (bOutput != null) {
                try {
                    bOutput.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public SQLServer7OfflineCapturer(MigrationStorer storer, Connection sourceConnection) {
    }

    public void captureObjects(String objType, CaptureContext context, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        this.m_captureObjectsOfflineCapturer.captureObjects(objType, context, filter);
    }

    public String getModelName() throws CaptureException {
        return "SQLServer7";
    }

    public String getSourceURL() throws CaptureException {
        return "/tmp/sqlserver7";
    }

    public void setStorer(MigrationStorer storer) {
        this.m_storer = storer;
    }

    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    public Connection getRepositoryConnection() {
        return this.m_repositoryConnection;
    }

    public void setRepositoryConnection(Connection repositoryConnection) {
        this.m_repositoryConnection = repositoryConnection;
    }
}

