/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.datamove.offline.Offline3rdPartyPrintStream;
import oracle.dbtools.migration.workbench.core.AbstractMigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.Quoter;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPluginPreferences;
import oracle.dbtools.migration.workbench.plugin.SQLServer7Converter;
import oracle.dbtools.migration.workbench.plugin.SQLServer7DbProvider;
import oracle.dbtools.migration.workbench.plugin.SQLServer7OfflineCapturer;
import oracle.dbtools.migration.workbench.plugin.SQLServerQuoter;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;

public class SQLServer7Plugin
extends AbstractMigrationPlugin {
    protected Converter m_converter;
    public static final String DRIVER_CLASS = "net.sourceforge.jtds.jdbc.Driver";
    static boolean s_driverLoaded = false;

    public String getPlatformName() {
        return "Microsoft SQL Server";
    }

    public String getPluginName() {
        return this.getPlatformName() + " " + this.getVersionNumber();
    }

    public String getVersionNumber() {
        return "7.0.0";
    }

    public ThirdPartyDbProvider getProvider(String url) throws MigrationPluginException {
        try {
            SQLServer7Plugin.loadDriver();
            Connection conn = DriverManager.getConnection(url);
            return new SQLServer7DbProvider(conn);
        }
        catch (SQLException sqlex) {
            throw new MigrationPluginException((Throwable)sqlex);
        }
    }

    public ThirdPartyDbProvider getProvider(String url, Properties info) throws MigrationPluginException {
        try {
            SQLServer7Plugin.loadDriver();
            Connection conn = DriverManager.getConnection(url, info);
            return new SQLServer7DbProvider(conn);
        }
        catch (SQLException sqlex) {
            throw new MigrationPluginException((Throwable)sqlex);
        }
    }

    public ThirdPartyDbProvider getProvider(String url, String user, String password) throws MigrationPluginException {
        try {
            SQLServer7Plugin.loadDriver();
            Connection conn = DriverManager.getConnection(url, user, password);
            return new SQLServer7DbProvider(conn);
        }
        catch (SQLException sqlex) {
            throw new MigrationPluginException((Throwable)sqlex);
        }
    }

    public ThirdPartyDbProvider getProvider(Connection conn) throws MigrationPluginException {
        return new SQLServer7DbProvider(conn);
    }

    protected static void loadDriver() throws MigrationPluginException {
        if (!s_driverLoaded) {
            try {
                Class.forName(DRIVER_CLASS).newInstance();
                s_driverLoaded = true;
            }
            catch (ClassNotFoundException cnfe) {
                throw new MigrationPluginException((Throwable)cnfe);
            }
            catch (InstantiationException ie) {
                throw new MigrationPluginException((Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                throw new MigrationPluginException((Throwable)iae);
            }
        }
    }

    public MigrationPluginPreferences getPreferencePanel() {
        return null;
    }

    public String getPublishedVersion() {
        return "7";
    }

    public Converter getConverter() {
        if (this.m_converter == null) {
            this.m_converter = new SQLServer7Converter();
        }
        return this.m_converter;
    }

    protected String getSupportedMapsXMLFileName() {
        return "SQLServer7SupportedDataTypesMap.xml";
    }

    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String platform, int major, int minor, String productversion) {
        if (platform.equals(this.getPlatformName()) && major == 7) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
    }

    public String getIconFileName() {
        return "/oracle/dbtools/migration/workbench/plugin/mssql/images/sqlserver.png";
    }

    public void registerMenuItems() {
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.plugin.mssql");
    }

    public Quoter getQuoter() {
        return new SQLServerQuoter();
    }

    public final boolean getDataExportCommmand(String srcTable, MdColumn[] srcTableCols, Offline3rdPartyPrintStream printStream) {
        MigrationConfig options = MigrationAddin.getMigrationConfig();
        printStream.startTable(srcTable);
        try {
            String cmd = "bcp \"" + this.StripString(srcTable, "[]") + "\" out \"" + this.getOutputFileName(srcTable) + "\"";
            cmd = cmd + " -q -c -CRAW -t \"" + options.getEndColumnDelimiter() + "\" -r \"" + options.getEndRowDelimiter();
            cmd = cmd + "\" -U<Username> -P<Password> -S<ServerName>";
            printStream.println(cmd);
            printStream.endTable();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public final String StripString(String in, String bad) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char val = in.charAt(i);
            if (bad.indexOf(val) != -1) continue;
            out.append(val);
        }
        return out.toString();
    }

    public boolean usesClobToBlob() {
        return true;
    }

    public String formatSQLLoaderColumn(MdColumn column, MdColumn tgtColumn) {
        String format = "";
        String columnName = tgtColumn.getColumnName();
        String dataType = column.getColumnType();
        String tgtDataType = tgtColumn.getColumnType();
        Integer tgtPrecision = tgtColumn.getPrecision();
        int columnLength = 0;
        columnLength = tgtPrecision == null ? 0 : tgtPrecision;
        if (tgtDataType.equalsIgnoreCase("CHAR") || tgtDataType.equalsIgnoreCase("NCHAR") || tgtDataType.equalsIgnoreCase("VARCHAR2") || tgtDataType.equalsIgnoreCase("NVARCHAR2") || tgtDataType.equalsIgnoreCase("CLOB") || tgtDataType.equalsIgnoreCase("NCLOB")) {
            if (columnLength >= 255) {
                format = "CHAR(" + columnLength + ")";
            }
            if (tgtDataType.equalsIgnoreCase("VARCHAR2") || tgtDataType.equalsIgnoreCase("NVARCHAR2") || tgtDataType.equalsIgnoreCase("CHAR") || tgtDataType.equalsIgnoreCase("NCHAR")) {
                format = MigrationAddin.getMigrationConfig().getEmptyStringIsSpace() ? format + " \"DECODE(:" + columnName + ", CHR(00), ' ', :" + columnName + ")\"" : format + " \"DECODE(:" + columnName + ", CHR(00), NULL, :" + columnName + ")\"";
            }
            if (tgtDataType.equalsIgnoreCase("CLOB") || tgtDataType.equalsIgnoreCase("NCLOB")) {
                format = format + "CHAR(2000000)";
            }
        } else if (tgtDataType.equalsIgnoreCase("TIMESTAMP")) {
            format = "\"TO_TIMESTAMP(:" + columnName + ", '" + MigrationAddin.getMigrationConfig().getTimeStampOfflineDateMask() + "')\"";
        } else if (tgtDataType.equalsIgnoreCase("DATE")) {
            format = "\"TO_DATE(:" + columnName + ",  '" + MigrationAddin.getMigrationConfig().getDateOfflineDateMask() + "')\"";
        } else if (dataType.equalsIgnoreCase("MONEY") || dataType.equalsIgnoreCase("MONEYN")) {
            format = "\"TRANSLATE (:" + columnName + ",'1,','1')\"";
        } else if (dataType.equalsIgnoreCase("IMAGE")) {
            format = this.usesClobToBlob() && MigrationAddin.getMigrationConfig().getGenerateClobToBlob() ? " CHAR(2000000) " : " CHAR(2000000) \"HEXTORAW (:" + columnName + ")\"";
        }
        return format;
    }

    public String getDatafileExtension() {
        return "dat";
    }

    private String getOutputFileName(String srcTable) {
        return srcTable + "." + this.getDatafileExtension();
    }

    public int getPlatformMask() {
        return 16;
    }

    public OfflineCapturer getOfflineCapturer() {
        return new SQLServer7OfflineCapturer(null, null);
    }
}

