/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.ObjectStatusList;
import oracle.ide.Ide;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateDSMLFormattedFiles {
    private StringBuffer m_carriedToken = new StringBuffer();
    private HashMap<File, ArrayList<File>> m_dbXMLMetadataList = new HashMap();
    private HashMap<File, ObjectStatusList> m_dSMLMap = null;
    private String m_endRow = "";
    private String m_endCol = "";
    private static StringBuffer s_strBuff = new StringBuffer();

    public GenerateDSMLFormattedFiles(HashMap<File, ObjectStatusList> dsmlMap) throws OfflineCaptureException {
        Iterator<File> i = dsmlMap.keySet().iterator();
        i.hasNext();
        File f = i.next();
        String dirName = f.getParentFile().getAbsolutePath();
        try {
            String encoding = Ide.getEnvironOptions().getEncoding();
            BufferedReader br = null;
            br = encoding == null ? new BufferedReader(new InputStreamReader(new FileInputStream(dirName + File.separator + "COLUMN.TXT"))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dirName + File.separator + "COLUMN.TXT"), encoding));
            int r = 0;
            while (r != -1) {
                r = br.read();
                if (r == -1 && this.m_endCol.equals("")) {
                    throw new OfflineCaptureException(new Exception(dirName + File.separator + "COLUMN.TXT"));
                }
                if (r == -1) continue;
                this.m_endCol = this.m_endCol + new Character((char)r).toString();
            }
            br = encoding == null ? new BufferedReader(new InputStreamReader(new FileInputStream(dirName + File.separator + "ROW.TXT"))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dirName + File.separator + "ROW.TXT"), encoding));
            r = 0;
            while (r != -1) {
                r = br.read();
                if (r == -1 && this.m_endRow.equals("")) {
                    throw new OfflineCaptureException(new Exception(dirName + File.separator + "ROW.TXT"));
                }
                if (r == -1) continue;
                this.m_endRow = this.m_endRow + new Character((char)r).toString();
            }
        }
        catch (FileNotFoundException e) {
            throw new OfflineCaptureException((Exception)e);
        }
        catch (IOException e) {
            throw new OfflineCaptureException((Exception)e);
        }
        this.m_dSMLMap = dsmlMap;
        this.generateDSMLFiles();
    }

    public static String getMessage(String pattern, Object[] params) {
        StringBuffer message = new StringBuffer();
        MessageFormat msgFmt = new MessageFormat(pattern);
        msgFmt.format(params, message, (FieldPosition)null);
        return message.toString();
    }

    public static String getUnqualifiedName(String filename) {
        String unqualifiedFilename = null;
        int i = filename.lastIndexOf(46);
        if (i > 0 && i < filename.length() - 1) {
            unqualifiedFilename = filename.substring(0, i);
        }
        return unqualifiedFilename;
    }

    private void generateDSMLFiles() throws OfflineCaptureException {
        int colsProcessed = 0;
        this.m_dbXMLMetadataList.clear();
        try {
            for (File dbName : this.m_dSMLMap.keySet()) {
                ObjectStatusList objStatusList = this.m_dSMLMap.get(dbName);
                ArrayList<File> xMLFileList = new ArrayList<File>();
                int index = 0;
                Iterator enumx = objStatusList.getKeys();
                while (enumx.hasNext()) {
                    File filename = (File)enumx.next();
                    String value = null;
                    value = filename.getPath();
                    String pathname = filename.getParent();
                    String unqualifiedFilename = GenerateDSMLFormattedFiles.getUnqualifiedName(filename.getName());
                    String xMLFilename = unqualifiedFilename + ".XML";
                    String xMLFullFilename = pathname + File.separator + xMLFilename;
                    File datFile = new File(value);
                    File xMLFile = new File(xMLFullFilename);
                    String thisLine = "";
                    String fileEncoding = "UTF-8";
                    BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xMLFile), fileEncoding));
                    String encoding = Ide.getEnvironOptions().getEncoding();
                    BufferedReader br = null;
                    br = encoding == null ? new BufferedReader(new InputStreamReader(new FileInputStream(datFile))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(datFile), encoding));
                    Object[] params = new Object[]{fileEncoding};
                    String pattern = "<?xml version=\"1.0\" encoding=\"{0}\" ?>";
                    String xmlHeader = GenerateDSMLFormattedFiles.getMessage(pattern, params);
                    bw.write(xmlHeader);
                    bw.write("<START><er>");
                    block4: while ((thisLine = br.readLine()) != null) {
                        Iterator stRows = this.breakup(thisLine, this.m_endRow);
                        while (stRows.hasNext()) {
                            String row = (String)stRows.next();
                            if (row.indexOf(this.m_endRow) != -1) {
                                colsProcessed = 0;
                                bw.write("</er><er>");
                                continue block4;
                            }
                            int fromIndex = 0;
                            int delimIndex = 0;
                            String col = "";
                            int rowLen = row.length();
                            boolean startOfRow = true;
                            while ((delimIndex = row.indexOf(this.m_endCol, fromIndex)) != -1 || fromIndex < rowLen) {
                                String nextToken;
                                if (delimIndex == -1) {
                                    if (!startOfRow) {
                                        ++fromIndex;
                                    }
                                    if (fromIndex != rowLen) {
                                        col = row.substring(fromIndex, rowLen);
                                        StringBuffer result = GenerateDSMLFormattedFiles.processString(col, false);
                                        this.m_carriedToken.append(result.toString());
                                        this.m_carriedToken.append("\n");
                                        break;
                                    }
                                    if (thisLine.length() != rowLen) break;
                                    this.m_carriedToken.append("\n");
                                    break;
                                }
                                ++colsProcessed;
                                if (!startOfRow) {
                                    ++fromIndex;
                                }
                                col = row.substring(fromIndex, delimIndex - 1);
                                bw.write("<ec>");
                                if (this.m_carriedToken.length() != 0) {
                                    bw.write(this.m_carriedToken.toString());
                                    this.m_carriedToken.setLength(0);
                                }
                                if ((nextToken = GenerateDSMLFormattedFiles.processString(col, false).toString()).length() != 0) {
                                    bw.write(nextToken);
                                }
                                bw.write("</ec>");
                                fromIndex = delimIndex + this.m_endCol.length();
                                startOfRow = false;
                            }
                            if (!row.endsWith(this.m_endRow)) continue;
                            bw.write("</er><er>");
                        }
                    }
                    bw.write("</er></START>");
                    ((Writer)bw).flush();
                    ((Writer)bw).close();
                    xMLFileList.add(xMLFile);
                    ++index;
                }
                this.m_dbXMLMetadataList.put(dbName, xMLFileList);
            }
        }
        catch (Exception e) {
            throw new OfflineCaptureException(e);
        }
    }

    Iterator breakup(String thisLine, String m_endRow) {
        ArrayList<String> myArrayList = new ArrayList<String>();
        if (thisLine == null || thisLine.equals("")) {
            return myArrayList.iterator();
        }
        int index = 0;
        int lastIndex = 0;
        while ((index = thisLine.indexOf(m_endRow, lastIndex)) != -1) {
            if (index == lastIndex) {
                myArrayList.add("");
            } else {
                myArrayList.add(thisLine.substring(lastIndex, index));
            }
            myArrayList.add(m_endRow);
            lastIndex = index + m_endRow.length();
        }
        if (lastIndex != thisLine.length()) {
            myArrayList.add(thisLine.substring(lastIndex));
        }
        return myArrayList.iterator();
    }

    private static StringBuffer processString(String in, boolean addDelims) {
        int i = 0;
        int maxLen = in.length();
        s_strBuff.setLength(0);
        if (addDelims) {
            s_strBuff.append("<ec>");
        }
        while (i < maxLen) {
            char c = in.charAt(i);
            if (c == '<') {
                s_strBuff.append("&lt;");
            } else if (c == '>') {
                s_strBuff.append("&gt;");
            } else if (c == '\'') {
                s_strBuff.append("&apos;");
            } else if (c == '\"') {
                s_strBuff.append("&quot;");
            } else if (c == '&') {
                s_strBuff.append("&amp;");
            } else if (c != '\u0000' && c != '\u0007' && c != '\u000e' && c != '\u0014' && c != '\u0015' && c != '\u000f') {
                s_strBuff.append(c);
            }
            ++i;
        }
        if (addDelims) {
            s_strBuff.append("</ec>");
        }
        return s_strBuff;
    }

    public HashMap<File, ArrayList<File>> getDSMLFormattedFilesTable() {
        return this.m_dbXMLMetadataList;
    }
}

